/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.ws.BillResultInfo;
import com.kingdee.eas.tm.im.ws.app.importbill.IBillSupport;
import com.kingdee.eas.tm.im.ws.app.importbill.TMBillImportUtils;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public abstract class TMBillSupport
implements IBillSupport {
    protected BigDecimal zero = new BigDecimal("0.00");
    private Context ctx;

    @Override
    public boolean isSupportSubmit() {
        return false;
    }

    @Override
    public boolean isSupportAudit() {
        return false;
    }

    @Override
    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    public Context getContext() {
        return this.ctx;
    }

    @Override
    public Class getInfoClass() {
        return null;
    }

    private List<String> setData(Context ctx, CoreBillBaseInfo info) throws BOSException, EASBizException {
        ArrayList<String> errorMsg = new ArrayList<String>();
        this.dealWithData(ctx, info, errorMsg);
        this.setDefaultData(info, errorMsg);
        this.verifyData(info, errorMsg);
        return errorMsg;
    }

    protected void setDefaultData(CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        this.setDefaultHeadData(model, errorMsg);
        IObjectCollection entries = (IObjectCollection)model.get(this.getEntryName());
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            CoreBillEntryBaseInfo entryInfo = (CoreBillEntryBaseInfo)entries.getObject(i);
            this.setDefaultEntryData(entryInfo, model, errorMsg);
        }
    }

    protected void setDefaultHeadData(CoreBillBaseInfo info, List<String> errorMsg) throws BOSException, EASBizException {
    }

    protected void setDefaultEntryData(CoreBillEntryBaseInfo entryModel, CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    protected void dealWithData(Context ctx, CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        this.dealWithHeadData((CoreBaseInfo)model, errorMsg);
        IObjectCollection entries = (IObjectCollection)model.get(this.getEntryName());
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            CoreBillEntryBaseInfo entryInfo = (CoreBillEntryBaseInfo)entries.getObject(i);
            this.dealWithEntryData(i + 1, entryInfo, (CoreBaseInfo)model, errorMsg);
        }
        TMBillImportUtils.setInfoByNumber(ctx, (CoreBaseInfo)model, errorMsg);
    }

    protected void dealWithHeadData(CoreBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    protected void dealWithEntryData(int rownum, CoreBillEntryBaseInfo entryModel, CoreBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    protected void verifyData(CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        this.verifyHeadData(model, errorMsg);
        IObjectCollection entries = (IObjectCollection)model.get(this.getEntryName());
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            CoreBillEntryBaseInfo entryInfo = (CoreBillEntryBaseInfo)entries.getObject(i);
            this.verifyEntryData(i + 1, entryInfo, model, errorMsg);
        }
    }

    protected void verifyHeadData(CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    protected void verifyEntryData(int rownum, CoreBillEntryBaseInfo entryModel, CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
    }

    @Override
    public List<BillResultInfo> audit(List<BillResultInfo> results) throws EASBizException, BOSException {
        BatchExecuteResult result = null;
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[results.size()];
        BatchExecuteParamsEntry entry = null;
        for (int i = 0; i < results.size(); ++i) {
            BillResultInfo resultInfo = results.get(i);
            if (resultInfo == null || resultInfo.getStatus() != 0) continue;
            String billid = resultInfo.getId();
            entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
            entry.add((Object)new ObjectUuidPK(billid));
            paramEntries[i] = entry;
        }
        Class[] batchMethod = new Class[]{IObjectPK.class};
        String methodPK = "audit";
        try {
            result = this.getInterface().batchExecute(methodPK, batchMethod, paramEntries);
        }
        catch (BaseException e) {
            throw new BOSException((Throwable)e);
        }
        Object[] objs = result.getReturnValues();
        int size = objs.length;
        for (int i = 0; i < size; ++i) {
            ArrayList<String> errorMsg = new ArrayList<String>();
            BillResultInfo resultInfo = new BillResultInfo();
            if (result.getException(i) == null) {
                resultInfo.setId(result.getReturnValue(i).toString());
                resultInfo.setStatus(0);
            } else {
                errorMsg.add(result.getException(i).getMessage());
                resultInfo.setErrorMsgs(errorMsg);
                resultInfo.setStatus(1);
            }
            results.add(resultInfo);
        }
        return results;
    }

    @Override
    public List<BillResultInfo> save(AbstractObjectCollection col) throws EASBizException, BOSException {
        List<BillResultInfo> results = this.saveOrSubmitData(col, true);
        return results;
    }

    @Override
    public List<BillResultInfo> submit(AbstractObjectCollection col) throws EASBizException, BOSException {
        List<BillResultInfo> results = this.saveOrSubmitData(col, false);
        return results;
    }

    private List<BillResultInfo> saveOrSubmitData(AbstractObjectCollection col, boolean isSave) throws BOSException, EASBizException {
        List<String> errorMsg;
        ArrayList<BillResultInfo> results = new ArrayList<BillResultInfo>();
        CoreBillBaseInfo info = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            info = (CoreBillBaseInfo)col.getObject(i);
            errorMsg = this.setData(this.ctx, info);
            if (errorMsg == null || errorMsg.size() <= 0) continue;
            BillResultInfo result = new BillResultInfo();
            result.setErrorMsgs(errorMsg);
            result.setNumber(info.getNumber());
            result.setStatus(1);
            results.add(result);
            col.removeObject(i);
            --i;
            --size;
        }
        if (col != null && col.size() > 0) {
            BatchExecuteResult result = null;
            BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[col.size()];
            BatchExecuteParamsEntry entry = null;
            int size2 = col.size();
            for (int i = 0; i < size2; ++i) {
                entry = new BatchExecuteParamsEntry(new Class[]{CoreBaseInfo.class});
                entry.add((Object)col.getObject(i));
                paramEntries[i] = entry;
            }
            Class[] batchMethod = new Class[]{CoreBaseInfo.class};
            String methodPK = "submit";
            if (isSave) {
                methodPK = "save";
            }
            try {
                result = this.getInterface().batchExecute(methodPK, batchMethod, paramEntries);
            }
            catch (BaseException e) {
                throw new BOSException((Throwable)e);
            }
            Object[] objs = result.getReturnValues();
            int size3 = objs.length;
            for (int i = 0; i < size3; ++i) {
                info = (CoreBillBaseInfo)col.getObject(i);
                errorMsg = new ArrayList<String>();
                BillResultInfo resultInfo = new BillResultInfo();
                resultInfo.setNumber(info.getNumber());
                if (result.getException(i) == null) {
                    resultInfo.setId(result.getReturnValue(i).toString());
                    resultInfo.setStatus(0);
                } else {
                    errorMsg.add(result.getException(i).getMessage());
                    resultInfo.setErrorMsgs(errorMsg);
                    resultInfo.setStatus(1);
                }
                results.add(resultInfo);
            }
        }
        return results;
    }

    public abstract ICoreBase getInterface() throws BOSException;
}

