/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.ws.app.importbill;

import com.google.gson.JsonParseException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.tm.common.utils.LogCheckUtil;
import com.kingdee.eas.tm.im.ws.BillResultInfo;
import com.kingdee.eas.tm.im.ws.BillTypeEnum;
import com.kingdee.eas.tm.im.ws.ResultInfo;
import com.kingdee.eas.tm.im.ws.app.WSResource;
import com.kingdee.eas.tm.im.ws.app.importbill.IBillSupport;
import com.kingdee.eas.tm.im.ws.app.importbill.IImportBill;
import com.kingdee.eas.tm.im.ws.app.importbill.IncomeInvoiceSupport;
import com.kingdee.eas.tm.im.ws.app.importbill.MakeInvoiceReqSupport;
import com.kingdee.eas.tm.im.ws.app.importbill.MakeInvoiceReqSupportOld;
import com.kingdee.eas.tm.im.ws.app.importbill.MakeInvoiceSupport;
import com.kingdee.eas.tm.im.ws.app.importbill.VehicleInvoiceReqSupport;
import com.kingdee.eas.tm.im.ws.app.importbill.VehicleMakeInvoiceSupport;
import com.kingdee.eas.tm.im.ws.app.json.JSONUtils;
import com.kingdee.util.BOSResourceBundle;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class TMImportBill
implements IImportBill {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.ws.app.importbill.TMImportBill");
    private static Map<String, Class<IBillSupport>> billClassMap = null;

    @Override
    public String importing(Context ctx, String billType, String billDataJSON, int billStatus) throws BOSException, EASBizException {
        ResultInfo resultInfo = new ResultInfo();
        IBillSupport billSupport = this.getBillSupport(billType);
        if (billSupport == null) {
            String errStr = WSResource.getResource(ctx, "NOT_SUPPORT_AUDITNOT_SUPPORT_BILLTYPE") + billType;
            errStr = LogCheckUtil.validLog((String)errStr);
            logger.error((Object)errStr);
            resultInfo.setStatus(1);
            resultInfo.setMsg(errStr);
            return JSONUtils.convertObjectToJson(ctx, resultInfo);
        }
        billSupport.setContext(ctx);
        Object infos = null;
        try {
            infos = JSONUtils.convertJsonToObject(ctx, billDataJSON, billSupport.getInfoClass());
        }
        catch (Exception exp) {
            resultInfo.setStatus(1);
            if (exp.getCause() != null && exp.getCause() instanceof JsonParseException) {
                resultInfo.setMsg(exp.getCause().getMessage());
            } else {
                resultInfo.setMsg(exp.getMessage());
            }
            return JSONUtils.convertObjectToJson(ctx, resultInfo);
        }
        CoreBillBaseCollection objCol = new CoreBillBaseCollection();
        if (infos instanceof AbstractObjectCollection) {
            objCol = (AbstractObjectCollection)infos;
        } else {
            objCol.addObject((IObjectValue)infos);
        }
        if (objCol == null || objCol.size() <= 0) {
            resultInfo.setStatus(1);
            resultInfo.setMsg("\u5f53\u524d\u4f20\u5165\u7684\u5355\u636e\u4e3a\u7a7a\uff0c\u6216\u8005json\u4e0d\u662f\u5355\u636e\u6570\u7ec4\u7c7b\u578b");
            return JSONUtils.convertObjectToJson(ctx, resultInfo);
        }
        List<BillResultInfo> billErrors = null;
        if (billStatus == 1) {
            billErrors = billSupport.save((AbstractObjectCollection)objCol);
        } else if (billStatus == 2) {
            if (billSupport.isSupportSubmit()) {
                billErrors = billSupport.submit((AbstractObjectCollection)objCol);
            } else {
                resultInfo.setStatus(1);
                String errMsg = WSResource.getResource(ctx, "NOT_SUPPORT_SUBMIT");
                resultInfo.setMsg(errMsg);
                logger.error((Object)errMsg);
            }
        } else if (billStatus == 3) {
            if (billSupport.isSupportSubmit() && billSupport.isSupportAudit()) {
                billErrors = billSupport.submit((AbstractObjectCollection)objCol);
                billErrors = billSupport.audit(billErrors);
            } else {
                resultInfo.setStatus(1);
                String errMsg = WSResource.getResource(ctx, "NOT_SUPPORT_AUDIT");
                resultInfo.setMsg(errMsg);
                logger.error((Object)errMsg);
            }
        } else {
            resultInfo.setStatus(1);
            String errMsg = WSResource.getResource(ctx, "NOT_SUPPORT_STATUS");
            resultInfo.setMsg(errMsg);
            logger.error((Object)errMsg);
        }
        if (billErrors != null && billErrors.size() > 0) {
            resultInfo.setBillErrors(billErrors);
            if (billErrors.size() == objCol.size()) {
                resultInfo.setStatus(2);
            } else {
                resultInfo.setStatus(1);
            }
        } else {
            resultInfo.setStatus(0);
        }
        return this.processResult(ctx, resultInfo);
    }

    private String processResult(Context ctx, ResultInfo resultInfo) throws BOSException {
        if (resultInfo.getStatus() != 0) {
            BillResultInfo billResult = null;
            int total = resultInfo.getBillErrors().size();
            int size = resultInfo.getBillErrors().size();
            for (int i = 0; i < size; ++i) {
                billResult = resultInfo.getBillErrors().get(i);
                if (billResult.getStatus() != 0) continue;
                resultInfo.getBillErrors().remove(i);
                --i;
                --size;
            }
            if (resultInfo.getBillErrors() != null && resultInfo.getBillErrors().size() == 0) {
                resultInfo.setStatus(0);
            } else if (resultInfo.getBillErrors().size() == total) {
                resultInfo.setStatus(2);
            } else {
                resultInfo.setStatus(1);
            }
        }
        if (resultInfo.getStatus() == 0) {
            resultInfo.getBillErrors().clear();
        }
        return JSONUtils.convertObjectToJson(ctx, resultInfo);
    }

    public IBillSupport getBillSupport(String billType) {
        this.registerBills();
        IBillSupport billSupport = null;
        Class<IBillSupport> billClass = billClassMap.get(billType);
        if (billClass != null) {
            try {
                billSupport = billClass.newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return billSupport;
    }

    protected synchronized void registerBills() {
        if (billClassMap != null) {
            return;
        }
        billClassMap = new HashMap<String, Class<IBillSupport>>();
        this.registBill(BillTypeEnum.MAKEINVOICE.getNumber(), MakeInvoiceSupport.class);
        this.registBill(BillTypeEnum.INCOMEINVOICE.getNumber(), IncomeInvoiceSupport.class);
        this.registBill(BillTypeEnum.MAKEINVOICEREQ.getNumber(), MakeInvoiceReqSupport.class);
        this.registBill(BillTypeEnum.VEHICLEMAKEINVOICE.getNumber(), VehicleMakeInvoiceSupport.class);
        this.registBill(BillTypeEnum.VEHICLEINVOICEREQ.getNumber(), VehicleInvoiceReqSupport.class);
        this.registBill(BillTypeEnum.MAKEINVOICEREQOLD.getNumber(), MakeInvoiceReqSupportOld.class);
        this.registeExt();
    }

    protected void registeExt() {
        String resClassName = "com.kingdee.eas.tm.im.ws.WSimportclasses";
        try {
            ResourceBundle resBundle = BOSResourceBundle.getBundle((String)resClassName, (Locale)new Locale("l1"));
            Enumeration<String> keyIter = resBundle.getKeys();
            while (keyIter.hasMoreElements()) {
                String billType = keyIter.nextElement();
                String className = resBundle.getString(billType);
                if (className == null) continue;
                this.registBill(billType, className);
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
    }

    private void registBill(String billType, Class billClass) {
        if (billClassMap.containsKey(billType)) {
            logger.error((Object)("bill type " + billType + " existed."));
            return;
        }
        billClassMap.put(billType, billClass);
    }

    private void registBill(String billType, String billClassName) {
        if (billClassMap.containsKey(billType)) {
            logger.error((Object)("bill type " + billType + " existed."));
            return;
        }
        Class<IBillSupport> billClass = this.getClass(billClassName);
        if (billClass != null) {
            billClassMap.put(billType, billClass);
        }
    }

    private Class<IBillSupport> getClass(String className) {
        Class<IBillSupport> billClass = null;
        try {
            billClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return billClass;
    }
}

