/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.ws.app.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.util.LocaleUtils;
import java.lang.reflect.Type;

public class EnumTypeAdapter
implements JsonSerializer<BizEnumValueDTO> {
    public static final String WAF_ENUM_VALUE_KEY = "isenum";
    private Context ctx;

    public EnumTypeAdapter(Context ctx) {
        this.ctx = ctx;
    }

    public JsonElement serialize(BizEnumValueDTO object, Type type, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(WAF_ENUM_VALUE_KEY, Boolean.valueOf(true));
        String strAlias = null;
        strAlias = this.ctx.getLocale().equals(LocaleUtils.locale_l1) ? object.getName() : object.getAlias(this.ctx.getLocale());
        jsonObject.addProperty("alias", strAlias);
        Object value = object.get("value");
        if (this.isNumberValue(value.toString())) {
            jsonObject.addProperty("value", (Number)Double.parseDouble(value.toString()));
        } else {
            jsonObject.addProperty("value", value.toString());
        }
        return jsonObject;
    }

    private boolean isNumberValue(String value) {
        boolean blnResult = true;
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        try {
            Float.parseFloat(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return blnResult;
    }
}

