/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.tm.td.AbstractTDFacadeControllerBean;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.account.engine.interfaces.impl.DefaultAccountCalculator;
import com.kingdee.eas.tm.td.account.engine.model.AccountCalculatorParams;
import com.kingdee.eas.tm.td.account.engine.model.AccountCalculatorResult;
import com.kingdee.eas.tm.td.app.util.TDBatchService;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TDFacadeControllerBean
extends AbstractTDFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.TDFacadeControllerBean");

    @Override
    protected Map _batchOperation(Context ctx, String bosType, String methodName, String[] billIDs) throws BOSException, EASBizException {
        BOSObjectType type = BOSObjectType.create((String)bosType);
        IBizCtrl bizCtrl = (IBizCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)type);
        HashMap<String, String> result = new HashMap<String, String>();
        ArrayList<String> idList = new ArrayList<String>(billIDs.length);
        for (int i = 0; i < billIDs.length; ++i) {
            idList.add(billIDs[i]);
        }
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        int errorCount = 0;
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate(idList);
            Iterator lt = idList.iterator();
            while (lt.hasNext()) {
                String id = (String)lt.next();
                Object value = map.get(id);
                if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                EASBizException mutexException = new EASBizException(new NumericExceptionSubItem("100", ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request", (Locale)ctx.getLocale())));
                ++errorCount;
                result.put(id, mutexException.getMessage());
                lt.remove();
            }
            if (idList.size() > 0) {
                BatchExecuteParamsEntry[] paramEntries = this.getParameters(idList, methodName);
                ServiceStateManager.getInstance().enableNextCallServices();
                ServiceStateManager.getInstance().getServiceState().enableServices();
                TDBatchService batchService = new TDBatchService(type, bizCtrl);
                BatchExecuteResult exeResult = batchService.batchExecute(ctx, methodName, this.getParameterTypes(methodName), paramEntries);
                if (exeResult.getBatchResult() == null) {
                    Throwable[] exps = exeResult.getExceptions();
                    for (int i = 0; i < exps.length; ++i) {
                        if (exps[i] == null) continue;
                        ++errorCount;
                        result.put(this.getId(paramEntries[i]).toString(), exps[i].getMessage());
                    }
                    result.put("ERROR_COUNT", String.valueOf(errorCount));
                } else {
                    BatchActionResults actionResults = (BatchActionResults)exeResult.getBatchResult();
                    for (int i = 0; i < paramEntries.length; ++i) {
                        Object id = this.getId(paramEntries[i]);
                        ActionResult actionResult = actionResults.getActionResult(id);
                        if (actionResult.getResult().equals((Object)ActionResultEnum.SUCCESS)) continue;
                        result.put(id.toString(), actionResult.getMessage());
                        ++errorCount;
                    }
                    result.put("ERROR_COUNT", String.valueOf(errorCount));
                }
            }
        }
        catch (BaseException e) {
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException(e.getMessage());
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate(idList);
        }
        return result;
    }

    public Class[] getParameterTypes(String methodName) {
        if (this.isSingleParameter(methodName)) {
            return new Class[]{IObjectPK.class};
        }
        return new Class[]{IObjectPK.class, CoreBaseInfo.class};
    }

    public boolean isSingleParameter(String methodName) {
        String[] methods = new String[]{"delete", "audit", "unAudit", "close", "unClose", "publish", "cancelPublish", "setTop", "cancelSetTop", "unaudit"};
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].equals(methodName)) continue;
            return true;
        }
        return false;
    }

    public BatchExecuteParamsEntry[] getParameters(List<String> idList, String methodName) {
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[idList.size()];
        BatchExecuteParamsEntry entry = null;
        Class[] paramTypes = this.getParameterTypes(methodName);
        for (int i = 0; i < idList.size(); ++i) {
            entry = new BatchExecuteParamsEntry(paramTypes);
            entry.add(0, (Object)new ObjectUuidPK(idList.get(i)));
            paramEntries[i] = entry;
        }
        return paramEntries;
    }

    public Object getId(BatchExecuteParamsEntry paramEntry) {
        return paramEntry.get(0);
    }

    @Override
    protected AccountCalculatorResult _getAccountData(Context ctx, AccountCalculatorParams params) throws BOSException, EASBizException {
        DefaultAccountCalculator accountCalculator = new DefaultAccountCalculator(ctx, params);
        accountCalculator.calculate();
        return accountCalculator.getResult();
    }

    @Override
    protected String _getAccountSQL(Context ctx, AccountCalculatorParams params) throws BOSException, EASBizException {
        DefaultAccountCalculator accountCalculator = new DefaultAccountCalculator(ctx, params);
        return accountCalculator.getAccountSQL();
    }

    @Override
    protected Set _getUnitIdsByOrgTree(Context ctx, String orgTreeId) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT t2.FUNITID orgUnitID FROM T_ORG_Tree t1  ");
        sb.append(" inner join T_ORG_Structure   t2 on t1.FID  = t2.FTREEID  ");
        sb.append(" inner join T_ORG_COMPANY t3 on t2.FUNITID  = t3.FID ");
        sb.append(" where t1.fid='").append(orgTreeId).append("'");
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sb.toString(), null);
        try {
            while (rs.next()) {
                ids.add(rs.getString("orgUnitID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ids;
    }

    @Override
    protected Map _getParam(Context ctx, String orgID, String[] paramNumber) throws BOSException, EASBizException {
        HashMap result = ParamManager.getParamHashMap((Context)ctx, (String[])paramNumber, (String)orgID);
        return result == null ? new HashMap() : result;
    }

    @Override
    protected void _checkFunctionPermission(Context ctx, String orgID, String permItemName) throws BOSException, EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK userPk = new ObjectUuidPK(BOSUuid.read((String)userInfo.getId().toString()));
        ObjectUuidPK orgPk = new ObjectUuidPK(BOSUuid.read((String)orgID));
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permItemName);
    }

    @Override
    protected OrgUnitCollection _getAuthOrgsByType(Context ctx, OrgType orgType, String permItem) throws BOSException, EASBizException {
        OrgUnitCollection collection = TDUtils.getAuthOrgByPermItem(ctx, orgType, permItem);
        return TDUtils.getOrgUnitInfosByType(ctx, collection, orgType, null);
    }

    @Override
    protected OrgUnitCollection _getAuthOrgsByType(Context ctx, OrgType orgType, IMetaDataPK queryPK) throws BOSException, EASBizException {
        String permItem = TDUtils.getPermissionItem(ctx, queryPK);
        return this._getAuthOrgsByType(ctx, orgType, permItem);
    }

    @Override
    protected String _getPermissionItem(Context ctx, IMetaDataPK metaPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, metaPK, actionPK);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                return permItemName;
            }
        }
        return null;
    }

    @Override
    protected Map _getParams(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        String sql = " select Fkey,FValue from T_TD_TDParam ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String Fkey = rs.getString("Fkey");
                String FValue = rs.getString("FValue");
                result.put(Fkey, FValue);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected Map _getProvinceNameAndNumber(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        String sql = " select FName_l2 as name,FNumber as number from T_BD_Province ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String name = rs.getString("name");
                String number = rs.getString("number");
                result.put(name, number);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected String _getCompanyIDSQL(Context ctx, String permissionItem) throws BOSException, EASBizException {
        String permItemId = this.getFuncPermissionId(ctx, permissionItem);
        return "SELECT cp.fid " + this.getCompanyFilterSQL(ctx.getCaller().toString(), permItemId, true, null, null, true);
    }

    public String getFuncPermissionId(Context ctx, String permissionItem) throws BOSException {
        String permItemId = "";
        String permSql = "select FID from t_pm_permitem where fnumber = '" + permissionItem + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)permSql);
        try {
            if (rs.next()) {
                permItemId = rs.getString("FID");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return permItemId;
    }

    public String getCompanyFilterSQL(String userId, String permssiomId, boolean isFunPerm, CompanyOrgUnitInfo root, String periodTypeID, boolean onlyLeaf) {
        StringBuffer sql = new StringBuffer();
        sql.append(" from t_org_company cp ");
        if (!onlyLeaf) {
            sql.append(" inner join t_org_company pcp on charindex(pcp.flongnumber||'!', cp.flongnumber) = 1 or pcp.fid = cp.fid ");
        }
        sql.append(" where cp.fisbizunit = 1 ");
        sql.append(" and cp.faccounttableid is not null ");
        if (periodTypeID != null) {
            sql.append(" and cp.faccountperiodid = '").append(periodTypeID).append("'");
        }
        if (root != null && !onlyLeaf) {
            sql.append(" and (pcp.flongnumber like '").append(root.getLongNumber()).append("!%' or pcp.fid = '").append(root.getId().toString()).append("')");
        } else if (root != null && onlyLeaf) {
            sql.append(" and (cp.flongnumber like '").append(root.getLongNumber()).append("!%' or cp.fid = '").append(root.getId().toString()).append("')");
        }
        if (isFunPerm && !StringUtils.isEmpty((String)permssiomId)) {
            sql.append(" and cp.fid in (").append(this.getOrgPermissonSQL(userId, permssiomId)).append(")");
        } else {
            sql.append(" and cp.fid in ('1111111111111111111111111111')");
        }
        return sql.toString();
    }

    public String getOrgPermissonSQL(String userId, String permssiomId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT UserOrgPerm.FOrgID FOrgID ");
        sql.append(" FROM T_PM_UserOrgPerm UserOrgPerm WHERE UserOrgPerm.FOwner = '").append(userId).append("'");
        sql.append(" AND UserOrgPerm.FPermItemID = '").append(permssiomId).append("'");
        sql.append(" UNION ALL");
        sql.append(" SELECT UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ");
        sql.append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID");
        sql.append(" WHERE UserRoleOrg.FUserID = '").append(userId).append("'");
        sql.append(" AND RolePerm.FPermItemID = '").append(permssiomId).append("'");
        return sql.toString();
    }

    @Override
    protected IObjectValue _getDefaultMainBizOrg(Context ctx, String permissionItem) throws BOSException, EASBizException {
        CompanyOrgUnitInfo orgUnit = null;
        CompanyOrgUnitInfo currentMainOrg = ContextUtil.getCurrentFIUnit((Context)ctx);
        String curOrgId = currentMainOrg.getId().toString();
        String defaultOrgId = null;
        String permItemId = this.getFuncPermissionId(ctx, permissionItem);
        String sql = "select  cp.FID FOrgID " + this.getCompanyFilterSQL(ctx.getCaller().toString(), permItemId, true, null, null, true) + " order by cp.flongnumber ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (currentMainOrg.isIsBizUnit()) {
                while (rs.next()) {
                    if (!curOrgId.equals(rs.getString("FOrgID"))) continue;
                    defaultOrgId = curOrgId;
                    break;
                }
            }
            if (defaultOrgId == null) {
                rs.beforeFirst();
                if (rs.next()) {
                    defaultOrgId = rs.getString("FOrgID");
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (defaultOrgId != null) {
            orgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(defaultOrgId), this.getOrgInfoSelector(OrgType.Company));
        }
        return orgUnit;
    }

    public SelectorItemCollection getOrgInfoSelector(OrgType orgType) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("isCU"));
        selector.add(new SelectorItemInfo("isBizUnit"));
        selector.add(new SelectorItemInfo("isSaleOrgUnit"));
        selector.add(new SelectorItemInfo("isAdminOrgUnit"));
        selector.add(new SelectorItemInfo("isPurchaseOrgUnit"));
        selector.add(new SelectorItemInfo("isStorageOrgUnit"));
        selector.add(new SelectorItemInfo("isCompanyOrgUnit"));
        selector.add(new SelectorItemInfo("isTransportOrgUnit"));
        selector.add(new SelectorItemInfo("isFreeze"));
        selector.add(new SelectorItemInfo("isGrouping"));
        selector.add(new SelectorItemInfo("isCostOrgUnit"));
        selector.add(new SelectorItemInfo("isStart"));
        selector.add(new SelectorItemInfo("code"));
        selector.add(new SelectorItemInfo("orgTypeStr"));
        if (OrgType.Company.equals((Object)orgType)) {
            selector.add(new SelectorItemInfo("baseExchangeTable.id"));
            selector.add(new SelectorItemInfo("baseCurrency.id"));
            selector.add(new SelectorItemInfo("baseCurrency.name"));
            selector.add(new SelectorItemInfo("baseCurrency.number"));
            selector.add(new SelectorItemInfo("baseCurrency.precision"));
            selector.add(new SelectorItemInfo("accountTable.id"));
            selector.add(new SelectorItemInfo("accountTable.name"));
            selector.add(new SelectorItemInfo("accountTable.number"));
            selector.add(new SelectorItemInfo("accountPeriodType.id"));
            selector.add(new SelectorItemInfo("accountPeriodType.name"));
            selector.add(new SelectorItemInfo("accountPeriodType.number"));
        }
        return selector;
    }

    @Override
    protected String _getCompanyIds(Context ctx, String curCompanyId, String permItemName, OrgType orgType) throws BOSException, EASBizException {
        OrgUnitCollection companys = TDUtils.getAuthOrgByPermItem(ctx, orgType, permItemName);
        HashSet<String> companyids = new HashSet<String>();
        for (int i = 0; i < companys.size(); ++i) {
            companyids.add(companys.get(i).getId().toString());
        }
        HashSet companyOrgids = new HashSet();
        HashSet<String> curOUId = new HashSet<String>();
        if (curCompanyId != null) {
            curOUId.add(curCompanyId);
            TDUtils.getCompanyOrgUnitIds(ctx, curOUId, companyOrgids);
        }
        if (companyids.size() > 0) {
            companyids.retainAll(companyOrgids);
        }
        companyids.add("");
        return CollectionUtil.convertSet2String(companyids, ",", true);
    }

    @Override
    protected boolean _delAttachment(Context ctx, String rowId) throws BOSException, EASBizException {
        boolean isSuccess = false;
        StringBuffer sb = new StringBuffer();
        sb.append("delete from  T_BAS_BoAttchAsso where Fboid ='" + rowId + "'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        isSuccess = true;
        return isSuccess;
    }
}

