/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.account.engine.interfaces.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.account.engine.interfaces.ISQLBuilder;
import com.kingdee.eas.tm.td.account.engine.interfaces.impl.AbstractAccountCalculator;
import com.kingdee.eas.tm.td.account.engine.interfaces.impl.DefaultAccountSQLBuilder;
import com.kingdee.eas.tm.td.account.engine.model.AccountCalculatorParams;
import com.kingdee.eas.tm.td.account.engine.util.AccountEngineUtil;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.List;
import org.apache.log4j.Logger;

public class DefaultAccountCalculator
extends AbstractAccountCalculator {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.account.engine.interfaces.impl.DefaultAccountCalculator");

    public DefaultAccountCalculator(Context ctx, AccountCalculatorParams params) throws BOSException, EASBizException {
        super(ctx, params);
    }

    @Override
    protected void calculateStep() throws BOSException, EASBizException {
        this.timer.reset();
        this.takeBillData();
        logger.info((Object)("\u5355\u636e\u53d6\u6570\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue()));
    }

    @Override
    protected void afterCalculate() throws BOSException, EASBizException {
        IRowSet rs = this.query();
        IRowSet sumRs = this.querySum();
        this.calculatorResult.setRs(rs);
        this.calculatorResult.setSumRs(sumRs);
        this.calculatorResult.setAccountConfigInfo(this.accountConfigInfo);
    }

    protected IRowSet query() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Select ");
        sql.append(AccountEngineUtil.getDimFieldStr(this.accountConfigInfo));
        sql.append(" ").append("From ");
        sql.append(this.detailTempTable);
        sql.append(AccountEngineUtil.getOrderSQL(this.accountConfigInfo, false));
        return DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
    }

    protected IRowSet querySum() throws EASBizException, BOSException {
        List groupFields = (List)this.params.get("groupFields");
        List sumFields = (List)this.params.get("sumFields");
        if (groupFields == null || sumFields == null || groupFields.isEmpty() || sumFields.isEmpty()) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Select ");
        sql.append(AccountEngineUtil.getFieldFromList(groupFields, this.fieldMap));
        sql.append(",");
        sql.append(AccountEngineUtil.getFieldFromSumList(sumFields));
        sql.append(" ").append("From ");
        sql.append(this.detailTempTable);
        sql.append(" group by ");
        sql.append(AccountEngineUtil.getFieldGroupList(groupFields, this.fieldMap));
        sql.append(AccountEngineUtil.getOrderSQL(this.accountConfigInfo, true));
        return DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
    }

    @Override
    protected ISQLBuilder createSQLBuilder(TakeDataContditionInfo conditionInfo) {
        return new DefaultAccountSQLBuilder(this.ctx, this.accountConfigInfo, conditionInfo, this.params);
    }
}

