/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.common.billimport.TDBillImportBase;
import com.kingdee.eas.tm.td.est.CalcFormulaCollection;
import com.kingdee.eas.tm.td.est.CalcFormulaFactory;
import com.kingdee.eas.tm.td.est.CalcFormulaInfo;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.ICalcFormula;
import com.kingdee.eas.tm.td.est.ILandData;
import com.kingdee.eas.tm.td.est.IRealEstateGroup;
import com.kingdee.eas.tm.td.est.LandDataCollection;
import com.kingdee.eas.tm.td.est.LandDataFactory;
import com.kingdee.eas.tm.td.est.LandDataInfo;
import com.kingdee.eas.tm.td.est.LandLevelEnum;
import com.kingdee.eas.tm.td.est.LandMethodEnum;
import com.kingdee.eas.tm.td.est.LandNatureEnum;
import com.kingdee.eas.tm.td.est.LandUsageEnum;
import com.kingdee.eas.tm.td.est.MonthEnum;
import com.kingdee.eas.tm.td.est.RealEstateGroupCollection;
import com.kingdee.eas.tm.td.est.RealEstateGroupFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.est.TaxCycleEnum;
import com.kingdee.eas.tm.td.est.taxPayerTypeEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class LandDataDataImport
extends AbstractDataTransmission {
    String curKey = null;
    private static final String[] ATTR_NAME_F7 = new String[]{"realEstateGroup", "country", "province", "city", "region", "calcFormula"};
    private static final String[] CELL_NAME_F7 = new String[]{"FRealEstateGroup_number", "FCountry_number", "FProvince_number", "FCity_number", "FRegion_number", "FCalcFormula_number"};
    private static final String[] COUNTRY_ATTR_NAME = new String[]{"country"};
    private static final String[] PROVINCE_ATTR_NAME = new String[]{"province"};
    private static final String[] CITY_ATTR_NAME = new String[]{"city"};
    private static final String[] REGION_ATTR_NAME = new String[]{"region"};
    private static final String[] ATTR_NAME_TEXT = new String[]{"sysNumber", "certificateNumber", "unitNumber", "landNo", "taxBureau", "taxBureauTel", "address", "description"};
    private static final String[] CELL_NAME_TEXT = new String[]{"FSysNumber", "FCertificateNumber", "FUnitNumber", "FLandNo", "FTaxBureau", "FTaxBureauTel", "FAddress", "FDescription_l2"};
    private static final String[] ATTR_NAME_NUM = new String[]{"area", "taxStandard", "landPrice", "usageAmount", "landCost"};
    private static final String[] CELL_NAME_NUM = new String[]{"FArea", "FTaxStandard", "FLandPrice", "FUsageAmount", "FLandCost"};
    private static final String[] ATTR_NAME_DATE = new String[]{"landTime", "taxStartTime", "taxEndTime"};
    private static final String[] CELL_NAME_DATE = new String[]{"FLandTime", "FTaxStartTime", "FTaxEndTime"};
    private static final String[] ATTR_NAME_ENUM = new String[]{"landNature", "landMethod", "usage", "state", "landLevel", "taxCycle", "firstPaymentMonth", "taxPayerType"};
    private static final String[] CELL_NAME_ENUM = new String[]{"FLandNature", "FLandMethod", "FUsage", "FState", "FLandLevel", "FTaxCycle", "FFirstPaymentMonth", "FTaxPayerType"};
    private static final String[] ATTR_NAME_REQUIRED = new String[]{"realEstateGroup", "landTime", "state", "area", "taxStandard", "taxCycle", "firstPaymentMonth", "calcFormula", "taxPayerType", "landNature", "usage"};
    private static final int VALUE_PRECISION = 2;
    private static final int AREA_PRECISION = 2;
    private static final Pattern PATTERN = Pattern.compile("0|([-]?[1-9][0-9]*)");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return LandDataFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            Logger.error((Throwable)bex);
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iLandData = this.getController(ctx);
        LandDataInfo landData = (LandDataInfo)coreBaseInfo;
        if (coreBaseInfo == null) {
            return;
        }
        try {
            if (coreBaseInfo.getId() == null || !iLandData.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iLandData.addnew(coreBaseInfo);
            } else {
                iLandData.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        LandDataInfo landData = new LandDataInfo();
        try {
            String number = ((DataToken)hsData.get((Object)"FNumber")).data.toString();
            if (null == number || number.length() <= 0) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "NumberNotNull", ctx.getLocale()));
            }
            this.curKey = number;
            Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
            int mode = datataskMode;
            this.doCompany(hsData, ctx, landData);
            landData = this.getInfo(ctx, mode, number, landData);
            landData = this.parseInfo(hsData, ctx, landData);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return landData;
    }

    private LandDataInfo getInfo(Context ctx, int mode, String number, LandDataInfo landDataInfo) throws BOSException, EASBizException, TaskExternalException {
        String importCompanyId = String.valueOf(landDataInfo.getCompany().getId());
        if (mode == 16 || mode == 128) {
            if (number == null) {
                return landDataInfo;
            }
            try {
                LandDataCollection coll = LandDataFactory.getLocalInstance(ctx).getLandDataCollection("where number ='" + number + "'");
                if (coll != null && coll.size() > 0) {
                    landDataInfo = coll.get(0);
                    String existCompanyId = String.valueOf(landDataInfo.getCompany().getId());
                    this.checkPermission(ctx, existCompanyId);
                    if (!existCompanyId.equals(importCompanyId)) {
                        String str = TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "UPDATE_COMPANY_ERROR", ctx.getLocale());
                        throw new TaskExternalException(number.toString().trim() + "  " + str);
                    }
                    if ("1".equals(landDataInfo.getState().getValue())) {
                        String str = TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "BILLSTATUS_ERROR1", ctx.getLocale());
                        throw new TaskExternalException(number.toString().trim() + "  " + str);
                    }
                } else {
                    String str = TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "LandDataNotExists", ctx.getLocale());
                    throw new TaskExternalException(number.toString().trim() + "  " + str);
                }
                landDataInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                return landDataInfo;
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage());
            }
        }
        if (mode == 8) {
            this.checkPermission(ctx, importCompanyId);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            view.setFilter(filter);
            LandDataCollection coll = LandDataFactory.getLocalInstance(ctx).getLandDataCollection(view);
            if (coll.size() > 0) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "LandDataHasExists", ctx.getLocale()));
            }
            UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (currentUserInfo != null) {
                landDataInfo.setCreator(currentUserInfo);
            }
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            landDataInfo.setCU(cu);
            Timestamp importTimestamp = new Timestamp(System.currentTimeMillis());
            landDataInfo.setCreateTime(importTimestamp);
            landDataInfo.setLastUpdateTime(importTimestamp);
            return landDataInfo;
        }
        return landDataInfo;
    }

    private LandDataInfo parseInfo(Hashtable hsData, Context ctx, LandDataInfo landDataInfo) throws TaskExternalException, TDException {
        int i;
        String number = ((DataToken)hsData.get((Object)"FNumber")).data.toString();
        if (null == number || number.length() <= 0) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "NumberNotNull", ctx.getLocale()));
        }
        landDataInfo.setNumber(number);
        this.doName(hsData, ctx, landDataInfo);
        for (i = 0; i < ATTR_NAME_F7.length; ++i) {
            this.doF7(hsData, ctx, landDataInfo, ATTR_NAME_F7[i], CELL_NAME_F7[i]);
        }
        for (i = 0; i < ATTR_NAME_TEXT.length; ++i) {
            this.doText(hsData, ctx, landDataInfo, ATTR_NAME_TEXT[i], CELL_NAME_TEXT[i]);
        }
        for (i = 0; i < ATTR_NAME_NUM.length; ++i) {
            this.doNum(hsData, ctx, landDataInfo, ATTR_NAME_NUM[i], CELL_NAME_NUM[i]);
        }
        for (i = 0; i < ATTR_NAME_DATE.length; ++i) {
            this.doDate(hsData, ctx, landDataInfo, ATTR_NAME_DATE[i], CELL_NAME_DATE[i]);
        }
        for (i = 0; i < ATTR_NAME_ENUM.length; ++i) {
            this.doEnum(hsData, ctx, landDataInfo, ATTR_NAME_ENUM[i], CELL_NAME_ENUM[i]);
        }
        return landDataInfo;
    }

    private void doName(Hashtable hsData, Context ctx, LandDataInfo landDataInfo) throws TaskExternalException {
        String name = this.getCellStr(hsData, "FName_l2");
        if (name == null || "".equals(name)) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "NameNotNull", ctx.getLocale()));
        }
        landDataInfo.setName(name);
    }

    private void doCompany(Hashtable hsData, Context ctx, LandDataInfo landDataInfo) throws TaskExternalException, TDException {
        CompanyOrgUnitInfo company = this.getCompany(ctx, hsData);
        landDataInfo.setCompany(company);
    }

    private CompanyOrgUnitInfo getCompany(Context ctx, Hashtable hsData) throws TaskExternalException, TDException {
        CompanyOrgUnitInfo comOrgUnitInfo = null;
        String FCompanyNumber = ((DataToken)hsData.get((Object)"FCompany_number")).data.toString();
        if (FCompanyNumber != null && FCompanyNumber.length() > 0) {
            String sql = "select top 1 fid,fnumber,fname_l2,fisbizunit  from T_ORG_COMPANY where fnumber = ?";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{FCompanyNumber});
                if (rs != null && rs.next()) {
                    if (!"1".equals(rs.getString("fisbizunit"))) {
                        throw new TDException(TDException.NOTBIZCOMPANY);
                    }
                } else {
                    throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "CompanyNotExists", ctx.getLocale()));
                }
                comOrgUnitInfo = new CompanyOrgUnitInfo();
                comOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                comOrgUnitInfo.setNumber(rs.getString("fnumber"));
                comOrgUnitInfo.setName(rs.getString("fname_l2"));
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            catch (UuidException e) {
                Logger.error((Throwable)e);
            }
            catch (SQLException e) {
                Logger.error((Throwable)e);
            }
        } else {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "CompanyNumberNotNULL", ctx.getLocale()));
        }
        return comOrgUnitInfo;
    }

    private boolean checkSameCompany(Context ctx, CompanyOrgUnitInfo companyInfo) throws TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        ILandData iLandData = (ILandData)this.getController(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        try {
            LandDataCollection coll = iLandData.getLandDataCollection(view);
            return coll.size() > 0;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void checkPermission(Context ctx, String companyId) throws TaskExternalException {
        String permItem = "land_landData_new";
        if (this.isSltImportUpdate()) {
            permItem = "land_landData_edit";
        }
        try {
            TDUtils.checkPermission(ctx, String.valueOf(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), companyId, permItem);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private void doF7(Hashtable hsData, Context ctx, LandDataInfo landDataInfo, String attrName, String cellName) throws TaskExternalException {
        String number = this.getCellStr(hsData, cellName);
        String colName = this.colName(hsData, cellName);
        if (number == null || "".equals(number)) {
            if (this.isInclude(ATTR_NAME_REQUIRED, attrName)) {
                String errorMsg = colName + TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "Data_NotNull", ctx.getLocale());
                throw new TaskExternalException(errorMsg);
            }
            return;
        }
        CoreBaseInfo info = new CoreBaseInfo(){};
        try {
            if (this.isInclude(COUNTRY_ATTR_NAME, attrName)) {
                info = DataImportUtils.getCountryInfoFromNumber((Context)ctx, (String)number);
            } else if (this.isInclude(PROVINCE_ATTR_NAME, attrName)) {
                info = DataImportUtils.getProvinceInfoFromNumber((Context)ctx, (String)number);
            } else if (this.isInclude(CITY_ATTR_NAME, attrName)) {
                info = DataImportUtils.getCityInfoFromNumber((Context)ctx, (String)number);
            } else if (this.isInclude(REGION_ATTR_NAME, attrName)) {
                info = DataImportUtils.getRegionInfoFromNumber((Context)ctx, (String)number);
            } else if ("realEstateGroup".equals(attrName)) {
                info = this.getRealEstateGroupInfoFromNumber(ctx, number);
            } else if ("calcFormula".equalsIgnoreCase(attrName)) {
                info = this.getCalcFormulaInfoFromNumber(ctx, number, colName);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (info == null) {
            String errorMsg = colName + TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "Data_Error", ctx.getLocale());
            throw new TaskExternalException(errorMsg);
        }
        landDataInfo.put(attrName, info);
    }

    private CoreBaseInfo getRealEstateGroupInfoFromNumber(Context ctx, String number) throws BOSException {
        RealEstateGroupInfo info = null;
        if (number != null && number.trim().length() > 0) {
            EntityViewInfo viewInfo = DataImportUtils.getViewInfo((String)number);
            IRealEstateGroup iRealEstateGroup = RealEstateGroupFactory.getLocalInstance(ctx);
            RealEstateGroupCollection collection = iRealEstateGroup.getRealEstateGroupCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
            }
        }
        return info;
    }

    private CoreBaseInfo getCalcFormulaInfoFromNumber(Context ctx, String number, String colName) throws BOSException, TaskExternalException {
        CalcFormulaInfo info = null;
        if (number != null && number.trim().length() > 0) {
            EntityViewInfo viewInfo = DataImportUtils.getViewInfo((String)number);
            ICalcFormula iCalcFormula = CalcFormulaFactory.getLocalInstance(ctx);
            CalcFormulaCollection collection = iCalcFormula.getCalcFormulaCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
                if (info == null) {
                    return null;
                }
                if (!"d8umkg7qNn3gU0ETqMCsX9uK96Y=".equals(String.valueOf(info.getTaxItemType().getId()))) {
                    String errorMsg = colName + TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "CalFormula_Not_Land", ctx.getLocale());
                    throw new TaskExternalException(errorMsg);
                }
            }
        }
        return info;
    }

    private void doText(Hashtable hsData, Context ctx, LandDataInfo landDataInfo, String attrName, String cellName) throws TaskExternalException {
        String str = this.getCellStr(hsData, cellName);
        String colName = this.colName(hsData, cellName);
        if ((str == null || "".equals(str)) && this.isInclude(ATTR_NAME_REQUIRED, attrName)) {
            throw new TaskExternalException(colName + TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "Data_NotNull", ctx.getLocale()));
        }
        landDataInfo.put(attrName, str, null);
    }

    private void doNum(Hashtable hsData, Context ctx, LandDataInfo landDataInfo, String attrName, String cellName) throws TaskExternalException {
        String num = this.getCellStr(hsData, cellName);
        String colName = this.colName(hsData, cellName);
        BigDecimal bdNum = null;
        if (num != null && !"".equals(num)) {
            String valStr = num.trim();
            bdNum = TDBillImportBase.getNumberByString(ctx, valStr, 2, TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "Number_Error", ctx.getLocale(), new Object[]{colName, 2}), false);
            if ("area".equals(attrName) && (bdNum = bdNum.setScale(2, 4)).compareTo(BigDecimal.ZERO) <= 0) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"AreaLargerZero"));
            }
            if ("taxStandard".equals(attrName) && (bdNum = bdNum.setScale(2, 4)).compareTo(BigDecimal.ZERO) <= 0) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"TaxStandardLargerZero"));
            }
            if ("landPrice".equals(attrName) && (bdNum = bdNum.setScale(2, 4)).compareTo(BigDecimal.ZERO) < 0) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"LandPriceNotSmallerZero"));
            }
            if ("usageAmount".equals(attrName) && (bdNum = bdNum.setScale(2, 4)).compareTo(BigDecimal.ZERO) < 0) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"UsageAmountNotSmallerZero"));
            }
            if ("landCost".equals(attrName) && (bdNum = bdNum.setScale(2, 4)).compareTo(BigDecimal.ZERO) < 0) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"LandCostNotSmallerZero"));
            }
            landDataInfo.put(attrName, bdNum);
        } else if (this.isInclude(ATTR_NAME_REQUIRED, attrName)) {
            throw new TaskExternalException(colName + TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "Data_NotNull", ctx.getLocale()));
        }
    }

    private void doDate(Hashtable hsData, Context ctx, LandDataInfo landDataInfo, String attrName, String cellName) throws TaskExternalException {
        String colName = this.colName(hsData, cellName);
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Object o = ((DataToken)hsData.get((Object)cellName)).data;
        if (o != null && o.toString().length() > 0) {
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                throw new TaskExternalException(colName + TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "Data_Error", ctx.getLocale()));
            }
        }
        if (o != null && o instanceof Date) {
            date = (Date)o;
        }
        if (date == null && this.isInclude(ATTR_NAME_REQUIRED, attrName)) {
            throw new TaskExternalException(colName + TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "Data_NotNull", ctx.getLocale()));
        }
        landDataInfo.put(attrName, date);
    }

    private void doEnum(Hashtable hsData, Context ctx, LandDataInfo landDataInfo, String attrName, String cellName) throws TaskExternalException {
        String colName = this.colName(hsData, cellName);
        String value = this.getCellStr(hsData, cellName).trim();
        if (value != null && !"".equals(value)) {
            IntEnum intEnumTemp = null;
            StringEnum strEnumTemp = null;
            if (attrName.equals("landNature")) {
                if (PATTERN.matcher(value).matches()) {
                    intEnumTemp = LandNatureEnum.getEnum(Integer.parseInt(value));
                }
                if (intEnumTemp == null) {
                    List enumList = LandNatureEnum.getEnumList();
                    for (IntEnum _enum : enumList) {
                        if (!_enum.getAlias().trim().equals(value)) continue;
                        intEnumTemp = _enum;
                        break;
                    }
                }
            } else if (attrName.equals("landMethod")) {
                if (PATTERN.matcher(value).matches()) {
                    intEnumTemp = LandMethodEnum.getEnum(Integer.parseInt(value));
                }
                if (intEnumTemp == null) {
                    List enumList = LandMethodEnum.getEnumList();
                    for (IntEnum _enum : enumList) {
                        if (!_enum.getAlias().trim().equals(value)) continue;
                        intEnumTemp = _enum;
                        break;
                    }
                }
            } else if (attrName.equals("usage")) {
                if (PATTERN.matcher(value).matches()) {
                    intEnumTemp = LandUsageEnum.getEnum(Integer.parseInt(value));
                }
                if (intEnumTemp == null) {
                    List enumList = LandUsageEnum.getEnumList();
                    for (IntEnum _enum : enumList) {
                        if (!_enum.getAlias().trim().equals(value)) continue;
                        intEnumTemp = _enum;
                        break;
                    }
                }
            } else if (attrName.equals("state")) {
                strEnumTemp = EstStateEnum.getEnum(value);
                if (strEnumTemp == null) {
                    List enumList = EstStateEnum.getEnumList();
                    for (StringEnum _enum : enumList) {
                        if (!_enum.getAlias().trim().equals(value)) continue;
                        strEnumTemp = _enum;
                        break;
                    }
                }
            } else if (attrName.equals("landLevel")) {
                if (PATTERN.matcher(value).matches()) {
                    intEnumTemp = LandLevelEnum.getEnum(Integer.parseInt(value));
                }
                if (intEnumTemp == null) {
                    List enumList = LandLevelEnum.getEnumList();
                    for (IntEnum _enum : enumList) {
                        if (!_enum.getAlias().trim().equals(value)) continue;
                        intEnumTemp = _enum;
                        break;
                    }
                }
            } else if (attrName.equals("taxCycle")) {
                if (PATTERN.matcher(value).matches()) {
                    intEnumTemp = TaxCycleEnum.getEnum(Integer.parseInt(value));
                }
                if (intEnumTemp == null) {
                    List enumList = TaxCycleEnum.getEnumList();
                    for (IntEnum _enum : enumList) {
                        if (!_enum.getAlias().trim().equals(value)) continue;
                        intEnumTemp = _enum;
                        break;
                    }
                }
            } else if (attrName.equals("firstPaymentMonth")) {
                if (PATTERN.matcher(value).matches() && !String.valueOf(0).equals(value)) {
                    intEnumTemp = MonthEnum.getEnum(Integer.parseInt(value));
                }
                if (intEnumTemp == null) {
                    List enumList = MonthEnum.getEnumList();
                    for (IntEnum _enum : enumList) {
                        if (!_enum.getAlias().trim().equals(value)) continue;
                        intEnumTemp = _enum;
                        break;
                    }
                }
            } else if (attrName.equals("taxPayerType") && (strEnumTemp = taxPayerTypeEnum.getEnum(value)) == null) {
                List enumList = taxPayerTypeEnum.getEnumList();
                for (StringEnum _enum : enumList) {
                    if (!_enum.getAlias().trim().equals(value)) continue;
                    strEnumTemp = _enum;
                    break;
                }
            }
            if (intEnumTemp == null && strEnumTemp == null) {
                throw new TaskExternalException(colName + TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "Data_Error", ctx.getLocale()));
            }
            if (intEnumTemp != null) {
                landDataInfo.put(attrName, intEnumTemp.getValue());
            } else if (strEnumTemp != null) {
                landDataInfo.put(attrName, strEnumTemp.getValue());
            }
        } else if (this.isInclude(ATTR_NAME_REQUIRED, attrName)) {
            throw new TaskExternalException(colName + TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "Data_NotNull", ctx.getLocale()));
        }
    }

    public boolean isInclude(String[] array, String str) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != str) continue;
            return true;
        }
        return false;
    }

    private String colName(Hashtable hsData, String cellName) {
        String retval = ((DataToken)hsData.get((Object)cellName)).desc;
        return retval;
    }

    private String getCellStr(Hashtable hsData, String cellName) {
        String retval = "";
        Object o = ((DataToken)hsData.get((Object)cellName)).data;
        if (o != null && !"".equals(o.toString())) {
            retval = o.toString();
        }
        return retval;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            DataImportTools.putToHashtable(result, (Object)"FCompany_number", (Object)rs.getString("company.number"));
            DataImportTools.putToHashtable(result, (Object)"FCompany_name_l2", (Object)rs.getString("company.name"));
            DataImportTools.putToHashtable(result, (Object)"FRealEstateGroup_number", (Object)rs.getString("realEstateGroup.number"));
            DataImportTools.putToHashtable(result, (Object)"FRealEstateGroup_name_l2", (Object)rs.getString("realEstateGroup.name"));
            DataImportTools.putToHashtable(result, (Object)"FNumber", (Object)rs.getString("number"));
            DataImportTools.putToHashtable(result, (Object)"FName_l2", (Object)rs.getString("name"));
            DataImportTools.putToHashtable(result, (Object)"FSysNumber", (Object)rs.getString("sysNumber"));
            DataImportTools.putToHashtable(result, (Object)"FCertificateNumber", (Object)rs.getString("certificateNumber"));
            DataImportTools.putToHashtable(result, (Object)"FUnitNumber", (Object)rs.getString("unitNumber"));
            DataImportTools.putToHashtable(result, (Object)"FLandNo", (Object)rs.getString("landNo"));
            DataImportTools.putToHashtable(result, (Object)"FLandNature", (Object)((Object)LandNatureEnum.getEnum(rs.getInt("landNature"))));
            DataImportTools.putToHashtable(result, (Object)"FLandMethod", (Object)((Object)LandMethodEnum.getEnum(rs.getInt("landMethod"))));
            DataImportTools.putToHashtable(result, (Object)"FLandTime", (Object)rs.getString("landTime"));
            DataImportTools.putToHashtable(result, (Object)"FUsage", (Object)((Object)LandUsageEnum.getEnum(rs.getInt("usage"))));
            DataImportTools.putToHashtable(result, (Object)"FCountry_number", (Object)rs.getString("country.number"));
            DataImportTools.putToHashtable(result, (Object)"FCountry_name_l2", (Object)rs.getString("country.name"));
            DataImportTools.putToHashtable(result, (Object)"FProvince_number", (Object)rs.getString("province.number"));
            DataImportTools.putToHashtable(result, (Object)"FProvince_name_l2", (Object)rs.getString("province.name"));
            DataImportTools.putToHashtable(result, (Object)"FCity_number", (Object)rs.getString("city.number"));
            DataImportTools.putToHashtable(result, (Object)"FCity_name_l2", (Object)rs.getString("city.name"));
            DataImportTools.putToHashtable(result, (Object)"FRegion_number", (Object)rs.getString("region.number"));
            DataImportTools.putToHashtable(result, (Object)"FRegion_name_l2", (Object)rs.getString("region.name"));
            DataImportTools.putToHashtable(result, (Object)"FAddress", (Object)rs.getString("address"));
            DataImportTools.putToHashtable(result, (Object)"FDescription_l2", (Object)rs.getString("description"));
            DataImportTools.putToHashtable(result, (Object)"FTaxBureau", (Object)rs.getString("taxBureau"));
            DataImportTools.putToHashtable(result, (Object)"FTaxBureauTel", (Object)rs.getString("taxBureauTel"));
            DataImportTools.putToHashtable(result, (Object)"FState", (Object)((Object)EstStateEnum.getEnum(rs.getString("state"))));
            DataImportTools.putToHashtable(result, (Object)"FTaxPayerType", (Object)((Object)taxPayerTypeEnum.getEnum(rs.getString("taxPayerType"))));
            DataImportTools.putToHashtable(result, (Object)"FTaxStartTime", (Object)rs.getString("taxStartTime"));
            DataImportTools.putToHashtable(result, (Object)"FTaxEndTime", (Object)rs.getString("taxEndTime"));
            DataImportTools.putToHashtable(result, (Object)"FArea", (Object)rs.getString("area"));
            DataImportTools.putToHashtable(result, (Object)"FLandLevel", (Object)((Object)LandLevelEnum.getEnum(rs.getInt("landLevel"))));
            DataImportTools.putToHashtable(result, (Object)"FTaxStandard", (Object)rs.getString("taxStandard"));
            DataImportTools.putToHashtable(result, (Object)"FLandPrice", (Object)rs.getString("landPrice"));
            DataImportTools.putToHashtable(result, (Object)"FUsageAmount", (Object)rs.getString("usageAmount"));
            DataImportTools.putToHashtable(result, (Object)"FLandCost", (Object)rs.getString("landCost"));
            DataImportTools.putToHashtable(result, (Object)"FTaxCycle", (Object)((Object)TaxCycleEnum.getEnum(rs.getInt("taxCycle"))));
            DataImportTools.putToHashtable(result, (Object)"FFirstPaymentMonth", (Object)((Object)MonthEnum.getEnum(rs.getInt("firstPaymentMonth"))));
            DataImportTools.putToHashtable(result, (Object)"FCalcFormula_number", (Object)rs.getString("calcFormula.number"));
            DataImportTools.putToHashtable(result, (Object)"FCalcFormula_name_l2", (Object)rs.getString("calcFormula.name"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        if (this.getContextMap().get("filter") != null) {
            String filterStr = this.getContextMap().get("filter").toString();
            filterStr = filterStr.replace("$", "'");
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                Logger.error((Throwable)e);
            }
        }
        if (this.getContextMap().get("bizCommonQueryFilter") != null) {
            String filterItems = this.getContextMap().get("bizCommonQueryFilter").toString();
            filterItems = filterItems.replace("$", "'");
            try {
                filter = new FilterInfo(filterItems);
            }
            catch (ParserException e) {
                Logger.error((Throwable)e);
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.td.est.app.LandDataQuery";
    }
}

