/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.assistant.RegionInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.common.billimport.TDBillImportBase;
import com.kingdee.eas.tm.td.est.CalcFormulaInfo;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.IRealEstate;
import com.kingdee.eas.tm.td.est.LandDataInfo;
import com.kingdee.eas.tm.td.est.MonthEnum;
import com.kingdee.eas.tm.td.est.PurposeEnum;
import com.kingdee.eas.tm.td.est.RealEstateCollection;
import com.kingdee.eas.tm.td.est.RealEstateFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.est.RealEstateInfo;
import com.kingdee.eas.tm.td.est.TaxCycleEnum;
import com.kingdee.eas.tm.td.est.taxPayerTypeEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class RealEstateDataImport
extends AbstractDataTransmission {
    String curKey = null;
    private static final int VALUE_PRECISION = 2;
    private static final int AREA_PRECISION = 2;
    private static final int RATE_PRECISION = 4;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return RealEstateFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            Logger.error((Throwable)bex);
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iRealEstate = this.getController(ctx);
        RealEstateInfo realEstate = (RealEstateInfo)coreBaseInfo;
        if (coreBaseInfo == null) {
            return;
        }
        try {
            if (coreBaseInfo.getId() == null || !iRealEstate.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iRealEstate.addnew(coreBaseInfo);
            } else {
                iRealEstate.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        RealEstateInfo realEstate = new RealEstateInfo();
        try {
            String number = ((DataToken)hsData.get((Object)"FNumber")).data.toString();
            if (null == number || number.length() <= 0) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "NumberNotNull", ctx.getLocale()));
            }
            this.curKey = number;
            Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
            int mode = datataskMode;
            CompanyOrgUnitInfo company = this.getCompany(ctx, hsData);
            realEstate.setCompany(company);
            realEstate = this.getInfo(ctx, mode, number, realEstate);
            realEstate = this.parseInfo(hsData, ctx, realEstate);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return realEstate;
    }

    private RealEstateInfo getInfo(Context ctx, int mode, String number, RealEstateInfo realEstateInfo) throws BOSException, EASBizException, TaskExternalException {
        String importCompanyId = String.valueOf(realEstateInfo.getCompany().getId());
        if (mode == 16 || mode == 128) {
            if (number == null) {
                return realEstateInfo;
            }
            try {
                RealEstateCollection coll = RealEstateFactory.getLocalInstance(ctx).getRealEstateCollection("where number ='" + number + "'");
                if (coll != null && coll.size() > 0) {
                    realEstateInfo = coll.get(0);
                    String existCompanyId = String.valueOf(realEstateInfo.getCompany().getId());
                    this.checkPermission(ctx, existCompanyId);
                    if (!existCompanyId.equals(importCompanyId)) {
                        String str = TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "UPDATE_COMPANY_ERROR", ctx.getLocale());
                        throw new TaskExternalException(number.toString().trim() + "  " + str);
                    }
                    if (!"0".equals(realEstateInfo.getState().getValue())) {
                        String str = TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "BILLSTATUS_ERROR1", ctx.getLocale());
                        throw new TaskExternalException(number.toString().trim() + "  " + str);
                    }
                } else {
                    String str = TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "realEstateNotExists", ctx.getLocale());
                    throw new TaskExternalException(number.toString().trim() + "  " + str);
                }
                Timestamp importTimestamp = new Timestamp(System.currentTimeMillis());
                realEstateInfo.setLastUpdateTime(importTimestamp);
                return realEstateInfo;
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage());
            }
        }
        if (mode == 8) {
            this.checkPermission(ctx, importCompanyId);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            view.setFilter(filter);
            RealEstateCollection coll = RealEstateFactory.getLocalInstance(ctx).getRealEstateCollection(view);
            if (coll.size() > 0) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "RealEstateHasExists", ctx.getLocale()));
            }
            UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (currentUserInfo != null) {
                realEstateInfo.setCreator(currentUserInfo);
                realEstateInfo.setCU(currentUserInfo.getCU());
            }
            Timestamp importTimestamp = new Timestamp(System.currentTimeMillis());
            realEstateInfo.setCreateTime(importTimestamp);
            realEstateInfo.setLastUpdateTime(importTimestamp);
            return realEstateInfo;
        }
        return realEstateInfo;
    }

    private RealEstateInfo parseInfo(Hashtable hsData, Context ctx, RealEstateInfo realEstateInfo) throws TaskExternalException, TDException, BOSException, SQLException {
        String calcRateString;
        BigDecimal taxValue;
        String taxValueString;
        String isReference;
        BigDecimal originalValue;
        BigDecimal buildingArea;
        Date value;
        String number = ((DataToken)hsData.get((Object)"FNumber")).data.toString();
        if (null == number || number.length() <= 0) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "NumberNotNull", ctx.getLocale()));
        }
        realEstateInfo.setNumber(number);
        String name = ((DataToken)hsData.get((Object)"FName")).data.toString();
        if (null == name || name.length() <= 0) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "NameNotNull", ctx.getLocale()));
        }
        realEstateInfo.setName(name);
        EstStateEnum state = this.getStateEnum(ctx, hsData);
        realEstateInfo.setState(state);
        String sysNumber = ((DataToken)hsData.get((Object)"FSysNumber")).data.toString();
        realEstateInfo.setSysNumber(sysNumber);
        String certificateNumber = ((DataToken)hsData.get((Object)"FCertificateNumber")).data.toString();
        realEstateInfo.setCertificateNumber(certificateNumber);
        String unitNumber = ((DataToken)hsData.get((Object)"FUnitNumber")).data.toString();
        if (unitNumber == null || unitNumber.isEmpty()) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "UnitNumberNotNull", ctx.getLocale()));
        }
        realEstateInfo.setUnitNumber(unitNumber);
        taxPayerTypeEnum taxPayerTypeEnum2 = this.getTaxPayerTypeEnum(ctx, hsData);
        realEstateInfo.setTaxPayerType(taxPayerTypeEnum2);
        LandDataInfo landData = this.getLandData(ctx, hsData);
        realEstateInfo.setLandData(landData);
        String taxBureau = ((DataToken)hsData.get((Object)"FTaxBureau")).data.toString();
        realEstateInfo.setTaxBureau(taxBureau);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Object o = ((DataToken)hsData.get((Object)"FAcqTime")).data;
        if (o != null && o.toString().length() > 0) {
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                Logger.error((Throwable)pex);
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "DateFormatError", ctx.getLocale()));
            }
        }
        if (o != null && o instanceof Date && (value = (Date)o) != null) {
            realEstateInfo.setAcqTime(value);
        }
        PurposeEnum purpose = this.getPurposeEnum(ctx, hsData);
        realEstateInfo.setPurpose(purpose);
        RealEstateGroupInfo realEstateGroup = this.getRealEstateGroup(ctx, hsData);
        realEstateInfo.setRealEstateGroup(realEstateGroup);
        if (realEstateGroup != null && (realEstateInfo.getTaxBureau() == null || realEstateInfo.getTaxBureau().isEmpty())) {
            realEstateInfo.setTaxBureau(realEstateGroup.getTaxBureau());
        }
        String countryNumber = ((DataToken)hsData.get((Object)"FCountry_number")).data.toString();
        CountryInfo country = DataImportUtils.getCountryInfoFromNumber((Context)ctx, (String)countryNumber);
        if (countryNumber != null && !"".equals(countryNumber) && country == null) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "countryNumberNotExists", ctx.getLocale()));
        }
        realEstateInfo.put("country", country);
        String provinceNumber = ((DataToken)hsData.get((Object)"FProvince_number")).data.toString();
        ProvinceInfo province = DataImportUtils.getProvinceInfoFromNumber((Context)ctx, (String)provinceNumber);
        if (provinceNumber != null && !"".equals(provinceNumber) && province == null) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "provinceNumberNotExists", ctx.getLocale()));
        }
        realEstateInfo.put("province", province);
        String cityNumber = ((DataToken)hsData.get((Object)"FCity_number")).data.toString();
        CityInfo city = DataImportUtils.getCityInfoFromNumber((Context)ctx, (String)cityNumber);
        if (cityNumber != null && !"".equals(cityNumber) && city == null) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "cityNumberNotExists", ctx.getLocale()));
        }
        realEstateInfo.put("city", city);
        String regionNumber = ((DataToken)hsData.get((Object)"FRegion_number")).data.toString();
        RegionInfo region = DataImportUtils.getRegionInfoFromNumber((Context)ctx, (String)regionNumber);
        if (regionNumber != null && !"".equals(regionNumber) && region == null) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "regionNumberNotExists", ctx.getLocale()));
        }
        realEstateInfo.put("region", region);
        String address = ((DataToken)hsData.get((Object)"FAddress")).data.toString();
        realEstateInfo.setAddress(address);
        String description = ((DataToken)hsData.get((Object)"FDescription")).data.toString();
        realEstateInfo.setDescription(description);
        String buildingAreaString = ((DataToken)hsData.get((Object)"FBuildingArea")).data.toString();
        if (null != buildingAreaString && buildingAreaString.length() > 0) {
            buildingArea = TDBillImportBase.getNumberByString(ctx, buildingAreaString, 2, TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "buildingAreaFormatError", ctx.getLocale(), new Object[]{2}), false);
            if (buildingArea.compareTo(BigDecimal.ZERO) <= 0) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "buildingAreaLargerZero", ctx.getLocale()));
            }
        } else {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "BuildingAreaNotNull", ctx.getLocale()));
        }
        realEstateInfo.setBuildingArea(buildingArea.setScale(2, 4));
        String originalValueString = ((DataToken)hsData.get((Object)"FOriginalValue")).data.toString();
        if (null != originalValueString && originalValueString.length() > 0) {
            originalValue = TDBillImportBase.getNumberByString(ctx, originalValueString, 2, TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "originalValueFormatErrot", ctx.getLocale(), new Object[]{2}), false);
            if (BigDecimal.ZERO.compareTo(originalValue) >= 0) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "originalValueLargerZero", ctx.getLocale()));
            }
        } else {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "OriginalValueNotNull", ctx.getLocale()));
        }
        realEstateInfo.setOriginalValue(originalValue.setScale(2, 4));
        String isPriceOnly = ((DataToken)hsData.get((Object)"FIsPriceOnly")).data.toString();
        if (null != isPriceOnly && isPriceOnly.length() > 0) {
            if (TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "TRUE", ctx.getLocale()).equals(isPriceOnly) || "1".equals(isPriceOnly) || "true".equals(isPriceOnly)) {
                realEstateInfo.setIsPriceOnly(true);
            } else if (TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "FALSE", ctx.getLocale()).equals(isPriceOnly) || "0".equals(isPriceOnly) || "false".equals(isPriceOnly)) {
                realEstateInfo.setIsPriceOnly(false);
            } else {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "isPriceOnlyNotCorrect", ctx.getLocale()));
            }
        }
        if (null != (isReference = ((DataToken)hsData.get((Object)"FIsReference")).data.toString()) && isReference.length() > 0) {
            if (TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "TRUE", ctx.getLocale()).equals(isReference) || "1".equals(isReference) || "true".equals(isReference)) {
                realEstateInfo.setIsReference(true);
            } else if (TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "FALSE", ctx.getLocale()).equals(isReference) || "0".equals(isReference) || "false".equals(isReference)) {
                realEstateInfo.setIsReference(false);
            } else {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "isReferenceNotCorrect", ctx.getLocale()));
            }
        }
        if (null != (taxValueString = ((DataToken)hsData.get((Object)"FTaxValue")).data.toString()) && taxValueString.length() > 0) {
            taxValue = TDBillImportBase.getNumberByString(ctx, taxValueString, 2, TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "taxValueFormatError", ctx.getLocale(), new Object[]{2}), false);
            if (BigDecimal.ZERO.compareTo(taxValue) >= 0) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "taxValueLargerZero", ctx.getLocale()));
            }
        } else {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "TaxValueNotNull", ctx.getLocale()));
        }
        realEstateInfo.setTaxValue(taxValue.setScale(2, 4));
        String currencyNumber = ((DataToken)hsData.get((Object)"FCurrency_number")).data.toString();
        CurrencyInfo currency = DataImportUtils.getCurrencyInfoFromNumber((Context)ctx, (String)currencyNumber);
        if (currencyNumber != null && !"".equals(currencyNumber) && currency == null) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "currencyNumberNotExists", ctx.getLocale()));
        }
        realEstateInfo.put("currency", currency);
        String taxRateString = ((DataToken)hsData.get((Object)"FTaxRate")).data.toString();
        if (null != taxRateString && taxRateString.length() > 0) {
            BigDecimal taxRate = TDBillImportBase.getNumberByString(ctx, taxRateString, 4, TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "taxRateFormatError", ctx.getLocale(), new Object[]{4}), true);
            realEstateInfo.setTaxRate(taxRate.setScale(4, 4));
        }
        if (null != (calcRateString = ((DataToken)hsData.get((Object)"FCalcRate")).data.toString()) && calcRateString.length() > 0) {
            BigDecimal calcRate = TDBillImportBase.getNumberByString(ctx, calcRateString, 4, TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "calcRateFormatError", ctx.getLocale(), new Object[]{4}), true);
            realEstateInfo.setCalcRate(calcRate.setScale(4, 4));
        }
        TaxCycleEnum taxCycleEnum = this.getTaxCycleEnum(ctx, hsData);
        realEstateInfo.setTaxCycle(taxCycleEnum);
        MonthEnum firstPaymentMonth = this.getFirstPaymentMonth(ctx, hsData);
        realEstateInfo.setFirstPaymentMonth(firstPaymentMonth);
        CalcFormulaInfo calcFormula = this.getCalcFormula(ctx, hsData);
        realEstateInfo.setCalcFormula(calcFormula);
        return realEstateInfo;
    }

    private CompanyOrgUnitInfo getCompany(Context ctx, Hashtable hsData) throws TaskExternalException, TDException {
        CompanyOrgUnitInfo comOrgUnitInfo = null;
        String FCompanyNumber = ((DataToken)hsData.get((Object)"FCompany_number")).data.toString();
        if (FCompanyNumber != null && FCompanyNumber.length() > 0) {
            String sql = "select top 1 fid,fnumber,fname_l2,fisbizunit  from T_ORG_COMPANY where fnumber = ?";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{FCompanyNumber});
                if (rs != null && rs.next()) {
                    if (!rs.getString("fisbizunit").equals("1")) {
                        throw new TDException(TDException.NOTBIZCOMPANY);
                    }
                } else {
                    throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "CompanyNotExists", ctx.getLocale()));
                }
                comOrgUnitInfo = new CompanyOrgUnitInfo();
                comOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                comOrgUnitInfo.setNumber(rs.getString("fnumber"));
                comOrgUnitInfo.setName(rs.getString("fname_l2"));
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            catch (UuidException e) {
                Logger.error((Throwable)e);
            }
            catch (SQLException e) {
                Logger.error((Throwable)e);
            }
        } else {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "CompanyNumberNotNULL", ctx.getLocale()));
        }
        return comOrgUnitInfo;
    }

    private LandDataInfo getLandData(Context ctx, Hashtable hsData) throws TaskExternalException {
        LandDataInfo landData = null;
        String FLandDataNumber = ((DataToken)hsData.get((Object)"FLandData_number")).data.toString();
        if (FLandDataNumber != null && FLandDataNumber.length() > 0) {
            String sql = "select top 1 fid,FNAME_l2  from T_TD_LandData  where FNUMBER = ?";
            if (FLandDataNumber != null && FLandDataNumber.length() > 0) {
                try {
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{FLandDataNumber});
                    if (rs == null || !rs.next()) {
                        throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "LandDataNumberNotExists", ctx.getLocale()));
                    }
                    landData = new LandDataInfo();
                    landData.setId(BOSUuid.read((String)rs.getString("fid")));
                    landData.setNumber(FLandDataNumber);
                    landData.setName(rs.getString("FNAME_l2"));
                }
                catch (BOSException e) {
                    Logger.error((Throwable)e);
                }
                catch (UuidException e) {
                    Logger.error((Throwable)e);
                }
                catch (SQLException e) {
                    Logger.error((Throwable)e);
                }
            }
        } else {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "LandDataNumberNotNull", ctx.getLocale()));
        }
        return landData;
    }

    private RealEstateGroupInfo getRealEstateGroup(Context ctx, Hashtable hsData) throws TaskExternalException {
        RealEstateGroupInfo realEstateGroupInfo = null;
        String FRealEstateGroupNumber = ((DataToken)hsData.get((Object)"FRealEstateGroup_number")).data.toString();
        String sql = "select top 1 fid,FNAME_l2,FTaxBureau  from T_TD_RealEstateGroup  where FNUMBER = ?";
        if (FRealEstateGroupNumber != null && FRealEstateGroupNumber.length() > 0) {
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{FRealEstateGroupNumber});
                if (rs == null || !rs.next()) {
                    throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "RealEstateGroupNumberNotExists", ctx.getLocale()));
                }
                realEstateGroupInfo = new RealEstateGroupInfo();
                realEstateGroupInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                realEstateGroupInfo.setNumber(FRealEstateGroupNumber);
                realEstateGroupInfo.setName(rs.getString("FNAME_l2"));
                realEstateGroupInfo.setTaxBureau(rs.getString("FTaxBureau"));
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            catch (UuidException e) {
                Logger.error((Throwable)e);
            }
            catch (SQLException e) {
                Logger.error((Throwable)e);
            }
        } else {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "RealEstateGroupNumberNotNULL", ctx.getLocale()));
        }
        return realEstateGroupInfo;
    }

    private CalcFormulaInfo getCalcFormula(Context ctx, Hashtable hsData) throws TaskExternalException {
        CalcFormulaInfo calcFormulaInfo = null;
        String FCalcFormulaNumber = ((DataToken)hsData.get((Object)"FCalcFormula_number")).data.toString();
        String sql = "select top 1 fid,FNAME_l2,FTAXMETHOD,FTAXITEMTYPEID  from T_TD_CalcFormula  where FNUMBER = ?";
        if (FCalcFormulaNumber != null && FCalcFormulaNumber.length() > 0) {
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{FCalcFormulaNumber});
                if (rs != null && rs.next()) {
                    String taxItemTypeID = rs.getString("FTAXITEMTYPEID");
                    String taxMethod = rs.getString("FTAXMETHOD");
                    if (!"ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(taxItemTypeID) || !"1".equals(taxMethod)) {
                        throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "calcFormulaNotExists", ctx.getLocale()));
                    }
                } else {
                    throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "CalcFormulaNumberNotExists", ctx.getLocale()));
                }
                calcFormulaInfo = new CalcFormulaInfo();
                calcFormulaInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                calcFormulaInfo.setNumber(FCalcFormulaNumber);
                calcFormulaInfo.setName(rs.getString("FNAME_l2"));
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            catch (UuidException e) {
                Logger.error((Throwable)e);
            }
            catch (SQLException e) {
                Logger.error((Throwable)e);
            }
        } else {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "CalcFormulaNumberNotNULL", ctx.getLocale()));
        }
        return calcFormulaInfo;
    }

    private TaxCycleEnum getTaxCycleEnum(Context ctx, Hashtable hsData) throws TaskExternalException {
        String taxCycle = ((DataToken)hsData.get((Object)"FTaxCycle")).data.toString();
        TaxCycleEnum taxCycleEnum = null;
        if (null != taxCycle && taxCycle.length() > 0) {
            List list = TaxCycleEnum.getEnumList();
            for (TaxCycleEnum enumType : list) {
                if (0 == enumType.getValue() || !enumType.getAlias().equals(taxCycle)) continue;
                taxCycleEnum = enumType;
                break;
            }
            try {
                if (taxCycleEnum == null) {
                    int taxCycleInt = Integer.valueOf(taxCycle);
                    taxCycleEnum = TaxCycleEnum.getEnum(taxCycleInt);
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "TaxCycleNotExists", ctx.getLocale()));
            }
            if (taxCycleEnum == null) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "TaxCycleNotExists", ctx.getLocale()));
            }
        } else {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "TaxCycleNotNull", ctx.getLocale()));
        }
        return taxCycleEnum;
    }

    private MonthEnum getFirstPaymentMonth(Context ctx, Hashtable hsData) throws TaskExternalException {
        String firstPaymentMonth = ((DataToken)hsData.get((Object)"FFirstPaymentMonth")).data.toString();
        MonthEnum firstPaymentMonthEnum = null;
        if (null != firstPaymentMonth && firstPaymentMonth.length() > 0) {
            List list = MonthEnum.getEnumList();
            for (MonthEnum enumType : list) {
                if (!enumType.getAlias().equals(firstPaymentMonth)) continue;
                firstPaymentMonthEnum = enumType;
                break;
            }
            try {
                if (firstPaymentMonthEnum == null) {
                    int firstPaymentMonthInt = Integer.valueOf(firstPaymentMonth);
                    firstPaymentMonthEnum = MonthEnum.getEnum(firstPaymentMonthInt);
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "FirstPaymentMonthFormatError", ctx.getLocale()));
            }
            if (firstPaymentMonthEnum == null) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "FirstPaymentMonthNotExists", ctx.getLocale()));
            }
        } else {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "FirstPaymentMonthNotNull", ctx.getLocale()));
        }
        return firstPaymentMonthEnum;
    }

    private taxPayerTypeEnum getTaxPayerTypeEnum(Context ctx, Hashtable hsData) throws TaskExternalException {
        taxPayerTypeEnum taxPayerType = null;
        String taxPayerTypeStr = ((DataToken)hsData.get((Object)"FTaxPayerType")).data.toString();
        if (null != taxPayerTypeStr && taxPayerTypeStr.length() > 0) {
            List list = taxPayerTypeEnum.getEnumList();
            for (taxPayerTypeEnum enumType : list) {
                if (!enumType.getAlias().equals(taxPayerTypeStr)) continue;
                taxPayerType = enumType;
                break;
            }
            if (taxPayerType == null) {
                taxPayerType = taxPayerTypeEnum.getEnum(taxPayerTypeStr);
            }
            if (taxPayerType == null) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "TaxPayerTypeNotExists", ctx.getLocale()));
            }
            return taxPayerType;
        }
        throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "TaxPayerTypeNotNull", ctx.getLocale()));
    }

    private PurposeEnum getPurposeEnum(Context ctx, Hashtable hsData) throws TaskExternalException {
        String purpose = ((DataToken)hsData.get((Object)"FPurpose")).data.toString();
        PurposeEnum purposeEnum = null;
        if (null != purpose && purpose.length() > 0) {
            List list = PurposeEnum.getEnumList();
            for (PurposeEnum enumType : list) {
                if (!enumType.getAlias().equals(purpose)) continue;
                purposeEnum = enumType;
                break;
            }
            if (purposeEnum == null) {
                purposeEnum = PurposeEnum.getEnum(purpose);
            }
            if (purposeEnum == null) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "PurposeNotExists", ctx.getLocale()));
            }
            return purposeEnum;
        }
        throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "PurposeNotNull", ctx.getLocale()));
    }

    private EstStateEnum getStateEnum(Context ctx, Hashtable hsData) throws TaskExternalException {
        String state = ((DataToken)hsData.get((Object)"FState")).data.toString();
        EstStateEnum stateEnum = null;
        if (null != state && state.length() > 0) {
            List list = EstStateEnum.getEnumList();
            for (EstStateEnum enumType : list) {
                if (!enumType.getAlias().equals(state)) continue;
                stateEnum = enumType;
                break;
            }
            if (stateEnum == null) {
                stateEnum = EstStateEnum.getEnum(state);
            }
            if (stateEnum == null) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "stateNotExists", ctx.getLocale()));
            }
            return stateEnum;
        }
        throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "StateNotNull", ctx.getLocale()));
    }

    private BigDecimal getBigDecimalValue(String strNum) throws TaskExternalException {
        try {
            if (strNum != null && strNum.length() > 0) {
                return new BigDecimal(strNum);
            }
            return null;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            DataImportTools.putToHashtable(result, (Object)"FCompany_number", (Object)rs.getString("company.number"));
            DataImportTools.putToHashtable(result, (Object)"FCompany_name_l2", (Object)rs.getString("company.name"));
            DataImportTools.putToHashtable(result, (Object)"FNumber", (Object)rs.getString("number"));
            DataImportTools.putToHashtable(result, (Object)"FName", (Object)rs.getString("name"));
            DataImportTools.putToHashtable(result, (Object)"FSysNumber", (Object)rs.getString("sysNumber"));
            DataImportTools.putToHashtable(result, (Object)"FCertificateNumber", (Object)rs.getString("certificateNumber"));
            DataImportTools.putToHashtable(result, (Object)"FUnitNumber", (Object)rs.getString("unitNumber"));
            DataImportTools.putToHashtable(result, (Object)"FTaxPayerType", (Object)((Object)taxPayerTypeEnum.getEnum(rs.getString("taxPayerType"))));
            DataImportTools.putToHashtable(result, (Object)"FLandData_number", (Object)rs.getString("landData.number"));
            DataImportTools.putToHashtable(result, (Object)"FLandData_name_l2", (Object)rs.getString("landData.name"));
            DataImportTools.putToHashtable(result, (Object)"FTaxBureau", (Object)rs.getString("taxBureau"));
            DataImportTools.putToHashtable(result, (Object)"FAcqTime", (Object)rs.getString("acqTime"));
            DataImportTools.putToHashtable(result, (Object)"FPurpose", (Object)((Object)PurposeEnum.getEnum(rs.getString("purpose"))));
            DataImportTools.putToHashtable(result, (Object)"FRealEstateGroup_number", (Object)rs.getString("realEstateGroup.number"));
            DataImportTools.putToHashtable(result, (Object)"FRealEstateGroup_name_l2", (Object)rs.getString("realEstateGroup.name"));
            DataImportTools.putToHashtable(result, (Object)"FCountry_number", (Object)rs.getString("country.number"));
            DataImportTools.putToHashtable(result, (Object)"FCountry_name_l2", (Object)rs.getString("country.name"));
            DataImportTools.putToHashtable(result, (Object)"FProvince_number", (Object)rs.getString("province.number"));
            DataImportTools.putToHashtable(result, (Object)"FProvince_name_l2", (Object)rs.getString("province.name"));
            DataImportTools.putToHashtable(result, (Object)"FCity_number", (Object)rs.getString("city.number"));
            DataImportTools.putToHashtable(result, (Object)"FCity_name_l2", (Object)rs.getString("city.name"));
            DataImportTools.putToHashtable(result, (Object)"FRegion_number", (Object)rs.getString("region.number"));
            DataImportTools.putToHashtable(result, (Object)"FRegion_name_l2", (Object)rs.getString("region.name"));
            DataImportTools.putToHashtable(result, (Object)"FAddress", (Object)rs.getString("address"));
            DataImportTools.putToHashtable(result, (Object)"FState", (Object)((Object)EstStateEnum.getEnum(rs.getString("state"))));
            DataImportTools.putToHashtable(result, (Object)"FDescription", (Object)rs.getString("description"));
            DataImportTools.putToHashtable(result, (Object)"FBuildingArea", (Object)rs.getString("buildingArea"));
            DataImportTools.putToHashtable(result, (Object)"FRentArea", (Object)rs.getString("rentArea"));
            DataImportTools.putToHashtable(result, (Object)"FOriginalValue", (Object)rs.getString("originalValue"));
            DataImportTools.putToHashtable(result, (Object)"FRentOriginalValue", (Object)rs.getString("rentOriginalValue"));
            DataImportTools.putToHashtable(result, (Object)"FIsPriceOnly", (Object)rs.getString("isPriceOnly"));
            DataImportTools.putToHashtable(result, (Object)"FIsReference", (Object)rs.getString("isReference"));
            DataImportTools.putToHashtable(result, (Object)"FTaxValue", (Object)rs.getString("taxValue"));
            DataImportTools.putToHashtable(result, (Object)"FCurrency_number", (Object)rs.getString("currency.number"));
            DataImportTools.putToHashtable(result, (Object)"FCurrency_name_l2", (Object)rs.getString("currency.name"));
            DataImportTools.putToHashtable(result, (Object)"FTaxRate", (Object)rs.getString("taxRate"));
            DataImportTools.putToHashtable(result, (Object)"FCalcRate", (Object)rs.getString("calcRate"));
            DataImportTools.putToHashtable(result, (Object)"FTaxCycle", (Object)((Object)TaxCycleEnum.getEnum(rs.getInt("taxCycle"))));
            DataImportTools.putToHashtable(result, (Object)"FFirstPaymentMonth", (Object)((Object)MonthEnum.getEnum(rs.getInt("firstPaymentMonth"))));
            DataImportTools.putToHashtable(result, (Object)"FCalcFormula_number", (Object)rs.getString("calcFormula.number"));
            DataImportTools.putToHashtable(result, (Object)"FCalcFormula_name_l2", (Object)rs.getString("calcFormula.name"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    private boolean checkSameCompany(Context ctx, CompanyOrgUnitInfo companyInfo) throws TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        IRealEstate iRealEstate = (IRealEstate)this.getController(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        try {
            RealEstateCollection coll = iRealEstate.getRealEstateCollection(view);
            return coll.size() > 0;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void checkPermission(Context ctx, String companyId) throws TaskExternalException {
        String permItem = "ert_realEstate_new";
        if (this.isSltImportUpdate()) {
            permItem = "ert_realEstate_edit";
        }
        try {
            TDUtils.checkPermission(ctx, String.valueOf(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), companyId, permItem);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        if (this.getContextMap().get("filter") != null) {
            String filterStr = this.getContextMap().get("filter").toString();
            filterStr = filterStr.replace("$", "'");
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                Logger.error((Throwable)e);
            }
        }
        if (this.getContextMap().get("bizCommonQueryFilter") != null) {
            String filterItems = this.getContextMap().get("bizCommonQueryFilter").toString();
            filterItems = filterItems.replace("$", "'");
            try {
                filter = new FilterInfo(filterItems);
            }
            catch (ParserException e) {
                Logger.error((Throwable)e);
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.td.est.app.RealEstateQuery";
    }
}

