/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.tm.td.DraftStatusEnum;
import com.kingdee.eas.tm.td.ITaxDraftRecord;
import com.kingdee.eas.tm.td.OwnerMenuEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.TaxOtherReportCollection;
import com.kingdee.eas.tm.td.TaxOtherReportFactory;
import com.kingdee.eas.tm.td.TaxOtherReportInfo;
import com.kingdee.eas.tm.td.app.AbstractTaxDraftRecordControllerBean;
import com.kingdee.eas.tm.td.app.util.TDServerUtils;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckResultTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.check.CheckAccountServiceFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.check.CheckServiceFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckAccountDetailResultVo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckAccountResultVo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckResultVo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckVo;
import com.kingdee.eas.tm.td.structure.TaxItemFormulaFacadeFactory;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TaxDraftRecordControllerBean
extends AbstractTaxDraftRecordControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.app.TaxDraftRecordControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    protected void checkForSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxDraftRecordInfo info = (TaxDraftRecordInfo)model;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        view.setFilter(filterInfo);
        TaxDraftRecordCollection coll = TaxDraftRecordFactory.getLocalInstance(ctx).getTaxDraftRecordCollection(view);
        if (coll != null && coll.size() > 0) {
            throw new BOSException("\u7f16\u7801" + info.getNumber() + "\u5df2\u5b58\u5728\u4e8e " + coll.get(0).getOwnerMenu().getAlias());
        }
        if (!DraftStatusEnum.SAVE.equals((Object)info.getDraftStatus())) {
            throw new TDException(TDException.SAVE_ERROR, new Object[]{info.getNumber()});
        }
        this.verify(ctx, info);
    }

    private void verify(Context ctx, TaxDraftRecordInfo info) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyOrgUnitInfo;
        if (info.getRelateAccount() != null) {
            StringBuffer query = new StringBuffer();
            query.append(" SELECT 1 FROM  T_TM_OrgToAccountRelation ");
            query.append(" where 1=1 ");
            if (info.getRelateAccount() != null) {
                query.append(" and FACCOUNTID = '").append(info.getRelateAccount().getId().toString()).append("'");
            }
            if (info.getCompanyOrgUnit() != null) {
                query.append(" and FCOMPANYORGUNITID = '").append(info.getCompanyOrgUnit().getId().toString()).append("'");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)query.toString());
            try {
                if (!rs.next()) {
                    throw new TDException(TDException.DRAFT_COPY_ERROR, new Object[]{info.getCompanyOrgUnit().getName(), info.getRelateAccount().getName()});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (!(companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompanyOrgUnit().getId().toString()))).isIsBizUnit()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FID,FNUMBER FROM T_TD_TaxDraftRecord ");
        sql.append(" WHERE FCompanyOrgUnitID='").append(info.getCompanyOrgUnit().getId().toString()).append("'");
        sql.append(" AND FRptPeriod='").append(info.getRptPeriod().getId().toString()).append("'");
        sql.append(" AND FTaxTypeID='").append(info.getTaxType().getId().toString()).append("'");
        sql.append(" AND FRecordType=").append(info.getRecordType().getValue()).append("");
        if (info.getBuildingTaxesGroup() != null) {
            sql.append(" AND FBUILDINGTAXESGROUPID='").append(info.getBuildingTaxesGroup().getId().toString()).append("'");
        } else {
            sql.append(" AND FBUILDINGTAXESGROUPID is null");
        }
        if (RecordTypeEnum.Account.equals((Object)info.getRecordType())) {
            sql.append(" AND FRelateAccountID='").append(info.getRelateAccount().getId().toString()).append("'");
        } else {
            sql.append(" AND FDraftRecordType='").append(info.getDraftRecordType().getValue()).append("'");
        }
        if (info.getId() != null) {
            sql.append(" AND FID <>'").append(info.getId().toString()).append("'");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                if (RecordTypeEnum.Account.equals((Object)info.getRecordType())) {
                    throw new TDException(TDException.ACCOUNT_SAVE_ERROR, new Object[]{info.getCompanyOrgUnit().getName(), info.getRptPeriod().getNumber() + "", rs.getString("FNumber")});
                }
                throw new TDException(TDException.DRAFT_SAVE_ERROR, new Object[]{info.getCompanyOrgUnit().getName(), info.getRptPeriod().getNumber() + "", rs.getString("FNumber")});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxDraftRecordInfo info = (TaxDraftRecordInfo)model;
        if (info.getId() != null) {
            TaxItemFormulaFacadeFactory.getLocalInstance(ctx).clearItemData(info.getId().toString());
        }
        super._update(ctx, pk, model);
        TaxItemFormulaFacadeFactory.getLocalInstance(ctx).saveItemData(model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxDraftRecordInfo info = (TaxDraftRecordInfo)model;
        this.checkForSave(ctx, (IObjectValue)info);
        if (info.getId() != null) {
            TaxItemFormulaFacadeFactory.getLocalInstance(ctx).clearItemData(info.getId().toString());
        }
        IObjectPK pk = super._save(ctx, model);
        TaxItemFormulaFacadeFactory.getLocalInstance(ctx).saveItemData(model);
        return pk;
    }

    @Override
    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!this._exists(ctx, pk)) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        TaxDraftRecordInfo info = this.getTaxDraftRecordInfo(ctx, pk);
        if (info.getDraftStatus().getValue() >= DraftStatusEnum.AUDIT.getValue()) {
            throw new TDException(TDException.AUDIT_STATUS);
        }
        TaxItemFormulaFacadeFactory.getLocalInstance(ctx).clearItemData(pk.toString());
        super._delete(ctx, pk);
    }

    @Override
    protected String _getTaxIdByNumber(Context ctx, String taxNum) throws BOSException {
        String taxId = "";
        StringBuffer getId = new StringBuffer();
        getId.append("select fid from T_TD_TaxDraftRecord where fnumber = '");
        getId.append(taxNum + "'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getId.toString());
        try {
            if (rowSet.next()) {
                taxId = rowSet.getString("fid");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException();
        }
        return taxId;
    }

    @Override
    protected void _writeVoucherInfo(Context ctx, String billID, String voucherID) throws BOSException, EASBizException {
        String voucherNumber = null;
        String voucherType = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select t1.fnumber,t2.FNAME_l2 as voucherType from T_GL_Voucher t1 inner join T_BD_VoucherTypes t2 on t1.fvouchertypeid = t2.fid ");
        sql.append(" where t1.fid =  '").append(voucherID).append("' ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                voucherNumber = rowSet.getString("fnumber");
                voucherType = rowSet.getString("voucherType");
            }
        }
        catch (SQLException e) {
            throw new BOSException();
        }
        sql.setLength(0);
        sql.append(" update  T_TD_TaxDraftRecord set FIsVoucher = 1 , FVoucherID ='").append(voucherID).append("' ,FVoucherNumber = '").append(voucherNumber).append("'");
        sql.append(" , FVoucherType = '").append(voucherType).append("' ");
        sql.append(" where fid = '").append(billID).append("' ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _deleteVoucherInfo(Context ctx, String billID, Map params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update  T_TD_TaxDraftRecord set FIsVoucher = 0 , FVoucherID = null,FVoucherNumber = null,FVoucherType = null");
        sql.append(" where fid = '").append(billID).append("' ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public String getMasterTable(Context ctx) throws BOSException, EASBizException {
        return "T_TD_TaxDraftRecord";
    }

    @Override
    protected void _audit(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        TaxDraftRecordInfo info = this.getTaxDraftRecordInfo(ctx, id);
        if (info.getDraftStatus().equals((Object)DraftStatusEnum.AUDIT)) {
            throw new TDException(TDException.HASAUDIT);
        }
        if (!info.getDraftStatus().equals((Object)DraftStatusEnum.SUBMIT)) {
            throw new TDException(TDException.NOT_SUBMIT_STATUS);
        }
        info.setDraftStatus(DraftStatusEnum.AUDIT);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(DateUtil.getTime());
        StringBuffer sql = new StringBuffer();
        sql.append("update  T_TD_TaxDraftRecord set FDraftStatus =? ,FAuditorID = ?,FAuditedTime = ?");
        sql.append(" where FID = '").append(info.getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{info.getDraftStatus().getValue(), info.getAuditor().getId().toString(), info.getAuditTime()});
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.taxRecordSubmit(ctx, model);
    }

    @Override
    protected Map _beforeSubmit(Context ctx, Map params) throws BOSException, EASBizException {
        List ids = (List)params.get("ids");
        Map values = (Map)params.get("values");
        RecordTypeEnum recordType = (RecordTypeEnum)((Object)params.get("recordType"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(TDSelectorFactory.getTaxDraftRecordSelectors());
        TaxDraftRecordCollection coll = TaxDraftRecordFactory.getLocalInstance(ctx).getTaxDraftRecordCollection(view);
        HashMap<String, CharSequence> promptMap = new HashMap<String, CharSequence>();
        HashMap<String, Boolean> enableSubmitMap = new HashMap<String, Boolean>();
        HashSet<String> checkIds = new HashSet<String>();
        HashSet<String> checkItemIds = new HashSet<String>();
        Map checkResultMap = null;
        TaxDraftRecordInfo info = null;
        boolean isNeedAsk = false;
        String askMsg = "\u5b58\u5728\u68c0\u67e5\u4e8b\u9879\u5173\u7cfb\u68c0\u9a8c\u4e0d\u901a\u8fc7\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f";
        StringBuffer askDetailMsg = new StringBuffer();
        Map checkAccountResultMap = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            try {
                this.checkForSubmit(ctx, (IObjectValue)info);
                checkIds.add(info.getId().toString());
                enableSubmitMap.put(info.getId().toString(), true);
                continue;
            }
            catch (Exception e) {
                promptMap.put(info.getId().toString(), e.getMessage());
            }
        }
        if (checkIds.size() > 0) {
            int i;
            int size2;
            if (values != null && values.size() > 0) {
                TaxDraftRecordInfo rptinfo = null;
                Iterator it = values.keySet().iterator();
                while (it.hasNext()) {
                    rptinfo = (TaxDraftRecordInfo)values.get(it.next());
                    TaxItemFormulaFacadeFactory.getLocalInstance(ctx).saveItemData((IObjectValue)rptinfo);
                }
            }
            HashMap<String, Object> checkParams = new HashMap<String, Object>();
            checkParams.put("checkIds", checkIds);
            checkParams.put("values", values);
            checkResultMap = CheckServiceFactory.getCheckService().check(ctx, checkParams, CheckTypeEnum.TAXDECLARE);
            CheckResultVo checkResult = null;
            String reportID = null;
            TaxDraftRecordInfo reportInfo = null;
            StringBuffer promptMsg = new StringBuffer();
            StringBuffer detailMsg = new StringBuffer();
            for (Map.Entry entry : checkResultMap.entrySet()) {
                reportID = (String)entry.getKey();
                checkResult = (CheckResultVo)checkResultMap.get(reportID);
                CheckVo checkVo = null;
                CheckItemInfo checkItemInfo = null;
                size2 = checkResult.getCheckList().size();
                for (i = 0; i < size2; ++i) {
                    checkVo = (CheckVo)checkResult.getCheckList().get(i);
                    checkItemIds.add(checkVo.getCheckInfo().getId().toString());
                }
                if (checkResult.isPass()) continue;
                isNeedAsk = true;
                size2 = checkResult.getErrorCheckList().size();
                for (i = 0; i < size2; ++i) {
                    checkVo = (CheckVo)checkResult.getErrorCheckList().get(i);
                    reportInfo = checkVo.getReportInfo();
                    checkItemInfo = (CheckItemInfo)checkVo.getCheckInfo();
                    detailMsg.setLength(0);
                    detailMsg.append("\u62a5\u8868\uff1a\u3010").append(reportInfo.getNumber()).append("\u3011\uff0c\u68c0\u67e5\u4e8b\u9879\uff1a\u3010").append(checkItemInfo.getNumber()).append("\u3011\uff0c\u4e0d\u901a\u8fc7\uff0c");
                    detailMsg.append(checkItemInfo.getCheckResult().getAlias());
                    promptMsg.append(detailMsg.toString()).append("\n");
                    if (CheckResultTypeEnum.SHOWERROR.equals((Object)checkItemInfo.getCheckResult())) {
                        askDetailMsg.append(detailMsg.toString()).append("\n");
                        continue;
                    }
                    isNeedAsk = false;
                    enableSubmitMap.remove(reportID);
                }
                promptMap.put(reportID, promptMsg);
            }
            try {
                if (RecordTypeEnum.Account.equals((Object)recordType)) {
                    checkAccountResultMap = CheckAccountServiceFactory.getCheckService().check(ctx, checkParams);
                    List resultList = (List)checkAccountResultMap.get("resultList");
                    CheckAccountResultVo resultVo2 = null;
                    CheckAccountDetailResultVo detailResultVo = null;
                    for (CheckAccountResultVo resultVo2 : resultList) {
                        reportInfo = resultVo2.getReportInfo();
                        if (resultVo2.isPass()) continue;
                        isNeedAsk = true;
                        size2 = resultVo2.getErrorList().size();
                        for (i = 0; i < size2; ++i) {
                            detailResultVo = resultVo2.getErrorList().get(i);
                            detailMsg.setLength(0);
                            detailMsg.append("\u62a5\u8868\uff1a\u3010").append(reportInfo.getNumber()).append("\u3011");
                            detailMsg.append("\u8868\u9875\uff1a\u3010").append(detailResultVo.getSheetName()).append("\u3011");
                            detailMsg.append("\uff0c\u53f0\u8d26\u68c0\u67e5\uff1a\u3010").append(resultVo2.getCheckInfo().getNumber()).append("\u3011");
                            if (detailResultVo.getEntryInfo() != null) {
                                detailMsg.append("\uff0c\u68c0\u67e5\u5185\u5bb9\uff1a\u3010").append(detailResultVo.getEntryInfo().getCheckFormula()).append("\u3011\uff0c\u4e0d\u901a\u8fc7\uff0c");
                                detailMsg.append(detailResultVo.getEntryInfo().getCheckResult().getAlias());
                            } else {
                                detailMsg.append(detailResultVo.getErrorMsg());
                            }
                            promptMsg.append(detailMsg.toString()).append("\n");
                            if (detailResultVo.getEntryInfo() != null && CheckResultTypeEnum.SHOWERROR.equals((Object)detailResultVo.getEntryInfo().getCheckResult())) {
                                askDetailMsg.append(detailMsg.toString()).append("\n");
                                continue;
                            }
                            isNeedAsk = false;
                            enableSubmitMap.remove(reportInfo.getId().toString());
                        }
                        promptMap.put(reportInfo.getId().toString(), promptMsg);
                    }
                }
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage());
            }
            if (values != null && values.size() > 0) {
                TaxDraftRecordInfo rptinfo = null;
                Iterator it = values.keySet().iterator();
                while (it.hasNext()) {
                    rptinfo = (TaxDraftRecordInfo)values.get(it.next());
                    rptinfo = TaxDraftRecordFactory.getLocalInstance(ctx).getTaxDraftRecordInfo((IObjectPK)new ObjectUuidPK(rptinfo.getId().toString()), TDSelectorFactory.getAllReportSelectors());
                    TaxItemFormulaFacadeFactory.getLocalInstance(ctx).saveItemData((IObjectValue)rptinfo);
                }
            }
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("checkIds", checkIds);
        ret.put("checkItemIds", checkItemIds);
        ret.put("enableSubmitMap", enableSubmitMap);
        ret.put("promptMap", promptMap);
        ret.put("isNeedAsk", isNeedAsk);
        ret.put("askMsg", askMsg);
        ret.put("checkResultMap", checkResultMap);
        ret.put("askDetailMsg", askDetailMsg.toString());
        ret.put("checkAccountResultMap", checkAccountResultMap);
        return ret;
    }

    private IObjectPK taxRecordSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        TaxDraftRecordInfo info = (TaxDraftRecordInfo)model;
        this.checkForSubmit(ctx, model);
        info.setDraftStatus(DraftStatusEnum.SUBMIT);
        if (info.getId() != null) {
            TaxItemFormulaFacadeFactory.getLocalInstance(ctx).clearItemData(info.getId().toString());
        }
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        this.afterSubmit(ctx, pk, model);
        TaxItemFormulaFacadeFactory.getLocalInstance(ctx).saveItemData(model);
        return pk;
    }

    private void afterSubmit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        boolean isSubmit2SaveConfirm;
        TaxDraftRecordInfo info = (TaxDraftRecordInfo)model;
        boolean isSubmit2Cacl = TDUtils.getBooleanParam(ctx, info.getCompanyOrgUnit().getId().toString(), "VATD004");
        if (isSubmit2Cacl) {
            try {
                ITaxDraftRecord iReport = TaxDraftRecordFactory.getLocalInstance(ctx);
                TaxDraftRecordInfo reportInfo = iReport.getTaxDraftRecordInfo((IObjectPK)new ObjectStringPK(pk.toString()), TDSelectorFactory.getAllReportSelectors());
                TDUtils.calculateReport(ctx, reportInfo);
                super._update(ctx, pk, (IObjectValue)reportInfo);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (isSubmit2SaveConfirm = TDUtils.getBooleanParam(ctx, info.getCompanyOrgUnit().getId().toString(), "VATD001")) {
            ITaxDraftRecord iReport = TaxDraftRecordFactory.getLocalInstance(ctx);
            TaxDraftRecordInfo reportInfo = iReport.getTaxDraftRecordInfo((IObjectPK)new ObjectStringPK(pk.toString()), TDSelectorFactory.getAllReportSelectors());
            TDServerUtils.doSaveTaxDraftConfirmBill(ctx, reportInfo);
        }
    }

    protected void checkForSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxDraftRecordInfo info = (TaxDraftRecordInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FOWNERMENU FROM T_TD_TaxDraftRecord").append(" WHERE FNumber = '").append(info.getNumber()).append("'").append(" AND FID <> '").append(info.getId().toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                throw new BOSException("\u7f16\u7801\u5df2\u5b58\u5728\u4e8e " + OwnerMenuEnum.getEnum(rs.getString("FOWNERMENU")).getAlias());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (info.getDraftStatus().equals((Object)DraftStatusEnum.AUDIT)) {
            throw new TDException(TDException.HASAUDIT);
        }
        if (info.getDraftStatus().equals((Object)DraftStatusEnum.DECLARED)) {
            throw new TDException(TDException.DECLARED);
        }
        this.verify(ctx, info);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        TaxDraftRecordInfo info = this.getTaxDraftRecordInfo(ctx, id);
        if (!info.getDraftStatus().equals((Object)DraftStatusEnum.AUDIT)) {
            throw new TDException(TDException.NOT_AUDIT_STATUS);
        }
        if (info.isIsVoucher()) {
            throw new TDException(TDException.HAS_VOUCHER);
        }
        info.setAuditor(null);
        info.setAuditTime(null);
        info.setDraftStatus(DraftStatusEnum.SAVE);
        this.update(ctx, id, info);
    }

    @Override
    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxDraftRecordInfo recordInfo = (TaxDraftRecordInfo)model;
        if (this.checkNumberOrName(ctx, (IObjectValue)recordInfo, "number")) {
            String number = recordInfo.getNumber();
            if (number.length() > 10) {
                number = number.substring(0, 9) + "...";
            }
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{number});
        }
    }

    private boolean checkNumberOrName(Context ctx, IObjectValue model, String type) throws EASBizException, BOSException {
        TaxDraftRecordInfo recordInfo = (TaxDraftRecordInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo();
        if ("number".equals(type)) {
            filterItem = new FilterItemInfo("number", (Object)recordInfo.getNumber(), CompareType.EQUALS);
        }
        if ("name".equals(type)) {
            filterItem = new FilterItemInfo("name", (Object)recordInfo.getName(), CompareType.EQUALS);
        }
        filter.getFilterItems().add(filterItem);
        if (recordInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)recordInfo.getId().toString(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (recordInfo.getCompanyOrgUnit() != null) {
            filterItem = new FilterItemInfo("companyOrgUnit", (Object)recordInfo.getCompanyOrgUnit().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("companyOrgUnit", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (recordInfo.getTaxType() != null) {
            filterItem = new FilterItemInfo("taxType", (Object)recordInfo.getTaxType().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (recordInfo.getRecordType() != null) {
            filterItem = new FilterItemInfo("recordType", (Object)recordInfo.getRecordType().getValue(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        return this.exists(ctx, filter);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TaxDraftRecordInfo info = this.getTaxDraftRecordInfo(ctx, pk, this.getSelectors());
        return info.getLogInfo();
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("taxType.id"));
        sic.add(new SelectorItemInfo("taxType.number"));
        sic.add(new SelectorItemInfo("taxType.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        return sic;
    }

    @Override
    protected Map _checkAudit(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        StringBuffer sql = new StringBuffer();
        sql.append(" select record.fnumber as fnumber");
        sql.append(" from T_TD_TaxDraftRecord record");
        sql.append(" left join T_TD_TaxDraftConfirmBill bill on record.fid = bill.frptid ");
        sql.append(" where record.fid in (").append(CollectionUtil.convertSet2String(ids, ",", true)).append(")");
        sql.append(" and record.frecordtype <>").append(0);
        sql.append(" and bill.frptid is null");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> noconfirmbill_numbers = new HashSet<String>();
        try {
            String number = null;
            while (rs.next()) {
                number = rs.getString("fnumber");
                noconfirmbill_numbers.add(number);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ret.put("noconfirmbill_numbers", noconfirmbill_numbers);
        return ret;
    }

    @Override
    protected Map _getCollByNumberSet(Context ctx, Map params) throws BOSException, EASBizException {
        Set numberSet = (Set)params.get("numberSet");
        int reportType = (Integer)params.get("reportType");
        Iterator numberIter = numberSet.iterator();
        ArrayList<ReportBaseInfo> coll = new ArrayList<ReportBaseInfo>();
        ArrayList<String> notList = new ArrayList<String>();
        ArrayList<String> auditList = new ArrayList<String>();
        ArrayList<String> declaredList = new ArrayList<String>();
        int errorCount = 0;
        String number = null;
        ReportBaseInfo reportInfo = null;
        HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>();
        boolean isSupportAuditBill = false;
        while (numberIter.hasNext()) {
            number = (String)numberIter.next();
            reportInfo = this.getReportValue(ctx, number, reportType);
            if (reportInfo == null) {
                notList.add(number);
                ++errorCount;
                continue;
            }
            Object value = paramMap.get(((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getId().toString());
            if (value == null) {
                isSupportAuditBill = TDUtils.getBooleanParam(ctx, ((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getId().toString(), "VATD003");
                paramMap.put(((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getId().toString(), isSupportAuditBill);
            } else {
                isSupportAuditBill = (Boolean)value;
            }
            if (!isSupportAuditBill && TDUtils.isAuditBill(reportInfo)) {
                auditList.add(number);
                ++errorCount;
                continue;
            }
            if (TDUtils.isDeclaredBill(reportInfo)) {
                declaredList.add(number);
                ++errorCount;
                continue;
            }
            coll.add(reportInfo);
        }
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("coll", coll);
        ret.put("errorCount", Integer.valueOf(errorCount));
        ret.put("notList", notList);
        ret.put("auditList", auditList);
        ret.put("declaredList", declaredList);
        return ret;
    }

    private ReportBaseInfo getReportValue(Context ctx, String number, int reportType) throws BOSException {
        ReportBaseInfo reportInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        if (reportType == 0) {
            view.setSelector(TDSelectorFactory.getAllReportSelectors());
            TaxDraftRecordCollection coll = TaxDraftRecordFactory.getLocalInstance(ctx).getTaxDraftRecordCollection(view);
            if (coll.size() > 0) {
                reportInfo = coll.get(0);
            }
        } else if (reportType == 1) {
            view.setSelector(TaxOtherReportInfo.getSelectors());
            TaxOtherReportCollection coll = TaxOtherReportFactory.getLocalInstance(ctx).getTaxOtherReportCollection(view);
            if (coll.size() > 0) {
                reportInfo = coll.get(0);
            }
        }
        return reportInfo;
    }

    @Override
    protected void _confirmDeclare(Context ctx, Map params) throws BOSException, EASBizException {
        ArrayList billIds = (ArrayList)params.get("billIds");
        BigDecimal amount = (BigDecimal)params.get("amount");
        int declaredType = (Integer)params.get("declaredType");
        String draftDate = (String)params.get("draftData");
        UserInfo aUserInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_TD_TaxDraftRecord set FDeclaredType = ").append(declaredType);
        sql.append(" , FPayAmount = ").append(amount);
        sql.append(" , FdraftDate = {ts'").append(draftDate).append("'} ");
        sql.append(" , FdraftUser = '").append(aUserInfo).append("'");
        sql.append(" , FDraftStatus = ").append(4);
        sql.append(" where Fid in (").append(CollectionUtil.convertList2String(billIds, ",", true)).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _updateDraftStatusById(Context ctx, Map params) throws BOSException, EASBizException {
        Set billids = (Set)params.get("billIds");
        BigDecimal amount = BigDecimal.ZERO;
        if (params.get("amount") != null && !((String)params.get("amount")).isEmpty()) {
            amount = new BigDecimal((String)params.get("amount"));
        }
        int type = 0;
        String date = "";
        if (params.get("type") != null) {
            type = Integer.parseInt((String)params.get("type"));
        }
        int status = 4;
        if (params.get("status") != null) {
            status = Integer.parseInt((String)params.get("status"));
        }
        if (params.get("date") != null) {
            date = (String)params.get("date");
        }
        StringBuffer updateSQL = new StringBuffer();
        UserInfo aUserInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        updateSQL.append(" update T_TD_TaxDraftRecord ");
        updateSQL.append(" set FDraftStatus = " + status + " ,FPayAmount= " + amount);
        if (status == 4) {
            if (date.equals("")) {
                updateSQL.append(" , FdraftDate = NOW()");
            } else {
                updateSQL.append(" , FdraftDate = to_date('").append(date).append("')");
            }
            updateSQL.append(" , FdraftUser = '").append(aUserInfo).append("'");
        } else {
            updateSQL.append(" , FdraftDate =''");
            updateSQL.append(" , FdraftUser = ''");
        }
        updateSQL.append(",FDeclaredType=" + type);
        updateSQL.append(" where fid in (").append(CollectionUtil.convertSet2String(billids, ",", true)).append(")");
        DbUtil.execute((Context)ctx, (String)updateSQL.toString());
    }

    @Override
    protected void _cancelConfirmDeclare(Context ctx, Map params) throws BOSException, EASBizException {
        ArrayList billIds = (ArrayList)params.get("billIds");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(billIds), CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("draftStatus"));
        view.setFilter(filter);
        view.setSelector(sic);
        TaxDraftRecordCollection coll = TaxDraftRecordFactory.getLocalInstance(ctx).getTaxDraftRecordCollection(view);
        ArrayList<String> wrongStatusBills = new ArrayList<String>();
        if (coll != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                if (DraftStatusEnum.DECLARED.equals((Object)coll.get(i).getDraftStatus())) continue;
                wrongStatusBills.add(coll.get(i).getNumber());
            }
        }
        if (!wrongStatusBills.isEmpty()) {
            String errorMsg = ResourceBase.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"CanNotCancelConfirm", (Locale)ctx.getLocale());
            throw new TDException(TDException.ERROR_MSG, new Object[]{errorMsg + ((Object)wrongStatusBills).toString()});
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_TD_TaxDraftRecord set FDeclaredType = null ");
        sql.append(" , FPayAmount = null ");
        sql.append(" , FdraftDate = null ");
        sql.append(" , FdraftUser = null ");
        sql.append(" , FDraftStatus = ").append(3);
        sql.append(" where Fid in (").append(CollectionUtil.convertList2String(billIds, ",", true)).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _updateReportStatus(Context ctx, List ids, DraftStatusEnum status) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_TD_TaxDraftRecord set FDraftStatus = ").append(status.getValue());
        sql.append(" where Fid in (").append(CollectionUtil.convertList2String(ids, ",", true)).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected ArrayList _batchDelete(Context ctx, Set ids, boolean hasAccountCheckRef, boolean hasItemCheckRef, boolean hasIndexCheckRef) throws BOSException, EASBizException {
        StringBuffer sql;
        ArrayList error = new ArrayList();
        String idInString = TDUtils.getInStringFromSet(ids);
        Iterator iterator = ids.iterator();
        if (hasAccountCheckRef) {
            sql = new StringBuffer();
            sql.append("delete from  t_td_checkaccountresult where FREPORTID in ");
            sql.append(String.valueOf(idInString));
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        if (hasItemCheckRef || hasIndexCheckRef) {
            sql = new StringBuffer();
            sql.append("delete from  T_TD_CheckResult where FREPORTID in ");
            sql.append(String.valueOf(idInString));
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        while (iterator.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)iterator.next().toString()));
            this._delete(ctx, (IObjectPK)pk);
        }
        return error;
    }
}

