/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.app.PerfSepServerUtils;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftReportCalculateParams;
import com.kingdee.eas.tm.td.app.util.TDServerUtils;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import org.apache.log4j.Logger;

public class TaxDraftReportBatchSaveHandler
implements IJobHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.app.TaxDraftReportBatchSaveHandler");

    public Object execute(Job job) throws Exception {
        block20: {
            Context ctx = null;
            MessageInfo messageInfo = new MessageInfo();
            String reportId = "";
            IMutexServiceControl mutexService = null;
            boolean isgetMutex = false;
            try {
                Object isSuccess;
                Boolean ex2;
                ctx = job.getContext();
                JobParam jobParam = (JobParam)job.getParameters();
                TaxDraftReportCalculateParams params = (TaxDraftReportCalculateParams)jobParam.getBizParam();
                reportId = params.getString("reportInfoId");
                String reportType = params.getString("reportType");
                String permItem = params.getString("permItem");
                String logItem = params.getString("logItem");
                IObjectPK logPk = null;
                mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                String jobinstId = jobParam.getJobId();
                ctx.put((Object)"JOB_INST_ID", (Object)jobinstId);
                ctx.put((Object)"UserInfo", params.getObject("UserInfo"));
                ContextUtil.setCurrentFIUnit((Context)ctx, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("CompanyInfo")));
                Locale locale = null;
                locale = jobParam.getLocale() != null ? jobParam.getLocale() : new Locale("L2");
                if (!"report".equals(reportType)) break block20;
                ICoreBase iReport = TDUtils.getReportInterface(ctx, reportId);
                if (!iReport.exists((IObjectPK)new ObjectStringPK(reportId))) {
                    ReportBaseInfo reportInfo = (ReportBaseInfo)params.getObject("reportInfo");
                    messageInfo = this.setMessageInfo(ctx, jobParam, reportInfo);
                    messageInfo.setExecption(RptUtil.getReportResource((String)"notEixt", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    Boolean bl = new Boolean(false);
                    return bl;
                }
                ReportBaseInfo reportInfo = TDUtils.getReportValue(ctx, reportId, null);
                messageInfo = this.setMessageInfo(ctx, jobParam, reportInfo);
                try {
                    if (!StringUtils.isEmpty((String)logItem)) {
                        String logDetailStr = reportInfo.getNumber();
                        logPk = LogUtils.beginLog(null, "saveConfirmBill", BOSObjectType.create((String)"2A607F02"), (IObjectPK)new ObjectUuidPK(reportInfo.getId().toString()), logDetailStr, "taxotherreport_comfire_save", "");
                    }
                    if (!StringUtils.isEmpty((String)permItem)) {
                        String orgId = ((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getId().toString();
                        TDFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(orgId, permItem);
                    }
                }
                catch (Exception ex2) {
                    messageInfo.setExecption(RptUtil.getReportResource((String)"notCalc", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    Boolean bl = new Boolean(false);
                    PerfSepServerUtils.updateTaskState((Job)job);
                    if (isgetMutex) {
                        mutexService.releaseObjIDForUpdate(reportId);
                    }
                    return bl;
                }
                if (TDUtils.isAuditBill(reportInfo)) {
                    messageInfo.setExecption(RptUtil.getReportResource((String)"notCalc", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    ex2 = new Boolean(false);
                    return ex2;
                }
                isgetMutex = mutexService.requestObjIDForUpdate(reportId);
                if (!isgetMutex) {
                    messageInfo.setExecption(RptUtil.getReportResource((String)"Error_Request_ObjectUpdateLock", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    ex2 = new Boolean(false);
                    return ex2;
                }
                if (logPk != null) {
                    LogUtils.afterLog(null, logPk);
                }
                JobInstStatusFacadeFactory.getLocalInstance((Context)ctx).updateProgress(jobinstId, 10, "accountTakeData...", "accountTakeData...", "accountTakeData...");
                Object object = isSuccess = this.doSave(job, reportInfo, messageInfo);
                return object;
            }
            catch (EASBizException e) {
                messageInfo.setExecption(e.getMessage());
                messageInfo.setSuccessed(false);
                messageInfo.setSendMsg(true);
                MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                throw e;
            }
            catch (Exception e1) {
                messageInfo.setExecption(e1.getMessage());
                messageInfo.setSuccessed(false);
                messageInfo.setSendMsg(true);
                MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                throw e1;
            }
            finally {
                PerfSepServerUtils.updateTaskState((Job)job);
                if (isgetMutex) {
                    mutexService.releaseObjIDForUpdate(reportId);
                }
            }
        }
        return new Boolean(true);
    }

    private MessageInfo setMessageInfo(Context ctx, JobParam jobParam, ReportBaseInfo reportInfo) {
        ReportBaseInfo recordInfo = reportInfo;
        MessageInfo info = new MessageInfo();
        info.setUserID(ctx.getCaller().toString());
        String companyName = (CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit") == null ? "" : ((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getName();
        companyName = companyName == null ? "" : companyName + ":";
        info.setbizAction(companyName + recordInfo.getNumber() + ":" + recordInfo.getName() + " (" + TDUtils.getString("com.kingdee.eas.tm.td.TDLogResource", "ReportConfirm", ctx.getLocale()) + ")");
        info.setOrgNumber(((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getNumber());
        return info;
    }

    private Object doSave(Job job, ReportBaseInfo reportInfo, MessageInfo messageInfo) throws EASBizException, BOSException {
        Context ctx = job.getContext();
        String errorMsg = TDServerUtils.doSaveTaxDraftConfirmBill(ctx, reportInfo);
        if (!StringUtils.isEmpty((String)errorMsg)) {
            messageInfo.setExecption(errorMsg.toString());
            messageInfo.setSuccessed(false);
            messageInfo.setSendMsg(false);
            MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
            throw new TDException(TDException.ERROR_MSG, new Object[]{errorMsg});
        }
        messageInfo.setSuccessed(true);
        messageInfo.setSendMsg(true);
        MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
        return new Boolean(true);
    }
}

