/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.app.PerfSepServerUtils;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftReportCalculateParams;
import com.kingdee.eas.tm.td.app.util.TDServerUtils;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Locale;
import org.apache.log4j.Logger;

public class TaxDraftReportCalculateHandler
implements IJobHandler {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.app.TaxDraftReportCalculateHandler");

    public Object execute(Job job) throws Exception {
        logger.error((Object)"[TaxDraftReportCalculateHandler:start]");
        Context ctx = null;
        MessageInfo messageInfo = null;
        String reportId = "";
        IMutexServiceControl mutexService = null;
        boolean isgetMutex = false;
        try {
            ctx = job.getContext();
            JobParam jobParam = (JobParam)job.getParameters();
            TaxDraftReportCalculateParams params = (TaxDraftReportCalculateParams)jobParam.getBizParam();
            reportId = params.getString("reportInfoId");
            String reportType = params.getString("reportType");
            mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            String jobinstId = jobParam.getJobId();
            ctx.put((Object)"JOB_INST_ID", (Object)jobinstId);
            ctx.put((Object)"UserInfo", params.getObject("UserInfo"));
            ContextUtil.setCurrentFIUnit((Context)ctx, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("CompanyInfo")));
            Locale locale = null;
            locale = jobParam.getLocale() != null ? jobParam.getLocale() : new Locale("L2");
            if ("report".equals(reportType)) {
                ReportBaseInfo reportInfo = (ReportBaseInfo)params.getObject("reportInfo");
                messageInfo = this.setMessageInfo(ctx, jobParam, reportInfo);
                ICoreBase iReport = TDUtils.getReportInterface(ctx, reportId);
                if (!iReport.exists((IObjectPK)new ObjectStringPK(reportId))) {
                    messageInfo.setExecption(RptUtil.getReportResource((String)"notEixt", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    Boolean bl = new Boolean(false);
                    return bl;
                }
                reportInfo = TDUtils.getReportValue(ctx, reportId, null);
                if (TDUtils.isAuditBill(reportInfo)) {
                    messageInfo.setExecption(RptUtil.getReportResource((String)"notCalc", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    Boolean bl = new Boolean(false);
                    return bl;
                }
                isgetMutex = mutexService.requestObjIDForUpdate(reportId);
                if (!isgetMutex) {
                    messageInfo.setExecption(RptUtil.getReportResource((String)"Error_Request_ObjectUpdateLock", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    Boolean bl = new Boolean(false);
                    return bl;
                }
                JobInstStatusFacadeFactory.getLocalInstance((Context)ctx).updateProgress(jobinstId, 10, "Report Calculate...", "Report Calculate...", "Report Calculate...");
                logger.error((Object)"[TaxDraftReportCalculateHandler:beforeCalculate]");
                Object isSuccess = this.calculate(job, reportInfo, messageInfo);
                logger.error((Object)"[TaxDraftReportCalculateHandler:afterCalculate]");
                Object object = isSuccess;
                return object;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)("[TaxDraftReportCalculateHandler:]" + (Object)((Object)e)));
            messageInfo.setExecption(e.getMessage());
            messageInfo.setSuccessed(false);
            messageInfo.setSendMsg(true);
            MessageUtil.sendMsg((Context)ctx, messageInfo);
            throw e;
        }
        catch (Exception e1) {
            logger.error((Object)("[TaxDraftReportCalculateHandler:]" + e1));
            messageInfo.setExecption(e1.getMessage());
            messageInfo.setSuccessed(false);
            messageInfo.setSendMsg(true);
            MessageUtil.sendMsg((Context)ctx, messageInfo);
            throw e1;
        }
        finally {
            logger.error((Object)"[TaxDraftReportCalculateHandler:end]");
            PerfSepServerUtils.updateTaskState((Job)job);
            if (isgetMutex) {
                mutexService.releaseObjIDForUpdate(reportId);
            }
        }
        return new Boolean(true);
    }

    private Object calculate(Job job, ReportBaseInfo reportInfo, MessageInfo messageInfo) throws Exception {
        logger.error((Object)"calculate start");
        Context ctx = job.getContext();
        JobParam jobParam = (JobParam)job.getParameters();
        String jobinstId = jobParam.getJobId();
        TaxDraftReportCalculateParams params = (TaxDraftReportCalculateParams)jobParam.getBizParam();
        String reportID = reportInfo.getId().toString();
        boolean isCalc = params.getBoolean("isCalc");
        boolean isConfirm = params.getBoolean("isConfirm");
        ICoreBase iReport = TDUtils.getReportInterface(ctx, reportID);
        String msg = "[TaxDraftReportCalculateHandler:Param]Param isCalc:" + isCalc + ",isConfirm:" + isConfirm;
        JobInstStatusFacadeFactory.getLocalInstance((Context)ctx).updateProgress(jobinstId, 11, msg, msg, msg);
        logger.error((Object)("[TaxDraftReportCalculateHandler:Param]Param isCalc:" + isCalc + ",isConfirm:" + isConfirm));
        if (isCalc) {
            JobInstStatusFacadeFactory.getLocalInstance((Context)ctx).updateProgress(jobinstId, 12, "Calc start", "Calc start", "Calc start");
            logger.error((Object)"Calc start");
            TDUtils.calculateReport(ctx, reportInfo);
            iReport.update((IObjectPK)new ObjectUuidPK(reportID), (CoreBaseInfo)reportInfo);
            JobInstStatusFacadeFactory.getLocalInstance((Context)ctx).updateProgress(jobinstId, 70, "Calc end", "Calc end", "Calc end");
            logger.error((Object)"Calc end");
        }
        if (isConfirm) {
            reportInfo = (ReportBaseInfo)iReport.getValue((IObjectPK)new ObjectStringPK(reportID), TDUtils.getReportFilter(ctx, reportID));
            TDServerUtils.doSaveTaxDraftConfirmBill(ctx, reportInfo);
        }
        JobInstStatusFacadeFactory.getLocalInstance((Context)ctx).updateProgress(jobinstId, 90, "calculate end", "calculate end", "calculate end");
        logger.error((Object)"calculate end");
        messageInfo.setSuccessed(true);
        messageInfo.setSendMsg(true);
        MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
        return new Boolean(true);
    }

    private SelectorItemCollection getAllReportSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("rptPeriod.id"));
        sic.add(new SelectorItemInfo("rptPeriod.name"));
        sic.add(new SelectorItemInfo("rptPeriod.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.precision"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        return sic;
    }

    private MessageInfo setMessageInfo(Context ctx, JobParam jobParam, ReportBaseInfo reportInfo) {
        Locale locale = null;
        locale = jobParam.getLocale() != null ? jobParam.getLocale() : new Locale("L2");
        MessageInfo info = new MessageInfo();
        info.setUserID(ctx.getCaller().toString());
        String companyName = (CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit") == null ? "" : ((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getName();
        companyName = companyName == null ? "" : companyName + ":";
        info.setbizAction(companyName + reportInfo.getNumber() + ":" + reportInfo.getName() + "(" + RptUtil.getReportResource((String)"ReportCalcMsg", (Locale)locale) + ")");
        info.setOrgNumber(((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getNumber());
        return info;
    }
}

