/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.app.PerfSepServerUtils;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.tm.td.ITaxDraftRecord;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.TaxDraftReportCalculateParams;
import com.kingdee.eas.tm.td.app.util.TDServerUtils;
import com.kingdee.eas.tm.td.utils.AccountTakeDataUtil;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.tm.td.utils.TaxDraftRptPropertyAdapter;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Locale;
import org.apache.log4j.Logger;

public class TaxDraftReportTakeDataHandler
implements IJobHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.app.TaxDraftReportTakeDataHandler");

    public Object execute(Job job) throws Exception {
        Context ctx = null;
        MessageInfo messageInfo = null;
        String reportId = "";
        IMutexServiceControl mutexService = null;
        boolean isgetMutex = false;
        try {
            ctx = job.getContext();
            JobParam jobParam = (JobParam)job.getParameters();
            TaxDraftReportCalculateParams params = (TaxDraftReportCalculateParams)jobParam.getBizParam();
            reportId = params.getString("reportInfoId");
            String reportType = params.getString("reportType");
            mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            String jobinstId = jobParam.getJobId();
            ctx.put((Object)"JOB_INST_ID", (Object)jobinstId);
            ctx.put((Object)"UserInfo", params.getObject("UserInfo"));
            ContextUtil.setCurrentFIUnit((Context)ctx, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("CompanyInfo")));
            Locale locale = null;
            locale = jobParam.getLocale() != null ? jobParam.getLocale() : new Locale("L2");
            if ("report".equals(reportType)) {
                Object isSuccess;
                ITaxDraftRecord iReport = TaxDraftRecordFactory.getLocalInstance(ctx);
                if (!iReport.exists((IObjectPK)new ObjectStringPK(reportId))) {
                    ReportInfo reportInfo = (ReportInfo)params.getObject("reportInfo");
                    messageInfo = this.setMessageInfo(ctx, jobParam, (ReportBaseInfo)reportInfo);
                    messageInfo.setExecption(RptUtil.getReportResource((String)"notEixt", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    Boolean bl = new Boolean(false);
                    return bl;
                }
                TaxDraftRecordInfo reportInfo = iReport.getTaxDraftRecordInfo((IObjectPK)new ObjectStringPK(reportId), TDSelectorFactory.getAllReportSelectors());
                messageInfo = this.setMessageInfo(ctx, jobParam, reportInfo);
                if (reportInfo.getAuditedStatus() == AuditedStatusEnum.AUDITED) {
                    messageInfo.setExecption(RptUtil.getReportResource((String)"notCalc", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    Boolean bl = new Boolean(false);
                    return bl;
                }
                isgetMutex = mutexService.requestObjIDForUpdate(reportId);
                if (!isgetMutex) {
                    messageInfo.setExecption(RptUtil.getReportResource((String)"Error_Request_ObjectUpdateLock", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    Boolean bl = new Boolean(false);
                    return bl;
                }
                JobInstStatusFacadeFactory.getLocalInstance((Context)ctx).updateProgress(jobinstId, 10, "accountTakeData...", "accountTakeData...", "accountTakeData...");
                Object object = isSuccess = this.accountTakeData(job, reportInfo, messageInfo);
                return object;
            }
        }
        catch (EASBizException e) {
            messageInfo.setExecption(e.getMessage());
            messageInfo.setSuccessed(false);
            messageInfo.setSendMsg(true);
            MessageUtil.sendMsg((Context)ctx, messageInfo);
            throw e;
        }
        catch (Exception e1) {
            messageInfo.setExecption(e1.getMessage());
            messageInfo.setSuccessed(false);
            messageInfo.setSendMsg(true);
            MessageUtil.sendMsg((Context)ctx, messageInfo);
            throw e1;
        }
        finally {
            PerfSepServerUtils.updateTaskState((Job)job);
            if (isgetMutex) {
                mutexService.releaseObjIDForUpdate(reportId);
            }
        }
        return new Boolean(true);
    }

    private Object accountTakeData(Job job, TaxDraftRecordInfo reportInfo, MessageInfo messageInfo) throws Exception {
        Context ctx = job.getContext();
        ITaxDraftRecord iReport = TaxDraftRecordFactory.getLocalInstance(ctx);
        JobParam jobParam = (JobParam)job.getParameters();
        TaxDraftReportCalculateParams params = (TaxDraftReportCalculateParams)jobParam.getBizParam();
        String reportID = reportInfo.getId().toString();
        boolean isTakeData = (Boolean)params.get("isTakeData");
        boolean isConfirm = params.getBoolean("isConfirm");
        boolean isCalc = params.getBoolean("isCalc");
        Book book = this.prepareTakeData(ctx, reportInfo);
        if (isTakeData) {
            AccountTakeDataUtil.accountTakeData(ctx, reportInfo, book);
        }
        if (isCalc) {
            TDUtils.calculateBook(ctx, reportInfo, book);
        }
        if (isConfirm) {
            TDServerUtils.doSaveTaxDraftConfirmBill(ctx, reportInfo);
        }
        reportInfo.setBook(book);
        iReport.update((IObjectPK)new ObjectUuidPK(reportID), reportInfo);
        messageInfo.setSuccessed(true);
        messageInfo.setSendMsg(true);
        MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
        return new Boolean(true);
    }

    private Book prepareTakeData(Context ctx, TaxDraftRecordInfo recordInfo) throws Exception {
        Book book = null;
        book = recordInfo.getData() != null ? recordInfo.getBook() : Book.Manager.getNewBook((String)"Sheet1", (int)3);
        book.setCalculate(false);
        BookProperties p = BookProperties.loadFromBook((Book)book);
        TaxDraftRptPropertyAdapter adapter = new TaxDraftRptPropertyAdapter();
        adapter.initReportProperties((IObjectValue)recordInfo, ctx);
        FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)new ReportCalculateContext(ctx, (IReportPropertyAdapter)adapter, p.getVariables(), (IErrorProvider)p.getErrorProvider(), null));
        return book;
    }

    private MessageInfo setMessageInfo(Context ctx, JobParam jobParam, ReportBaseInfo reportInfo) {
        Locale locale = null;
        locale = jobParam.getLocale() != null ? jobParam.getLocale() : new Locale("L2");
        TaxDraftRecordInfo recordInfo = (TaxDraftRecordInfo)reportInfo;
        MessageInfo info = new MessageInfo();
        info.setUserID(ctx.getCaller().toString());
        String companyName = recordInfo.getCompanyOrgUnit() == null ? "" : recordInfo.getCompanyOrgUnit().getName();
        companyName = companyName == null ? "" : companyName + ":";
        info.setbizAction(companyName + recordInfo.getNumber() + ":" + recordInfo.getName() + "(" + RptUtil.getReportResource((String)"ReportCalcMsg", (Locale)locale) + ")");
        info.setOrgNumber(recordInfo.getCompanyOrgUnit().getNumber());
        return info;
    }
}

