/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.tm.td.DraftBillBuildCenter;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxBaseBillInfo;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.TaxOtherReportInfo;
import com.kingdee.eas.tm.td.app.util.TDServerCache;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryCollection;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryInfo;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TDServerUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.app.util.TDServerUtils");
    public static final String NEWLINE = ";\r\n";

    public static String doSaveTaxDraftConfirmBill(Context ctx, ReportBaseInfo reportInfo) throws EASBizException, BOSException {
        StringBuffer errorDetail = new StringBuffer();
        Book book = null;
        try {
            book = TDUtils.getReportBook(ctx, (IObjectValue)reportInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (book == null) {
            errorDetail.append("book is NULL").append("\r\n");
            return errorDetail.toString();
        }
        RptBillRangeEntryCollection entrys = DraftBillBuildCenter.getBillRangeEntry(reportInfo);
        if (entrys == null) {
            entrys = new RptBillRangeEntryCollection();
            errorDetail.append(TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "NO_BILLRANGE", ctx.getLocale(), null)).append("\r\n");
            return errorDetail.toString();
        }
        for (int k = 0; k < entrys.size(); ++k) {
            RptBillRangeEntryInfo entry = entrys.get(k);
            String billName = entry.getBillName();
            String billBosType = entry.getBillBosType();
            Sheet sheet = book.getSheet(billName);
            if (sheet == null) {
                errorDetail.append(TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "NOT_EXISTS_SHEET", ctx.getLocale(), new Object[]{billName})).append("\r\n");
                continue;
            }
            int rowCount = sheet.getRows().getMaxIntMark() + 1;
            int colCount = sheet.getCols().getMaxIntMark() + 1;
            Point point = new Point(0, 0);
            int fieldsCount = 0;
            block5: for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    Object userObject = sheet.getRange(i, j).getUserObject("fieldsCount");
                    if (userObject == null) continue;
                    point = new Point(j, i);
                    fieldsCount = (Integer)userObject;
                    break block5;
                }
            }
            CoreBaseCollection taxBills = new CoreBaseCollection();
            int rowIndex = point.y + 1;
            int colIndex = point.x;
            String fieldKey = null;
            Object fieldValue = null;
            boolean isError = false;
            int errorCount = 0;
            DraftBillBuildCenter fieldsInfo = null;
            DraftBillBuildCenter.initDraftBillInfos(ctx, billBosType);
            EntityObjectInfo entityInfo = DraftBillBuildCenter.getDrafteBillEntity(ctx, billBosType);
            for (int i = rowIndex; i < rowCount; ++i) {
                isError = false;
                TaxBaseBillInfo info = DraftBillBuildCenter.getTaxBillInfo(entityInfo);
                if (reportInfo instanceof TaxDraftRecordInfo) {
                    TaxDraftRecordInfo value = (TaxDraftRecordInfo)reportInfo;
                    info.setRptId(value.getId().toString());
                    info.setTaxItemType(value.getTaxType());
                    info.setReport(value);
                } else if (reportInfo instanceof TaxOtherReportInfo) {
                    TaxOtherReportInfo value = (TaxOtherReportInfo)reportInfo;
                    info.setRptId(value.getId().toString());
                    info.setOtherReport(value);
                }
                for (int j = colIndex; j < colIndex + fieldsCount; ++j) {
                    if (sheet.getRange(point.y, j).getUserObject("fieldKey") == null) continue;
                    fieldKey = sheet.getRange(point.y, j).getUserObject("fieldKey").toString();
                    fieldValue = null;
                    Object value = sheet.getRange(i, j).getValue().getValue();
                    fieldsInfo = (DraftBillBuildCenter)DraftBillBuildCenter.getFieldsMap(billBosType).get(fieldKey);
                    if (fieldsInfo == null) continue;
                    try {
                        if (value instanceof String) {
                            fieldValue = value.toString();
                        } else if (value instanceof GregorianCalendar) {
                            GregorianCalendar time = (GregorianCalendar)value;
                            fieldValue = time.getTime();
                        } else if (value instanceof Date) {
                            Date date = (Date)value;
                            fieldValue = date;
                        } else if (value instanceof BigDecimal) {
                            fieldValue = new BigDecimal(value.toString());
                        }
                        if ("companyOrgUnit".equals(fieldKey) && (fieldValue == null || fieldValue.toString().isEmpty())) {
                            isError = true;
                            break;
                        }
                        DraftBillBuildCenter.buildDraftBillInfo(fieldKey, fieldValue, (IObjectValue)info, fieldsInfo);
                        continue;
                    }
                    catch (Exception ex) {
                        ++errorCount;
                        errorDetail.append(DraftBillBuildCenter.buildErrorResult(i, fieldKey, fieldValue, fieldsInfo));
                        isError = true;
                        break;
                    }
                }
                if (isError) continue;
                taxBills.add((CoreBaseInfo)info);
            }
            if (taxBills.size() <= 0) continue;
            TDServerUtils.saveTaxBills(ctx, billBosType, taxBills);
        }
        return errorDetail.toString();
    }

    private static void saveTaxBills(Context ctx, String bosType, CoreBaseCollection taxBills) throws BOSException, EASBizException {
        ICoreBillBase iBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType(bosType));
        iBillBase.save(taxBills);
    }

    public static void clearTrimInfo(IObjectValue info, String[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            String value = info.getString(fields[i]);
            if (StringUtils.isEmpty((String)value)) continue;
            info.put(fields[i], (Object)value.trim());
        }
    }

    public static void checkEmptyFields(Context ctx, IObjectValue info, List fields) throws EASBizException, BOSException {
        String[] fieldsArr = new String[fields.size()];
        fields.toArray(fieldsArr);
        TDServerUtils.checkEmptyFields(ctx, info, fieldsArr);
    }

    public static void checkEmptyFields(Context ctx, IObjectValue info, String[] fields) throws EASBizException, BOSException {
        ArrayList<String> billFields = new ArrayList<String>();
        ArrayList<String> entryFields = new ArrayList<String>();
        String field2 = null;
        String entriesName = null;
        for (String field2 : fields) {
            if (field2.indexOf(".") > 0) {
                entryFields.add(field2.split("\\.")[1]);
                entriesName = field2.split("\\.")[0];
                continue;
            }
            billFields.add(field2);
        }
        StringBuffer errorMsg = new StringBuffer();
        if (billFields.size() > 0) {
            TDServerUtils.checkBillEmptyFields(ctx, info, billFields, errorMsg);
        }
        if (entryFields.size() > 0 && !StringUtils.isEmpty(entriesName) && info.get(entriesName) instanceof IObjectCollection) {
            IObjectCollection entries = (IObjectCollection)info.get(entriesName);
            IObjectValue entry = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.getObject(i);
                TDServerUtils.checkEntryEmptyFields(ctx, i + 1, entry, entryFields, errorMsg);
            }
        }
        if (errorMsg.length() > 0) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{errorMsg.toString()});
        }
    }

    private static void checkBillEmptyFields(Context ctx, IObjectValue info, List<String> fields, StringBuffer errorMsg) throws EASBizException, BOSException {
        String bosType = info.getBOSType().toString();
        EntityObjectInfo entity = TDServerCache.getEntity(ctx, bosType);
        PropertyInfo property = null;
        StringBuffer emptyFields = new StringBuffer();
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            property = entity.getPropertyByName(field);
            if (!TDServerUtils.checkIsEmpty(info, field)) continue;
            emptyFields.append(property.getAlias(ctx.getLocale())).append("\u3001");
        }
        if (emptyFields.length() > 0) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TDBizResource", "MSG_NOTNULL", ctx.getLocale(), new Object[]{emptyFields.substring(0, emptyFields.length() - 1)})).append(NEWLINE);
        }
    }

    private static void checkEntryEmptyFields(Context ctx, int index, IObjectValue info, List<String> fields, StringBuffer errorMsg) throws EASBizException, BOSException {
        String bosType = info.getBOSType().toString();
        EntityObjectInfo entity = TDServerCache.getEntity(ctx, bosType);
        PropertyInfo property = null;
        StringBuffer emptyFields = new StringBuffer();
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            property = entity.getPropertyByName(field);
            if (!TDServerUtils.checkIsEmpty(info, field)) continue;
            emptyFields.append(property.getAlias(ctx.getLocale())).append("\u3001");
        }
        if (emptyFields.length() > 0) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TDBizResource", "MSG_ENTRY_NOTNULL", ctx.getLocale(), new Object[]{index, emptyFields.substring(0, emptyFields.length() - 1)})).append(NEWLINE);
        }
    }

    private static boolean checkIsEmpty(IObjectValue value, String field) {
        return value.get(field) == null || value.get(field) instanceof String && StringUtils.isEmpty((String)value.get(field).toString());
    }

    public static void checkLengthFields(Context ctx, IObjectValue info, String[] fields) throws EASBizException, BOSException {
        ArrayList<String> billFields = new ArrayList<String>();
        ArrayList<String> entryFields = new ArrayList<String>();
        String field2 = null;
        String entriesName = null;
        for (String field2 : fields) {
            if (field2.indexOf(".") > 0) {
                entryFields.add(field2.split("\\.")[1]);
                entriesName = field2.split("\\.")[0];
                continue;
            }
            billFields.add(field2);
        }
        StringBuffer errorMsg = new StringBuffer();
        if (billFields.size() > 0) {
            TDServerUtils.checkBillOverLengthFields(ctx, info, billFields, errorMsg);
        }
        if (entryFields.size() > 0 && !StringUtils.isEmpty(entriesName) && info.get(entriesName) instanceof IObjectCollection) {
            IObjectCollection entries = (IObjectCollection)info.get(entriesName);
            IObjectValue entry = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.getObject(i);
                TDServerUtils.checkEntryOverLengthFields(ctx, i + 1, entry, entryFields, errorMsg);
            }
        }
        if (errorMsg.length() > 0) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{errorMsg.toString()});
        }
    }

    private static void checkBillOverLengthFields(Context ctx, IObjectValue model, List<String> fields, StringBuffer errorMsg) throws EASBizException, BOSException {
        String bosType = model.getBOSType().toString();
        EntityObjectInfo entity = TDServerCache.getEntity(ctx, bosType);
        String field = null;
        int maxLength = 0;
        int strLength = 0;
        PropertyInfo property = null;
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            field = fields.get(i);
            String value = model.getString(field);
            if (StringUtils.isEmpty((String)value) || (maxLength = TDServerUtils.getMaxLength(ctx, model, field)) == -1 || (strLength = value.getBytes().length) <= maxLength) continue;
            property = entity.getPropertyByName(field);
            String fieldName = property.getAlias(ctx.getLocale());
            String error = TDUtils.getString("com.kingdee.eas.tm.td.TDBizResource", "MSG_OVER_LENGTH", ctx.getLocale(), new Object[]{fieldName, maxLength, strLength});
            errorMsg.append(error).append(NEWLINE);
        }
    }

    private static void checkEntryOverLengthFields(Context ctx, int index, IObjectValue entry, List<String> fields, StringBuffer errorMsg) throws EASBizException, BOSException {
        String bosType = entry.getBOSType().toString();
        EntityObjectInfo entity = TDServerCache.getEntity(ctx, bosType);
        String field = null;
        int maxLength = 0;
        int strLength = 0;
        PropertyInfo property = null;
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            field = fields.get(i);
            String value = entry.getString(field);
            if (StringUtils.isEmpty((String)value) || (maxLength = TDServerUtils.getMaxLength(ctx, entry, field)) == -1 || (strLength = value.getBytes().length) <= maxLength) continue;
            property = entity.getPropertyByName(field);
            String fieldName = property.getAlias(ctx.getLocale());
            String error = TDUtils.getString("com.kingdee.eas.tm.td.TDBizResource", "MSG_ENTRY_OVER_LENGTH", ctx.getLocale(), new Object[]{index, fieldName, maxLength, strLength});
            errorMsg.append(error).append(NEWLINE);
        }
    }

    private static int getMaxLength(Context ctx, IObjectValue value, String field) {
        DataTableInfo tableInfo;
        ColumnInfo columnInfo;
        String bosType = value.getBOSType().toString();
        EntityObjectInfo entity = TDServerCache.getEntity(ctx, bosType);
        PropertyInfo property = entity.getPropertyByName(field);
        if (property != null && property.getMappingField() != null && property.getMappingField().getName() != null) {
            field = property.getMappingField().getName();
        }
        if ((columnInfo = (tableInfo = entity.getTable()).getColumnByName(field)) == null) {
            return -1;
        }
        SQLType sqlType = columnInfo.getTypeName();
        if (!SQLType.NVARCHAR.equals((Object)sqlType) && !SQLType.VARCHAR.equals((Object)sqlType)) {
            return -1;
        }
        return columnInfo.getLength();
    }

    public static boolean checkDateDup(Context ctx, IObjectValue info, IObjectCollection coll, String[] fields) throws EASBizException, BOSException {
        java.util.Date startDate1 = info.getDate(fields[0]);
        startDate1 = TDUtils.parseDate(startDate1, 0, 0, 0, 0);
        java.util.Date endDate1 = info.getDate(fields[1]);
        endDate1 = TDUtils.parseDate(endDate1, 23, 59, 59, 999);
        IObjectValue info2 = null;
        for (int i = 0; i < coll.size(); ++i) {
            info2 = coll.getObject(i);
            java.util.Date startDate2 = info2.getDate(fields[0]);
            startDate2 = TDUtils.parseDate(startDate2, 0, 0, 0, 0);
            java.util.Date endDate2 = info2.getDate(fields[1]);
            endDate2 = TDUtils.parseDate(endDate2, 23, 59, 59, 999);
            if (endDate1 == null && endDate2 == null) {
                return true;
            }
            if (endDate1 == null && endDate2 != null) {
                if (!endDate2.after(startDate1)) continue;
                return true;
            }
            if (endDate1 != null && endDate2 == null) {
                if (!endDate1.after(startDate2)) continue;
                return true;
            }
            if (endDate1 == null || endDate2 == null) continue;
            if (!startDate1.before(startDate2) && startDate1.before(endDate2)) {
                return true;
            }
            if (!startDate1.before(startDate2) || !endDate1.after(startDate2)) continue;
            return true;
        }
        return false;
    }

    public static IObjectCollection checkDateDup2(Context ctx, IObjectValue info, IObjectCollection coll, String[] fields) throws EASBizException, BOSException {
        CoreBaseCollection collDup = new CoreBaseCollection();
        java.util.Date startDate1 = info.getDate(fields[0]);
        startDate1 = TDUtils.parseDate(startDate1, 0, 0, 0, 0);
        java.util.Date endDate1 = info.getDate(fields[1]);
        endDate1 = TDUtils.parseDate(endDate1, 23, 59, 59, 999);
        IObjectValue info2 = null;
        for (int i = 0; i < coll.size(); ++i) {
            info2 = coll.getObject(i);
            java.util.Date startDate2 = info2.getDate(fields[0]);
            startDate2 = TDUtils.parseDate(startDate2, 0, 0, 0, 0);
            java.util.Date endDate2 = info2.getDate(fields[1]);
            endDate2 = TDUtils.parseDate(endDate2, 23, 59, 59, 999);
            if (endDate1 == null && endDate2 == null) {
                collDup.addObject(info2);
                continue;
            }
            if (endDate1 == null && endDate2 != null) {
                if (!endDate2.after(startDate1)) continue;
                collDup.addObject(info2);
                continue;
            }
            if (endDate1 != null && endDate2 == null) {
                if (!endDate1.after(startDate2)) continue;
                collDup.addObject(info2);
                continue;
            }
            if (endDate1 == null || endDate2 == null) continue;
            if (!startDate1.before(startDate2) && startDate1.before(endDate2)) {
                collDup.addObject(info2);
                continue;
            }
            if (!startDate1.before(startDate2) || !endDate1.after(startDate2)) continue;
            collDup.addObject(info2);
        }
        return collDup;
    }

    public static boolean checkDateDup3(Context ctx, IObjectCollection coll, String[] fields) throws EASBizException, BOSException {
        CoreBaseCollection coll2 = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            IObjectValue info = coll.getObject(i);
            coll2.clear();
            coll2.addObjectCollection(coll);
            coll2.removeObject(info);
            if (!TDServerUtils.checkDateDup(ctx, info, (IObjectCollection)coll2, fields)) continue;
            return true;
        }
        return false;
    }

    public static Map getDateDup(Context ctx, IObjectCollection coll, String[] fields, String logoField) throws EASBizException, BOSException {
        HashMap<String, IObjectCollection> result = new HashMap<String, IObjectCollection>();
        String dim = null;
        for (int i = 0; i < coll.size(); ++i) {
            dim = "";
            IObjectValue info = coll.getObject(i);
            IObjectCollection collDup = TDServerUtils.checkDateDup2(ctx, info, coll, fields);
            for (int j = 0; j < collDup.size(); ++j) {
                dim = dim + collDup.getObject(j).get(logoField).toString() + "_";
            }
            if (!"".equals(dim)) {
                dim = dim.substring(0, dim.length() - 1);
            }
            result.put(dim, collDup);
        }
        Set keySets = result.keySet();
        ArrayList keyLists = new ArrayList(keySets);
        block2: for (int i = 0; i < keyLists.size(); ++i) {
            String key1 = (String)keyLists.get(i);
            HashSet<String> set1 = new HashSet<String>(Arrays.asList(key1.split("_")));
            for (int j = 0; j < keyLists.size(); ++j) {
                String key2 = (String)keyLists.get(j);
                HashSet<String> set2 = new HashSet<String>(Arrays.asList(key2.split("_")));
                if (i == j || !set1.containsAll(set2)) continue;
                result.remove(key1);
                continue block2;
            }
        }
        return result;
    }
}

