/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryCollection;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigException;
import com.kingdee.eas.tm.td.basedata.AccountConfigFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigStatusEnum;
import com.kingdee.eas.tm.td.basedata.AccountTypeInfo;
import com.kingdee.eas.tm.td.basedata.DataSourceFactory;
import com.kingdee.eas.tm.td.basedata.DataSourceInfo;
import com.kingdee.eas.tm.td.basedata.DataSourceToAccountFactory;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationFactory;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationInfo;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionFactory;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.basedata.app.AbstractAccountConfigControllerBean;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountConfigControllerBean
extends AbstractAccountConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.basedata.app.AccountConfigControllerBean");
    protected String dsTempTableName = null;
    protected String dsEntryTempTableName = null;
    protected BOSUuid newDataSourceId = null;

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountConfigInfo info = (AccountConfigInfo)model;
        if (info.getId() != null) {
            this.dealChangedFieldsDataForm(ctx, info);
        }
        if (info.getAccountType() != null && info.getAccountType().getTaxTypeItem() != null) {
            String taxTypeID = info.getAccountType().getTaxTypeItem().getId().toString();
            TaxItemTypeInfo taxTypeInfo = TaxItemTypeFactory.getLocalInstance(ctx).getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK(taxTypeID));
            info.getAccountType().setTaxTypeItem(taxTypeInfo);
        }
        return super._submit(ctx, (IObjectValue)info);
    }

    protected void dealChangedFieldsDataForm(Context ctx, AccountConfigInfo info) throws BOSException, EASBizException {
        int i;
        HashSet<String> accountConfigEntryIds = new HashSet<String>();
        AccountConfigEntryCollection oldACEntryColl = AccountConfigEntryFactory.getLocalInstance(ctx).getAccountConfigEntryCollection(" where  parent.id ='" + String.valueOf(info.getId()) + "'");
        AccountConfigEntryCollection newACEntryColl = info.getEntry();
        HashMap<String, DataTypeEnum> checkMap = new HashMap<String, DataTypeEnum>();
        AccountConfigEntryInfo oldACEntry = null;
        AccountConfigEntryInfo newACEntry = null;
        int j = oldACEntryColl.size();
        for (i = 0; i < j; ++i) {
            oldACEntry = oldACEntryColl.get(i);
            checkMap.put(String.valueOf(oldACEntry.getId()), oldACEntry.getDataType());
        }
        j = newACEntryColl.size();
        for (i = 0; i < j; ++i) {
            newACEntry = newACEntryColl.get(i);
            if (!checkMap.containsKey(String.valueOf(newACEntry.getId())) || newACEntry.getDataType().equals(checkMap.get(String.valueOf(newACEntry.getId())))) continue;
            accountConfigEntryIds.add(String.valueOf(newACEntry.getId()));
        }
        if (accountConfigEntryIds == null || accountConfigEntryIds.size() == 0) {
            return;
        }
        OrgToAccountRelationInfo relationInfo = null;
        relationInfo = (OrgToAccountRelationInfo)info.get("relation");
        if (relationInfo != null) {
            String orgUnitId = null;
            String companyOrgUnitId = null;
            if (relationInfo.getOrgUnit() != null) {
                orgUnitId = String.valueOf(relationInfo.getOrgUnit().getId());
            } else {
                companyOrgUnitId = String.valueOf(relationInfo.getCompanyOrgUnit().getId());
            }
            Set dataSourceIds = DataSourceToAccountFactory.getLocalInstance(ctx).getDataSourceByAccount(info.getId().toString(), orgUnitId, companyOrgUnitId);
            if (dataSourceIds == null || dataSourceIds.size() == 0) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(" update t_tm_fieldsmapping set FVALUEEXPRESSION = null,FEXPRESSIONALIAS = null ");
            sb.append(" where FCONDITIONID in (select FID from t_tm_takedatacontdition where FDATASOURCEID in").append(TDUtils.getInStringFromSet(dataSourceIds)).append(") ");
            sb.append(" and FACCOUNTCONFIGENTRYID in ").append(TDUtils.getInStringFromSet(accountConfigEntryIds)).append(";");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getValue(ctx, pk);
        }
        AccountConfigInfo info = (AccountConfigInfo)model;
        info.setState(AccountConfigStatusEnum.ACTIVE);
        super._cancelCancel(ctx, pk, model);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getValue(ctx, pk);
        }
        AccountConfigInfo info = (AccountConfigInfo)model;
        info.setState(AccountConfigStatusEnum.INACTIVE);
        super._cancel(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    @Override
    protected boolean _deleteOtherData(Context ctx, String accountID, String orgUnitID, String companyOrgUnitID) throws BOSException, EASBizException {
        HashSet<String> dsidSet = new HashSet<String>();
        HashSet<String> idList = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FDATASOURCEID as dsid,fid FROM  T_TM_DataSourceToAccount");
        sb.append(" where FAccountConfigID = '").append(accountID).append("' ");
        if (orgUnitID != null) {
            sb.append(" and FORGUNITID = '").append(orgUnitID).append("' ");
        }
        if (companyOrgUnitID != null) {
            sb.append(" and FCompanyOrgUnitID = '").append(companyOrgUnitID).append("' ");
        }
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sb.toString(), null);
        try {
            while (rs.next()) {
                String dsid = rs.getString("dsid");
                String fid = rs.getString("fid");
                dsidSet.add(dsid);
                idList.add(fid);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (dsidSet.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", dsidSet, CompareType.INCLUDE));
            DataSourceFactory.getLocalInstance(ctx).delete(filter);
        }
        if (dsidSet.size() > 0) {
            sb.setLength(0);
            String dsids = TDUtils.getInStringFromSet(dsidSet);
            sb.append(" DELETE FROM T_TM_TakeDataContdition WHERE FDataSourceID in ").append(dsids);
            DBUtil.executeBatch((Context)ctx, (String[])new String[]{sb.toString()});
        }
        if (companyOrgUnitID != null) {
            sb.setLength(0);
            sb.append(" DELETE FROM T_TM_OrgToAccountRelation WHERE ");
            sb.append(" FCOMPANYORGUNITID = '" + companyOrgUnitID + "' and FAccountID = '" + accountID + "' ");
            DBUtil.executeBatch((Context)ctx, (String[])new String[]{sb.toString()});
        }
        String relationID = TDUtils.getInStringFromSet(idList);
        sb.setLength(0);
        if (relationID != null) {
            sb.append(" DELETE FROM T_TM_DataSourceToAccount WHERE fid in ").append(relationID);
            DBUtil.executeBatch((Context)ctx, (String[])new String[]{sb.toString()});
        }
        return false;
    }

    @Override
    protected boolean _isUsing(Context ctx, String accountID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        try {
            sql.append(" SELECT FName FROM T_TD_TaxDraftRecord where FRELATEACCOUNTID = '").append(accountID).append("' ");
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), null);
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new EASBizException(null, (Throwable)e);
        }
        return false;
    }

    @Override
    protected void _active(Context ctx, String billId, String relationId) throws BOSException, EASBizException {
        SelectorItemCollection selector = this.getRelationSelector();
        OrgToAccountRelationInfo info = OrgToAccountRelationFactory.getLocalInstance(ctx).getOrgToAccountRelationInfo((IObjectPK)new ObjectUuidPK(relationId), selector);
        AccountConfigInfo accountInfo = info.getAccount();
        String logDetialStr = this.getLogStr(ctx, accountInfo, info);
        IObjectPK logPk = LogUtils.beginLog(ctx, "actve", BOSObjectType.create((String)"1C64123D"), (IObjectPK)new ObjectUuidPK(accountInfo.getId().toString()), logDetialStr, "accountconfig_active", "");
        if (AccountConfigStatusEnum.ACTIVE.equals((Object)info.getState())) {
            throw new AccountConfigException(AccountConfigException.CANNOTACTIVE);
        }
        info.setState(AccountConfigStatusEnum.ACTIVE);
        OrgToAccountRelationFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId().toString()), info);
        LogUtils.afterLog(ctx, logPk);
    }

    @Override
    protected void _inActive(Context ctx, String billId, String relationId) throws BOSException, EASBizException {
        SelectorItemCollection selector = this.getRelationSelector();
        OrgToAccountRelationInfo info = OrgToAccountRelationFactory.getLocalInstance(ctx).getOrgToAccountRelationInfo((IObjectPK)new ObjectUuidPK(relationId), selector);
        AccountConfigInfo accountInfo = info.getAccount();
        String logDetialStr = this.getLogStr(ctx, accountInfo, info);
        IObjectPK logPk = LogUtils.beginLog(ctx, "inActve", BOSObjectType.create((String)"1C64123D"), (IObjectPK)new ObjectUuidPK(accountInfo.getId().toString()), logDetialStr, "accountconfig_unactive", "");
        if (!AccountConfigStatusEnum.ACTIVE.equals((Object)info.getState())) {
            throw new AccountConfigException(AccountConfigException.CANNOTINACTIVE);
        }
        info.setState(AccountConfigStatusEnum.INACTIVE);
        OrgToAccountRelationFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId().toString()), info);
        LogUtils.afterLog(ctx, logPk);
    }

    @Override
    protected ArrayList _remove(Context ctx, Map params) throws BOSException, EASBizException {
        String[] billIds = (String[])params.get("billIds");
        String[] relationIds = (String[])params.get("relationIds");
        ArrayList<String> errorList = new ArrayList<String>();
        for (int i = 0; i < billIds.length; ++i) {
            try {
                this._remove(ctx, billIds[i], relationIds[i]);
                continue;
            }
            catch (EASBizException e) {
                errorList.add(e.getMessage());
            }
        }
        return errorList;
    }

    @Override
    protected void _remove(Context ctx, String billId, String relationId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        if (!AccountConfigFactory.getLocalInstance(ctx).exists((IObjectPK)pk)) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        AccountConfigInfo info = AccountConfigFactory.getLocalInstance(ctx).getAccountConfigInfo((IObjectPK)pk);
        OrgToAccountRelationInfo relationInfo = OrgToAccountRelationFactory.getLocalInstance(ctx).getOrgToAccountRelationInfo((IObjectPK)new ObjectUuidPK(relationId), this.getRelationSelector());
        String logDetialStr = this.getLogStr(ctx, info, relationInfo);
        IObjectPK logPk = LogUtils.beginLog(ctx, "remove", BOSObjectType.create((String)"1C64123D"), (IObjectPK)new ObjectUuidPK(pk.toString()), logDetialStr, "accountconfig_delete", "");
        if (this._isUsing(ctx, pk.toString())) {
            throw new TDException(TDException.DELETE_REFRENCES_ERROR, new Object[]{info.getNumber()});
        }
        if (!AccountConfigStatusEnum.SAVE.equals((Object)relationInfo.getState())) {
            throw new TDException(TDException.DELETE_STATUS_ERROR, new Object[]{info.getNumber()});
        }
        String orgUnitID = null;
        String companyOrgUnitID = null;
        if (relationInfo.getCompanyOrgUnit() != null) {
            companyOrgUnitID = relationInfo.getCompanyOrgUnit().getId().toString();
        }
        if (relationInfo.getOrgUnit() != null) {
            orgUnitID = relationInfo.getOrgUnit().getId().toString();
        }
        this._deleteOtherData(ctx, billId, orgUnitID, companyOrgUnitID);
        this._delete(ctx, (IObjectPK)pk);
        LogUtils.afterLog(ctx, logPk);
    }

    private String getLogStr(Context ctx, AccountConfigInfo info, OrgToAccountRelationInfo relationInfo) {
        String taxTypeName = relationInfo.getAccountType().getTaxTypeItem().getName();
        String logDetialStr = "";
        if (relationInfo.getOrgUnit() == null) {
            String companyOrgName = relationInfo.getCompanyOrgUnit().getName();
            logDetialStr = taxTypeName + " " + TDUtils.getString("com.kingdee.eas.tm.td.TDLogResource", "OUName", ctx.getLocale()) + " " + companyOrgName + " " + info.getNumber();
        } else {
            String orgName = relationInfo.getOrgUnit().getName();
            logDetialStr = taxTypeName + " " + TDUtils.getString("com.kingdee.eas.tm.td.TDLogResource", "CUName", ctx.getLocale()) + "   " + orgName + " " + info.getNumber();
        }
        return logDetialStr;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.getBoolean("isCompany")) {
            this.checkNumberOrNameDup4Comp(ctx, model, "number");
            return;
        }
        this.checkNumberOrNameDup4CU(ctx, model, "number");
    }

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.getBoolean("isCompany")) {
            this.checkNumberOrNameDup4Comp(ctx, model, "name");
            return;
        }
        this.checkNumberOrNameDup4CU(ctx, model, "name");
    }

    private void checkNumberOrNameDup4CU(Context ctx, IObjectValue model, String type) throws BOSException, EASBizException {
        TreeBaseInfo treeModel = (TreeBaseInfo)model;
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String cu = this.getCU(ctx, (ObjectBaseInfo)treeModel).getId().toString();
        AccountTypeInfo accountTypeInfo = (AccountTypeInfo)treeModel.get("accountType");
        String checkStr = null;
        String checkField = null;
        if ("number".equals(type)) {
            checkStr = treeModel.getNumber();
            checkField = "fnumber";
        }
        if ("name".equals(type)) {
            checkStr = treeModel.getName();
            checkField = "fname_" + loc;
        }
        StringBuffer checkSql = new StringBuffer();
        checkSql.append(" SELECT  1");
        checkSql.append(" FROM  T_TM_OrgToAccountRelation OrgTAcc ");
        checkSql.append(" inner join T_TM_AccountConfig AccCon on OrgTAcc.FACCOUNTID = AccCon.fid ");
        checkSql.append(" where OrgTAcc.FORGUNITID = ? and  AccCon." + checkField + " = ? and AccCon.FACCOUNTTYPEID = ? and FISCOMPANYADD = 0 ");
        if (treeModel.getId() != null) {
            checkSql.append(" and AccCon.fid <> '").append(treeModel.getId().toString()).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString(), (Object[])new Object[]{cu, checkStr, accountTypeInfo.getId().toString()});
        try {
            if (rs.next()) {
                if (!StringUtils.isEmpty((String)checkStr) && checkStr.length() > 10) {
                    checkStr = checkStr.substring(0, 9) + "...";
                }
                if ("number".equals(type)) {
                    throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{checkStr});
                }
                if ("name".equals(type)) {
                    throw new TDException(TDException.NAME_EXISTS, new Object[]{checkStr});
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkNumberOrNameDup4Comp(Context ctx, IObjectValue model, String type) throws BOSException, EASBizException {
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String companyId = model.getString("companyId");
        TreeBaseInfo treeModel = (TreeBaseInfo)model;
        String checkStr = "";
        String checkField = null;
        if ("number".equals(type)) {
            checkStr = treeModel.getNumber();
            checkField = "fnumber";
        }
        if ("name".equals(type)) {
            checkStr = treeModel.getName();
            checkField = "fname_" + loc;
        }
        AccountTypeInfo accountTypeInfo = (AccountTypeInfo)treeModel.get("accountType");
        StringBuffer checkSql = new StringBuffer();
        checkSql.append(" SELECT  1");
        checkSql.append(" FROM  T_TM_OrgToAccountRelation OrgTAcc ");
        checkSql.append(" inner join T_TM_AccountConfig AccCon on OrgTAcc.FACCOUNTID = AccCon.fid ");
        checkSql.append(" where OrgTAcc.FCOMPANYORGUNITID = ? and  AccCon." + checkField + " = ? and AccCon.FACCOUNTTYPEID = ? ");
        if (treeModel.getId() != null) {
            checkSql.append(" and AccCon.fid <> '").append(treeModel.getId().toString()).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString(), (Object[])new Object[]{companyId, checkStr, accountTypeInfo.getId().toString()});
        try {
            if (rs.next()) {
                if ("number".equals(type)) {
                    throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{checkStr});
                }
                if ("name".equals(type)) {
                    throw new TDException(TDException.NAME_EXISTS, new Object[]{checkStr});
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AccountConfigInfo accountInfo = this.getAccountConfigInfo(ctx, pk, this.getSelector());
        return accountInfo.getLogInfo();
    }

    private SelectorItemCollection getRelationSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("isCompanyAdd"));
        selector.add(new SelectorItemInfo("companyOrgUnit.name"));
        selector.add(new SelectorItemInfo("companyOrgUnit.number"));
        selector.add(new SelectorItemInfo("companyOrgUnit.id"));
        selector.add(new SelectorItemInfo("orgUnit.id"));
        selector.add(new SelectorItemInfo("orgUnit.name"));
        selector.add(new SelectorItemInfo("orgUnit.number"));
        selector.add(new SelectorItemInfo("account.id"));
        selector.add(new SelectorItemInfo("account.name"));
        selector.add(new SelectorItemInfo("account.number"));
        selector.add(new SelectorItemInfo("account.accountType.id"));
        selector.add(new SelectorItemInfo("account.accountType.name"));
        selector.add(new SelectorItemInfo("account.accountType.number"));
        selector.add(new SelectorItemInfo("account.accountType.taxTypeItem.id"));
        selector.add(new SelectorItemInfo("account.accountType.taxTypeItem.name"));
        selector.add(new SelectorItemInfo("account.accountType.taxTypeItem.number"));
        return selector;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("accountType.id"));
        selector.add(new SelectorItemInfo("accountType.name"));
        selector.add(new SelectorItemInfo("accountType.number"));
        selector.add(new SelectorItemInfo("accountType.taxTypeItem.id"));
        selector.add(new SelectorItemInfo("accountType.taxTypeItem.name"));
        selector.add(new SelectorItemInfo("accountType.taxTypeItem.number"));
        return selector;
    }

    @Override
    protected void _copyDataSourceAndTakeDataCondition(Context ctx, String selectedAccountConfigId, String newAccountConfigId, String companyOrgUnitId, String orgUnitId) throws BOSException, EASBizException {
        String dataSourceId = null;
        Set dataSourceInfoSet = DataSourceToAccountFactory.getLocalInstance(ctx).getDataSourceByAccount(selectedAccountConfigId, orgUnitId, companyOrgUnitId);
        if (dataSourceInfoSet != null && dataSourceInfoSet.size() > 0) {
            Iterator it = dataSourceInfoSet.iterator();
            int numberEnd = 0;
            while (it.hasNext()) {
                ++numberEnd;
                dataSourceId = (String)it.next();
                try {
                    this.dsTempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
                    this.dsEntryTempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
                    StringBuffer insertDSSql = new StringBuffer();
                    insertDSSql.append(" select * into " + this.dsTempTableName + " from T_TM_DataSource where fid ='" + dataSourceId + "'");
                    StringBuffer insertDSEntrySql = new StringBuffer();
                    insertDSEntrySql.append("select * into " + this.dsEntryTempTableName + " from T_TM_DataSourceEntry where FParentID in ");
                    insertDSEntrySql.append(" ( select fid from " + this.dsTempTableName + " )");
                    StringBuffer updateDSNumberAndName = new StringBuffer();
                    String dataSourceNumber = "DS" + TDUtils.getNumberString() + numberEnd;
                    updateDSNumberAndName.append(" update " + this.dsTempTableName + " set FNumber ='" + dataSourceNumber + "',");
                    updateDSNumberAndName.append(" FName_l2 ='" + dataSourceNumber + "'");
                    updateDSNumberAndName.append(" where Fid ='" + dataSourceId + "';");
                    DbUtil.execute((Context)ctx, (String)insertDSSql.toString());
                    DbUtil.execute((Context)ctx, (String)insertDSEntrySql.toString());
                    DbUtil.execute((Context)ctx, (String)updateDSNumberAndName.toString());
                    String sql = " alter table " + this.dsTempTableName + " add fnewid varchar(44)";
                    String sql1 = " alter table " + this.dsEntryTempTableName + " add fnewId varchar(44)";
                    String sql2 = " alter table " + this.dsEntryTempTableName + " add fnewParentId varchar(44)";
                    String sql3 = " alter table " + this.dsEntryTempTableName + " add fnewParentTableId varchar(44)";
                    DbUtil.execute((Context)ctx, (String)sql);
                    DbUtil.execute((Context)ctx, (String)sql1);
                    DbUtil.execute((Context)ctx, (String)sql2);
                    DbUtil.execute((Context)ctx, (String)sql3);
                    String sql4 = " update " + this.dsEntryTempTableName + " set fnewid = newbosid('910BFDFB') ";
                    DbUtil.execute((Context)ctx, (String)sql4);
                    StringBuffer sql5 = new StringBuffer();
                    sql5.append(" update " + this.dsEntryTempTableName + " t10 set (fnewParentTableId,fparenttableId) =  ( ");
                    sql5.append(" select t1.fnewid ,t1.fnewid from  " + this.dsEntryTempTableName + " t1 inner join " + this.dsEntryTempTableName + " t2  ");
                    sql5.append(" on t1.fid = t2.fparenttableId where  t10.fid = t2.fid ");
                    sql5.append(" ) ");
                    DbUtil.execute((Context)ctx, (String)sql5.toString());
                    this.newDataSourceId = BOSUuid.create((String)"AF4374B7");
                    String sql6 = " update " + this.dsTempTableName + " set fnewid ='" + this.newDataSourceId + "'";
                    DbUtil.execute((Context)ctx, (String)sql6);
                    StringBuffer sql7 = new StringBuffer();
                    sql7.append(" update " + this.dsEntryTempTableName + " t10 set (fnewParentId)=( ");
                    sql7.append(" select t1.fnewid from " + this.dsTempTableName + " t1 inner join " + this.dsEntryTempTableName + " t2 on t1.fid = t2.fparentid ");
                    sql7.append(" where t2.fid = t10.fid ");
                    sql7.append(" ) ");
                    DbUtil.execute((Context)ctx, (String)sql7.toString());
                    DataSourceToAccountFactory.getLocalInstance(ctx).addAccountDataSource(newAccountConfigId, this.newDataSourceId.toString(), orgUnitId, companyOrgUnitId);
                    StringBuffer updateSql = new StringBuffer();
                    updateSql.append(" update  ").append(this.dsEntryTempTableName).append(" set fid = fnewId, FParentTableID = fnewParentTableId,FParentID=fnewParentId ");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString());
                    updateSql.setLength(0);
                    updateSql.append(" update  ").append(this.dsTempTableName).append(" set fid = fnewId ");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString());
                    DbUtil.execute((Context)ctx, (String)this.insertDataSource(this.dsTempTableName));
                    DbUtil.execute((Context)ctx, (String)this.insertDSEntry(this.dsEntryTempTableName));
                }
                catch (Exception e) {
                    throw new BOSException(e.getMessage());
                }
                finally {
                    if (this.dsTempTableName != null) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(this.dsTempTableName);
                    }
                    if (this.dsEntryTempTableName != null) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(this.dsEntryTempTableName);
                    }
                }
                String takeDataConditionId = TakeDataContditionFactory.getLocalInstance(ctx).getIdBySourceId(dataSourceId);
                if ("".equals(takeDataConditionId)) continue;
                TakeDataContditionInfo takeDataConditionInfo = (TakeDataContditionInfo)TakeDataContditionFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(takeDataConditionId));
                BOSUuid newTakeDataConditionId = BOSUuid.create((String)"D91004CE");
                takeDataConditionInfo.setId(newTakeDataConditionId);
                String takeDataConditionName = "TDC" + TDUtils.getNumberString() + numberEnd;
                takeDataConditionInfo.setNumber(takeDataConditionName);
                takeDataConditionInfo.setName(takeDataConditionName);
                ObjectUuidPK dataSourceIObjectPK = new ObjectUuidPK(this.newDataSourceId);
                DataSourceInfo dataSourceInfo = (DataSourceInfo)DataSourceFactory.getLocalInstance(ctx).getValue((IObjectPK)dataSourceIObjectPK);
                takeDataConditionInfo.setDataSource(dataSourceInfo);
                TakeDataContditionFactory.getLocalInstance(ctx).addnew(takeDataConditionInfo);
                AccountConfigEntryFactory.getLocalInstance(ctx).addIntoFieldsMappingWhenCopy(takeDataConditionId.toString(), newTakeDataConditionId.toString(), newAccountConfigId);
            }
        }
    }

    private String insertDataSource(String tempTableName) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" insert into T_TM_DataSource");
        insertSql.append(" (fid,FFilterString,FBillBosType,FState,FIsScheduled,");
        insertSql.append(" FName_l2,FNumber,FDescription_l2,FCreatorID,FCreateTime,FLastUpdateTime,FControlUnitID,FDataDirection)");
        insertSql.append(" select fid,FFilterString,FBillBosType,FState,FIsScheduled,FName_l2,");
        insertSql.append(" FNumber,FDescription_l2,FCreatorID,FCreateTime,FLastUpdateTime,FControlUnitID,FDataDirection from ").append(tempTableName);
        return insertSql.toString();
    }

    private String insertDSEntry(String tempTableName) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_TM_DataSourceEntry");
        insertSql.append("(Fid,FName_l2,FSeq,FBosType,FTableName,FTableAlias,FJoinType,FjoinCondition,FIsMainTable,FParentTableId,FParentId)");
        insertSql.append("select Fid,FName_l2,FSeq,FBosType,FTableName,FTableAlias,FJoinType,FjoinCondition,FIsMainTable,FParentTableId, FParentId ");
        insertSql.append("from ").append(tempTableName);
        return insertSql.toString();
    }
}

