/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.DataSourceFactory;
import com.kingdee.eas.tm.td.basedata.DataSourceInfo;
import com.kingdee.eas.tm.td.basedata.DraftItemException;
import com.kingdee.eas.tm.td.basedata.DraftItemFactory;
import com.kingdee.eas.tm.td.basedata.DraftItemInfo;
import com.kingdee.eas.tm.td.basedata.DraftItemStatus;
import com.kingdee.eas.tm.td.basedata.DraftItemToDataSourceFactory;
import com.kingdee.eas.tm.td.basedata.OrgToDraftItemFactory;
import com.kingdee.eas.tm.td.basedata.OrgToDraftItemInfo;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionFactory;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionInfo;
import com.kingdee.eas.tm.td.basedata.app.AbstractDraftItemControllerBean;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftItemControllerBean
extends AbstractDraftItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.basedata.app.DraftItemControllerBean");
    protected String dsTempTableName = null;
    protected String dsEntryTempTableName = null;
    protected BOSUuid newDataSourceId = null;

    @Override
    protected boolean _deleteOtherData(Context ctx, String orgUnitID, String draftItemID, String companyOrgUnitID) throws BOSException, EASBizException {
        HashSet<String> dsidSet = new HashSet<String>();
        HashSet<String> idList = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FDATASOURCEID as dsid,fid FROM  T_TM_DraftItemToDataSource");
        sb.append(" where FDRAFTITEMID = '").append(draftItemID).append("' ");
        if (orgUnitID != null) {
            sb.append(" and FORGUNITID = '").append(orgUnitID).append("' ");
        }
        if (companyOrgUnitID != null) {
            sb.append(" and FCompanyOrgUnitID = '").append(companyOrgUnitID).append("' ");
        }
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sb.toString(), null);
        try {
            while (rs.next()) {
                String dsid = rs.getString("dsid");
                String fid = rs.getString("fid");
                dsidSet.add(dsid);
                idList.add(fid);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (dsidSet.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", dsidSet, CompareType.INCLUDE));
            DataSourceFactory.getLocalInstance(ctx).delete(filter);
        }
        if (dsidSet.size() > 0) {
            sb.setLength(0);
            String dsids = TDUtils.getInStringFromSet(dsidSet);
            sb.append(" DELETE FROM T_TM_TakeDataContdition WHERE FDataSourceID in ").append(dsids);
            DBUtil.executeBatch((Context)ctx, (String[])new String[]{sb.toString()});
        }
        if (companyOrgUnitID != null) {
            sb.setLength(0);
            sb.append(" DELETE FROM T_TM_OrgToDraftItem WHERE ");
            sb.append(" FCOMPANYORGUNITID = '" + companyOrgUnitID + "' and FDRAFTITEMID = '" + draftItemID + "' ");
            DBUtil.executeBatch((Context)ctx, (String[])new String[]{sb.toString()});
        }
        String relationID = TDUtils.getInStringFromSet(idList);
        sb.setLength(0);
        if (relationID != null) {
            sb.append(" DELETE FROM T_TM_DraftItemToDataSource WHERE fid in ").append(relationID);
            DBUtil.executeBatch((Context)ctx, (String[])new String[]{sb.toString()});
        }
        return false;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeModel = (TreeBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        if (treeModel.innerGetParent() == null) {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            filter.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("#0 and #1 and #2");
            }
        } else {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            if (treeModel.innerGetParent().getId() != null) {
                filterItem = new FilterItemInfo("parent", (Object)treeModel.innerGetParent().getId().toString(), CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("#0 and #1");
            }
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                if (treeModel.innerGetParent().getId() != null) {
                    filter.setMaskString("#0 and #1 and #2");
                } else {
                    filter.setMaskString("#0 and #1");
                }
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeModel);
        if (FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
            if (FilterUtility.hasFilterItem((FilterInfo)filter)) {
                filter.mergeFilter(filterCU, "AND");
            } else {
                filter = filterCU;
            }
        }
        view.setFilter(filter);
        TreeBaseCollection results = this.getTreeBaseCollection(ctx, view);
        String number = treeModel.getNumber();
        if (results != null && results.size() > 0) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{number});
        }
    }

    @Override
    protected void _active(Context ctx, String billId, String relationId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(relationId);
        OrgToDraftItemInfo info = OrgToDraftItemFactory.getLocalInstance(ctx).getOrgToDraftItemInfo((IObjectPK)pk, this.getSelector());
        String taxTypeName = info.getTaxTypeItem().getName();
        String itemNumber = info.getDraftItem().getNumber();
        String itemID = info.getDraftItem().getId().toString();
        String logDetialStr = "";
        if (info.getOrgUnit() == null) {
            String companyOrgName = info.getCompanyOrgUnit().getName();
            logDetialStr = taxTypeName + " " + TDUtils.getString("com.kingdee.eas.tm.td.TDLogResource", "OUName", ctx.getLocale()) + "  " + companyOrgName + " " + itemNumber;
        } else {
            String orgName = info.getOrgUnit().getName();
            logDetialStr = taxTypeName + " " + TDUtils.getString("com.kingdee.eas.tm.td.TDLogResource", "CUName", ctx.getLocale()) + "  " + orgName + " " + itemNumber;
        }
        IObjectPK logPk = LogUtils.beginLog(ctx, "actve", BOSObjectType.create((String)"3A5945C2"), (IObjectPK)new ObjectUuidPK(itemID), logDetialStr, "accountconfig_active", "");
        if (DraftItemStatus.AWAKEN.equals((Object)info.getState())) {
            throw new DraftItemException(DraftItemException.CANNOTACTIVE);
        }
        info.setState(DraftItemStatus.AWAKEN);
        OrgToDraftItemFactory.getLocalInstance(ctx).update((IObjectPK)pk, info);
        LogUtils.afterLog(ctx, logPk);
    }

    @Override
    protected void _inActive(Context ctx, String billId, String relationId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(relationId);
        OrgToDraftItemInfo info = OrgToDraftItemFactory.getLocalInstance(ctx).getOrgToDraftItemInfo((IObjectPK)pk, this.getSelector());
        String taxTypeName = info.getTaxTypeItem().getName();
        String itemNumber = info.getDraftItem().getNumber();
        String itemID = info.getDraftItem().getId().toString();
        String logDetialStr = "";
        if (info.getOrgUnit() == null) {
            String companyOrgName = info.getCompanyOrgUnit().getName();
            logDetialStr = taxTypeName + " " + TDUtils.getString("com.kingdee.eas.tm.td.TDLogResource", "OUName", ctx.getLocale()) + "  " + companyOrgName + " " + itemNumber;
        } else {
            String orgName = info.getOrgUnit().getName();
            logDetialStr = taxTypeName + " " + TDUtils.getString("com.kingdee.eas.tm.td.TDLogResource", "CUName", ctx.getLocale()) + "  " + orgName + " " + itemNumber;
        }
        IObjectPK logPk = LogUtils.beginLog(ctx, "inActve", BOSObjectType.create((String)"3A5945C2"), (IObjectPK)new ObjectUuidPK(itemID), logDetialStr, "accountconfig_unactive", "");
        if (!DraftItemStatus.AWAKEN.equals((Object)info.getState())) {
            throw new DraftItemException(DraftItemException.CANNOTINACTIVE);
        }
        info.setState(DraftItemStatus.NOAWAKEN);
        OrgToDraftItemFactory.getLocalInstance(ctx).update((IObjectPK)pk, info);
        LogUtils.afterLog(ctx, logPk);
    }

    @Override
    protected ArrayList _remove(Context ctx, Map params) throws BOSException, EASBizException {
        String[] billIds = (String[])params.get("billIds");
        String[] relationIds = (String[])params.get("relationIds");
        ArrayList<String> errorList = new ArrayList<String>();
        for (int i = 0; i < billIds.length; ++i) {
            try {
                this._remove(ctx, billIds[i], relationIds[i]);
                continue;
            }
            catch (EASBizException e) {
                errorList.add(e.getMessage());
            }
        }
        return errorList;
    }

    @Override
    protected void _remove(Context ctx, String billId, String relationId) throws BOSException, EASBizException {
        if (!DraftItemFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(billId))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        DraftItemInfo info = DraftItemFactory.getLocalInstance(ctx).getDraftItemInfo((IObjectPK)new ObjectUuidPK(billId));
        ObjectUuidPK pk = new ObjectUuidPK(relationId);
        OrgToDraftItemInfo relationInfo = OrgToDraftItemFactory.getLocalInstance(ctx).getOrgToDraftItemInfo((IObjectPK)pk, this.getSelector());
        String taxTypeName = relationInfo.getTaxTypeItem().getName();
        String itemNumber = relationInfo.getDraftItem().getNumber();
        String itemID = relationInfo.getDraftItem().getId().toString();
        String logDetialStr = "";
        if (relationInfo.getOrgUnit() == null) {
            String companyOrgName = relationInfo.getCompanyOrgUnit().getName();
            logDetialStr = taxTypeName + " " + TDUtils.getString("com.kingdee.eas.tm.td.TDLogResource", "OUName", ctx.getLocale()) + "  " + companyOrgName + " " + itemNumber;
        } else {
            String orgName = relationInfo.getOrgUnit().getName();
            logDetialStr = taxTypeName + " " + TDUtils.getString("com.kingdee.eas.tm.td.TDLogResource", "CUName", ctx.getLocale()) + "  " + orgName + " " + itemNumber;
        }
        IObjectPK logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"3A5945C2"), (IObjectPK)new ObjectUuidPK(itemID), logDetialStr, "accountconfig_delete", "");
        if (!DraftItemStatus.SAVING.equals((Object)relationInfo.getState())) {
            throw new TDException(TDException.DELETE_STATUS_ERROR, new Object[]{info.getNumber()});
        }
        String orgUnitID = null;
        String companyOrgUnitID = null;
        if (relationInfo.getCompanyOrgUnit() != null) {
            companyOrgUnitID = relationInfo.getCompanyOrgUnit().getId().toString();
        }
        if (relationInfo.getOrgUnit() != null) {
            orgUnitID = relationInfo.getOrgUnit().getId().toString();
        }
        this._deleteOtherData(ctx, billId, orgUnitID, companyOrgUnitID);
        this._delete(ctx, (IObjectPK)new ObjectUuidPK(billId));
        LogUtils.afterLog(ctx, logPk);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("taxItemType.id"));
        selector.add(new SelectorItemInfo("taxItemType.name"));
        selector.add(new SelectorItemInfo("taxItemType.number"));
        DraftItemInfo info = this.getDraftItemInfo(ctx, pk, selector);
        return info.getLogInfo();
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("isCompanyAdd"));
        selector.add(new SelectorItemInfo("companyOrgUnit.name"));
        selector.add(new SelectorItemInfo("companyOrgUnit.number"));
        selector.add(new SelectorItemInfo("companyOrgUnit.id"));
        selector.add(new SelectorItemInfo("orgUnit.id"));
        selector.add(new SelectorItemInfo("orgUnit.name"));
        selector.add(new SelectorItemInfo("orgUnit.number"));
        selector.add(new SelectorItemInfo("draftItem.id"));
        selector.add(new SelectorItemInfo("draftItem.name"));
        selector.add(new SelectorItemInfo("draftItem.number"));
        selector.add(new SelectorItemInfo("taxTypeItem.id"));
        selector.add(new SelectorItemInfo("taxTypeItem.name"));
        selector.add(new SelectorItemInfo("taxTypeItem.number"));
        return selector;
    }

    @Override
    protected void _copyDataSourceAndTakeDataCondition(Context ctx, String selectedDraftItemId, String newDraftItemId, String companyOrgUnitId, String orgUnitId) throws BOSException, EASBizException {
        String dataSourceId = null;
        Set dataSourceInfoSet = DraftItemToDataSourceFactory.getLocalInstance(ctx).getDataSourceByParam(orgUnitId, selectedDraftItemId, companyOrgUnitId);
        if (dataSourceInfoSet != null && dataSourceInfoSet.size() > 0) {
            Iterator it = dataSourceInfoSet.iterator();
            int numberEnd = 0;
            while (it.hasNext()) {
                ++numberEnd;
                dataSourceId = (String)it.next();
                try {
                    this.dsTempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
                    this.dsEntryTempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
                    StringBuffer insertDSSql = new StringBuffer();
                    insertDSSql.append(" select * into " + this.dsTempTableName + " from T_TM_DataSource where fid ='" + dataSourceId + "'");
                    StringBuffer insertDSEntrySql = new StringBuffer();
                    insertDSEntrySql.append("select * into " + this.dsEntryTempTableName + " from T_TM_DataSourceEntry where FParentID in ");
                    insertDSEntrySql.append(" ( select fid from " + this.dsTempTableName + " )");
                    StringBuffer updateDSNumberAndName = new StringBuffer();
                    String dataSourceNumber = "DS" + TDUtils.getNumberString() + numberEnd;
                    updateDSNumberAndName.append(" update " + this.dsTempTableName + " set FNumber ='" + dataSourceNumber + "',");
                    updateDSNumberAndName.append(" FName_l2 ='" + dataSourceNumber + "'");
                    updateDSNumberAndName.append(" where Fid ='" + dataSourceId + "';");
                    DbUtil.execute((Context)ctx, (String)insertDSSql.toString());
                    DbUtil.execute((Context)ctx, (String)insertDSEntrySql.toString());
                    DbUtil.execute((Context)ctx, (String)updateDSNumberAndName.toString());
                    String sql = " alter table " + this.dsTempTableName + " add fnewid varchar(44)";
                    String sql1 = " alter table " + this.dsEntryTempTableName + " add fnewId varchar(44)";
                    String sql2 = " alter table " + this.dsEntryTempTableName + " add fnewParentId varchar(44)";
                    String sql3 = " alter table " + this.dsEntryTempTableName + " add fnewParentTableId varchar(44)";
                    DbUtil.execute((Context)ctx, (String)sql);
                    DbUtil.execute((Context)ctx, (String)sql1);
                    DbUtil.execute((Context)ctx, (String)sql2);
                    DbUtil.execute((Context)ctx, (String)sql3);
                    String sql4 = " update " + this.dsEntryTempTableName + " set fnewid = newbosid('910BFDFB') ";
                    DbUtil.execute((Context)ctx, (String)sql4);
                    StringBuffer sql5 = new StringBuffer();
                    sql5.append(" update " + this.dsEntryTempTableName + " t10 set (fnewParentTableId,fparenttableId) =  ( ");
                    sql5.append(" select t1.fnewid ,t1.fnewid from  " + this.dsEntryTempTableName + " t1 inner join " + this.dsEntryTempTableName + " t2  ");
                    sql5.append(" on t1.fid = t2.fparenttableId where  t10.fid = t2.fid ");
                    sql5.append(" ) ");
                    DbUtil.execute((Context)ctx, (String)sql5.toString());
                    this.newDataSourceId = BOSUuid.create((String)"AF4374B7");
                    String sql6 = " update " + this.dsTempTableName + " set fnewid ='" + this.newDataSourceId + "'";
                    DbUtil.execute((Context)ctx, (String)sql6);
                    StringBuffer sql7 = new StringBuffer();
                    sql7.append(" update " + this.dsEntryTempTableName + " t10 set (fnewParentId)=( ");
                    sql7.append(" select t1.fnewid from " + this.dsTempTableName + " t1 inner join " + this.dsEntryTempTableName + " t2 on t1.fid = t2.fparentid ");
                    sql7.append(" where t2.fid = t10.fid ");
                    sql7.append(" ) ");
                    DbUtil.execute((Context)ctx, (String)sql7.toString());
                    DraftItemToDataSourceFactory.getLocalInstance(ctx).addDraftItemDataSource(orgUnitId, newDraftItemId.toString(), this.newDataSourceId.toString(), companyOrgUnitId);
                    StringBuffer updateSql = new StringBuffer();
                    updateSql.append(" update  ").append(this.dsEntryTempTableName).append(" set fid = fnewId, FParentTableID = fnewParentTableId,FParentID=fnewParentId ");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString());
                    updateSql.setLength(0);
                    updateSql.append(" update  ").append(this.dsTempTableName).append(" set fid = fnewId ");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString());
                    DbUtil.execute((Context)ctx, (String)this.insertDataSource(this.dsTempTableName));
                    DbUtil.execute((Context)ctx, (String)this.insertDSEntry(this.dsEntryTempTableName));
                }
                catch (Exception e) {
                    throw new BOSException(e.getMessage());
                }
                finally {
                    if (this.dsTempTableName != null) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(this.dsTempTableName);
                    }
                    if (this.dsEntryTempTableName != null) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(this.dsEntryTempTableName);
                    }
                }
                String takeDataConditionId = TakeDataContditionFactory.getLocalInstance(ctx).getIdBySourceId(dataSourceId);
                if ("".equals(takeDataConditionId)) continue;
                TakeDataContditionInfo takeDataConditionInfo = (TakeDataContditionInfo)TakeDataContditionFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(takeDataConditionId));
                BOSUuid newTakeDataConditionId = BOSUuid.create((String)"D91004CE");
                takeDataConditionInfo.setId(newTakeDataConditionId);
                String takeDataConditionName = "TDC" + TDUtils.getNumberString() + numberEnd;
                takeDataConditionInfo.setNumber(takeDataConditionName);
                takeDataConditionInfo.setName(takeDataConditionName);
                ObjectUuidPK dataSourceIObjectPK = new ObjectUuidPK(this.newDataSourceId);
                DataSourceInfo dataSourceInfo = (DataSourceInfo)DataSourceFactory.getLocalInstance(ctx).getValue((IObjectPK)dataSourceIObjectPK);
                takeDataConditionInfo.setDataSource(dataSourceInfo);
                TakeDataContditionFactory.getLocalInstance(ctx).addnew(takeDataConditionInfo);
            }
        }
    }

    private String insertDataSource(String tempTableName) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" insert into T_TM_DataSource");
        insertSql.append(" (fid,FFilterString,FBillBosType,FState,FIsScheduled,");
        insertSql.append(" FName_l2,FNumber,FDescription_l2,FCreatorID,FCreateTime,FLastUpdateTime,FControlUnitID,FDataDirection)");
        insertSql.append(" select fid,FFilterString,FBillBosType,FState,FIsScheduled,FName_l2,");
        insertSql.append(" FNumber,FDescription_l2,FCreatorID,FCreateTime,FLastUpdateTime,FControlUnitID,FDataDirection from ").append(tempTableName);
        return insertSql.toString();
    }

    private String insertDSEntry(String tempTableName) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_TM_DataSourceEntry");
        insertSql.append("(Fid,FName_l2,FSeq,FBosType,FTableName,FTableAlias,FJoinType,FjoinCondition,FIsMainTable,FParentTableId,FParentId)");
        insertSql.append("select Fid,FName_l2,FSeq,FBosType,FTableName,FTableAlias,FJoinType,FjoinCondition,FIsMainTable,FParentTableId, FParentId ");
        insertSql.append("from ").append(tempTableName);
        return insertSql.toString();
    }
}

