/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxBaseCollection;
import com.kingdee.eas.tm.td.basedata.TaxBaseEntryCollection;
import com.kingdee.eas.tm.td.basedata.TaxBaseFactory;
import com.kingdee.eas.tm.td.basedata.TaxBaseInfo;
import com.kingdee.eas.tm.td.basedata.TaxInfoState;
import com.kingdee.eas.tm.td.basedata.app.AbstractTaxBaseControllerBean;
import com.kingdee.eas.tm.td.cloud.TDCloudException;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TaxBaseControllerBean
extends AbstractTaxBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.basedata.app.TaxBaseControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxBaseInfo info = (TaxBaseInfo)model;
        info.setId(BOSUuid.create((String)"343D860A"));
        IObjectPK logPk = LogUtils.beginLog(ctx, "addNew", BOSObjectType.create((String)"343D860A"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "taxBase_new", info.getCompany().getId().toString());
        this.checkNumber(ctx, info.getNumber(), info);
        IObjectPK pk = super._addnew(ctx, model);
        LogUtils.afterLog(ctx, logPk);
        return pk;
    }

    private void checkNumber(Context ctx, String number, TaxBaseInfo info) throws BOSException, EASBizException {
        if (number != null && !"".equals(number.trim())) {
            boolean exists;
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            if (info.getId() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            }
            if (exists = super._exists(ctx, filterInfo)) {
                String str = TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "EXIST_SAME_NUMBER", ctx.getOriginLocale());
                throw new TDException(TDException.ERROR_MSG, new Object[]{str});
            }
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getTaxBaseInfo(ctx, pk);
        }
        TaxBaseInfo info = (TaxBaseInfo)model;
        IObjectPK logPk = LogUtils.beginLog(ctx, "edit", BOSObjectType.create((String)"343D860A"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "taxBase_edit", info.getCompany().getId().toString());
        this.checkNumber(ctx, info.getNumber(), info);
        super._update(ctx, pk, (IObjectValue)model);
        LogUtils.afterLog(ctx, logPk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxBaseInfo taxBaseInfo = (TaxBaseInfo)model;
        if (taxBaseInfo.getId() == null) {
            String companyId = taxBaseInfo.getCompany().getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
            boolean exists = TaxBaseFactory.getLocalInstance(ctx).exists(filter);
            if (exists) {
                String str = taxBaseInfo.getCompany().getName() + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Bill_HasExist", ctx.getLocale());
                throw new TDException(TDException.ERROR_MSG, new Object[]{str});
            }
        }
        this.setSeq(taxBaseInfo);
        return super._save(ctx, (IObjectValue)taxBaseInfo);
    }

    private void setSeq(TaxBaseInfo taxBaseInfo) {
        TaxBaseEntryCollection entry = taxBaseInfo.getTaxBaseEntry();
        for (int i = 0; i < entry.size(); ++i) {
            entry.get(i).setSeq(i + 1);
        }
    }

    @Override
    protected ArrayList _batchDelete(Context ctx, Set ids) throws BOSException, EASBizException {
        ArrayList<String> errors = new ArrayList<String>();
        Iterator idIter = ids.iterator();
        while (idIter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)idIter.next().toString()));
            TaxBaseInfo info = this.getTaxBaseInfo(ctx, (IObjectPK)pk);
            if (TaxInfoState.ABLE.equals((Object)info.getState())) {
                errors.add(info.getNumber() + "\uff1a" + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Active_NotDelete", ctx.getLocale()));
                continue;
            }
            super.delete(ctx, (IObjectPK)pk);
        }
        return errors;
    }

    @Override
    protected ArrayList _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        int i;
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        TaxBaseCollection coll = TaxBaseFactory.getLocalInstance(ctx).getTaxBaseCollection(view);
        TaxBaseInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        IObjectPK logPk = null;
        ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            logPk = LogUtils.beginLog(ctx, "cancel", BOSObjectType.create((String)"343D860A"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "taxBase_cancel", info.getCompany().getId().toString());
            if (!TaxInfoState.ABLE.equals((Object)info.getState())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CANNOT_INACTIVE", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
            logPkList.add(logPk);
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TM_TaxBase set FState = 0 where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        int j = logPkList.size();
        for (i = 0; i < j; ++i) {
            LogUtils.afterLog(ctx, (IObjectPK)logPkList.get(i));
        }
        return errors;
    }

    @Override
    protected ArrayList _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        int i;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        TaxBaseCollection coll = TaxBaseFactory.getLocalInstance(ctx).getTaxBaseCollection(view);
        TaxBaseInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        IObjectPK logPk = null;
        ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            logPk = LogUtils.beginLog(ctx, "cancelcancel", BOSObjectType.create((String)"343D860A"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "taxBase_cancelcancel", info.getCompany().getId().toString());
            if (!TaxInfoState.DISABLE.equals((Object)info.getState())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CANNOT_ACTIVE", ctx.getLocale()));
                continue;
            }
            EntityViewInfo view1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString(), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
            view1.setFilter(filter1);
            TaxBaseCollection coll1 = TaxBaseFactory.getLocalInstance(ctx).getTaxBaseCollection(view1);
            if (coll1.size() > 0) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CONTAINS_ACTIVE", ctx.getLocale()));
                continue;
            }
            DbUtil.execute((Context)ctx, (String)("update T_TM_TaxBase set FState = 1 where FID in ('" + info.getId().toString() + "');"));
            logPkList.add(logPk);
        }
        int j = logPkList.size();
        for (i = 0; i < j; ++i) {
            LogUtils.afterLog(ctx, (IObjectPK)logPkList.get(i));
        }
        return errors;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TaxBaseInfo info = TaxBaseFactory.getLocalInstance(ctx).getTaxBaseInfo(pk);
        IObjectPK logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"343D860A"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "taxBase_delete", info.getCompany().getId().toString());
        this.checkBeforeDelete(ctx, info);
        super._delete(ctx, pk);
        LogUtils.afterLog(ctx, logPk);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxBaseInfo info = TaxBaseFactory.getLocalInstance(ctx).getTaxBaseInfo(pk);
        this.checkBeforeCancel(ctx, info);
        info.setState(TaxInfoState.DISABLE);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxBaseInfo info = TaxBaseFactory.getLocalInstance(ctx).getTaxBaseInfo(pk);
        this.checkBeforeCancelCancel(ctx, info);
        info.setState(TaxInfoState.ABLE);
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void checkBeforeDelete(Context ctx, TaxBaseInfo info) throws BOSException, EASBizException {
        if (TaxInfoState.ABLE.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.DELETE_STATUS_ERROR1);
        }
    }

    private void checkBeforeCancel(Context ctx, TaxBaseInfo info) throws BOSException, EASBizException {
        if (!TaxInfoState.ABLE.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.CANCEL_STATUS_ERROR);
        }
    }

    private void checkBeforeCancelCancel(Context ctx, TaxBaseInfo info) throws BOSException, EASBizException {
        if (TaxInfoState.ABLE.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.CANCELCANCEL_STATUS_ERROR);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        TaxBaseCollection coll1 = TaxBaseFactory.getLocalInstance(ctx).getTaxBaseCollection(view);
        if (coll1.size() > 0) {
            throw new TDCloudException(TDCloudException.CANCELCANCEL_CONTAINS, new Object[]{info.getNumber()});
        }
    }

    @Override
    protected List _getCreditRatingCounts(Context ctx, Map params) throws BOSException, EASBizException {
        ArrayList rateList = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FCreditRating as rate,count(1) as rateCount FROM T_TM_TaxBase  ");
        sql.append(" WHERE FSTATE = 1 ");
        OrgUnitCollection companys = TDUtils.getAuthOrgByPermItem(ctx, OrgType.Company, "taxbase_view");
        HashSet<String> companyids = new HashSet<String>();
        for (int i = 0; i < companys.size(); ++i) {
            companyids.add(companys.get(i).getId().toString());
        }
        HashSet companyOrgids = new HashSet();
        HashSet curCompanyId = new HashSet();
        if (params.get("curCompanyId") != null) {
            curCompanyId.add(params.get("curCompanyId"));
            TDUtils.getCompanyOrgUnitIds(ctx, curCompanyId, companyOrgids);
        }
        if (companyids.size() > 0) {
            companyids.retainAll(companyOrgids);
        }
        companyids.add("");
        sql.append(" and FCompanyId in (").append(CollectionUtil.convertSet2String(companyids, ",", true)).append(")");
        sql.append(" GROUP BY FCreditRating");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, Integer> rate = null;
        try {
            while (rs.next()) {
                rate = new HashMap<String, Integer>();
                rate.put("rate", rs.getInt("rate"));
                rate.put("rateCount", rs.getInt("rateCount"));
                rateList.add(rate);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rateList;
    }

    @Override
    protected int _getSeqByTaxType(Context ctx, String taxType, String id) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select taxentry.fseq as FSeq  from T_TM_TaxBaseEntry  as taxentry where  (taxentry.ftaxitemtypeId=(select fid from T_TM_TaxItemType  as taxtype  where taxtype.fnumber ='" + taxType + "') ");
        sql.append(" or taxentry.ftaxitemtype=(select fname_l2 from T_TM_TaxItemType  as taxtype  where taxtype.fnumber ='" + taxType + "'))");
        sql.append("and taxentry.fparentid='" + id + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        Integer seq = -1;
        try {
            while (rs.next()) {
                seq = rs.getInt("FSeq");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return seq;
    }
}

