/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.app.util.TDServerUtils;
import com.kingdee.eas.tm.td.basedata.TaxReliefRulesInfo;
import com.kingdee.eas.tm.td.basedata.app.AbstractTaxReliefRulesControllerBean;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import org.apache.log4j.Logger;

public class TaxReliefRulesControllerBean
extends AbstractTaxReliefRulesControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.basedata.app.TaxReliefRulesControllerBean");
    private static final String NUMBER = "number";
    private static final String TAXRELIEFNAME = "taxReliefName";
    private static final String NAME = "name";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxReliefRulesInfo info = (TaxReliefRulesInfo)model;
        info.setValidDate(TDUtils.parseDate(info.getValidDate(), 0, 0, 0, 0));
        info.setExpireDate(TDUtils.parseDate(info.getExpireDate(), 23, 59, 59, 999));
        this.checkBeforeSubmit(ctx, info);
        this.checkNumberDup(ctx, (DataBaseInfo)model);
        if (info.getCU() == null) {
            info.setCU(CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4")));
        }
        return super._submit(ctx, model);
    }

    protected void checkBeforeSubmit(Context ctx, TaxReliefRulesInfo info) throws EASBizException, BOSException {
        String[] emptyFields = new String[]{"taxItemType", "taxReliefMajorCatergory", "taxReliefSubCatergory", NUMBER, TAXRELIEFNAME, NAME};
        TDServerUtils.checkEmptyFields(ctx, (IObjectValue)info, emptyFields);
        if (info.getValidDate() != null && info.getExpireDate() != null && DateTimeUtils.dayAfter((Date)info.getValidDate(), (Date)info.getExpireDate())) {
            String str = TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxReliefRulesResource", "DATE_ERROR", ctx.getLocale(), new Object[]{info.getNumber(), info.getString(TAXRELIEFNAME), info.getName()});
            throw new TDException(TDException.ERROR_MSG, new Object[]{str});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        DataBaseInfo info = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo(NUMBER, (Object)info.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo(TAXRELIEFNAME, (Object)info.getString(TAXRELIEFNAME), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo(NAME, (Object)info.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            String str = TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxReliefRulesResource", "EXIST_SAME_DATA", ctx.getLocale(), new Object[]{info.getNumber(), info.getString(TAXRELIEFNAME), info.getName()});
            throw new TDException(TDException.ERROR_MSG, new Object[]{str});
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }
}

