/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.dataImport.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.dataImport.impl.AbstractDataImport;
import com.kingdee.eas.tm.td.basedata.dataImport.model.DataImportParams;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AccountDataImport
extends AbstractDataImport {
    public AccountDataImport(Context ctx, DataImportParams params) {
        super(ctx, params);
    }

    @Override
    protected String getImportCuId() throws BOSException, EASBizException {
        String tempCUID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        StringBuffer draftitemCheck = new StringBuffer();
        draftitemCheck.append(" select  top 1 t1.FOrgUnitID as cuId  from T_TM_OrgToAccountRelation t1 ");
        draftitemCheck.append(" inner join  T_TM_AccountConfig t2 on t1.FAccountID  = t2.fid ");
        draftitemCheck.append(" inner join  t_org_company  t3 on t1.FOrgUnitID =  t3.FControlUnitID ");
        draftitemCheck.append(" where t1.FState = '2' and t3.fid = '" + this.params.getCompanyId() + "' ");
        draftitemCheck.append(" and t2.FAccountTypeID = '" + this.params.getAccountTypeID() + "' ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)draftitemCheck.toString());
        try {
            if (rs.next()) {
                tempCUID = rs.getString("cuId");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return tempCUID;
    }

    @Override
    protected void delDataSourceConfigRelationRecords() throws BOSException, EASBizException {
        StringBuffer delDraftRelation = new StringBuffer();
        delDraftRelation.append(" delete from  T_TM_DataSourceToAccount where fid  in (");
        delDraftRelation.append(this.getSelectSql("dsRelation")).append(" )");
        DbUtil.execute((Context)this.ctx, (String)delDraftRelation.toString());
    }

    @Override
    protected void delOrgConfigRelationRecords() throws BOSException, EASBizException {
        StringBuffer delOrgDraftRelation = new StringBuffer();
        delOrgDraftRelation.append(" delete from  T_TM_OrgToAccountRelation where fid  in (");
        delOrgDraftRelation.append(this.getSelectSql("accountOrgRelation")).append(" )");
        DbUtil.execute((Context)this.ctx, (String)delOrgDraftRelation.toString());
    }

    @Override
    protected String getSelectSql(String selectType) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        if ("takeContdition".equals(selectType)) {
            sb.append(" select t3.fid ");
            sb.append(" from T_TM_DataSourceToAccount t0 ");
            sb.append(" left join T_TM_DataSource t1 on t1.fid = t0.fdatasourceid ");
            sb.append(" left join T_TM_DataSourceEntry t2 on t1.fid = t2.fparentid ");
            sb.append(" left join T_TM_TakeDataContdition  t3 on t1.fid = t3.FDATASOURCEID ");
            sb.append(" inner join T_TM_AccountConfig account on account.fid = t0.FAccountConfigID ");
            sb.append(" where t0.FCompanyOrgUnitID = '" + this.params.getCompanyId() + "' ");
            sb.append(" and account.FAccountTypeID=  '" + this.params.getAccountTypeID() + "' ");
            sb.append(" and t0.FIsCompanyAdd = 0");
        } else if ("dsEntry".equals(selectType)) {
            sb.append(" select t2.fid ");
            sb.append(" from T_TM_DataSourceToAccount t0 ");
            sb.append(" left join T_TM_DataSource t1 on t1.fid = t0.fdatasourceid ");
            sb.append(" left join T_TM_DataSourceEntry t2 on t1.fid = t2.fparentid ");
            sb.append(" inner join T_TM_AccountConfig account on account.fid = t0.FAccountConfigID ");
            sb.append(" where t0.FCompanyOrgUnitID = '" + this.params.getCompanyId() + "' ");
            sb.append(" and account.FAccountTypeID=  '" + this.params.getAccountTypeID() + "' ");
            sb.append(" and  t0.FIsCompanyAdd = 0");
        } else if ("dataSource".equals(selectType)) {
            sb.append(" select t1.fid ");
            sb.append(" from T_TM_DataSourceToAccount t0 ");
            sb.append(" left join T_TM_DataSource t1 on t1.fid = t0.fdatasourceid ");
            sb.append(" inner join T_TM_AccountConfig account on account.fid = t0.FAccountConfigID ");
            sb.append(" where t0.FCompanyOrgUnitID = '" + this.params.getCompanyId() + "' ");
            sb.append(" and account.FAccountTypeID=  '" + this.params.getAccountTypeID() + "' ");
            sb.append(" and t0.FIsCompanyAdd = 0");
        } else if ("dsRelation".equals(selectType)) {
            sb.append(" select t0.fid ");
            sb.append(" from T_TM_DataSourceToAccount t0 ");
            sb.append(" inner join T_TM_AccountConfig account on account.fid = t0.FAccountConfigID ");
            sb.append(" where t0.FCompanyOrgUnitID = '" + this.params.getCompanyId() + "' ");
            sb.append(" and account.FAccountTypeID=  '" + this.params.getAccountTypeID() + "' ");
            sb.append(" and t0.FIsCompanyAdd = 0");
        } else if ("accountOrgRelation".equals(selectType)) {
            sb.append(" select t0.fid from T_TM_OrgToAccountRelation t0");
            sb.append(" inner join T_TM_AccountConfig account on account.fid = t0.FAccountID ");
            sb.append(" where t0.FIsCompanyAdd = 0 and t0.FCompanyOrgUnitID =  '" + this.params.getCompanyId() + "' and t0.FAccountTypeID =  '" + this.params.getAccountTypeID() + "' ");
        }
        if (this.params.getAccounts() != null && this.params.getAccounts().size() > 0) {
            String orgUnitID = null;
            orgUnitID = !"00000000-0000-0000-0000-000000000000CCE7AED4".equals(this.params.getImportCuId()) ? "00000000-0000-0000-0000-000000000000CCE7AED4" : this.company.getCU().getId().toString();
            sb.append(" and (");
            sb.append(" account.fid in (").append(CollectionUtil.convertList2String(this.params.getAccounts(), ",", true)).append(")");
            sb.append(" or account.fid in (");
            sb.append(" select FAccountID from T_TM_OrgToAccountRelation where FOrgUnitID ='").append(orgUnitID).append("'");
            sb.append(" and FAccountTypeID = '").append(this.params.getAccountTypeID()).append("'");
            sb.append(" ))");
        }
        return sb.toString();
    }

    private String getAccountConfigIDSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FAccountID  from T_TM_OrgToAccountRelation  ");
        sql.append(" where  FIsCompanyAdd = 0 and FCompanyOrgUnitID =  '" + this.params.getCompanyId() + "' and FAccountTypeID =  '" + this.params.getAccountTypeID() + "'");
        return sql.toString();
    }

    @Override
    protected void insertOrgConfigRelationRecords() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select count(1) as TOTALCOUNT");
        sql.append(" from T_TM_OrgToAccountRelation  t1 inner join T_TM_AccountConfig t2 on t1.FAccountID = t2.fid ");
        sql.append(" where t1.FCompanyOrgUnitID is null and t1.FState = '2' and t1.FOrgUnitID = '");
        sql.append(this.importCuId).append("' and t1.FAccountTypeID= '" + this.params.getAccountTypeID() + "'");
        if (this.params.getAccounts() != null && this.params.getAccounts().size() > 0) {
            sql.append(" and t1.FAccountID in (").append(CollectionUtil.convertList2String(this.params.getAccounts(), ",", true)).append(")");
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                this.successCount = rs.getInt("TOTALCOUNT");
                if (this.successCount == 0) {
                    this.result.setDetailMsg(TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "msg_DataImportEmpty", this.ctx.getLocale(), new Object[]{this.company.getName()}));
                    continue;
                }
                this.result.setDetailMsg(TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "msg_DataImportSuccess", this.ctx.getLocale(), new Object[]{this.company.getName(), this.successCount}));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer insertStr = new StringBuffer();
        insertStr.append(" insert into T_TM_OrgToAccountRelation ");
        insertStr.append(" (fid,FOrgUnitID,FCompanyOrgUnitID,FAccountID,FAccountTypeID,FIsCompanyAdd ) ");
        insertStr.append(" select newBosid('AF79FE9C'),null,'" + this.params.getCompanyId() + "',t1.FAccountID,t1.FAccountTypeID,0");
        insertStr.append(" from T_TM_OrgToAccountRelation  t1 inner join T_TM_AccountConfig t2 on t1.FAccountID = t2.fid ");
        insertStr.append(" where t1.FCompanyOrgUnitID is null and t1.FState = '2' and t1.FOrgUnitID = '");
        insertStr.append(this.importCuId).append("' and t1.FAccountTypeID= '" + this.params.getAccountTypeID() + "'");
        if (this.params.getAccounts() != null && this.params.getAccounts().size() > 0) {
            insertStr.append(" and t1.FAccountID in (").append(CollectionUtil.convertList2String(this.params.getAccounts(), ",", true)).append(")");
        }
        DbUtil.execute((Context)this.ctx, (String)insertStr.toString());
    }

    @Override
    protected Map<String, String> getCUDataSourceMap() throws BOSException, EASBizException {
        IRowSet dataSource;
        StringBuffer getIds = new StringBuffer();
        getIds.append(" SELECT t2.fid as dsid,t1.fid as relationID FROM  T_TM_DataSourceToAccount t1 ");
        getIds.append(" inner join T_TM_DataSource t2 on t1.FDataSourceID = t2.fid ");
        getIds.append(" where FOrgUnitID  = '" + this.importCuId + "' and t1.FAccountConfigID in ( ");
        getIds.append(this.getAccountConfigIDSQL());
        getIds.append("  )");
        if (this.params.getAccounts() != null && this.params.getAccounts().size() > 0) {
            getIds.append(" and t1.FAccountConfigID in (").append(CollectionUtil.convertList2String(this.params.getAccounts(), ",", true)).append(")");
        }
        if ((dataSource = DbUtil.executeQuery((Context)this.ctx, (String)getIds.toString())).size() == 0) {
            return null;
        }
        HashMap<String, String> dsMap = new HashMap<String, String>();
        try {
            while (dataSource.next()) {
                dsMap.put(dataSource.getString("dsid"), dataSource.getString("relationID"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return dsMap;
    }

    @Override
    protected void insertDataSourceConfigRelationRecords() throws BOSException, EASBizException {
        String orgToDsTableName = null;
        try {
            orgToDsTableName = TempTablePool.getInstance((Context)this.ctx).createTempTableName();
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        StringBuffer insertOrgToDSSql = new StringBuffer();
        insertOrgToDSSql.append(" select * into " + orgToDsTableName + " from T_TM_DataSourceToAccount where fid in (" + this.relationIds + ")");
        DbUtil.execute((Context)this.ctx, (String)insertOrgToDSSql.toString());
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update " + orgToDsTableName + " t10  set (FCompanyOrgUnitID,FDataSourceID) = ( ");
        updateSql.append(" SELECT '" + this.params.getCompanyId() + "',t2.fnewId  ");
        updateSql.append(" FROM " + orgToDsTableName + " t1 inner join " + this.dsTempTableName + "  t2 on t1.FDataSourceID = t2.fid ");
        updateSql.append(" where t10.fid = t1.fid) ");
        DbUtil.execute((Context)this.ctx, (String)updateSql.toString());
        DbUtil.execute((Context)this.ctx, (String)this.insertOrgToDataSource(orgToDsTableName));
        TempTablePool.getInstance((Context)this.ctx).releaseTable(orgToDsTableName);
    }

    private String insertOrgToDataSource(String tempTableName) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" insert into T_TM_DataSourceToAccount");
        insertSql.append(" (fid,FAccountConfigID,FDataSourceID,FOrgUnitID,FCompanyOrgUnitID,FIsCompanyAdd )");
        insertSql.append(" select newbosid('8201EC3B'),FAccountConfigID,FDataSourceID,null,FCompanyOrgUnitID,0 from ").append(tempTableName);
        return insertSql.toString();
    }

    @Override
    protected void checkNumberOrNameDup(String type) throws BOSException, EASBizException {
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        String checkField = null;
        if ("number".equals(type)) {
            checkField = "fnumber";
        }
        if ("name".equals(type)) {
            checkField = "fname_" + loc;
        }
        StringBuffer checkSql = new StringBuffer();
        checkSql.append(" SELECT  AccCon." + checkField + " as checkField,count(1) as count");
        checkSql.append(" FROM T_TM_OrgToAccountRelation OrgTAcc ");
        checkSql.append(" inner join T_TM_AccountConfig AccCon on OrgTAcc.FACCOUNTID = AccCon.fid ");
        checkSql.append(" where OrgTAcc.FCOMPANYORGUNITID = ? ");
        checkSql.append(" and AccCon.FACCOUNTTYPEID = ? ");
        checkSql.append(" group by AccCon." + checkField + ",AccCon.FACCOUNTTYPEID ");
        checkSql.append(" having count(1) >1  ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)checkSql.toString(), (Object[])new Object[]{this.params.getCompanyId(), this.params.getAccountTypeID()});
        StringBuffer errorNumber = new StringBuffer();
        try {
            while (rs.next()) {
                errorNumber.append(rs.getString("checkField"));
                errorNumber.append(",");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (errorNumber.length() > 0) {
            if ("number".equals(type)) {
                throw new TDException(TDException.IMPORTNUMBER_DUP, new Object[]{errorNumber.substring(0, errorNumber.length() - 1)});
            }
            if ("name".equals(type)) {
                throw new TDException(TDException.IMPORTNAME_DUP, new Object[]{errorNumber.substring(0, errorNumber.length() - 1)});
            }
        }
    }
}

