/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.td.cloud.app.AbstractTDSolutionFacadeControllerBean;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class TDSolutionFacadeControllerBean
extends AbstractTDSolutionFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.app.TDSolutionFacadeControllerBean");

    @Override
    protected List _getSolutionList(Context ctx, String parentUIName) throws BOSException, EASBizException {
        ArrayList<QuerySolutionInfo> solutions = new ArrayList<QuerySolutionInfo>();
        if (parentUIName != null) {
            EntityViewInfo viewInfo = null;
            viewInfo = this.getQuerySolutionViewInfo(ctx, parentUIName);
            QuerySolutionCollection solutionCol = QuerySolutionFactory.getLocalInstance((Context)ctx).getQuerySolutionCollection(viewInfo);
            for (int i = 0; i < solutionCol.size(); ++i) {
                solutions.add(solutionCol.get(i));
            }
        }
        return solutions;
    }

    @Override
    protected Map _getSolutionDetail(Context ctx, String solutionId) throws BOSException, EASBizException {
        HashMap<String, String> data = new HashMap<String, String>();
        if (solutionId != null && solutionId.length() > 0) {
            String customerParams = null;
            QuerySolutionInfo solutionInfo = null;
            IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            solutionInfo = iQuerySolution.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(solutionId));
            QueryPanelCollection queryPanels = solutionInfo.getQueryPanelInfo();
            int size = queryPanels.size();
            for (int i = 0; i < size; ++i) {
                QueryPanelInfo info = queryPanels.get(i);
                customerParams = info.getCustomerParams();
            }
            if (customerParams != null) {
                data.put("searchFilter", customerParams);
                data.put("solution", (String)solutionInfo);
            }
        }
        return data;
    }

    @Override
    protected String _saveSolution(Context ctx, String solutionName, String parentUIName, String filterJsonStr) throws BOSException, EASBizException {
        String solutionId = null;
        if (solutionName != null && parentUIName != null && filterJsonStr != null) {
            String viewId = null;
            QuerySolutionInfo solutionInfo = this.getSameNameSolution(ctx, solutionName, parentUIName);
            if (solutionInfo != null) {
                viewId = solutionInfo.getId().toString();
                solutionInfo = this.editSolution(ctx, viewId, parentUIName, solutionName, filterJsonStr);
            } else {
                solutionInfo = this.addSolution(ctx, parentUIName, solutionName, filterJsonStr);
                this.resetDefaultSolution(ctx, parentUIName);
            }
            solutionId = solutionInfo.getId().toString();
        }
        return solutionId;
    }

    @Override
    protected void _setDefaultSolution(Context ctx, String parentUIName, String solutionId) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = null;
        viewInfo = this.getQuerySolutionViewInfo(ctx, parentUIName);
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        QuerySolutionCollection solutionCol = iQuerySolution.getQuerySolutionCollection(viewInfo);
        if (null != solutionCol && solutionCol.size() != 0) {
            for (int i = 0; i < solutionCol.size(); ++i) {
                if (solutionCol.get(i).getId().toString().equals(solutionId)) {
                    solutionCol.get(i).setIsUserDefaultSolu(true);
                } else {
                    solutionCol.get(i).setIsUserDefaultSolu(false);
                }
                iQuerySolution.update((IObjectPK)new ObjectUuidPK(solutionCol.get(i).getId()), (CoreBaseInfo)solutionCol.get(i));
            }
        }
    }

    @Override
    protected void _removeSolution(Context ctx, String parentUIName, String solutionId) throws BOSException, EASBizException {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        iQuerySolution.delete((IObjectPK)new ObjectUuidPK(solutionId));
        this.resetDefaultSolution(ctx, parentUIName);
    }

    @Override
    protected void _unSetDefaultSolution(Context ctx, String parentUIName, String solutionId) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = null;
        viewInfo = this.getQuerySolutionViewInfo(ctx, parentUIName);
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        QuerySolutionCollection solutionCol = iQuerySolution.getQuerySolutionCollection(viewInfo);
        if (null != solutionCol && solutionCol.size() != 0) {
            for (int i = 0; i < solutionCol.size(); ++i) {
                if (!solutionCol.get(i).getId().toString().equals(solutionId) || !solutionCol.get(i).isIsUserDefaultSolu()) continue;
                solutionCol.get(i).setIsUserDefaultSolu(false);
                iQuerySolution.update((IObjectPK)new ObjectUuidPK(solutionCol.get(i).getId()), (CoreBaseInfo)solutionCol.get(i));
                break;
            }
        }
    }

    public QuerySolutionInfo getSameNameSolution(Context ctx, String solutionName, String parentUIName) throws EASBizException, BOSException {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        return iQuerySolution.getOwnerSolutionByName(null, this.getQueryPk(), parentUIName, this.getShareType(), solutionName);
    }

    @Override
    protected Map _getQrySolResMap(Context ctx) throws EASBizException, BOSException {
        return this.getResources(ctx, "com.kingdee.eas.tm.td.TDCommonQueryResource", new String[]{"236_SOLUTION_SAVE_OK", "237_SOLUTION_SET_OK", "238_SOLUTION_DELETE_OK", "257_DEFAULT_SOLUTION", "340_HAS_SAME_SOLUTION", "259_PROCESS_QRY", "260_SAVE_SOL", "261_INPUT_SOLNAME", "262_SELECTED_ITEMS", "263_MORE", "264_CLLAPSE", "265_DELETE_SOL", "266_SET_DEFAULT", "267_SETUP", "268_COM_SOL", "207_REQUIRE_COMPANY", "269_SOL_NAME", "270_COM_ITEMS", "271_SOL_QRY", "287_DEFAULT_SOL", "403_UNFLOD", "404_PACK_UP", "405_CANCEL_SET_DEFUALT"});
    }

    private Map<String, String> getResources(Context ctx, String resPath, String[] items) {
        ConcurrentHashMap<String, String> resItems = null;
        if (ctx != null && resPath != null && items != null && items.length > 0) {
            resItems = new ConcurrentHashMap<String, String>(items.length);
            for (String itemName : items) {
                resItems.put(itemName, EASCommonResource.getString((String)resPath, (String)itemName, (Locale)ctx.getLocale()));
            }
        }
        return resItems;
    }

    public BOSUuid getCurrentUserId(Context ctx) {
        return ContextUtil.getCurrentUserInfo((Context)ctx).getId();
    }

    public ShareTypeEnum getShareType() {
        return ShareTypeEnum.USER_NOORG_LEVEL;
    }

    public String getQueryPk() {
        return null;
    }

    public EntityViewInfo getQuerySolutionViewInfo(Context ctx, String parentUIName) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("queryObjectName", (Object)this.getQueryPk()));
        filter.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentUIName));
        filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)16));
        filter.getFilterItems().add(new FilterItemInfo("owner", (Object)this.getCurrentUserId(ctx).toString()));
        viewInfo.setFilter(filter);
        SorterItemCollection sortCol = new SorterItemCollection();
        sortCol.add(new SorterItemInfo("name"));
        viewInfo.setSorter(sortCol);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)this.getSelectorItemCollection());
        return viewInfo;
    }

    public QuerySolutionInfo editSolution(Context ctx, String solutionId, String parentUIName, String solutionName, String filterJsonStr) throws EASBizException, BOSException {
        QuerySolutionInfo solutionInfo = null;
        try {
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)solutionId));
            solutionInfo = iSolution.getQuerySolutionInfo((IObjectPK)pk);
            solutionInfo.setShareType(this.getShareType());
            QueryPanelCollection queryPanelCol = this.getQueryPanelCollection(filterJsonStr);
            solutionInfo.getQueryPanelInfo().clear();
            solutionInfo.getQueryPanelInfo().addCollection(queryPanelCol);
            solutionInfo.setRowCount(-1);
            iSolution.update((IObjectPK)pk, (CoreBaseInfo)solutionInfo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return solutionInfo;
    }

    public QuerySolutionInfo addSolution(Context ctx, String parentUIName, String solutionName, String filterJsonStr) throws EASBizException, BOSException {
        QuerySolutionInfo solutionInfo = null;
        try {
            solutionInfo = new QuerySolutionInfo();
            solutionInfo.setName(solutionName);
            solutionInfo.setQueryObjectName(this.getQueryPk());
            solutionInfo.setShareType(this.getShareType());
            solutionInfo.setSolutionType(SolutionTypeEnum.CUSTOMER_SOLUTION);
            solutionInfo.setParentUIName(parentUIName);
            solutionInfo.setIsUserDefaultSolu(false);
            solutionInfo.setOwner(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            QueryPanelCollection queryPanelCol = this.getQueryPanelCollection(filterJsonStr);
            solutionInfo.getQueryPanelInfo().addCollection(queryPanelCol);
            solutionInfo.setRowCount(-1);
            List list = this.getSolutionList(ctx, parentUIName);
            if (list == null || list.size() == 0) {
                solutionInfo.setIsUserDefaultSolu(true);
            } else {
                boolean hasDefault = false;
                for (Object o : list) {
                    QuerySolutionInfo sol = (QuerySolutionInfo)o;
                    if (!sol.isIsUserDefaultSolu()) continue;
                    hasDefault = true;
                    break;
                }
                if (!hasDefault) {
                    solutionInfo.setIsUserDefaultSolu(true);
                }
            }
            IObjectPK pk = QuerySolutionFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)solutionInfo);
            solutionInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return solutionInfo;
    }

    public void resetDefaultSolution(Context ctx, String parentUIName) throws BOSException, EASBizException {
        EntityViewInfo viewInfo;
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        QuerySolutionCollection solutionCol = iQuerySolution.getQuerySolutionCollection(viewInfo = this.getQuerySolutionViewInfo(ctx, parentUIName));
        if (solutionCol != null && solutionCol.size() > 0) {
            int size = solutionCol.size();
            for (int i = 0; i < size; ++i) {
                QuerySolutionInfo info = solutionCol.get(i);
                if (!info.isIsUserDefaultSolu()) continue;
                return;
            }
            QuerySolutionInfo querySolutionInfoOld = solutionCol.get(0);
            querySolutionInfoOld.setIsUserDefaultSolu(true);
            SelectorItemCollection updateSelector = new SelectorItemCollection();
            updateSelector.add(new SelectorItemInfo("isUserDefaultSolu"));
            iQuerySolution.updatePartial((CoreBaseInfo)querySolutionInfoOld, updateSelector);
        }
    }

    public SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.id"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.panelClassName"));
        return sic;
    }

    public QueryPanelCollection getQueryPanelCollection(String filterJsonStr) throws EASBizException, BOSException {
        QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
        FilterInfo filter = new FilterInfo();
        queryPanelInfo.setFilterInfo(filter.toString());
        queryPanelInfo.setQueryPanelType(QueryPanelTypeEnum.CUSTOMER_PANEL);
        queryPanelInfo.setCustomerParams(filterJsonStr);
        QueryPanelCollection queryPanelCol = new QueryPanelCollection();
        queryPanelCol.add(queryPanelInfo);
        return queryPanelCol;
    }
}

