/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.ProcessStatusEnum;
import com.kingdee.eas.tm.td.TaxAlertItemStatusEnum;
import com.kingdee.eas.tm.td.cloud.app.AbstractTaxCalendarFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TaxCalendarFacadeControllerBean
extends AbstractTaxCalendarFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.cloud.app.TaxCalendarFacadeControllerBean");

    @Override
    protected Map _getCalenderTotalData(Context ctx, Map params) throws BOSException, EASBizException {
        params.put("type", 1);
        return this.query(ctx, params);
    }

    @Override
    protected Map _getCalenderDetailData(Context ctx, Map params) throws BOSException, EASBizException {
        params.put("type", 2);
        return this.query(ctx, params);
    }

    protected Map query(Context ctx, Map params) throws EASBizException, BOSException {
        String tempTableName = (String)params.get("tempTableName");
        int type = Integer.parseInt(params.get("type").toString());
        if (tempTableName == null || "null".equals(tempTableName)) {
            tempTableName = this.createTempTable(ctx, params);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.getQuerySelectSQL(ctx, tempTableName, params));
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("tempTableName", tempTableName);
        ret.put("type", type);
        if (type == 1) {
            ret.put("calenderTotal", this.generateCalenderTotalData(rs));
        } else if (type == 2) {
            ret.put("calenderDetail", this.generateCalenderDetailData(rs));
        }
        this.queryAlarm(ctx, ret, params);
        return ret;
    }

    protected void queryAlarm(Context ctx, Map ret, Map params) throws EASBizException, BOSException {
        String tempTableName = (String)params.get("orgTempTableName");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.getQueryAlarmSelectSQL(ctx, tempTableName, params));
        int type = Integer.parseInt(params.get("type").toString());
        if (type == 1) {
            this.generateAlarmCalenderTotalData(rs, ret);
        } else if (type == 2) {
            ret.put("calenderAlarmDetail", this.generateCalenderAlarmDetailData(rs));
        }
    }

    private void generateAlarmCalenderTotalData(IRowSet rs, Map params) throws BOSException {
        Date FTaxDate = null;
        Object FReportDate = null;
        Object FAuditDate = null;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = null;
        Map ret = (Map)params.get("calenderTotal");
        try {
            while (rs.next()) {
                FTaxDate = rs.getDate("FBizDate");
                dateStr = sf.format(FTaxDate);
                this.setCalenderMap(ret, dateStr);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private List generateCalenderAlarmDetailData(IRowSet rs) throws BOSException {
        ArrayList ret = new ArrayList();
        HashMap<String, Object> data = null;
        try {
            while (rs.next()) {
                data = new HashMap<String, Object>();
                data.put("id", rs.getString("FID"));
                data.put("FCompanyID", rs.getString("FCompanyID"));
                data.put("FItemNumber", rs.getString("FItemNumber"));
                data.put("FItemName", rs.getString("FItemName"));
                data.put("FBizDate", rs.getDate("FBizDate"));
                data.put("FCompanyName", rs.getString("FCompanyName"));
                data.put("FValue", rs.getBigDecimal("FValue"));
                data.put("FMaxValue", rs.getBigDecimal("FMaxValue"));
                data.put("FMinValue", rs.getBigDecimal("FMinValue"));
                data.put("FSourceValue", rs.getBigDecimal("FSourceValue"));
                data.put("FState", TaxAlertItemStatusEnum.getEnum(rs.getString("FState")).getAlias());
                data.put("FProcessStatus", ProcessStatusEnum.getEnum(rs.getString("FProcessStatus")).getAlias());
                data.put("FQuotaNumber", rs.getString("FQuotaNumber"));
                ret.add(data);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private String getQueryAlarmSelectSQL(Context ctx, String tempTableName, Map params) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT alert.FID as FID,temp.FCompanyID as FCompanyID,");
        sql.append(" alert.fitemNumber as FItemNumber,alert.fitemName as FItemName,alert.fbizdate as FBizDate,");
        sql.append(" company.fname_").append(ctx.getLocale().toString()).append(" as FCompanyName,");
        sql.append(" alert.fvalue as FValue,alert.fmaxValue as FMaxValue,alert.FminValue as FMinValue,alert.FsourceValue as FSourceValue,");
        sql.append(" alert.fstatus as FState,alert.fprocessStatus as FProcessStatus,");
        sql.append(" quota.FNumber as FQuotaNumber ");
        sql.append(" FROM ").append(tempTableName).append(" temp ");
        sql.append(" inner join t_org_company company on company.fid = temp.fcompanyid");
        sql.append(" inner join T_TD_TaxAlertItem alert on alert.fcompanyorgunitid = company.fid");
        sql.append(" left join T_TD_TaxQuotaRecord quota on quota.fid = alert.FQuotaID");
        sql.append(" where 1=1 ");
        int type = Integer.parseInt(params.get("type").toString());
        if (type == 1) {
            int year = Integer.parseInt(params.get("year").toString());
            int month = Integer.parseInt(params.get("month").toString());
            String dateStart = year + "-" + (month < 10 ? "0" + month : Integer.valueOf(month)) + "-01";
            Calendar aCalendar = Calendar.getInstance();
            try {
                aCalendar.setTime(sf.parse(dateStart));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            int maxDay = aCalendar.getActualMaximum(5);
            String dateEnd = year + "-" + (month < 10 ? "0" + month : Integer.valueOf(month)) + "-" + maxDay;
            sql.append(" and (alert.fbizdate >= {ts'").append(dateStart).append("'} ").append(" and alert.fbizdate <= ADD_MONTHS({ts'").append(dateEnd).append("'}, 1))");
            sql.append(" and alert.FStatus = '1' and alert.FProcessStatus='2'");
        } else if (type == 2) {
            String dateStr = params.get("year").toString() + "-" + params.get("month").toString() + "-" + params.get("taxDate").toString();
            sql.append(" and TO_CHAR(alert.fbizdate, 'YYYY-MM-DD') ='").append(dateStr).append("' ");
            sql.append(" and alert.FStatus = '1' and alert.FProcessStatus='2'");
        }
        return sql.toString();
    }

    private List generateCalenderDetailData(IRowSet rs) throws BOSException {
        ArrayList ret = new ArrayList();
        HashMap<String, Object> data = null;
        try {
            while (rs.next()) {
                data = new HashMap<String, Object>();
                data.put("id", rs.getString("FID"));
                data.put("companyID", rs.getString("FCompanyID"));
                data.put("companyName", rs.getString("FCompanyName"));
                data.put("taxNotesID", rs.getString("FTaxNotesID"));
                data.put("taxNotesName", rs.getString("FTaxNotesName"));
                data.put("taxDate", rs.getDate("FTaxDate"));
                data.put("reportDate", rs.getDate("FReportDate"));
                data.put("auditDate", rs.getDate("FAuditDate"));
                data.put("provinceID", rs.getString("FProvinceID"));
                data.put("provinceName", rs.getString("FProvinceName"));
                data.put("reportDays", rs.getString("FReportDays"));
                data.put("auditDays", rs.getString("FAuditDays"));
                ret.add(data);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private Map generateCalenderTotalData(IRowSet rs) throws BOSException {
        HashMap ret = new HashMap();
        Date FTaxDate = null;
        Date FReportDate = null;
        Date FAuditDate = null;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = null;
        try {
            while (rs.next()) {
                FTaxDate = rs.getDate("FTaxDate");
                dateStr = sf.format(FTaxDate);
                this.setCalenderMap(ret, dateStr);
                FReportDate = rs.getDate("FReportDate");
                dateStr = sf.format(FReportDate);
                this.setCalenderMap(ret, dateStr);
                FAuditDate = rs.getDate("FAuditDate");
                dateStr = sf.format(FAuditDate);
                this.setCalenderMap(ret, dateStr);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private void setCalenderMap(Map ret, String dateStr) {
        HashMap<String, Integer> dateValue = (HashMap<String, Integer>)ret.get(dateStr);
        if (dateValue == null) {
            dateValue = new HashMap<String, Integer>();
            dateValue.put("count", 1);
            ret.put(dateStr, dateValue);
        } else {
            int count = Integer.parseInt(dateValue.get("count").toString());
            dateValue.put("count", count + 1);
            ret.put(dateStr, dateValue);
        }
    }

    private String getQuerySelectSQL(Context ctx, String tempTableName, Map params) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT temp.FID as FID,temp.FCompanyID as FCompanyID,FTaxNotesID,FTaxDate,FReportDate,FAuditDate,");
        sql.append(" company.fname_").append(ctx.getLocale().toString()).append(" as FCompanyName,");
        sql.append(" notes.FName_").append(ctx.getLocale().toString()).append(" as FTaxNotesName,FProvinceID, ");
        sql.append(" province.FName_").append(ctx.getLocale().toString()).append(" as FProvinceName,");
        sql.append(" FReportDays,FAuditDays");
        sql.append(" from ").append(tempTableName).append(" temp ");
        sql.append(" inner join t_org_company company on company.fid = temp.fcompanyid");
        sql.append(" inner join T_TD_TaxNotes notes on notes.fid = temp.FTaxNotesID");
        sql.append(" inner join T_BD_Province province on province.fid = temp.FProvinceID");
        sql.append(" where 1=1 ");
        int type = Integer.parseInt(params.get("type").toString());
        if (type == 1) {
            int year = Integer.parseInt(params.get("year").toString());
            int month = Integer.parseInt(params.get("month").toString());
            String dateStart = year + "-" + (month < 10 ? "0" + month : Integer.valueOf(month)) + "-01";
            Calendar aCalendar = Calendar.getInstance();
            try {
                aCalendar.setTime(sf.parse(dateStart));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            int maxDay = aCalendar.getActualMaximum(5);
            String dateEnd = year + "-" + (month < 10 ? "0" + month : Integer.valueOf(month)) + "-" + maxDay;
            sql.append(" and ((FTaxDate >= {ts'").append(dateStart).append("'} ").append(" and FTaxDate <= ADD_MONTHS({ts'").append(dateEnd).append("'}, 1))");
            sql.append(" OR (FReportDate >= {ts'").append(dateStart).append("'} ").append(" and FReportDate <= ADD_MONTHS({ts'").append(dateEnd).append("'}, 1))");
            sql.append(" OR (FAuditDate >= {ts'").append(dateStart).append("'}").append(" and FAuditDate <= ADD_MONTHS({ts'").append(dateEnd).append("'}, 1)))");
        } else if (type == 2) {
            String dateStr = params.get("year").toString() + "-" + params.get("month").toString() + "-" + params.get("taxDate").toString();
            sql.append(" and ( FTaxDate = {ts'").append(dateStr).append("'} ");
            sql.append(" OR FReportDate = {ts'").append(dateStr).append("'} ");
            sql.append(" OR FAuditDate = {ts'").append(dateStr).append("'}").append(" )");
        }
        return sql.toString();
    }

    protected String createTempTable(Context ctx, Map params) throws BOSException, EASBizException {
        String orgTempTableName = this.doCreateTempTable(ctx, this.getCreateOrgTable());
        this.insertOrgData(ctx, orgTempTableName, params);
        params.put("orgTempTableName", orgTempTableName);
        String tempTableName = this.doCreateTempTable(ctx, this.getCreateTempTable());
        this.insertData(ctx, tempTableName, orgTempTableName, params);
        this.updateData(ctx, tempTableName, params);
        return tempTableName;
    }

    private void insertOrgData(Context ctx, String orgTempTableName, Map params) throws BOSException {
        Set companyIds = (Set)params.get("companyID");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Iterator idIter = companyIds.iterator();
        Object[] values = null;
        while (idIter.hasNext()) {
            values = new Object[]{idIter.next()};
            paramsList.add(values);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(orgTempTableName).append(" ").append(" (FCompanyID) values ( ? )");
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
    }

    private void insertData(Context ctx, String tempTableName, String orgTempTableName, Map params) throws BOSException {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into ").append(tempTableName).append(" ").append(" (FID,FCompanyID,FTaxNotesID,FProvinceID,FTaxDate,FREPORTDAYS,FAUDITDAYS) ");
        String selectSQL = this.getSelectSQL(orgTempTableName, params);
        String sql = insertSQL + selectSQL;
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void updateData(Context ctx, String tempTableName, Map params) throws BOSException {
        DbUtil.execute((Context)ctx, (String)this.getUpdateDays(tempTableName));
        DbUtil.execute((Context)ctx, (String)this.getUpdateDays4Org(tempTableName));
        DbUtil.execute((Context)ctx, (String)this.getUpdateDateSQL(tempTableName));
    }

    private String getSelectSQL(String orgTempTableName, Map params) {
        StringBuffer selectSQL = new StringBuffer();
        selectSQL.append(" select newbosid('88888888') as FID,orgTemp.FCompanyID,taxtime.FTaxNotesID,taxtime.FProvinceID, ");
        selectSQL.append(" to_date(concat(concat(concat(to_char(taxtime.FYear),'-'),concat(to_char(taxtime.FMonth),'-')),to_char(taxtime.FTaxDate))) as FTaxDate,0,0");
        selectSQL.append(" FROM ").append(orgTempTableName).append(" orgTemp ");
        selectSQL.append(" inner join t_tm_taxbase taxbase on orgTemp.FCompanyID = taxbase.FCOMPANYID");
        selectSQL.append(" inner join T_TD_TaxTimeTable taxtime on taxtime.FPROVINCEID = taxbase.FREGISTPROVINCE");
        selectSQL.append(" inner join T_TD_TaxNotes taxnotes on taxtime.FTaxNotesID = taxnotes.fid");
        selectSQL.append(" where taxnotes.FState=1 and taxtime.FState=1 and taxbase.FSTATE=1");
        return selectSQL.toString();
    }

    private String getUpdateDays(String tempTableName) {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append(" update ").append(tempTableName).append(" as a ");
        updateSQL.append(" set (FReportDays,FAuditDays) =");
        updateSQL.append(" ( select taxlead.FREPORTDAYS,taxlead.FAUDITDAYS from ").append(tempTableName).append(" b ");
        updateSQL.append(" inner join t_td_taxleadtime taxlead on b.FTaxNotesID = taxlead.FTAXNOTESID");
        updateSQL.append(" where taxlead.FState=1 and taxlead.FCOMPANYID is null  ");
        updateSQL.append(" and a.fid =b.fid)");
        return updateSQL.toString();
    }

    private String getUpdateDays4Org(String tempTableName) {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append(" update ").append(tempTableName).append(" as a ");
        updateSQL.append(" set (FReportDays,FAuditDays) =");
        updateSQL.append(" ( select taxlead.FREPORTDAYS,taxlead.FAUDITDAYS from ").append(tempTableName).append(" b ");
        updateSQL.append(" inner join t_td_taxleadtime taxlead on b.FTaxNotesID = taxlead.FTAXNOTESID");
        updateSQL.append(" where taxlead.FState=1 and taxlead.FCOMPANYID =b.FCOMPANYID  ");
        updateSQL.append(" and a.fid =b.fid)");
        return updateSQL.toString();
    }

    private String getUpdateDateSQL(String tempTableName) {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append(" update ").append(tempTableName).append(" ");
        updateSQL.append(" set FReportDate=add_days(FTaxDate,FReportDays*-1),FAuditDate=add_days(FTaxDate,FAuditDays*-1) ");
        return updateSQL.toString();
    }

    private String doCreateTempTable(Context ctx, String createSql) throws BOSException, EASBizException {
        TempTablePool pool = TempTablePool.getInstanceForRead((Context)ctx);
        try {
            return pool.createTempTable(createSql);
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private String getCreateOrgTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempOrgTable(");
        sql.append("FCompanyID varchar(44)");
        sql.append(");");
        return sql.toString();
    }

    private String getCreateTempTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempReportTable(");
        sql.append("FID varchar(44),");
        sql.append("FCompanyID varchar(44),");
        sql.append("FTaxNotesID varchar(44),");
        sql.append("FProvinceID varchar(44),");
        sql.append("FTaxDate datetime,");
        sql.append("FReportDays int,");
        sql.append("FAuditDays int,");
        sql.append("FReportDate datetime,");
        sql.append("FAuditDate datetime");
        sql.append(");");
        return sql.toString();
    }
}

