/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxBaseCollection;
import com.kingdee.eas.tm.td.basedata.TaxBaseFactory;
import com.kingdee.eas.tm.td.basedata.TaxBaseInfo;
import com.kingdee.eas.tm.td.cloud.InspectBizStatusEnum;
import com.kingdee.eas.tm.td.cloud.InspectItemStatusEnum;
import com.kingdee.eas.tm.td.cloud.InspectStatusEnum;
import com.kingdee.eas.tm.td.cloud.ItemTypeEnum;
import com.kingdee.eas.tm.td.cloud.TDCloudException;
import com.kingdee.eas.tm.td.cloud.TaxInspectDetailCollection;
import com.kingdee.eas.tm.td.cloud.TaxInspectEntryCollection;
import com.kingdee.eas.tm.td.cloud.TaxInspectEntryInfo;
import com.kingdee.eas.tm.td.cloud.TaxInspectException;
import com.kingdee.eas.tm.td.cloud.TaxInspectFactory;
import com.kingdee.eas.tm.td.cloud.TaxInspectInfo;
import com.kingdee.eas.tm.td.cloud.app.AbstractTaxInspectControllerBean;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxInspectControllerBean
extends AbstractTaxInspectControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.app.TaxInspectControllerBean");

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxInspectInfo info = (TaxInspectInfo)model;
        this.checkBeforeSave(ctx, info);
        this.setBizStatus(info);
        super._save(ctx, pk, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, null, (CoreBillBaseInfo)model);
        TaxInspectInfo info = (TaxInspectInfo)model;
        this.setBizStatus(info);
        return super._save(ctx, model);
    }

    private void setBizStatus(TaxInspectInfo info) {
        TaxInspectEntryCollection entry = info.getEntries();
        TaxInspectDetailCollection inspectDetail = null;
        TaxInspectEntryInfo entryInfo = null;
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntries().get(i);
            inspectDetail = entryInfo.getDetail();
            if (InspectItemStatusEnum.CLOSE.equals((Object)entryInfo.getItemStatus()) || inspectDetail.size() <= 0) continue;
            entryInfo.setItemStatus(InspectItemStatusEnum.DOING);
        }
        if (entry.size() == 0) {
            info.setBizStatus(InspectBizStatusEnum.untreated);
        } else {
            HashSet<InspectItemStatusEnum> bizStatusSet = new HashSet<InspectItemStatusEnum>();
            int size2 = entry.size();
            for (int i = 0; i < size2; ++i) {
                entryInfo = entry.get(i);
                bizStatusSet.add(entryInfo.getItemStatus());
            }
            InspectBizStatusEnum bizStatus = null;
            bizStatus = bizStatusSet.contains((Object)InspectItemStatusEnum.DOING) ? InspectBizStatusEnum.loading : (bizStatusSet.contains((Object)InspectItemStatusEnum.UNDO) && bizStatusSet.contains((Object)InspectItemStatusEnum.CLOSE) ? InspectBizStatusEnum.loading : (bizStatusSet.contains((Object)InspectItemStatusEnum.UNDO) ? InspectBizStatusEnum.untreated : InspectBizStatusEnum.processed));
            info.setBizStatus(bizStatus);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TaxInspectInfo info = TaxInspectFactory.getLocalInstance(ctx).getTaxInspectInfo(pk);
        this.checkBeforeDelete(ctx, info);
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxInspectInfo info = (TaxInspectInfo)model;
        this.checkBeforeSubmit(ctx, info);
        info.setStatus(InspectStatusEnum.SUBMIT);
        this.setBizStatus(info);
        return super._submit(ctx, model);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxInspectInfo info = TaxInspectFactory.getLocalInstance(ctx).getTaxInspectInfo(pk);
        this.checkBeforeSubmit(ctx, info);
        info.setStatus(InspectStatusEnum.SUBMIT);
        this.setBizStatus(info);
        super._submit(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TaxInspectInfo info = TaxInspectFactory.getLocalInstance(ctx).getTaxInspectInfo(pk);
        this.checkBeforeAudit(ctx, info);
        info.setStatus(InspectStatusEnum.AUDIT);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAudittime(new Timestamp(new Date().getTime()));
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TaxInspectInfo info = TaxInspectFactory.getLocalInstance(ctx).getTaxInspectInfo(pk);
        this.checkBeforeUnAudit(ctx, info);
        info.setStatus(InspectStatusEnum.SAVE);
        info.setAuditor(null);
        info.setAudittime(null);
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _close(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    private void checkBeforeDelete(Context ctx, TaxInspectInfo info) throws BOSException, EASBizException {
        if (!InspectStatusEnum.SUBMIT.equals((Object)info.getStatus()) && !InspectStatusEnum.SAVE.equals((Object)info.getStatus())) {
            throw new TDCloudException(TDCloudException.DELETE_STATUS_ERROR);
        }
    }

    private void checkBeforeSave(Context ctx, TaxInspectInfo info) throws BOSException, EASBizException {
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)coreBillBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{coreBillBaseInfo.getString("number"), ""});
        }
        return true;
    }

    private void checkBeforeSubmit(Context ctx, TaxInspectInfo info) throws BOSException, EASBizException {
        if (!InspectStatusEnum.SUBMIT.equals((Object)info.getStatus()) && !InspectStatusEnum.SAVE.equals((Object)info.getStatus())) {
            throw new TDCloudException(TDCloudException.SUBMIT_STATUS_ERROR);
        }
    }

    private void checkBeforeAudit(Context ctx, TaxInspectInfo info) throws BOSException, EASBizException {
        if (!InspectStatusEnum.SUBMIT.equals((Object)info.getStatus())) {
            throw new TDCloudException(TDCloudException.AUDIT_STATUS_ERROR);
        }
    }

    private void checkBeforeUnAudit(Context ctx, TaxInspectInfo info) throws BOSException, EASBizException {
        if (!InspectStatusEnum.AUDIT.equals((Object)info.getStatus())) {
            throw new TDCloudException(TDCloudException.UNAUDIT_STATUS_ERROR);
        }
        if (InspectBizStatusEnum.processed.equals((Object)info.getBizStatus())) {
            throw new TaxInspectException(TaxInspectException.COMPLETENOAUDIT);
        }
    }

    private void checkBeforeClose(Context ctx, TaxInspectInfo info) throws BOSException, EASBizException {
    }

    @Override
    protected void _unClose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    private void checkBeforeUnClose(Context ctx, TaxInspectInfo info) throws BOSException, EASBizException {
    }

    @Override
    protected Map _getbizStatusNumber(Context ctx, Map params) throws BOSException, EASBizException {
        int bizStatus = params.get("bizStatus") != null ? (Integer)params.get("bizStatus") : 2;
        String periodFrom = (String)params.get("periodFrom");
        String periodTo = (String)params.get("periodTo");
        periodFrom = periodFrom.replace("-", "");
        periodTo = periodTo.replace("-", "");
        HashMap result = new HashMap();
        HashSet<Map<String, Integer>> res = new HashSet<Map<String, Integer>>();
        Map<String, Integer> item = new HashMap<String, String>();
        List itemTypes = ItemTypeEnum.getEnumList();
        String sql = "select FitemType,count(1) as count from T_TD_TaxInspect as t";
        sql = sql + " left join t_bd_period as period on t.FINSPECTORPERIODID = period.fid";
        OrgUnitCollection companys = TDUtils.getAuthOrgByPermItem(ctx, OrgType.Company, "td_taxinspect_view");
        HashSet<String> companyids = new HashSet<String>();
        for (int i = 0; i < companys.size(); ++i) {
            companyids.add(companys.get(i).getId().toString());
        }
        HashSet companyOrgids = new HashSet();
        HashSet curCompanyId = new HashSet();
        if (params.get("curCompanyId") != null) {
            curCompanyId.add(params.get("curCompanyId"));
            TDUtils.getCompanyOrgUnitIds(ctx, curCompanyId, companyOrgids);
        }
        if (companyids.size() > 0) {
            companyids.retainAll(companyOrgids);
        }
        companyids.add("");
        sql = sql + " where FCompanyID in (" + CollectionUtil.convertSet2String(companyids, ",", true) + ")";
        if (params.get("bizStatus") != null) {
            if (0 == bizStatus) {
                sql = sql + " and FBizStatus in ('0','1') ";
            } else if (1 == bizStatus) {
                sql = sql + " and FBizStatus = '" + 2 + "'";
            }
        }
        sql = sql + " group by FitemType";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int count = 0;
        HashMap<String, Map<String, Integer>> itemMap = new HashMap<String, Map<String, Integer>>();
        for (int i = 0; i < itemTypes.size(); ++i) {
            item = new HashMap();
            item.put("itemName", (Integer)((Object)((ItemTypeEnum)((Object)itemTypes.get(i))).getAlias()));
            item.put("itemValue", (Integer)((Object)((ItemTypeEnum)((Object)itemTypes.get(i))).getValue()));
            item.put("count", count);
            itemMap.put(((ItemTypeEnum)((Object)itemTypes.get(i))).getValue(), item);
            res.add(item);
        }
        try {
            while (rs.next()) {
                String itemType = rs.getString("FitemType");
                count = rs.getInt("count");
                item = (Map)itemMap.get(itemType);
                item.put("count", count);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        result.put("data", res);
        return result;
    }

    @Override
    protected Map _getCompanyParam(Context ctx, String companyID) throws BOSException, EASBizException {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        TaxBaseCollection taxBaseColl = TaxBaseFactory.getRemoteInstance().getTaxBaseCollection(view);
        TaxBaseInfo taxBaseInfo = null;
        if (taxBaseColl.size() > 0) {
            taxBaseInfo = taxBaseColl.get(0);
        }
        ret.put("taxBaseInfo", taxBaseInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountPeriodType.*"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
        ret.put("company", (Serializable)company);
        boolean isModifyOnlyDuty = TDUtils.getBooleanParam(ctx, companyID, "VATD005");
        ret.put("isModifyOnlyDuty", Boolean.valueOf(isModifyOnlyDuty));
        return ret;
    }

    @Override
    protected Map _getInitData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, UserInfo> ret = new HashMap<String, UserInfo>();
        ret.put("user", ContextUtil.getCurrentUserInfo((Context)ctx));
        return ret;
    }

    @Override
    protected IObjectValue _createNewData(Context ctx) throws BOSException, EASBizException {
        TaxInspectInfo info = new TaxInspectInfo();
        info.setId(BOSUuid.create((String)"FB6B3A1D"));
        return info;
    }
}

