/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.cloud.QuotaStatusEnum;
import com.kingdee.eas.tm.td.cloud.TDCloudException;
import com.kingdee.eas.tm.td.cloud.TaxQuotaFactory;
import com.kingdee.eas.tm.td.cloud.TaxQuotaInfo;
import com.kingdee.eas.tm.td.cloud.app.AbstractTaxQuotaControllerBean;
import org.apache.log4j.Logger;

public class TaxQuotaControllerBean
extends AbstractTaxQuotaControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.app.TaxQuotaControllerBean");

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TaxQuotaInfo info = TaxQuotaFactory.getLocalInstance(ctx).getTaxQuotaInfo(pk);
        this.checkBeforeDelete(ctx, info);
        super._delete(ctx, pk);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxQuotaInfo info = TaxQuotaFactory.getLocalInstance(ctx).getTaxQuotaInfo(pk);
        this.checkBeforeCancel(ctx, info);
        info.setStatus(QuotaStatusEnum.DisEnable);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxQuotaInfo info = TaxQuotaFactory.getLocalInstance(ctx).getTaxQuotaInfo(pk);
        this.checkBeforeCancelCancel(ctx, info);
        info.setStatus(QuotaStatusEnum.Enable);
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void checkBeforeDelete(Context ctx, TaxQuotaInfo info) throws BOSException, EASBizException {
        if (QuotaStatusEnum.Enable.equals((Object)info.getStatus())) {
            throw new TDCloudException(TDCloudException.DELETE_STATUS_ERROR1);
        }
    }

    private void checkBeforeCancel(Context ctx, TaxQuotaInfo info) throws BOSException, EASBizException {
        if (!QuotaStatusEnum.Enable.equals((Object)info.getStatus())) {
            throw new TDCloudException(TDCloudException.CANCEL_STATUS_ERROR);
        }
    }

    private void checkBeforeCancelCancel(Context ctx, TaxQuotaInfo info) throws BOSException, EASBizException {
        if (QuotaStatusEnum.Enable.equals((Object)info.getStatus())) {
            throw new TDCloudException(TDCloudException.CANCELCANCEL_STATUS_ERROR);
        }
    }
}

