/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.tm.td.cloud.GroupInfo;
import com.kingdee.eas.tm.td.cloud.UserGroupInfo;
import com.kingdee.eas.tm.td.cloud.app.AbstractUserGroupControllerBean;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserGroupControllerBean
extends AbstractUserGroupControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.app.UserGroupControllerBean");

    @Override
    protected List _getUserIDList(Context ctx, Set groupIds) throws BOSException, EASBizException {
        List userIDList = new ArrayList();
        userIDList = groupIds.size() > 1000 ? this.getBatchAssignUserIDList(ctx, groupIds) : this.getAssignUserIDList(ctx, groupIds);
        return userIDList;
    }

    private List getAssignUserIDList(Context ctx, Set groupIds) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        String fieldName = "FUserID";
        StringBuffer exeSql = new StringBuffer();
        exeSql.append(" select ").append(fieldName).append(" from T_TD_UserGroup");
        exeSql.append(" where  FGroupID in ( ").append(CollectionUtil.convertSet2String(groupIds, ",", true)).append(") ");
        exeSql.append(" group by ").append(fieldName).append(" having count(").append(fieldName).append(")=").append(groupIds.size());
        exeSql.append(" order by ").append(fieldName);
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)exeSql.toString());
            while (row.next()) {
                idList.add(row.getString(1));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return idList;
    }

    private List getBatchAssignUserIDList(Context ctx, Set groupIds) throws BOSException {
        ArrayList<String> userIdList = new ArrayList<String>();
        ITableManagerFacade instance = null;
        Connection cn = null;
        PreparedStatement stmt = null;
        String tbl = null;
        try {
            instance = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
            tbl = instance.getTableName("USERGROUP");
            StringBuffer createSql = new StringBuffer();
            createSql.append("create table ");
            createSql.append(tbl);
            createSql.append(" (fid varchar(44)");
            createSql.append(")");
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createSql.toString());
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.prepareStatement("insert into " + tbl + " values(?)");
            for (Object companyId : groupIds) {
                stmt.setString(1, companyId.toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
            String fieldName = "FUserID";
            StringBuffer exeSql = new StringBuffer();
            exeSql.append(" select ").append(fieldName).append(" from T_TD_UserGroup");
            exeSql.append(" where  FGroupID in (select fid from ").append(tbl).append(") ");
            exeSql.append(" group by ").append(fieldName).append(" having count(").append(fieldName).append(")=").append(groupIds.size());
            exeSql.append(" order by ").append(fieldName);
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)exeSql.toString());
            while (row.next()) {
                userIdList.add(row.getString(1));
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                instance.releaseTableName(tbl);
                SQLUtils.cleanup(stmt, cn);
                throw throwable;
            }
        }
        instance.releaseTableName(tbl);
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return userIdList;
    }

    @Override
    protected List _assignUser(Context ctx, IObjectCollection groupCols, IObjectCollection userCols, boolean isAssign) throws BOSException, EASBizException {
        if (isAssign) {
            this.assign(ctx, groupCols, userCols);
        } else {
            this.cancelAssign(ctx, groupCols, userCols);
        }
        ArrayList errorList = new ArrayList();
        return errorList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAssign(Context ctx, IObjectCollection groupCols, IObjectCollection userCols) throws BOSException {
        int i;
        GroupInfo group = null;
        IObjectValue user = null;
        ArrayList<String> groupIdList = new ArrayList<String>();
        ArrayList<String> userIdList = new ArrayList<String>();
        int size = groupCols.size();
        for (i = 0; i < size; ++i) {
            group = (GroupInfo)groupCols.getObject(i);
            groupIdList.add(group.get("id").toString());
        }
        size = userCols.size();
        for (i = 0; i < size; ++i) {
            user = userCols.getObject(i);
            userIdList.add(user.get("id").toString());
        }
        String groupTbl = null;
        String groupIDStr = null;
        String userTbl = null;
        String userIDStr = null;
        if (groupIdList.size() > 1000) {
            groupTbl = this.getIdTempTable(ctx, "USERGROUP", groupIdList);
            groupIDStr = "select fid from " + groupTbl;
        } else {
            groupIDStr = CollectionUtil.convertList2String(groupIdList);
        }
        if (userIdList.size() > 1000) {
            userTbl = this.getIdTempTable(ctx, "USERGROUP", userIdList);
            userIDStr = "select fid from " + userTbl;
        } else {
            userIDStr = CollectionUtil.convertList2String(userIdList);
        }
        try {
            StringBuffer deleteSQL = new StringBuffer();
            deleteSQL.append(" delete from T_TD_UserGroup ");
            deleteSQL.append(" where FGroupID  in (").append(groupIDStr).append(")");
            deleteSQL.append(" and FUserID in (").append(userIDStr).append(")");
            DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
        }
        finally {
            this.releaseTempTable(ctx, groupTbl);
            this.releaseTempTable(ctx, userTbl);
        }
    }

    private void assign(Context ctx, IObjectCollection groupCols, IObjectCollection userCols) throws BOSException {
        GroupInfo group = null;
        IObjectValue user = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            this.clearIsDefaultFlag(ctx, groupCols, userCols);
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("INSERT INTO T_TD_UserGroup(FID,FGroupID,FUserID,FIsDefault) values(?,?,?,?)");
            int size = groupCols.size();
            for (int i = 0; i < size; ++i) {
                group = (GroupInfo)groupCols.getObject(i);
                int checkSize = userCols.size();
                for (int j = 0; j < checkSize; ++j) {
                    user = userCols.getObject(j);
                    String sql = "Select 1 from T_TD_UserGroup where FGroupID='" + group.get("id").toString() + "' and FUserID='" + user.get("id").toString() + "'";
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    if (rs.next()) {
                        if (!group.getBoolean("isDefault")) continue;
                        StringBuffer sb = new StringBuffer();
                        sb.append(" update T_TD_UserGroup  set FIsDefault = 1");
                        sb.append(" where FGroupID='" + group.get("id").toString() + "' and FUserID='" + user.get("id").toString() + "'");
                        DbUtil.execute((Context)ctx, (String)sb.toString());
                        continue;
                    }
                    pstmt.setString(1, BOSUuid.create((String)"9EC8B5EA").toString());
                    pstmt.setString(2, group.get("id").toString());
                    pstmt.setString(3, user.get("id").toString());
                    pstmt.setInt(4, group.getBoolean("isDefault") ? 1 : 0);
                    pstmt.addBatch();
                }
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearIsDefaultFlag(Context ctx, IObjectCollection groupCols, IObjectCollection userCols) throws BOSException {
        boolean hasDefault = false;
        int size = groupCols.size();
        for (int i = 0; i < size; ++i) {
            GroupInfo group = (GroupInfo)groupCols.getObject(i);
            if (!group.getBoolean("isDefault")) continue;
            hasDefault = true;
            break;
        }
        if (!hasDefault) {
            return;
        }
        String userTbl = null;
        String userIDStr = null;
        ArrayList<String> userIdList = new ArrayList<String>();
        int size2 = userCols.size();
        for (int i = 0; i < size2; ++i) {
            IObjectValue user = userCols.getObject(i);
            userIdList.add(user.get("id").toString());
        }
        if (userIdList.size() > 1000) {
            userTbl = this.getIdTempTable(ctx, "USERGROUP", userIdList);
            userIDStr = "select fid from " + userTbl;
        } else {
            userIDStr = CollectionUtil.convertList2String(userIdList);
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" update T_TD_UserGroup  set FIsDefault = 0");
            sql.append(" where FUserID in (").append(userIDStr).append(")");
            sql.append(" and FIsDefault = 1");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        finally {
            this.releaseTempTable(ctx, userTbl);
        }
    }

    @Override
    protected void _setDefaultGroup(Context ctx, String billID) throws BOSException, EASBizException {
        UserGroupInfo userGroupInfo = (UserGroupInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(billID));
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_TD_UserGroup  set FIsDefault = 0");
        sql.append(" where FUserID ='").append(userGroupInfo.getUser().getId().toString()).append("'");
        sql.append(" and FIsDefault = 1");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update T_TD_UserGroup  set FIsDefault = 1");
        sql.append(" where FID ='").append(billID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getIdTempTable(Context ctx, String tableName, List idList) throws BOSException {
        Connection cn = null;
        PreparedStatement stmt = null;
        String tbl = null;
        try {
            tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName(tableName);
            StringBuffer createSql = new StringBuffer();
            createSql.append(" create table ");
            createSql.append(tbl);
            createSql.append(" (fid varchar(44)");
            createSql.append(")");
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createSql.toString());
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.prepareStatement("insert into " + tbl + " values(?)");
            for (Object id : idList) {
                stmt.setString(1, id.toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return tbl;
    }

    private void releaseTempTable(Context ctx, String tableName) throws BOSException {
        if (tableName != null) {
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTableName(tableName);
        }
    }
}

