/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.service.FunctionPermissionService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.common.TMCustomizedWEBMenuCollection;
import com.kingdee.eas.tm.td.cloud.common.TMCustomizedWEBMenuFactory;
import com.kingdee.eas.tm.td.cloud.common.TMWEBMenuCollection;
import com.kingdee.eas.tm.td.cloud.common.TMWEBMenuFactory;
import com.kingdee.eas.tm.td.cloud.common.TMWEBMenuInfo;
import com.kingdee.eas.tm.td.cloud.common.app.AbstractTMWEBMenuControllerBean;
import com.kingdee.eas.tm.td.cloud.utils.TMBaseSelectorFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TMWEBMenuControllerBean
extends AbstractTMWEBMenuControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.base.app.TMWEBMenuControllerBean");

    @Override
    protected IObjectCollection _buildPermissionMenu(Context ctx, String typeStr) throws BOSException, EASBizException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        TMWEBMenuCollection customizedMenus = this.getCustomizedMenu(ctx, user, typeStr);
        HashSet<BOSUuid> exculdeMenuId = new HashSet<BOSUuid>();
        int size = customizedMenus.size();
        for (int i = 0; i < size; ++i) {
            exculdeMenuId.add(customizedMenus.get(i).getId());
        }
        TMWEBMenuCollection sysMenus = this.getSysMenu(ctx, exculdeMenuId, typeStr);
        TMWEBMenuCollection willCheckMenus = this.mergeSysAndCustomizedMenus(sysMenus, customizedMenus);
        TMWEBMenuCollection menus = this.checkMenuPermission(ctx, willCheckMenus);
        HashSet<BOSUuid> hasPermissMenuParentIds = new HashSet<BOSUuid>();
        if (menus.size() > 0) {
            TMWEBMenuInfo menuInfo;
            int i;
            int size2 = menus.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                BOSUuid parentId;
                TMWEBMenuInfo menuInfo2 = menus.get(i2).getParent();
                if (menuInfo2 == null || !menuInfo2.isIsLeaf() || hasPermissMenuParentIds.contains(parentId = menuInfo2.getId())) continue;
                hasPermissMenuParentIds.add(parentId);
            }
            TMWEBMenuCollection tempMenu = (TMWEBMenuCollection)((Object)menus.clone());
            int size3 = tempMenu.size();
            for (i = 0; i < size3; ++i) {
                menuInfo = menus.get(i);
                if (menuInfo.isIsLeaf()) continue;
                tempMenu.remove(menuInfo);
            }
            if (!this.equalsMenus(tempMenu, customizedMenus)) {
                TMCustomizedWEBMenuFactory.getLocalInstance(ctx).batchSaveForCurrentUser(tempMenu);
            }
            size3 = menus.size();
            for (i = 0; i < size3; ++i) {
                menuInfo = menus.get(i);
                if (this.hasParentPermission(menuInfo, hasPermissMenuParentIds)) continue;
                menus.removeObject((IObjectValue)menuInfo);
            }
            this.filterSysMenuWithoutChildMenu(menus, typeStr, user);
            menus.sort("orderNumber");
        }
        return menus;
    }

    private void filterSysMenuWithoutChildMenu(TMWEBMenuCollection menus, String menuType, UserInfo user) {
    }

    private boolean hasParentPermission(TMWEBMenuInfo menuInfo, Set hasPermissMenuParentIds) {
        return null == menuInfo || hasPermissMenuParentIds.size() <= 0 || hasPermissMenuParentIds.contains(menuInfo.getParent().getId());
    }

    private boolean equalsMenus(TMWEBMenuCollection menus, TMWEBMenuCollection customizedMenus) {
        if (menus.size() != customizedMenus.size()) {
            return false;
        }
        int size = menus.size();
        for (int i = 0; i < size; ++i) {
            if (menus.get(i).getId().equals((Object)customizedMenus.get(i).getId())) continue;
            return false;
        }
        return true;
    }

    private TMWEBMenuCollection checkMenuPermission(Context ctx, TMWEBMenuCollection willCheckMenus) throws EASBizException, BOSException {
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
        HashMap<Integer, String> permItemNames = new HashMap<Integer, String>();
        Map retPermItemMap = new HashMap();
        int size = willCheckMenus.size();
        for (int i = 0; i < size; ++i) {
            if (StringUtils.isEmpty((String)willCheckMenus.get(i).getPermissionID())) continue;
            permItemNames.put(new Integer(i), willCheckMenus.get(i).getPermissionID());
        }
        if (permItemNames.size() > 0) {
            FunctionPermissionService service = new FunctionPermissionService(ctx);
            retPermItemMap = service.hasBatchPermission((IObjectPK)userPK, (IObjectPK)orgPK, permItemNames, true);
        }
        TMWEBMenuCollection menus = new TMWEBMenuCollection();
        int size2 = willCheckMenus.size();
        for (int i = 0; i < size2; ++i) {
            Boolean permValue;
            if (!StringUtils.isEmpty((String)willCheckMenus.get(i).getPermissionID()) && ((permValue = (Boolean)retPermItemMap.get(new Integer(i))) == null || !permValue.booleanValue())) continue;
            menus.add(willCheckMenus.get(i));
        }
        return menus;
    }

    private TMWEBMenuCollection mergeSysAndCustomizedMenus(TMWEBMenuCollection sysMenus, TMWEBMenuCollection customizedMenus) {
        TMWEBMenuCollection menus = new TMWEBMenuCollection();
        menus.addCollection(customizedMenus);
        menus.addCollection(sysMenus);
        return menus;
    }

    private TMWEBMenuCollection getCustomizedMenu(Context ctx, UserInfo user, String typeStr) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)user.getId()));
        filter.getFilterItems().add(new FilterItemInfo("webMenu.typeStr", (Object)("%" + typeStr + "%"), CompareType.LIKE));
        view.setFilter(filter);
        view.setSelector(TMBaseSelectorFactory.getCustomizedMenuSelectors());
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("seqNumber"));
        view.setSorter(sorter);
        TMCustomizedWEBMenuCollection customizedMenus = TMCustomizedWEBMenuFactory.getLocalInstance(ctx).getTMCustomizedWEBMenuCollection(view);
        TMWEBMenuCollection menus = new TMWEBMenuCollection();
        int size = customizedMenus.size();
        for (int i = 0; i < size; ++i) {
            menus.add(customizedMenus.get(i).getWebMenu());
        }
        return menus;
    }

    private TMWEBMenuCollection getSysMenu(Context ctx, Set exculdeMenuId, String typeStr) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!exculdeMenuId.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)exculdeMenuId, CompareType.NOTINCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("typeStr", (Object)("%" + typeStr + "%"), CompareType.LIKE));
        view.setFilter(filter);
        view.setSelector(TMBaseSelectorFactory.getSysMenuSelectors());
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("orderNumber"));
        view.setSorter(sorter);
        return this.getTMWEBMenuCollection(ctx, view);
    }

    @Override
    protected Map _getDepMenuParams(Context ctx, Map params) throws BOSException, EASBizException {
        String menuid = (String)params.get("menuid");
        TMWEBMenuInfo menuInfo = TMWEBMenuFactory.getLocalInstance(ctx).getTMWEBMenuInfo((IObjectPK)new ObjectUuidPK(menuid));
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String uName = userInfo.getNumber();
        String uCard = String.valueOf(new Date().getTime());
        String uType = menuInfo.getDepField2();
        String sign = TDUtils.StringToMD5(uName + menuInfo.getDepField1() + uCard);
        String authurl = "uName=" + uName + "&uCard=" + uCard + "&uType=" + uType + "&sign=" + sign;
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("authurl", authurl);
        return ret;
    }

    private String getSign(String uName, String uCard, TMWEBMenuInfo menuInfo) {
        String sign = TDUtils.StringToMD5(uName + menuInfo.getDepField1() + uCard);
        return sign;
    }
}

