/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.TDCloudException;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckBaseInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckIndexInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckViewFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.ICheckBase;
import com.kingdee.eas.tm.td.cloud.datamodel.app.AbstractCheckBaseControllerBean;
import org.apache.log4j.Logger;

public abstract class CheckBaseControllerBean
extends AbstractCheckBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.datamodel.app.CheckBaseControllerBean");

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CheckBaseInfo info = this.getBizInterface(ctx).getCheckBaseInfo(pk);
        this.checkBeforeDelete(ctx, info);
        super._delete(ctx, pk);
        FilterInfo filter = new FilterInfo();
        if (info instanceof CheckItemInfo) {
            filter.getFilterItems().add(new FilterItemInfo("item.id", (Object)pk.toString(), CompareType.EQUALS));
        } else if (info instanceof CheckIndexInfo) {
            filter.getFilterItems().add(new FilterItemInfo("index.id", (Object)pk.toString(), CompareType.EQUALS));
        }
        CheckViewFactory.getLocalInstance(ctx).delete(filter);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CheckBaseInfo info = this.getBizInterface(ctx).getCheckBaseInfo(pk);
        this.checkBeforeCancel(ctx, info);
        info.setState(EnableStateEnum.DISABLE);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CheckBaseInfo info = this.getBizInterface(ctx).getCheckBaseInfo(pk);
        this.checkBeforeCancelCancel(ctx, info);
        info.setState(EnableStateEnum.ENABLE);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected abstract ICheckBase getBizInterface(Context var1) throws BOSException, EASBizException;

    private void checkBeforeDelete(Context ctx, CheckBaseInfo info) throws BOSException, EASBizException {
        if (EnableStateEnum.ENABLE.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.DELETE_STATUS_ERROR1);
        }
    }

    private void checkBeforeCancel(Context ctx, CheckBaseInfo info) throws BOSException, EASBizException {
        if (!EnableStateEnum.ENABLE.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.CANCEL_STATUS_ERROR);
        }
    }

    private void checkBeforeCancelCancel(Context ctx, CheckBaseInfo info) throws BOSException, EASBizException {
        if (EnableStateEnum.ENABLE.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.CANCELCANCEL_STATUS_ERROR);
        }
    }
}

