/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemStateEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemTypeCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemTypeFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemTypeInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.app.AbstractCheckItemTypeControllerBean;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class CheckItemTypeControllerBean
extends AbstractCheckItemTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.datamodel.app.CheckItemTypeControllerBean");

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkBeforeDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    private void checkBeforeDelete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        CheckItemTypeInfo info = this.getCheckItemTypeInfo(ctx, pk);
        if (info.getState().equals((Object)CheckItemStateEnum.ENABLE)) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"EnableNotAllowRemove")});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkBeforeSubmit(ctx, model);
        return super._submit(ctx, model);
    }

    private void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException, TDException {
        CheckItemTypeInfo info = (CheckItemTypeInfo)model;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        }
        view.setFilter(filter);
        CheckItemTypeCollection coll = CheckItemTypeFactory.getLocalInstance(ctx).getCheckItemTypeCollection(view);
        if (coll != null && coll.size() > 0) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Number_Not_Repeat", (Object[])new String[]{info.getNumber()})});
        }
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isEmpty((String)info.getName())) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.td.TDCommonResource", (String)"Name")).append(",");
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.td.TDCommonResource", (String)"Number")).append(",");
        }
        if (sb.length() > 0) {
            String msg = sb.substring(0, sb.length() - 1);
            throw new TDException(TDException.ERROR_MSG, new Object[]{msg + EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"NOTNULL")});
        }
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CheckItemTypeInfo info = (CheckItemTypeInfo)model;
        if (CheckItemStateEnum.DISABLE.equals((Object)info.getState())) {
            throw new TDException(TDException.DISABLEAREADY);
        }
        info.setState(CheckItemStateEnum.DISABLE);
        super._cancel(ctx, pk, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CheckItemTypeInfo info = (CheckItemTypeInfo)model;
        if (CheckItemStateEnum.ENABLE.equals((Object)info.getState())) {
            throw new TDException(TDException.ENABLEALREADY);
        }
        info.setState(CheckItemStateEnum.ENABLE);
        super._cancelCancel(ctx, pk, model);
    }
}

