/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckAccountResultFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckResultFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckResultStateEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.app.AbstractCheckResultControllerBean;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckResultControllerBean
extends AbstractCheckResultControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.datamodel.app.CheckResultControllerBean");

    @Override
    protected Map _updateCheckResult(Context ctx, Map params) throws BOSException, EASBizException {
        int i;
        ObjectBaseInfo info;
        AbstractObjectCollection col;
        SelectorItemCollection sic;
        HashMap result = new HashMap();
        ArrayList ids = (ArrayList)params.get("ids");
        ArrayList<String> needUpdateIds = new ArrayList<String>();
        ArrayList<String> errMsgs = new ArrayList<String>();
        CheckTypeEnum checkType = (CheckTypeEnum)((Object)params.get("checkType"));
        HashSet setIds = new HashSet(ids);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", setIds, CompareType.INCLUDE));
        view.setFilter(filter);
        if (CheckTypeEnum.TAXACCOUNT.equals((Object)checkType)) {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("account.id"));
            sic.add(new SelectorItemInfo("account.number"));
            sic.add(new SelectorItemInfo("account.name"));
            sic.add(new SelectorItemInfo("checkAcct.id"));
            sic.add(new SelectorItemInfo("checkAcct.number"));
            sic.add(new SelectorItemInfo("checkAcct.name"));
            view.setSelector(sic);
            col = CheckAccountResultFactory.getLocalInstance(ctx).getCheckAccountResultCollection(view);
            info = null;
            for (i = 0; i < col.size(); ++i) {
                info = col.get(i);
                if (CheckResultStateEnum.PASS.equals((Object)info.getState())) {
                    errMsgs.add(ResourceBase.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"CHECKACCOUNTRESULT_AUDIT_ERROR", (Locale)ctx.getOriginLocale(), (Object[])new String[]{info.getAccount().getNumber(), info.getCheckAcct().getNumber(), info.getSheetName()}));
                    continue;
                }
                needUpdateIds.add(info.getId().toString());
            }
        } else {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("report.id"));
            sic.add(new SelectorItemInfo("report.number"));
            sic.add(new SelectorItemInfo("report.name"));
            sic.add(new SelectorItemInfo("item.id"));
            sic.add(new SelectorItemInfo("item.number"));
            sic.add(new SelectorItemInfo("item.name"));
            view.setSelector(sic);
            col = CheckResultFactory.getLocalInstance(ctx).getCheckResultCollection(view);
            info = null;
            for (i = 0; i < col.size(); ++i) {
                info = col.get(i);
                if (CheckResultStateEnum.PASS.equals((Object)info.getState())) {
                    errMsgs.add(ResourceBase.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"ITEMCHECKRESULT_AUDIT_ERROR", (Locale)ctx.getOriginLocale(), (Object[])new String[]{info.getReport().getNumber(), info.getItem().getNumber()}));
                    continue;
                }
                needUpdateIds.add(info.getId().toString());
            }
        }
        result.put("errMsgs", errMsgs);
        if (needUpdateIds.size() == 0) {
            return result;
        }
        CheckResultStateEnum state = (CheckResultStateEnum)((Object)params.get("state"));
        String prompt = (String)params.get("prompt");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        StringBuffer updateSQL = new StringBuffer();
        if (CheckTypeEnum.TAXACCOUNT.equals((Object)checkType)) {
            updateSQL.append(" update T_TD_CheckAccountResult ");
            updateSQL.append(" set FState = ? , FHandlerPrompt = ? , FHandlerID=? , FHandlerTime=?");
            updateSQL.append(" where fid in (").append(CollectionUtil.convertList2String(needUpdateIds)).append(")");
        } else {
            updateSQL.append(" update T_TD_CheckResult ");
            updateSQL.append(" set FState = ? , FPrompt = ? , FHandlerID=? , FLastUpdateTime=?");
            updateSQL.append(" where fid in (").append(CollectionUtil.convertList2String(needUpdateIds)).append(")");
        }
        DbUtil.execute((Context)ctx, (String)updateSQL.toString(), (Object[])new Object[]{state.getValue(), prompt, userInfo.getId().toString(), timestamp});
        return result;
    }

    @Override
    protected Map _getClassificationNumber(Context ctx, Map params) throws BOSException, EASBizException {
        String periodFrom = (String)params.get("periodFrom");
        String periodTo = (String)params.get("periodTo");
        periodFrom = periodFrom.replace("-", "");
        periodTo = periodTo.replace("-", "");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        ArrayList<String> indexTypes = new ArrayList<String>();
        indexTypes.add("IDX001");
        indexTypes.add("IDX002");
        indexTypes.add("IDX003");
        indexTypes.add("IDX004");
        ArrayList<String> riskLevels = new ArrayList<String>();
        riskLevels.add("3");
        riskLevels.add("2");
        riskLevels.add("1");
        int size = indexTypes.size();
        for (int i = 0; i < size; ++i) {
            int length = riskLevels.size();
            for (int j = 0; j < length; ++j) {
                result.put(indexTypes.get(i) + "_" + riskLevels.get(j), 0);
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select INDEXTYPE.FNumber as indexType,FRiskLevel as riskLevel , count(CHECKRESULT.fid) as number FROM T_TD_CheckResult AS CHECKRESULT ");
        sql.append(" LEFT OUTER JOIN T_TD_CheckIndex AS checkINDEX ON CHECKRESULT.FIndexID = checkINDEX.FID ");
        sql.append(" INNER JOIN T_TD_IndexType AS INDEXTYPE ON checkINDEX.FIndexTypeID = INDEXTYPE.FID ");
        sql.append(" where CHECKRESULT.FCheckType = '2' ");
        sql.append(" and CHECKRESULT.FisConfirm=1 ");
        OrgUnitCollection companys = TDUtils.getAuthOrgByPermItem(ctx, OrgType.Company, "td_indexcheckresult_view");
        HashSet<String> companyids = new HashSet<String>();
        for (int i = 0; i < companys.size(); ++i) {
            companyids.add(companys.get(i).getId().toString());
        }
        HashSet companyOrgids = new HashSet();
        HashSet curCompanyId = new HashSet();
        if (params.get("curCompanyId") != null) {
            curCompanyId.add(params.get("curCompanyId"));
            TDUtils.getCompanyOrgUnitIds(ctx, curCompanyId, companyOrgids);
        }
        if (companyids.size() > 0) {
            companyids.retainAll(companyOrgids);
        }
        companyids.add("");
        sql.append(" and CHECKRESULT.FCompanyID in (").append(CollectionUtil.convertSet2String(companyids, ",", true)).append(")");
        if (params.get("state") != null) {
            if ((Integer)params.get("state") == 0) {
                sql.append(" and CHECKRESULT.FState in (2,4) ");
            } else if ((Integer)params.get("state") == 1) {
                sql.append(" and CHECKRESULT.FState = 3 ");
            } else {
                sql.append(" and CHECKRESULT.FState in (2,3,4) ");
            }
        } else {
            sql.append(" and CHECKRESULT.FState in (2,3,4) ");
        }
        sql.append(" and (CHECKRESULT.FYear*100+CHECKRESULT.FMonth)>=" + periodFrom + " and (CHECKRESULT.FYear*100+CHECKRESULT.FMonth)<=" + periodTo);
        sql.append(" group by FRiskLevel,INDEXTYPE.FNumber ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String indexType = rs.getString("indexType");
                String riskLevel = rs.getString("riskLevel");
                int number = rs.getInt("number");
                if (!indexTypes.contains(indexType) || !riskLevels.contains(riskLevel)) continue;
                result.put(indexType + "_" + riskLevel, number);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected Map _updateCheckResultRisk(Context ctx, Map params) throws BOSException {
        ArrayList ids = (ArrayList)params.get("ids");
        String isRisk = (String)params.get("isRisk");
        String riskLevel = (String)params.get("riskLevel");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append(" update T_TD_CheckResult ");
        updateSQL.append(" set FisConfirm=? , FHandlerID=? , FLastUpdateTime=?");
        if (!riskLevel.isEmpty()) {
            updateSQL.append(" ,FRiskLevel=?");
        }
        updateSQL.append(" where fid in (").append(CollectionUtil.convertList2String(ids)).append(")");
        if (!riskLevel.isEmpty()) {
            DbUtil.execute((Context)ctx, (String)updateSQL.toString(), (Object[])new Object[]{"true".equals(isRisk) ? 1 : 0, userInfo.getId().toString(), timestamp, riskLevel});
        } else {
            DbUtil.execute((Context)ctx, (String)updateSQL.toString(), (Object[])new Object[]{"true".equals(isRisk) ? 1 : 0, userInfo.getId().toString(), timestamp});
        }
        return null;
    }
}

