/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.account.engine.util.KsqlUtil;
import com.kingdee.eas.tm.td.basedata.DataSourceCollection;
import com.kingdee.eas.tm.td.basedata.DataSourceEntryCollection;
import com.kingdee.eas.tm.td.basedata.DataSourceEntryFactory;
import com.kingdee.eas.tm.td.basedata.DataSourceEntryInfo;
import com.kingdee.eas.tm.td.basedata.DataSourceFactory;
import com.kingdee.eas.tm.td.basedata.DataSourceInfo;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionCollection;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionFactory;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionInfo;
import com.kingdee.eas.tm.td.cloud.GroupCollection;
import com.kingdee.eas.tm.td.cloud.GroupFactory;
import com.kingdee.eas.tm.td.cloud.GroupInfo;
import com.kingdee.eas.tm.td.cloud.OrgGroupCollection;
import com.kingdee.eas.tm.td.cloud.OrgGroupFactory;
import com.kingdee.eas.tm.td.cloud.TDCloudException;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchFieldsMappingCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchFieldsMappingFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchFieldsMappingInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataModelStateEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.DataSourceToDataFetchCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.DataSourceToDataFetchFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.DataSourceToDataFetchInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.FetchTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.app.AbstractDataFetchControllerBean;
import com.kingdee.eas.tm.td.cloud.datamodel.utils.DataModelUtil;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DataFetchControllerBean
extends AbstractDataFetchControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.datamodel.app.DataFetchControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, (DataBaseInfo)model);
        return super._submit(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        DataBaseInfo coreBillBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)coreBillBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{coreBillBaseInfo.getString("number"), ""});
        }
        filter = new FilterInfo();
        filterItem = new FilterItemInfo("tblName", (Object)coreBillBaseInfo.getString("tblName"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            String str = TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "TBLNAME_ERROR", ctx.getLocale(), new Object[]{coreBillBaseInfo.getString("number"), coreBillBaseInfo.getString("tblName")});
            throw new TDException(TDException.ERROR_MSG, new Object[]{str});
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DataFetchInfo info = DataFetchFactory.getLocalInstance(ctx).getDataFetchInfo(pk);
        this.checkBeforeDelete(ctx, info);
        this.deleteOtherData(ctx, pk.toString());
        super._delete(ctx, pk);
        if (this.checkTableIsExist(ctx, info.getTblName()) && info.getTblName().indexOf("T_TD_DYNAMIC_") >= 0) {
            String sql = "Drop Table  " + info.getTblName();
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    protected void deleteOtherData(Context ctx, String dataFetchID) throws BOSException, EASBizException {
        HashSet<String> dsidSet = new HashSet<String>();
        HashSet<String> idList = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FDATASOURCEID as dsid,fid FROM  T_TD_DataSourceToDataFetch");
        sb.append(" where FDataFetchID = '").append(dataFetchID).append("' ");
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sb.toString(), null);
        try {
            while (rs.next()) {
                String dsid = rs.getString("dsid");
                String fid = rs.getString("fid");
                dsidSet.add(dsid);
                idList.add(fid);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (dsidSet.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", dsidSet, CompareType.INCLUDE));
            DataSourceFactory.getLocalInstance(ctx).delete(filter);
        }
        if (dsidSet.size() > 0) {
            sb.setLength(0);
            String dsids = TDUtils.getInStringFromSet(dsidSet);
            sb.append(" DELETE FROM T_TM_TakeDataContdition WHERE FDataSourceID in ").append(dsids);
            DBUtil.executeBatch((Context)ctx, (String[])new String[]{sb.toString()});
        }
        sb.setLength(0);
        sb.append(" DELETE FROM T_TD_DataFetchFieldsMapping WHERE ");
        sb.append(" FDataFetchEntryID  in (select fid from T_TD_DataFetchEntry where FParentID = '" + dataFetchID + "')");
        DBUtil.executeBatch((Context)ctx, (String[])new String[]{sb.toString()});
        String relationID = TDUtils.getInStringFromSet(idList);
        sb.setLength(0);
        if (relationID != null) {
            sb.append(" DELETE FROM T_TD_DataSourceToDataFetch WHERE fid in ").append(relationID);
            DBUtil.executeBatch((Context)ctx, (String[])new String[]{sb.toString()});
        }
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DataFetchInfo info = DataFetchFactory.getLocalInstance(ctx).getDataFetchInfo(pk);
        this.checkBeforeCancel(ctx, info);
        info.setState(DataModelStateEnum.DISABLE);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DataFetchInfo info = DataFetchFactory.getLocalInstance(ctx).getDataFetchInfo(pk);
        this.checkBeforeCancelCancel(ctx, info);
        info.setState(DataModelStateEnum.ENABLE);
        try {
            this.updateTableToDB(ctx, info);
        }
        catch (Exception e) {
            String errorMsg = TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "updateTableToDBError", ctx.getLocale()) + "\n";
            errorMsg = errorMsg + e.getMessage();
            throw new TDException(TDException.ERROR_MSG, new Object[]{errorMsg});
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void updateTableToDB(Context ctx, DataFetchInfo info) throws BOSException, EASBizException {
        int i;
        if (info == null || StringUtils.isEmpty((String)info.getTblName()) || FetchTypeEnum.QingAnalysis.equals((Object)info.getFetchType())) {
            return;
        }
        if (info.getTblName().indexOf("T_TD_DYNAMIC_") < 0) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{"\u8868\u540d\u5fc5\u987b\u4ee5T_TD_DYNAMIC_\u5f00\u5934"});
        }
        if (!this.checkTableIsExist(ctx, info.getTblName())) {
            this.createNewTable(ctx, info);
            return;
        }
        Map<String, FieldMetaData> dbTable = this.getDBTableFieldMap(ctx, info.getTblName());
        FieldMetaData dbField = null;
        DataFetchEntryInfo fieldInfo = null;
        DataFetchEntryCollection coll = info.getEntry();
        ArrayList<String> alterSQLList = new ArrayList<String>();
        for (i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            dbField = dbTable.get(fieldInfo.getName().toUpperCase());
            if (dbField == null) {
                alterSQLList.add(this.getAddFieldSQL(ctx, info.getTblName(), fieldInfo));
                continue;
            }
            if (KsqlUtil.isSQLServer(ctx)) {
                if ("0".equals(dbField.getDefaultValue()) && !StringUtils.isEmpty((String)fieldInfo.getDefaultValue())) {
                    alterSQLList.add(this.getAddFieldDefaultValueSQL(info.getTblName(), fieldInfo));
                    alterSQLList.add(this.getUpdateDefaultValueSQL(info.getTblName(), fieldInfo));
                } else if (!"0".equals(dbField.getDefaultValue()) && StringUtils.isEmpty((String)fieldInfo.getDefaultValue())) {
                    alterSQLList.add(this.getDropFieldDefaultValueSQL(info.getTblName(), fieldInfo));
                }
            } else if (dbField.getDefaultValue() == null && !StringUtils.isEmpty((String)fieldInfo.getDefaultValue())) {
                alterSQLList.add(this.getAddFieldDefaultValueSQL(info.getTblName(), fieldInfo));
            } else if (dbField.getDefaultValue() != null && StringUtils.isEmpty((String)fieldInfo.getDefaultValue())) {
                alterSQLList.add(this.getDropFieldDefaultValueSQL(info.getTblName(), fieldInfo));
            }
            if (dbField.isNullabled && !fieldInfo.isIsNullable()) {
                alterSQLList.add(this.getAlterFieldNullabledSQL(ctx, info.getTblName(), fieldInfo, false));
                continue;
            }
            if (dbField.isNullabled || !fieldInfo.isIsNullable()) continue;
            alterSQLList.add(this.getAlterFieldNullabledSQL(ctx, info.getTblName(), fieldInfo, true));
        }
        for (i = 0; i < alterSQLList.size(); ++i) {
            DbUtil.execute((Context)ctx, (String)((String)alterSQLList.get(i)));
        }
    }

    private String getAddFieldSQL(Context ctx, String tableName, DataFetchEntryInfo fieldInfo) throws EASBizException {
        StringBuffer sSQL = new StringBuffer();
        String fieldName = fieldInfo.getName();
        String dataType = DataModelUtil.getDataTypeStr(ctx, fieldInfo);
        String defaultValue = DataModelUtil.getDefaultValueSQL(fieldInfo, true);
        String constraint = !fieldInfo.isIsNullable() ? "Not Null" : "";
        sSQL.append("Alter table ").append(tableName).append(" add ");
        sSQL.append(fieldName).append(" ");
        sSQL.append(dataType).append(" ");
        sSQL.append(defaultValue).append(" ").append(constraint);
        return sSQL.toString();
    }

    private String getAddFieldDefaultValueSQL(String tableName, DataFetchEntryInfo fieldInfo) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Alter table ").append(tableName).append(" add ");
        sSQL.append(DataModelUtil.getDefaultValueSQL(fieldInfo, true)).append(" for ");
        sSQL.append(fieldInfo.getName());
        return sSQL.toString();
    }

    private String getUpdateDefaultValueSQL(String tableName, DataFetchEntryInfo fieldInfo) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("update ").append(tableName).append(" set ");
        sSQL.append(fieldInfo.getName()).append(" = ");
        sSQL.append(DataModelUtil.getDefaultValueSQL(fieldInfo, false));
        sSQL.append(" where ").append(fieldInfo.getName()).append(" is null ");
        return sSQL.toString();
    }

    private String getDropFieldDefaultValueSQL(String tableName, DataFetchEntryInfo fieldInfo) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Alter table ").append(tableName).append(" drop default for ");
        sSQL.append(fieldInfo.getName());
        return sSQL.toString();
    }

    private String getAlterFieldNullabledSQL(Context ctx, String tableName, DataFetchEntryInfo fieldInfo, boolean isNullabled) throws EASBizException {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Alter table ").append(tableName).append(" alter column ");
        sSQL.append(fieldInfo.getName()).append(" ");
        sSQL.append(DataModelUtil.getDataTypeStr(ctx, fieldInfo));
        if (!isNullabled) {
            sSQL.append(" Not Null");
        }
        return sSQL.toString();
    }

    private Map<String, FieldMetaData> getDBTableFieldMap(Context ctx, String tableName) throws BOSException {
        String sSQL = "select ksql_col_name, ksql_col_type, ksql_col_length, ksql_col_default, ksql_col_nullable from ksql_usercolumns where ksql_col_tabname = '" + tableName + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sSQL);
        FieldMetaData field = null;
        String nullableValue = null;
        HashMap<String, FieldMetaData> dbTable = new HashMap<String, FieldMetaData>();
        try {
            while (rs.next()) {
                field = new FieldMetaData();
                field.setName(rs.getString("ksql_col_name"));
                field.setDataType(rs.getString("ksql_col_type"));
                field.setLength(rs.getInt("ksql_col_length"));
                field.setDefaultValue(rs.getString("ksql_col_default"));
                nullableValue = rs.getString("ksql_col_nullable");
                if ("Y".equalsIgnoreCase(nullableValue) || "1".equals(nullableValue)) {
                    field.setNullabled(true);
                } else {
                    field.setNullabled(false);
                }
                dbTable.put(field.getName().toUpperCase(), field);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return dbTable;
    }

    private boolean checkTableIsExist(Context ctx, String tableName) throws BOSException {
        String sSQL = "SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '" + tableName + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sSQL);
        try {
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    private void createNewTable(Context ctx, DataFetchInfo info) throws BOSException, EASBizException {
        String newLine = "\n\t";
        StringBuffer createSQL = new StringBuffer();
        createSQL.append("Create Table ").append(info.getTblName()).append("(").append(newLine);
        DataFetchEntryCollection coll = info.getEntry();
        coll.sort("seq");
        DataFetchEntryInfo fieldInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            String fieldName = fieldInfo.getName();
            String dataType = DataModelUtil.getDataTypeStr(ctx, fieldInfo);
            String defaultValue = DataModelUtil.getDefaultValueSQL(fieldInfo, true);
            String constraint = !fieldInfo.isIsNullable() ? "Not Null" : "";
            createSQL.append("  ").append(fieldName).append(" ").append(dataType).append(" ").append(defaultValue).append(" ").append(constraint).append(",").append(newLine);
        }
        String pkName = DataModelUtil.getPkName(info.getTblName());
        createSQL.append("CONSTRAINT ").append(pkName).append(" PRIMARY KEY (FID)");
        createSQL.append(")");
        DbUtil.execute((Context)ctx, (String)createSQL.toString());
    }

    private void checkBeforeDelete(Context ctx, DataFetchInfo info) throws BOSException, EASBizException {
        if (DataModelStateEnum.ENABLE.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.DELETE_STATUS_ERROR1);
        }
    }

    private void checkBeforeCancel(Context ctx, DataFetchInfo info) throws BOSException, EASBizException {
        if (!DataModelStateEnum.ENABLE.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.CANCEL_STATUS_ERROR);
        }
    }

    private void checkBeforeCancelCancel(Context ctx, DataFetchInfo info) throws BOSException, EASBizException {
        if (DataModelStateEnum.ENABLE.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.CANCELCANCEL_STATUS_ERROR);
        }
    }

    @Override
    protected Set _getDataSourceByID(Context ctx, String dataFetchId) throws BOSException, EASBizException {
        HashSet<String> dataSet = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select fDataSourceID from T_TD_DataSourceToDataFetch");
        sb.append(" where FDataFetchID  = ");
        sb.append(" '").append(dataFetchId).append("'");
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sb.toString(), null);
        try {
            while (rs.next()) {
                String dsID = rs.getString("fDataSourceID");
                dataSet.add(dsID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return dataSet;
    }

    @Override
    protected void _addDataSourceToDataFetch(Context ctx, String dataFetchID, String dataSourceID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append(" delete FROM T_TD_DataSourceToDataFetch where FDataFetchID = '" + dataFetchID + "' and fDataSourceID  = '" + dataSourceID + "' ");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" insert into T_TD_DataSourceToDataFetch(fid,FDataFetchID,fDataSourceID) values(newBosid('492639ED'),'" + dataFetchID + "','" + dataSourceID + "') ");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    @Override
    protected ArrayList _getAccountByDataSource(Context ctx, Map params) throws BOSException, EASBizException {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        ArrayList<DataFetchInfo> datalist = new ArrayList<DataFetchInfo>();
        HashSet<String> fvalues = new HashSet<String>();
        HashSet<String> companyIDs = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        int count = 0;
        ArrayList otherData = new ArrayList();
        IRowSet rs = null;
        String groupNumber = (String)params.get("groupNumber");
        Set companyIds = params.get("companyIds") != null ? (Set)params.get("companyIds") : null;
        int dateFromYear = params.get("dateFromYear") != null ? (Integer)params.get("dateFromYear") : Calendar.getInstance().get(1) - 1;
        int dateFromMonth = params.get("dateFromMonth") != null ? (Integer)params.get("dateFromMonth") : 12;
        int dateToYear = params.get("dateToYear") != null ? ((Integer)params.get("dateToYear")).intValue() : Calendar.getInstance().get(1);
        int dateToMonth = params.get("dateToMonth") != null ? (Integer)params.get("dateToMonth") : 12;
        int state = params.get("state") != null ? (Integer)params.get("state") : 2;
        HashSet<String> param = new HashSet<String>();
        param.add("dr_sc001");
        param.add("dr_sc002");
        sql.append("  select fvalue from t_td_tdparam where fkey in(").append(CollectionUtil.convertSet2String(param, ",", true)).append(")");
        rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), null);
        try {
            while (rs.next()) {
                fvalues.add(rs.getString("fvalue"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append(" select Fid,Fnumber,Fname_l2 as name,Ftblname FROM T_TD_DataFetch ");
        sql.append(" where Fstate = 1 and FetchType = 1");
        rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), null);
        try {
            while (rs.next()) {
                DataFetchInfo info = new DataFetchInfo();
                String id = rs.getString("Fid");
                String number = rs.getString("Fnumber");
                String name = rs.getString("name");
                String tabname = rs.getString("Ftblname");
                info.setId(BOSUuid.read((String)id));
                info.setNumber(number);
                info.setName(name);
                info.setTblName(tabname);
                datalist.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        OrgUnitCollection companys = TDUtils.getAuthOrgByPermItem(ctx, OrgType.Company, "td_riskscreeninganalysis_view");
        HashSet<String> companyids = new HashSet<String>();
        for (int i = 0; i < companys.size(); ++i) {
            companyids.add(companys.get(i).getId().toString());
        }
        HashSet companyOrgids = new HashSet();
        HashSet curCompanyId = new HashSet();
        if (params.get("curCompanyId") != null) {
            curCompanyId.add(params.get("curCompanyId"));
            TDUtils.getCompanyOrgUnitIds(ctx, curCompanyId, companyOrgids);
        }
        if (companyids.size() > 0) {
            companyids.retainAll(companyOrgids);
        }
        companyids.add("");
        if (!StringUtils.isEmpty((String)groupNumber) && !"null".equals(groupNumber)) {
            GroupInfo groupInfo = GroupFactory.getLocalInstance(ctx).getGroupInfo("where number = '" + groupNumber + "'");
            GroupCollection groupColl = GroupFactory.getLocalInstance(ctx).getGroupCollection(" where longNumber like '" + groupInfo.getLongNumber() + "%'");
            HashSet<String> groupIncludeChildrenIds = new HashSet<String>();
            GroupInfo info = null;
            int size = groupColl.size();
            for (int i = 0; i < size; ++i) {
                info = groupColl.get(i);
                groupIncludeChildrenIds.add(info.getId().toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("group.id", groupIncludeChildrenIds, CompareType.INCLUDE));
            view.setFilter(filter);
            OrgGroupCollection orgGroupColl = OrgGroupFactory.getLocalInstance(ctx).getOrgGroupCollection(view);
            int size2 = orgGroupColl.size();
            for (int i = 0; i < size2; ++i) {
                companyIDs.add(orgGroupColl.get(i).getCompany().getId().toString());
            }
            if (companyIDs.size() != 0) {
                companyIDs.retainAll(companyids);
            }
        }
        for (int i = 0; i < datalist.size(); ++i) {
            HashMap<String, Object> dataSource = new HashMap<String, Object>();
            HashMap<String, Object> otherDataSource = new HashMap<String, Object>();
            sql.setLength(0);
            sql.append(" select count(1) as count from ").append(((DataFetchInfo)datalist.get(i)).getTblName());
            if (params.get("state") != null) {
                if (state == 0) {
                    sql.append(" where FState in (2,4) ");
                } else if (state == 1) {
                    sql.append(" where FState = 3 ");
                } else {
                    sql.append(" where FState in (2,3,4) ");
                }
            } else {
                sql.append(" where FState in (2,3,4) ");
            }
            sql.append(" AND ");
            sql.append(" ( FYear*100+FMonth >= ").append(dateFromYear * 100 + dateFromMonth);
            sql.append(" and ").append(" FYear*100+FMonth <= ").append(dateToYear * 100 + dateToMonth);
            sql.append(" ) ");
            StringBuffer tempsql = new StringBuffer(sql.toString());
            if (companyIDs.size() != 0) {
                tempsql.append(" and  FCompany in (").append(CollectionUtil.convertSet2String(companyIDs, ",", true)).append(")");
            } else {
                tempsql.append(" and  FCompany in (").append(CollectionUtil.convertSet2String(companyids, ",", true)).append(")");
            }
            rs = DBUtil.executeQuery((Context)ctx, (String)tempsql.toString(), null);
            try {
                if (rs.next()) {
                    if (fvalues.contains(((DataFetchInfo)datalist.get(i)).getNumber())) {
                        dataSource.put("solutionName", ((DataFetchInfo)datalist.get(i)).getName());
                        dataSource.put("solutionNumber", ((DataFetchInfo)datalist.get(i)).getNumber());
                        dataSource.put("account", rs.getInt("count"));
                        result.add(dataSource);
                        continue;
                    }
                    otherDataSource.put("solutionName", ((DataFetchInfo)datalist.get(i)).getName());
                    otherDataSource.put("solutionNumber", ((DataFetchInfo)datalist.get(i)).getNumber());
                    otherDataSource.put("account", rs.getInt("count"));
                    otherData.add(otherDataSource);
                    count += rs.getInt("count");
                    continue;
                }
                rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), null);
                if (!rs.next()) continue;
                if (fvalues.contains(((DataFetchInfo)datalist.get(i)).getNumber())) {
                    dataSource.put("solutionName", ((DataFetchInfo)datalist.get(i)).getName());
                    dataSource.put("solutionNumber", ((DataFetchInfo)datalist.get(i)).getNumber());
                    dataSource.put("account", 0);
                    result.add(dataSource);
                    continue;
                }
                otherDataSource.put("solutionName", ((DataFetchInfo)datalist.get(i)).getName());
                otherDataSource.put("solutionNumber", ((DataFetchInfo)datalist.get(i)).getNumber());
                otherDataSource.put("account", 0);
                otherData.add(otherDataSource);
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        sql.setLength(0);
        StringBuffer tempsql = null;
        sql.append(" SELECT\u3000t1.fid,isnull(t1.fname_l2,'\u4e8b\u9879\u68c0\u67e5\uff08\u9ed8\u8ba4\uff09') as fname,t.totalcount FROM");
        sql.append(" ( SELECT item.FCheckItemTypeID as itemtype, count(1) as totalcount FROM T_TD_CheckResult as result");
        sql.append("   LEFT OUTER JOIN T_TD_CheckItem as item ON result.FItemID = item.FID ");
        sql.append("   WHERE result.FCheckType = '1' ");
        sql.append("   and result.FState in (2,4) ");
        tempsql = new StringBuffer(sql.toString());
        if (companyIDs.size() != 0) {
            tempsql.append(" and  result.FCompanyID in (").append(CollectionUtil.convertSet2String(companyIDs, ",", true)).append(")");
        } else {
            tempsql.append(" and  result.FCompanyID in (").append(CollectionUtil.convertSet2String(companyids, ",", true)).append(")");
        }
        tempsql.append(" AND ");
        tempsql.append(" ( result.FYear*100+result.FMonth >= ").append(dateFromYear * 100 + dateFromMonth);
        tempsql.append("   and ").append(" result.FYear*100+result.FMonth <= ").append(dateToYear * 100 + dateToMonth);
        tempsql.append(" ) ");
        tempsql.append("   GROUP BY FCheckItemTypeID ) as t\u3000");
        tempsql.append(" LEFT JOIN T_TD_CheckItemType as t1 on t.itemtype =t1.fid ");
        sql.append("   GROUP BY FCheckItemTypeID ) as t\u3000");
        sql.append(" LEFT JOIN T_TD_CheckItemType as t1 on t.itemtype =t1.fid ");
        rs = DbUtil.executeQuery((Context)ctx, (String)tempsql.toString());
        try {
            HashMap<String, Object> otherDataSource;
            if (rs.size() > 0) {
                while (rs.next()) {
                    otherDataSource = new HashMap<String, Object>();
                    otherDataSource.put("solutionId", rs.getString("fid"));
                    otherDataSource.put("solutionName", rs.getString("fname"));
                    otherDataSource.put("solutionNumber", "itemCheckTotalNumber");
                    otherDataSource.put("account", rs.getInt("totalcount"));
                    count += rs.getInt("totalcount");
                    otherData.add(otherDataSource);
                }
            } else {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    otherDataSource = new HashMap();
                    otherDataSource.put("solutionId", rs.getString("fid"));
                    otherDataSource.put("solutionName", rs.getString("fname"));
                    otherDataSource.put("solutionNumber", "itemCheckTotalNumber");
                    otherDataSource.put("account", 0);
                    otherData.add(otherDataSource);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        result.add(0, Integer.valueOf(count));
        result.add(1, otherData);
        return result;
    }

    @Override
    protected void _copyDataSourceAndTakeDataCondition(Context ctx, String copyDataFetchID, String newDataFetchID) throws BOSException, EASBizException {
        DataSourceToDataFetchCollection coll = DataSourceToDataFetchFactory.getLocalInstance(ctx).getDataSourceToDataFetchCollection("where dataFetch.id = '" + copyDataFetchID + "'");
        if (coll.size() > 0) {
            HashMap<String, DataSourceInfo> dataSourceMap = new HashMap<String, DataSourceInfo>();
            HashMap<String, DataSourceEntryInfo> dataSourceEntryMap = new HashMap<String, DataSourceEntryInfo>();
            HashMap<String, TakeDataContditionInfo> conditionMap = new HashMap<String, TakeDataContditionInfo>();
            HashMap accountEntryMap = new HashMap();
            HashSet<String> dataSourceSet = new HashSet<String>();
            DataSourceToDataFetchInfo info = null;
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                info = (DataSourceToDataFetchInfo)it.next();
                dataSourceSet.add(info.getDataSource().getId().toString());
            }
            DataFetchInfo copyDataFetch = DataFetchFactory.getLocalInstance(ctx).getDataFetchInfo((IObjectPK)new ObjectUuidPK(copyDataFetchID));
            DataFetchInfo newDataFetch = DataFetchFactory.getLocalInstance(ctx).getDataFetchInfo((IObjectPK)new ObjectUuidPK(newDataFetchID));
            HashMap<String, String> map1 = new HashMap<String, String>();
            HashMap<String, DataFetchEntryInfo> map2 = new HashMap<String, DataFetchEntryInfo>();
            DataFetchEntryInfo entryInfo = null;
            Iterator it2 = copyDataFetch.getEntry().iterator();
            while (it2.hasNext()) {
                entryInfo = (DataFetchEntryInfo)it2.next();
                map1.put(entryInfo.getName(), entryInfo.getId().toString());
            }
            it2 = newDataFetch.getEntry().iterator();
            while (it2.hasNext()) {
                entryInfo = (DataFetchEntryInfo)it2.next();
                map2.put(entryInfo.getName(), entryInfo);
            }
            String key2 = null;
            for (String key2 : map1.keySet()) {
                accountEntryMap.put(map1.get(key2), map2.get(key2));
            }
            EntityViewInfo dview = new EntityViewInfo();
            FilterInfo dfilter = new FilterInfo();
            dfilter.getFilterItems().add(new FilterItemInfo("id", dataSourceSet, CompareType.INCLUDE));
            dview.setFilter(dfilter);
            DataSourceCollection dataSourceColl = DataSourceFactory.getLocalInstance(ctx).getDataSourceCollection(dview);
            DataSourceInfo dataSourceInfo = null;
            int numberEnd = 0;
            String dataSourceNumber = null;
            String oldDataSourceID = null;
            int size = dataSourceColl.size();
            for (int i = 0; i < size; ++i) {
                dataSourceInfo = dataSourceColl.get(i);
                dataSourceNumber = "DS" + TDUtils.getNumberString() + numberEnd;
                oldDataSourceID = dataSourceInfo.getId().toString();
                dataSourceInfo.setId(BOSUuid.create((String)"AF4374B7"));
                dataSourceMap.put(oldDataSourceID, dataSourceInfo);
                dataSourceInfo.setNumber(dataSourceNumber);
                dataSourceInfo.getEntry().clear();
                DataSourceFactory.getLocalInstance(ctx).addnew(dataSourceInfo);
                DataSourceToDataFetchInfo dataSourceToDataFetchInfo = new DataSourceToDataFetchInfo();
                dataSourceToDataFetchInfo.setDataFetch(newDataFetch);
                dataSourceToDataFetchInfo.setDataSource(dataSourceInfo);
                DataSourceToDataFetchFactory.getLocalInstance(ctx).addnew(dataSourceToDataFetchInfo);
                ++numberEnd;
            }
            EntityViewInfo deview = new EntityViewInfo();
            FilterInfo defilter = new FilterInfo();
            defilter.getFilterItems().add(new FilterItemInfo("parent.id", dataSourceSet, CompareType.INCLUDE));
            deview.setFilter(defilter);
            DataSourceEntryCollection dataSourceEntryColl = DataSourceEntryFactory.getLocalInstance(ctx).getDataSourceEntryCollection(deview);
            DataSourceEntryInfo dataSourceEntryInfo = null;
            String oldSataSourceEntryID = null;
            Iterator it3 = dataSourceEntryColl.iterator();
            while (it3.hasNext()) {
                dataSourceEntryInfo = (DataSourceEntryInfo)it3.next();
                oldSataSourceEntryID = dataSourceEntryInfo.getId().toString();
                dataSourceEntryInfo.setId(BOSUuid.create((String)"910BFDFB"));
                dataSourceEntryInfo.setParent((DataSourceInfo)dataSourceMap.get(dataSourceEntryInfo.getParent().getId().toString()));
                dataSourceEntryMap.put(oldSataSourceEntryID, dataSourceEntryInfo);
            }
            it3 = dataSourceEntryColl.iterator();
            while (it3.hasNext()) {
                dataSourceEntryInfo = (DataSourceEntryInfo)it3.next();
                if (dataSourceEntryInfo.getParentTable() != null) {
                    dataSourceEntryInfo.setParentTable((DataSourceEntryInfo)dataSourceEntryMap.get(dataSourceEntryInfo.getParentTable().getId().toString()));
                }
                DataSourceEntryFactory.getLocalInstance(ctx).addnew(dataSourceEntryInfo);
            }
            HashSet<String> conditionSet = new HashSet<String>();
            EntityViewInfo cview = new EntityViewInfo();
            FilterInfo cfilter = new FilterInfo();
            cfilter.getFilterItems().add(new FilterItemInfo("dataSource.id", dataSourceSet, CompareType.INCLUDE));
            cview.setFilter(cfilter);
            TakeDataContditionCollection conditionColl = TakeDataContditionFactory.getLocalInstance(ctx).getTakeDataContditionCollection(cview);
            TakeDataContditionInfo conditionInfo = null;
            int conditionNumberEnd = 0;
            String conditionNumber = null;
            String oldConditionID = null;
            int size2 = conditionColl.size();
            for (int i = 0; i < size2; ++i) {
                conditionInfo = conditionColl.get(i);
                oldConditionID = conditionInfo.getId().toString();
                conditionInfo.setId(BOSUuid.create((String)"D91004CE"));
                conditionNumber = "TDC" + TDUtils.getNumberString() + conditionNumberEnd;
                conditionInfo.setNumber(conditionNumber);
                conditionInfo.setDataSource((DataSourceInfo)dataSourceMap.get(conditionInfo.getDataSource().getId().toString()));
                TakeDataContditionFactory.getLocalInstance(ctx).addnew(conditionInfo);
                conditionMap.put(oldConditionID, conditionInfo);
                conditionSet.add(oldConditionID);
                ++conditionNumberEnd;
            }
            EntityViewInfo fview = new EntityViewInfo();
            FilterInfo ffilter = new FilterInfo();
            ffilter.getFilterItems().add(new FilterItemInfo("condition.id", conditionSet, CompareType.INCLUDE));
            fview.setFilter(ffilter);
            DataFetchFieldsMappingCollection fieldColl = DataFetchFieldsMappingFactory.getLocalInstance(ctx).getDataFetchFieldsMappingCollection(fview);
            DataFetchFieldsMappingInfo mappingInfo = null;
            Iterator it4 = fieldColl.iterator();
            while (it4.hasNext()) {
                mappingInfo = (DataFetchFieldsMappingInfo)it4.next();
                mappingInfo.setId(BOSUuid.create((String)"7958CD88"));
                mappingInfo.setCondition((TakeDataContditionInfo)conditionMap.get(mappingInfo.getCondition().getId().toString()));
                mappingInfo.setDataFetchEntry((DataFetchEntryInfo)accountEntryMap.get(mappingInfo.getDataFetchEntry().getId().toString()));
                DataFetchFieldsMappingFactory.getLocalInstance(ctx).addnew(mappingInfo);
            }
        }
    }

    class FieldMetaData {
        String name;
        String dataType;
        int length;
        String defaultValue;
        boolean isNullabled;

        FieldMetaData() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public boolean isNullabled() {
            return this.isNullabled;
        }

        public void setNullabled(boolean isNullabled) {
            this.isNullabled = isNullabled;
        }
    }
}

