/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.IItem;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.app.AbstractItemControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ItemControllerBean
extends AbstractItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.app.ItemControllerBean");

    @Override
    protected boolean _checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean checkNumber = true;
        ItemInfo info = (ItemInfo)model;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        view.setFilter(filter);
        ItemCollection coll = ItemFactory.getLocalInstance(ctx).getItemCollection(view);
        if (coll != null && coll.size() > 0) {
            checkNumber = false;
        }
        return checkNumber;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    @Override
    protected ItemCollection _getItemListBySumItemFormula(Context ctx, String sumItemFormula) throws BOSException, EASBizException {
        Pattern pt = Pattern.compile("([\\(]*)([^\\+|^\\-|^\\*|^\\/|^\\(|^\\))]{1,})([\\+|\\-|\\*|\\/|\\(|\\)]*)");
        if (sumItemFormula == null || sumItemFormula.length() == 0) {
            return null;
        }
        Matcher matcher = pt.matcher(sumItemFormula);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        ArrayList<String> sumItemNumber = new ArrayList<String>();
        String itemNumber = null;
        StringBuffer maskString = new StringBuffer("(");
        int count = 0;
        while (matcher.find()) {
            itemNumber = matcher.group(2);
            sumItemNumber.add(itemNumber);
            if (itemNumber == null || itemNumber.trim().length() == 0) continue;
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)itemNumber.trim(), CompareType.EQUALS));
            if (count != 0) {
                maskString.append(" OR ");
            }
            maskString.append("#").append(count);
            ++count;
        }
        maskString.append(")");
        filter.setMaskString(maskString.toString());
        view.setFilter(filter);
        IItem ie = ItemFactory.getLocalInstance(ctx);
        ItemCollection subItems = ie.getItemCollection(view);
        if (subItems == null || subItems.isEmpty()) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{"\u603b\u8ba1\u9879\u516c\u5f0f\u51fa\u9519\uff0c\u8ba1\u7b97\u9879\uff08" + sumItemNumber + "\uff09\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01"});
        }
        if (sumItemNumber.size() != subItems.size()) {
            for (int i = 0; i < subItems.size(); ++i) {
                sumItemNumber.remove(subItems.get(i).getNumber());
            }
        }
        sumItemNumber.clear();
        sumItemNumber = null;
        return subItems;
    }

    @Override
    protected ArrayList _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        ItemCollection coll = ItemFactory.getLocalInstance(ctx).getItemCollection(view);
        ItemInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!EnableStateEnum.ENABLE.equals((Object)info.getState())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CANNOT_INACTIVE", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TD_Item set FState = 1 where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        return errors;
    }

    @Override
    protected ArrayList _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        ItemCollection coll = ItemFactory.getLocalInstance(ctx).getItemCollection(view);
        ItemInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!EnableStateEnum.DISABLE.equals((Object)info.getState())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CANNOT_ACTIVE", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TD_Item set FState = 0 where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        return errors;
    }
}

