/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.TDCloudException;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionEntryCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.app.AbstractItemDimensionControllerBean;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ItemDimensionControllerBean
extends AbstractItemDimensionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.datamodel.app.ItemDimensionControllerBean");

    @Override
    protected boolean _checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean checkNumber = true;
        ItemDimensionInfo info = (ItemDimensionInfo)model;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        view.setFilter(filter);
        ItemDimensionCollection coll = ItemDimensionFactory.getLocalInstance(ctx).getItemDimensionCollection(view);
        if (coll != null && coll.size() > 0) {
            checkNumber = false;
        }
        return checkNumber;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.SaveBackItem(ctx, model);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.SaveBackItem(ctx, model);
        return super._submit(ctx, model);
    }

    private void SaveBackItem(Context ctx, IObjectValue model) throws BOSException {
        ItemDimensionInfo info = (ItemDimensionInfo)model;
        ItemDimensionEntryCollection entries = info.getEntry();
        HashSet<String> items = new HashSet<String>();
        for (int i = 0; i < entries.size(); ++i) {
            ItemDimensionEntryInfo entryInfo = entries.get(i);
            if (entryInfo.getItem() == null) continue;
            items.add(entryInfo.getItem().getId().toString());
        }
        if (items.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("update T_TD_Item set FIsReference = 1 where FID in (").append(CollectionUtil.convertSet2String(items, ",", true)).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ItemDimensionInfo info = ItemDimensionFactory.getLocalInstance(ctx).getItemDimensionInfo(pk);
        ItemDimensionEntryCollection entries = info.getEntry();
        HashSet<String> items = new HashSet<String>();
        for (int i = 0; i < entries.size(); ++i) {
            ItemDimensionEntryInfo entryInfo = entries.get(i);
            if (entryInfo.getItem() == null) continue;
            items.add(entryInfo.getItem().getId().toString());
        }
        String sql = "select FItemID from t_td_itemdimensionentry where FParentID!='" + info.getId().toString() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String itemId = "";
        try {
            while (rs.next()) {
                itemId = rs.getString("FItemID");
                items.remove(itemId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (items.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("update T_TD_Item set FIsReference = 0 where FID in (").append(CollectionUtil.convertSet2String(items, ",", true)).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        super._delete(ctx, pk);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ItemDimensionInfo info = ItemDimensionFactory.getLocalInstance(ctx).getItemDimensionInfo(pk);
        this.checkBeforeCancel(ctx, info);
        info.setState(EnableStateEnum.DISABLE);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ItemDimensionInfo info = ItemDimensionFactory.getLocalInstance(ctx).getItemDimensionInfo(pk);
        this.checkBeforeCancelCancel(ctx, info);
        info.setState(EnableStateEnum.ENABLE);
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void checkBeforeCancel(Context ctx, ItemDimensionInfo info) throws BOSException, EASBizException {
        if (!EnableStateEnum.ENABLE.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.CANCEL_STATUS_ERROR);
        }
    }

    private void checkBeforeCancelCancel(Context ctx, ItemDimensionInfo info) throws BOSException, EASBizException {
        if (EnableStateEnum.ENABLE.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.CANCELCANCEL_STATUS_ERROR);
        }
    }

    @Override
    protected ArrayList _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        ItemDimensionCollection coll = ItemDimensionFactory.getLocalInstance(ctx).getItemDimensionCollection(view);
        ItemDimensionInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!EnableStateEnum.ENABLE.equals((Object)info.getState())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CANNOT_INACTIVE", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TD_ItemDimension set FState = 1 where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        return errors;
    }

    @Override
    protected ArrayList _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        ItemDimensionCollection coll = ItemDimensionFactory.getLocalInstance(ctx).getItemDimensionCollection(view);
        ItemDimensionInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!EnableStateEnum.DISABLE.equals((Object)info.getState())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CANNOT_ACTIVE", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TD_ItemDimension set FState = 0 where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        return errors;
    }
}

