/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.tm.td.account.engine.interfaces.ISQLBuilder;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionInfo;
import com.kingdee.eas.tm.td.cloud.OrgGroupCollection;
import com.kingdee.eas.tm.td.cloud.OrgGroupFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.rpt.app.AbstractRiskScreeningAnalysisFacadeControllerBean;
import com.kingdee.eas.tm.td.cloud.datamodel.rpt.app.RiskScreeningAnalysisSQLBuilder;
import com.kingdee.eas.tm.td.cloud.datamodel.utils.DataModelUtil;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RiskScreeningAnalysisFacadeControllerBean
extends AbstractRiskScreeningAnalysisFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.datamodel.rpt.app.RiskScreeningAnalysisFacadeControllerBean");

    @Override
    protected Map _handleRiskAnakysis(Context ctx, Map params) throws BOSException, EASBizException {
        this.initParams(ctx, params);
        ArrayList<String> newIds = new ArrayList<String>();
        ArrayList ids = (ArrayList)params.get("ids");
        for (String id : ids) {
            if (this.isRiskExists(ctx, id, params)) continue;
            newIds.add(id);
        }
        if (newIds.size() > 0) {
            String sql = this.getInsertRiskSQL(params);
            DbUtil.execute((Context)ctx, (String)sql);
        }
        Map updateRiskParams = this.getUpdateRiskParams(params);
        String sql = (String)updateRiskParams.get("sql");
        List paramList = (List)updateRiskParams.get("paramList");
        if (paramList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)sql, (List)paramList);
        }
        return null;
    }

    protected void initParams(Context ctx, Map params) throws BOSException, EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        params.put("handler", userInfo.getId().toString());
        params.put("handlerName", userInfo.getName());
        Timestamp handlerTime = new Timestamp(System.currentTimeMillis());
        params.put("handlerTime", handlerTime);
        String dataFetchId = (String)params.get("dataFetchId");
        ObjectUuidPK pk = new ObjectUuidPK(dataFetchId);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.*"));
        DataFetchInfo dataFecthInfo = DataFetchFactory.getLocalInstance(ctx).getDataFetchInfo((IObjectPK)pk, sic);
        params.put("dataFetch", dataFecthInfo);
        Map dimMap = this.initDimMap(ctx, params);
        params.put("dimMap", dimMap);
        List<String> dim = DataModelUtil.getDataFetchDimFields(dataFecthInfo);
        params.put("dim", dim);
    }

    protected String getInsertRiskSQL(Map params) {
        DataFetchInfo dataFetchInfo = (DataFetchInfo)params.get("dataFetch");
        ArrayList ids = (ArrayList)params.get("ids");
        String tempTable = (String)params.get("tempTable");
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ").append(dataFetchInfo.getTblName()).append("(");
        sql.append(DataModelUtil.getDataFetchFieldStr(dataFetchInfo, null));
        sql.append(" ) ");
        sql.append(" SELECT ").append(DataModelUtil.getDataFetchFieldStr(dataFetchInfo, null));
        sql.append(" FROM ").append(tempTable);
        sql.append(" WHERE fid in (").append(CollectionUtil.convertList2String(ids)).append(")");
        return sql.toString();
    }

    @Override
    protected ISQLBuilder getSQLBuilder(Context ctx, DataFetchInfo dataFetchInfo, TakeDataContditionInfo conditionInfo, RptParams params) {
        RiskScreeningAnalysisSQLBuilder sqlBuilder = new RiskScreeningAnalysisSQLBuilder(ctx, dataFetchInfo, conditionInfo, params);
        return sqlBuilder;
    }

    protected Map getUpdateRiskParams(Map params) {
        DataFetchInfo dataFetchInfo = (DataFetchInfo)params.get("dataFetch");
        ArrayList ids = (ArrayList)params.get("ids");
        Map dimMap = (Map)params.get("dimMap");
        List dim = (List)params.get("dim");
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE ").append(dataFetchInfo.getTblName());
        sql.append(" SET FRiskLevel =? , FState = ?  , FHandlerID=? ,FHandlerName=?, FPrompt = ?, FHandlerTime=?");
        sql.append(" WHERE ");
        String dimName = null;
        int size = dim.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sql.append(" AND ");
            }
            dimName = (String)dim.get(i);
            sql.append(dimName).append(" = ?");
        }
        Map valueMap = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        ArrayList paramElem = null;
        for (String id : ids) {
            valueMap = (Map)dimMap.get(id);
            paramElem = new ArrayList();
            paramElem.add(params.get("riskLevelValue"));
            paramElem.add(params.get("stateValue"));
            paramElem.add(params.get("handler"));
            paramElem.add(params.get("handlerName"));
            paramElem.add(params.get("prompt"));
            paramElem.add(params.get("handlerTime"));
            Object value = null;
            int size2 = dim.size();
            for (int i = 0; i < size2; ++i) {
                dimName = (String)dim.get(i);
                value = valueMap.get(dimName);
                paramElem.add(value);
            }
            paramList.add(paramElem.toArray());
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("sql", sql.toString());
        ret.put("paramList", paramList);
        return ret;
    }

    protected Map initDimMap(Context ctx, Map params) throws BOSException {
        DataFetchInfo dataFetchInfo = (DataFetchInfo)params.get("dataFetch");
        ArrayList ids = (ArrayList)params.get("ids");
        String tempTable = (String)params.get("tempTable");
        if (StringUtils.isEmpty((String)tempTable)) {
            tempTable = dataFetchInfo.getTblName();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FID,");
        sql.append(DataModelUtil.getDataFetchDimFieldStr(dataFetchInfo, null));
        sql.append(" FROM ").append(tempTable);
        sql.append(" WHERE FID in (").append(CollectionUtil.convertList2String(ids)).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap dimMap = new HashMap();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        List<String> dim = DataModelUtil.getDataFetchDimFields(dataFetchInfo);
        try {
            while (rs.next()) {
                String id = rs.getString("fid");
                valueMap = new HashMap();
                int size = dim.size();
                for (int i = 0; i < size; ++i) {
                    valueMap.put(dim.get(i), rs.getObject(dim.get(i).toString()));
                }
                dimMap.put(id, valueMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return dimMap;
    }

    protected boolean isRiskExists(Context ctx, String id, Map params) throws BOSException {
        DataFetchInfo dataFetchInfo = (DataFetchInfo)params.get("dataFetch");
        Map dimMap = (Map)params.get("dimMap");
        List dim = (List)params.get("dim");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT 1 FROM ").append(dataFetchInfo.getTblName());
        sql.append(" WHERE  ");
        Map valueMap = (Map)dimMap.get(id);
        Object value = null;
        String dimName = null;
        ArrayList paramList = new ArrayList();
        int size = dim.size();
        for (int i = 0; i < size; ++i) {
            dimName = (String)dim.get(i);
            value = valueMap.get(dimName);
            if (i != 0) {
                sql.append(" AND ");
            }
            if (value == null) {
                sql.append(dimName).append(" IS NULL ");
                continue;
            }
            sql.append(dimName).append(" = ?");
            paramList.add(value);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected void doService(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        DataFetchInfo dataFetchInfo = (DataFetchInfo)params.getObject("dataFetch");
        List dim = (List)params.getObject("dim");
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE ").append(tempTable).append(" as t ");
        sql.append(" SET (FRiskLevel, FState, FHandlerID,FHandlerName, FPrompt, FHandlerTime,FRelatedID)=");
        sql.append(" (SELECT top 1 tbl.FRiskLevel, tbl.FState, tbl.FHandlerID,tbl.FHandlerName, tbl.FPrompt,tbl.FHandlerTime,tbl.FID FROM ");
        sql.append(dataFetchInfo.getTblName()).append(" as tbl");
        sql.append(" INNER JOIN ").append(tempTable).append(" t1 ");
        sql.append(" ON ").append(this.getDimJoinOnSQL(dim, "tbl", "t1"));
        sql.append(" WHERE t.fid = t1.fid)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        Object[] companys = (Object[])params.getObject("companys");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> companyIds = new HashSet<String>();
        CompanyOrgUnitInfo company = null;
        if (companys != null && companys.length > 0) {
            int length = companys.length;
            for (int i = 0; i < length; ++i) {
                company = (CompanyOrgUnitInfo)companys[i];
                companyIds.add(company.getId().toString());
            }
        } else {
            Set groupIncludeChildrenIds = (Set)params.getObject("groupIncludeChildrenIds");
            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)groupIncludeChildrenIds, CompareType.INCLUDE));
            view.setFilter(filter);
            OrgGroupCollection orgGroupColl = OrgGroupFactory.getLocalInstance(ctx).getOrgGroupCollection(view);
            int size = orgGroupColl.size();
            for (int i = 0; i < size; ++i) {
                companyIds.add(orgGroupColl.get(i).getCompany().getId().toString());
            }
        }
        int yearFrom = params.getInt("yearFrom");
        int monthFrom = params.getInt("monthFrom");
        int yearTo = params.getInt("yearTo");
        int monthTo = params.getInt("monthTo");
        sql.setLength(0);
        sql.append(" DELETE FROM ").append(dataFetchInfo.getTblName()).append(" as a");
        sql.append(" WHERE NOT EXISTS( select 1 from ").append(tempTable).append(" as b where a.fid = b.FRelatedID )");
        sql.append(" AND a.FCompany in (").append(CollectionUtil.convertSet2String(companyIds, ",", true)).append(")");
        sql.append(" AND (");
        sql.append(" a.FYear*100+a.FMonth >= ").append(yearFrom * 100 + monthFrom);
        sql.append(" and ").append(" a.FYear*100+a.FMonth <= ").append(yearTo * 100 + monthTo);
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected String getDimJoinOnSQL(List dim, String tbl, String other) {
        StringBuffer sql = new StringBuffer();
        String dimName = null;
        int size = dim.size();
        for (int i = 0; i < size; ++i) {
            dimName = (String)dim.get(i);
            if (i != 0) {
                sql.append(" AND ");
            }
            sql.append(" (").append(tbl).append(".").append(dimName).append("=").append(other).append(".").append(dimName);
            sql.append(" OR (").append(tbl).append(".").append(dimName).append(" IS NULL and ").append(other).append(".").append(dimName).append(" IS NULL)) ").append("\r\n");
        }
        return sql.toString();
    }
}

