/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextAreaCtrl;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.base.uiframe.client.LoginHelper;
import com.kingdee.eas.base.uiframe.client.MainFrame;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.util.XiaoYunUtil;
import com.kingdee.eas.base.xtsync.xtutil.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tm.td.common.BgPanel;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.ClientUpdateChecker;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExitSystemHelper;
import com.kingdee.eas.util.client.KsmUtil;
import com.kingdee.eas.util.client.MailUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.util.client.ReloginHelper;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;
import org.jdesktop.jdic.browser.IWebBrowser;

public class TaxAdvMsgBox
extends KDDialog {
    protected static final Logger logger = Logger.getLogger(TaxAdvMsgBox.class);
    protected boolean isDetail = false;
    IWebBrowser browser = null;
    protected String msg;
    protected String detail;
    protected int messageType;
    protected int option;
    protected String[] options;
    protected int result = 2;
    protected static Image imgInfoCue;
    protected static Image imgInfoAsk;
    protected static Image imgInfoError;
    protected static Image imgInfoAdvise;
    protected static final String CUE = "imgInfo_cue";
    protected static final String ASK = "imgInfo_ask";
    protected static final String ERROR = "imgInfo_error";
    protected static final String ADVISE = "imgInfo_advise";
    protected static final Color bottomBgColor;
    protected static final Color separatorColor;
    protected KDTextField userName;
    protected KDLabelContainer contUserName;
    protected KDTextField email;
    protected KDLabelContainer contEmail;
    protected KDTextField phone;
    protected KDLabelContainer contPhone;
    protected KDTextField title;
    protected KDLabelContainer contTitle;
    protected KDTextAreaCtrl txtDetail;
    protected JPanel bgPanel;
    protected KDButton btnFeedback;
    protected KDButton btnCancel;
    protected KDButton btnRetry;
    protected KDButton btnReConnection;
    protected KDButton btnQuitSystem;
    protected JPanel pnlBottom;
    protected KDTextArea msgLabel;
    private String screenShot;
    protected KDLabel lblXiaoYun;
    protected KDLabel lblXiaoYunTip;
    protected KDButton btnViewReport;
    protected static Map thisParams;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int NO_CANCEL_OPTION = 1234;
    public static final int OK_ONLY_OPTION = 3;
    public static final int OK_CANCEL_ADV_OPTION = 4;
    public static final int OK_ADV_OPTION = 5;
    public static final int DETAIL_OK_OPTION = 8188;
    public static final int YES_NO_OPTION = 8189;
    public static final int YES_NO_ADV_OPTION = 8190;
    public static final int OK_RETRY_OPTION = 6;
    public static final int YES_NO_CANCEL_ADV_OPTION = 7;
    public static final int REPORT_DETAIL_OK_OPTION = 9001;
    public static final int REPORT_YES_NO_CANCEL_ADV_OPTION = 9002;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    private static final String resName = "com.kingdee.eas.util.client.AdvMsgBox";

    public String getMsg() {
        return this.msg;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public static Image getImgInfoCue() {
        if (imgInfoCue == null) {
            imgInfoCue = EASResource.getImage((String)CUE);
        }
        return imgInfoCue;
    }

    public static Image getImgInfoAsk() {
        if (imgInfoAsk == null) {
            imgInfoAsk = EASResource.getImage((String)ASK);
        }
        return imgInfoAsk;
    }

    public static Image getImgInfoError() {
        if (imgInfoError == null) {
            imgInfoError = EASResource.getImage((String)ERROR);
        }
        return imgInfoError;
    }

    public static Image getImgInfoAdvise() {
        if (imgInfoAdvise == null) {
            imgInfoAdvise = EASResource.getImage((String)ADVISE);
        }
        return imgInfoAdvise;
    }

    public static TaxAdvMsgBox createAdvMsgBox(Component owner, String title, String msg, String detail, int messageType, int option) {
        return TaxAdvMsgBox.createAdvMsgBox(owner, title, msg, detail, messageType, option, null);
    }

    public static TaxAdvMsgBox createAdvMsgBox(Component owner, String title, String msg, String detail, int messageType, int option, Map params) {
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        thisParams = params;
        if (ownerWindow instanceof Frame) {
            return new TaxAdvMsgBox((Frame)ownerWindow, title, msg, detail, messageType, option);
        }
        if (ownerWindow instanceof Dialog) {
            return new TaxAdvMsgBox((Dialog)ownerWindow, title, msg, detail, messageType, option);
        }
        if (SystemEntry.instance.isWebStart()) {
            Frame myOwner = JOptionPane.getFrameForComponent(SystemEntry.instance.getApplet());
            return new TaxAdvMsgBox(myOwner, title, msg, detail, messageType, option);
        }
        return new TaxAdvMsgBox((Frame)null, title, msg, detail, messageType, option);
    }

    public TaxAdvMsgBox(Dialog owner, String title, String msg, String detail) {
        this(owner, title, msg, detail, 0, 5);
    }

    public TaxAdvMsgBox(Dialog owner, String title, String msg, String detail, int messageType, int option) {
        super(owner, title, true);
        this.init(msg, detail, messageType, option);
    }

    public TaxAdvMsgBox(Frame owner, String title, String msg, String detail) {
        this(owner, title, msg, detail, 0, 5);
    }

    public TaxAdvMsgBox(Frame owner, String title, String msg, String detail, int messageType, int option) {
        super(owner, title, true);
        this.init(msg, detail, messageType, option);
    }

    public TaxAdvMsgBox(Frame owner, String title, String msg, String detail, String[] options, int messageType, int option) {
        super(owner, title, true);
        this.init(msg, detail, options, messageType, option);
    }

    public TaxAdvMsgBox(Dialog owner, String title, String msg, String detail, String[] options, int messageType, int option) {
        super(owner, title, true);
        this.init(msg, detail, options, messageType, option);
    }

    public TaxAdvMsgBox(Frame owner, String title, boolean b) {
        super(owner, title, true);
    }

    public TaxAdvMsgBox(Dialog owner, String title, boolean b) {
        super(owner, title, true);
    }

    public int getResult() {
        return this.result;
    }

    protected void init(String msg, String detail, int messageType, int option) {
        this.msg = msg;
        this.detail = detail;
        this.messageType = messageType;
        this.option = option;
        this.jbInit();
    }

    protected void init(String msg, String detail, String[] options, int messageType, int option) {
        this.msg = msg;
        this.detail = detail;
        this.messageType = messageType;
        this.option = option;
        this.options = options;
        this.jbInit();
    }

    protected void jbInit() {
        this.jbInit(null);
    }

    private void setStatusMessage(String text) {
        IUIObject o = SystemEntry.instance.getMainUIObject().getSelectedUIObject();
        if (o instanceof CoreUI) {
            CoreUI ui = (CoreUI)o;
            ui.setMessageText(text);
            ui.showMessage();
        }
    }

    protected void jbInit(JPanel bgPanel1) {
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(null);
        this.bgPanel = bgPanel1 == null ? (this.messageType == 1 ? new BgPanel(TaxAdvMsgBox.getImgInfoCue(), this.msg) : (this.messageType == 2 ? new BgPanel(TaxAdvMsgBox.getImgInfoAdvise(), this.msg) : (this.messageType == 3 ? new BgPanel(TaxAdvMsgBox.getImgInfoAsk(), this.msg) : new BgPanel(TaxAdvMsgBox.getImgInfoError(), this.msg)))) : bgPanel1;
        final Dimension bgPanelDimension = this.bgPanel.getPreferredSize();
        int normalBottomHeight = 42;
        int advanceBottomHeight = 202;
        contentPane.setPreferredSize(new Dimension(bgPanelDimension.width, bgPanelDimension.height + 42));
        this.bgPanel.setBounds(0, 0, bgPanelDimension.width, bgPanelDimension.height);
        contentPane.add(this.bgPanel);
        this.pnlBottom = new JPanel();
        this.pnlBottom.setLayout(null);
        this.pnlBottom.setBounds(0, bgPanelDimension.height, bgPanelDimension.width, 202);
        contentPane.add(this.pnlBottom);
        this.pnlBottom.setBackground(bottomBgColor);
        KDSeparator sp = new KDSeparator();
        sp.setBounds(0, 0, bgPanelDimension.width, 2);
        this.pnlBottom.add((Component)sp);
        KDButton btnSendMail = new KDButton(EASResource.getString((String)"sendMail"));
        btnSendMail.setMargin(new Insets(2, 1, 2, 1));
        btnSendMail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxAdvMsgBox.this.dispose();
                MailUtil.sendMailToKingdee((String)TaxAdvMsgBox.this.msg, (String)TaxAdvMsgBox.this.detail);
            }
        });
        this.btnRetry = new KDButton(EASResource.getString((String)"relogin"));
        this.btnRetry.setMargin(new Insets(2, 1, 2, 1));
        this.btnRetry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxAdvMsgBox.this.dispose();
                if (TaxAdvMsgBox.this.needUpdateClient()) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.util.client.AdvMsgBox.needUpdateClient"));
                    try {
                        ExitSystemHelper.preparedExit();
                        LoginHelper.logout();
                        MainFrame.closeApplicationWhenSessionTimeOut();
                    }
                    catch (Throwable ee) {
                        logger.error((Object)"close windows occur error!", ee);
                        System.exit(-1);
                    }
                }
                try {
                    SystemEntry.instance.innerReLogin();
                    TaxAdvMsgBox.this.setStatusMessage(EASResource.getString((String)"reconnectionSuccess"));
                }
                catch (Exception exc) {
                    logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)exc));
                    MsgBox.showConnectionError();
                }
            }
        });
        KDButton btnAdv = new KDButton(EASResource.getString((String)"advance"));
        btnAdv.setMargin(new Insets(2, 1, 2, 1));
        btnAdv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanel contentPane = (JPanel)TaxAdvMsgBox.this.getContentPane();
                if (TaxAdvMsgBox.this.isDetail) {
                    contentPane.setPreferredSize(new Dimension(bgPanelDimension.width, bgPanelDimension.height + 42));
                    TaxAdvMsgBox.this.pack();
                    TaxAdvMsgBox.this.isDetail = false;
                } else {
                    contentPane.setPreferredSize(new Dimension(bgPanelDimension.width, bgPanelDimension.height + 202));
                    TaxAdvMsgBox.this.pack();
                    TaxAdvMsgBox.this.isDetail = true;
                }
            }
        });
        KDButton btnOK = new KDButton(EASResource.getString((String)"ok"));
        btnOK.setMargin(new Insets(2, 1, 2, 1));
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxAdvMsgBox.this.result = 0;
                TaxAdvMsgBox.this.dispose();
            }
        });
        this.btnCancel = this.options == null ? new KDButton(EASResource.getString((String)"cancel")) : new KDButton(this.options[2]);
        this.btnCancel.setMargin(new Insets(2, 1, 2, 1));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxAdvMsgBox.this.result = 2;
                TaxAdvMsgBox.this.dispose();
            }
        });
        this.btnViewReport = new KDButton("\u67e5\u770b\u68c0\u67e5\u62a5\u544a");
        this.btnViewReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxAdvMsgBox.this.result = 99;
                TaxAdvMsgBox.this.dispose();
            }
        });
        this.btnFeedback = new KDButton(EASResource.getString((String)"feedback"));
        this.btnFeedback.setMargin(new Insets(2, 1, 2, 1));
        this.btnFeedback.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.lblXiaoYun = new KDLabel();
        this.lblXiaoYun.setName("lblXiaoYun");
        this.lblXiaoYun.setBorder(BorderFactory.createEmptyBorder());
        this.lblXiaoYun.setPreferredSize(new Dimension(32, 32));
        this.lblXiaoYun.setIcon(EASResource.getIcon((String)"image_xiaoyun32"));
        this.lblXiaoYun.setToolTipText("\u70b9\u51fb\u53ef\u8be2\u95ee\u5c0fK");
        this.lblXiaoYun.setOpaque(false);
        this.lblXiaoYun.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    TaxAdvMsgBox.this.action_lblXiaoYun_Clicked();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to open XiaoYun!", (Throwable)ex);
                    if (RPCException.getErrorCode((Throwable)ex) == 500) {
                        MsgBox.showWarning((String)"\u4e0e\u7cfb\u7edf\u7684\u8fde\u63a5\u5df2\u4e2d\u65ad\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u7cfb\u7edf");
                    }
                    MsgBox.showWarning((String)"Failed to open XiaoYun,please check the logs");
                }
            }
        });
        Thread t = null;
        try {
            t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean flag = TaxAdvMsgBox.this.checkXiaoYunAnswer();
                        if (flag) {
                            if (TaxAdvMsgBox.this.lblXiaoYunTip.getX() == 10 && TaxAdvMsgBox.this.lblXiaoYunTip.getY() == 5) {
                                TaxAdvMsgBox.this.lblXiaoYunTip.setVisible(true);
                                TaxAdvMsgBox.this.lblXiaoYunTip.revalidate();
                                TaxAdvMsgBox.this.lblXiaoYun.revalidate();
                                TaxAdvMsgBox.this.lblXiaoYun.repaint();
                            } else {
                                TaxAdvMsgBox.this.lblXiaoYun.setToolTipText("\u5c0fK\u5df2\u4e3a\u60a8\u627e\u5230\u89e3\u51b3\u65b9\u6848,\u8bf7\u70b9\u51fb\u6211\u67e5\u770b");
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to checkXiaoYunAnswer" + e));
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)("Failed to checkXiaoYunAnswer" + e));
        }
        this.lblXiaoYunTip = new KDLabel();
        this.lblXiaoYunTip.setText("\u5c0fK\u5df2\u4e3a\u60a8\u627e\u5230\u89e3\u51b3\u65b9\u6848,\u8bf7\u70b9\u51fb\u6211\u67e5\u770b");
        this.btnReConnection = this.options == null ? new KDButton(EASResource.getString((String)"reConnection")) : new KDButton(this.options[2]);
        this.btnReConnection.setMargin(new Insets(2, 1, 2, 1));
        this.btnReConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxAdvMsgBox.this.result = 2;
                TaxAdvMsgBox.this.dispose();
                if (TaxAdvMsgBox.this.needUpdateClient()) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.util.client.AdvMsgBox.needUpdateClient"));
                    try {
                        ExitSystemHelper.preparedExit();
                        LoginHelper.logout();
                        MainFrame.closeApplicationWhenSessionTimeOut();
                    }
                    catch (Throwable ee) {
                        logger.error((Object)"close windows occur error!", ee);
                        System.exit(-1);
                    }
                }
                try {
                    ReloginHelper.getInstance().relogin();
                    TaxAdvMsgBox.this.setStatusMessage(EASResource.getString((String)"reconnectionSuccess"));
                }
                catch (Exception e1) {
                    logger.error((Object)"connection error:", (Throwable)e1);
                    MsgBox.showConnectionError();
                }
            }
        });
        KDButton btnYes = null;
        btnYes = this.options == null ? new KDButton(EASResource.getString((String)"yes")) : new KDButton(this.options[0]);
        btnYes.setMargin(new Insets(2, 1, 2, 1));
        btnYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxAdvMsgBox.this.result = 0;
                TaxAdvMsgBox.this.dispose();
            }
        });
        KDButton btnNo = null;
        btnNo = this.options == null ? new KDButton(EASResource.getString((String)"no")) : new KDButton(this.options[1]);
        btnNo.setMargin(new Insets(2, 1, 2, 1));
        btnNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxAdvMsgBox.this.result = 1;
                TaxAdvMsgBox.this.dispose();
            }
        });
        this.btnQuitSystem = new KDButton(EASResource.getString((String)"quitSystem"));
        this.btnQuitSystem.setMargin(new Insets(2, 1, 2, 1));
        this.btnQuitSystem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExitSystemHelper.preparedExit();
                    LoginHelper.logout();
                    MainFrame.closeApplicationWhenSessionTimeOut();
                }
                catch (Throwable ee) {
                    logger.error((Object)"close windows occur error!", ee);
                    System.exit(-1);
                }
            }
        });
        if (this.option == 8188) {
            btnOK.setBounds(342, 11, 77, 21);
            btnAdv.setBounds(262, 11, 77, 21);
            this.lblXiaoYun.setBounds(225, 5, 32, 32);
            this.lblXiaoYunTip.setBounds(10, 5, 210, 32);
            this.pnlBottom.add((Component)btnAdv);
            this.pnlBottom.add((Component)btnOK);
            this.pnlBottom.add((Component)this.lblXiaoYun);
            this.pnlBottom.add((Component)this.lblXiaoYunTip);
            this.lblXiaoYunTip.setVisible(false);
            t.start();
            this.setDefaultFocus((Component)btnOK);
        } else if (this.option == 9001) {
            btnOK.setBounds(342, 11, 77, 21);
            this.btnViewReport.setBounds(132, 11, 120, 21);
            btnAdv.setBounds(258, 11, 77, 21);
            this.pnlBottom.add((Component)btnAdv);
            this.pnlBottom.add((Component)btnOK);
            this.pnlBottom.add((Component)this.btnViewReport);
            t.start();
            this.setDefaultFocus((Component)btnOK);
        } else if (this.option == 9002) {
            btnYes.setBounds(260, 11, 77, 21);
            btnNo.setBounds(345, 11, 77, 21);
            btnAdv.setBounds(175, 11, 77, 21);
            this.btnViewReport.setBounds(10, 11, 120, 21);
            this.pnlBottom.add((Component)btnYes);
            this.pnlBottom.add((Component)btnNo);
            this.pnlBottom.add((Component)this.btnViewReport);
            this.pnlBottom.add((Component)btnAdv);
        } else if (this.option == 8189) {
            btnYes.setBounds(262, 11, 77, 21);
            btnNo.setBounds(342, 11, 77, 21);
            this.pnlBottom.add((Component)btnYes);
            this.pnlBottom.add((Component)btnNo);
            this.setDefaultFocus((Component)btnYes);
        } else if (this.messageType == 1) {
            btnOK.setBounds(342, 11, 77, 21);
            this.pnlBottom.add((Component)btnOK);
        } else if (this.messageType == 2) {
            btnOK.setBounds(342, 11, 77, 21);
            this.pnlBottom.add((Component)btnOK);
        } else if (this.messageType == 3) {
            if (this.option == 2) {
                btnOK.setBounds(257, 11, 77, 21);
                this.btnCancel.setBounds(342, 11, 77, 21);
                this.pnlBottom.add((Component)btnOK);
                this.pnlBottom.add((Component)this.btnCancel);
            } else if (this.option == 1) {
                btnYes.setBounds(172, 11, 77, 21);
                btnNo.setBounds(257, 11, 77, 21);
                this.btnCancel.setBounds(342, 11, 77, 21);
                this.pnlBottom.add((Component)btnYes);
                this.pnlBottom.add((Component)btnNo);
                this.pnlBottom.add((Component)this.btnCancel);
            } else if (this.option == 1234) {
                btnNo.setBounds(192, 11, 77, 21);
                this.btnCancel.setBounds(342, 11, 77, 21);
                this.pnlBottom.add((Component)btnNo);
                this.pnlBottom.add((Component)this.btnCancel);
            } else if (this.option == 8190) {
                btnYes.setBounds(257, 11, 77, 21);
                btnNo.setBounds(342, 11, 77, 21);
                btnAdv.setBounds(10, 11, 77, 21);
                this.pnlBottom.add((Component)btnYes);
                this.pnlBottom.add((Component)btnNo);
                this.pnlBottom.add((Component)btnAdv);
                this.setDefaultFocus((Component)btnOK);
            } else if (this.option == 4) {
                btnOK.setBounds(257, 11, 77, 21);
                this.btnCancel.setBounds(342, 11, 77, 21);
                btnAdv.setBounds(10, 11, 77, 21);
                this.pnlBottom.add((Component)btnOK);
                this.pnlBottom.add((Component)this.btnCancel);
                this.pnlBottom.add((Component)btnAdv);
                this.setDefaultFocus((Component)btnOK);
            } else {
                btnYes.setBounds(172, 11, 77, 21);
                btnNo.setBounds(257, 11, 77, 21);
                this.btnCancel.setBounds(342, 11, 77, 21);
                btnAdv.setBounds(10, 11, 77, 21);
                this.pnlBottom.add((Component)btnYes);
                this.pnlBottom.add((Component)btnNo);
                this.pnlBottom.add((Component)this.btnCancel);
                this.pnlBottom.add((Component)btnAdv);
            }
        } else if (this.messageType == 0) {
            if (this.option == 6) {
                this.btnReConnection.setBounds(172, 11, 77, 21);
                this.btnFeedback.setBounds(10, 11, 77, 21);
                this.btnRetry.setBounds(257, 11, 77, 21);
                this.btnQuitSystem.setBounds(342, 11, 77, 21);
                this.pnlBottom.add((Component)this.btnRetry);
                this.pnlBottom.add((Component)this.btnReConnection);
                this.pnlBottom.add((Component)this.btnFeedback);
                this.pnlBottom.add((Component)this.btnQuitSystem);
                this.setDefaultFocus((Component)this.btnRetry);
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent we) {
                        if (MsgBox.showConfirm2((String)EASResource.getString((String)"cnFailWillExit")) == 0) {
                            System.exit(0);
                        }
                    }
                });
            } else if (this.option == 5) {
                this.btnCancel.setText(EASResource.getString((String)"ignore"));
                this.btnCancel.addKeyListener((KeyListener)new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        TaxAdvMsgBox.this.respondToKeyPressing(e, bgPanelDimension, 42, 202);
                    }
                });
                this.btnQuitSystem.addKeyListener((KeyListener)new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        TaxAdvMsgBox.this.respondToKeyPressing(e, bgPanelDimension, 42, 202);
                    }
                });
                this.btnReConnection.setBounds(172, 11, 77, 21);
                this.btnFeedback.setBounds(10, 11, 77, 21);
                this.btnQuitSystem.setBounds(257, 11, 77, 21);
                this.btnCancel.setBounds(342, 11, 77, 21);
                this.lblXiaoYun.setBounds(110, 5, 32, 32);
                t.start();
                this.pnlBottom.add((Component)this.btnReConnection);
                this.pnlBottom.add((Component)this.btnFeedback);
                this.pnlBottom.add((Component)this.btnQuitSystem);
                this.pnlBottom.add((Component)this.btnCancel);
                this.pnlBottom.add((Component)this.lblXiaoYun);
                this.setDefaultFocus((Component)this.btnCancel);
            } else {
                btnOK.setBounds(342, 11, 77, 21);
                this.pnlBottom.add((Component)btnOK);
            }
        }
        this.txtDetail = new KDTextAreaCtrl();
        this.txtDetail.getTextComponent().setEditable(false);
        this.txtDetail.setText(this.detail);
        this.txtDetail.setSelectionStart(0);
        this.txtDetail.setSelectionEnd(0);
        this.txtDetail.setBounds(10, 43, 409, 150);
        this.txtDetail.getTextComponent().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TaxAdvMsgBox.this.respondToKeyPressing(e, bgPanelDimension, 42, 202);
            }
        });
        this.pnlBottom.add((Component)this.txtDetail);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    protected void respondToKeyPressing(KeyEvent e, Dimension bgPanelDimension, int normalBottomHeight, int advanceBottomHeight) {
        if (e.getKeyCode() == 69 && e.isControlDown()) {
            JPanel contentPane = (JPanel)this.getContentPane();
            if (this.isDetail) {
                contentPane.setPreferredSize(new Dimension(bgPanelDimension.width, bgPanelDimension.height + normalBottomHeight));
                this.pack();
                this.isDetail = false;
            } else {
                contentPane.setPreferredSize(new Dimension(bgPanelDimension.width, bgPanelDimension.height + advanceBottomHeight));
                this.pack();
                this.isDetail = true;
            }
        }
    }

    protected void setDefaultFocus(final Component comp) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                comp.requestFocusInWindow();
            }
        });
    }

    public static void main(String[] args) throws Exception {
        String detail = "dkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdkdkdkdkdkdkdkddkdkdkdk";
        MsgBox.showError(null, (String)"dkdkdkdkd", (String)detail);
        System.exit(0);
    }

    private static Locale getCurLocale() {
        try {
            return SysContext.getSysContext().getOriginLocale();
        }
        catch (Throwable e) {
            return LocaleUtils.locale_zh_CN;
        }
    }

    public static String getResString(String key) {
        return ResourceBase.getString((String)resName, (String)key, (Locale)TaxAdvMsgBox.getCurLocale());
    }

    private void oneKeyKSM(String screenShot) throws ServiceException, BOSException, IOException, LicenseException {
        String user = this.userName.getText();
        String productno = LicenseSrvAgentFactory.getRemoteInstance().getProductNo();
        String email = this.email.getText();
        String title = this.title.getText();
        String desc = this.txtDetail.getText();
        String phone = this.phone.getText();
        if (StringUtils.isEmpty((String)productno)) {
            this.showMsg(TaxAdvMsgBox.getResString("getProNoFail"));
            return;
        }
        if (StringUtils.isEmpty((String)user)) {
            this.showMsg(TaxAdvMsgBox.getResString("userNameVal"));
            return;
        }
        if (StringUtils.isEmpty((String)email) || !KsmUtil.matcheInfomation((String)email, (String)"^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$")) {
            this.showMsg(TaxAdvMsgBox.getResString("mailVal"));
            return;
        }
        if (StringUtils.isEmpty((String)phone) || !KsmUtil.matcheInfomation((String)phone, (String)"^\\d{11}$")) {
            this.showMsg(TaxAdvMsgBox.getResString("phoneNumVal"));
            return;
        }
        if (StringUtils.isEmpty((String)title)) {
            this.showMsg(TaxAdvMsgBox.getResString("titleVal"));
            return;
        }
        if (title.length() > 30) {
            this.showMsg(TaxAdvMsgBox.getResString("titleLengthVal"));
            return;
        }
        if (StringUtils.isEmpty((String)desc)) {
            this.showMsg(TaxAdvMsgBox.getResString("descVal"));
            return;
        }
        if (desc.length() < 30) {
            this.showMsg(TaxAdvMsgBox.getResString("desc2Short"));
            return;
        }
        if (desc.length() > 200) {
            this.showMsg(TaxAdvMsgBox.getResString("desc2Long"));
            return;
        }
        String msg = KsmUtil.saveFeedBackWithFiles((String)productno, (String)user, (String)phone, (String)email, (String)title, (String)desc, (String)this.detail, (String)screenShot);
        if (!StringUtils.isEmpty((String)msg)) {
            if (msg.startsWith("failed!")) {
                msg = msg.substring("failed!".length());
                this.showMsg(msg);
            } else {
                this.showMsg(TaxAdvMsgBox.getResString("submitSucc") + ":" + msg + "\uff0c" + TaxAdvMsgBox.getResString("userNameVal"));
            }
        }
    }

    private String getScreenShot() {
        return null;
    }

    private void showMsg(String msg) {
        MsgBox.showInfo((String)msg);
    }

    private void initKsmFields() {
        this.screenShot = this.getScreenShot();
        this.contUserName = new KDLabelContainer();
        this.contUserName.setName("contUserName");
        this.contUserName.setBoundLabelText(TaxAdvMsgBox.getResString("applier"));
        this.contUserName.setBoundLabelLength(100);
        this.contUserName.setBoundLabelUnderline(true);
        this.contUserName.setBounds(new Rectangle(10, 10, 400, 18));
        this.userName = new KDTextField();
        this.userName.setCustomForegroundColor(Color.gray);
        this.userName.setName("txtUserName");
        this.userName.setMaxLength(100);
        this.userName.setCustomForegroundColor(Color.blue);
        this.contUserName.setBoundEditor((JComponent)this.userName);
        this.add((Component)this.contUserName, null);
        this.contEmail = new KDLabelContainer();
        this.contEmail.setName("contEmail");
        this.contEmail.setBoundLabelText(TaxAdvMsgBox.getResString("email"));
        this.contEmail.setBoundLabelLength(100);
        this.contEmail.setBoundLabelUnderline(true);
        this.contEmail.setBounds(new Rectangle(10, 38, 400, 18));
        this.email = new KDTextField();
        this.email.setCustomForegroundColor(Color.gray);
        this.email.setName("txtEmail");
        this.email.setMaxLength(100);
        this.email.setCustomForegroundColor(Color.blue);
        this.contEmail.setBoundEditor((JComponent)this.email);
        this.add((Component)this.contEmail, null);
        this.contPhone = new KDLabelContainer();
        this.contPhone.setName("contPhone");
        this.contPhone.setBoundLabelText(TaxAdvMsgBox.getResString("mobile"));
        this.contPhone.setBoundLabelLength(100);
        this.contPhone.setBoundLabelUnderline(true);
        this.contPhone.setBounds(new Rectangle(10, 66, 400, 18));
        this.phone = new KDTextField();
        this.phone.setCustomForegroundColor(Color.gray);
        this.phone.setName("txtPhone");
        this.phone.setMaxLength(100);
        this.phone.setCustomForegroundColor(Color.blue);
        this.contPhone.setBoundEditor((JComponent)this.phone);
        this.add((Component)this.contPhone, null);
        this.contTitle = new KDLabelContainer();
        this.contTitle.setName("contTitle");
        this.contTitle.setBoundLabelText(TaxAdvMsgBox.getResString("title"));
        this.contTitle.setBoundLabelLength(100);
        this.contTitle.setBoundLabelUnderline(true);
        this.contTitle.setBounds(new Rectangle(10, 94, 400, 18));
        this.title = new KDTextField();
        this.title.setCustomForegroundColor(Color.gray);
        this.title.setName("txtPhone");
        this.title.setMaxLength(100);
        this.title.setCustomForegroundColor(Color.blue);
        this.contTitle.setBoundEditor((JComponent)this.title);
        this.add((Component)this.contTitle, null);
        this.txtDetail.setEditable(true);
        final String detailDesc = TaxAdvMsgBox.getResString("descVal");
        this.txtDetail.setText(detailDesc);
        this.txtDetail.getTextComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (detailDesc != null && detailDesc.equals(TaxAdvMsgBox.this.txtDetail.getText())) {
                    TaxAdvMsgBox.this.txtDetail.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                String text = TaxAdvMsgBox.this.txtDetail.getText();
                if (text == null || text.trim().isEmpty()) {
                    TaxAdvMsgBox.this.txtDetail.setText(detailDesc);
                }
            }
        });
        Dimension bgPanelDimension = this.bgPanel.getPreferredSize();
        JPanel contentPane = (JPanel)this.getContentPane();
        int advanceBottomHeight = 202;
        contentPane.setPreferredSize(new Dimension(bgPanelDimension.width, bgPanelDimension.height + 202));
        this.pack();
        this.bgPanel.setVisible(false);
        this.setTitle(TaxAdvMsgBox.getResString("windowTitle"));
        this.btnFeedback.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnRetry.setVisible(false);
        this.btnReConnection.setVisible(false);
        this.btnQuitSystem.setVisible(false);
        this.lblXiaoYun.setVisible(false);
        this.lblXiaoYunTip.setVisible(false);
        KDButton submitFeedback = new KDButton(TaxAdvMsgBox.getResString("windowTitle"));
        submitFeedback.setMargin(new Insets(2, 1, 2, 1));
        submitFeedback.setBounds(10, 11, 77, 21);
        this.pnlBottom.add((Component)submitFeedback);
        submitFeedback.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TaxAdvMsgBox.this.oneKeyKSM(TaxAdvMsgBox.this.screenShot);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                    MsgBox.showWarning((String)TaxAdvMsgBox.getResString("submitFeedbackFail"));
                }
            }
        });
        this.msgLabel = new KDTextArea(TaxAdvMsgBox.getResString("submitInfo"));
        this.msgLabel.setBounds(new Rectangle(10, 125, 400, 30));
        this.msgLabel.setEditable(false);
        this.msgLabel.setLineWrap(true);
        EmptyBorder emptyBorder = (EmptyBorder)BorderFactory.createEmptyBorder();
        this.msgLabel.setBorder((Border)emptyBorder);
        this.msgLabel.setCustomForegroundColor(Color.blue);
        this.add((Component)this.msgLabel, null);
        this.msgLabel.setVisible(true);
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        try {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("email"));
            selectors.add(new SelectorItemInfo("cell"));
            selectors.add(new SelectorItemInfo("name"));
            user = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(user.getId()), selectors);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        if (user != null) {
            String email = user.getEmail();
            String phone = user.getCell();
            String name = user.getName();
            this.userName.setText(name);
            this.email.setText(email);
            this.phone.setText(phone);
        }
    }

    private void action_lblXiaoYun_Clicked() throws Exception {
        if (!XiaoYunUtil.checkUrlEasKsm()) {
            return;
        }
        ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
        LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        UserInfo userInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(user.getId()));
        String uId = userInfo.getUid();
        if (uId == null) {
            MsgBox.showWarning((String)"\u65e0\u91d1\u8776\u4e91\u901a\u884c\u8bc1\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u7533\u8bf7\u4e91\u901a\u884c\u8bc1");
            return;
        }
        String productInstanceID = baseInfo.getProductInstanceID();
        if (productInstanceID == null) {
            MsgBox.showWarning((String)"\u4ea7\u54c1\u5b9e\u4f8b\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
            return;
        }
        String authCode = this.getAuthCode(uId, productInstanceID, true);
        String source = "eas";
        String productNo = agent.getProductNo();
        String question = this.getXiaoYunQuestion();
        if (!StringUtil.isEmpty((String)question) && question.length() > 1500) {
            question = question.substring(0, 1500);
        }
        if (authCode != null) {
            StringBuffer bf = new StringBuffer();
            bf.append("http://club.kingdee.com/club/auth/login?auth_code=").append(authCode).append("&callback=").append(URLEncoder.encode(new StringBuffer("http://club.kingdee.com/club/services/imcc?productNo=").append(productNo).append("&source=").append(source).append("&question=").append(URLEncoder.encode(question, "utf-8")).append("&showq=1").toString(), "utf-8"));
            logger.error((Object)("question:" + question));
            logger.info((Object)("url:" + bf));
            FrameWorkUtils.openByDefaultBrowser((String)bf.toString());
        }
    }

    private boolean checkXiaoYunAnswer() throws Exception {
        if (!XiaoYunUtil.checkUrlEasKsmWithoutTip()) {
            return false;
        }
        ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
        LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        UserInfo userInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(user.getId()));
        String uId = userInfo.getUid();
        String productInstanceID = baseInfo.getProductInstanceID();
        if (uId == null || productInstanceID == null) {
            return false;
        }
        String authCode = this.getAuthCode(uId, baseInfo.getProductInstanceID(), false);
        if (authCode == null) {
            return false;
        }
        String source = "eas";
        String productNo = agent.getProductNo();
        String question = this.getXiaoYunQuestion();
        if (!StringUtil.isEmpty((String)question) && question.length() > 1500) {
            question = question.substring(0, 1500);
        }
        String url = "http://club.kingdee.com/club/auth/login";
        StringBuffer bf = new StringBuffer();
        bf.append("auth_code=").append(authCode).append("&callback=").append(URLEncoder.encode(new StringBuffer("http://club.kingdee.com/club/services/imcc?productNo=").append(productNo).append("&source=").append(source).append("&question=").append(URLEncoder.encode(question, "utf-8")).append("&checkAnswer=1").toString(), "utf-8"));
        logger.info((Object)("question:" + question));
        logger.info((Object)bf);
        JSONObject o = XiaoYunUtil.doGet((String)url, (String)bf.toString());
        JSONArray robotAnswer = (JSONArray)JSONObject.parseObject((String)o.getString("data")).get((Object)"robotAnswer");
        Object ansCon = ((Map)robotAnswer.get(0)).get("ansCon");
        return !"\u60a8\u7684\u95ee\u9898\u592a\u957f\u6216\u8005\u6ca1\u6709\u4efb\u4f55\u95ee\u9898\uff0c\u6211\u7406\u89e3\u4e0d\u4e86\uff0c\u6362\u79cd\u95ee\u6cd5\u6765\u95ee\u6211\u5427..".equals(ansCon);
    }

    private String getXiaoYunQuestion() {
        String question = this.msg;
        if (!StringUtil.isEmpty((String)this.detail)) {
            question = question + "\n" + this.detail;
        }
        logger.info((Object)("question:" + question));
        return question;
    }

    private String getAuthCode(String uId, String prod_inst_code, boolean isShowMsg) throws Exception {
        String authCode = null;
        JSONObject o = EasCloud.cloudErpAccessToken((String)uId, (String)prod_inst_code);
        if (o.getInteger("errcode") == 0) {
            JSONObject data = JSONObject.parseObject((String)o.getString("data"));
            String access_token = data.getString("access_token");
            System.out.println("com.kingdee.eas.base.uiframe.EasCloud.getUserAuthCode(" + access_token + ")");
            JSONObject authCodeJson = EasCloud.getUserAuthCode((String)access_token);
            if (authCodeJson.getInteger("errcode") == 0) {
                JSONObject authCodeObject = JSONObject.parseObject((String)authCodeJson.getString("data"));
                authCode = authCodeObject.getString("auth_code");
            } else {
                if (isShowMsg) {
                    String description = authCodeJson.getString("description_cn");
                    if (StringUtil.isEmpty((String)description)) {
                        description = authCodeJson.getString("description");
                    }
                    MsgBox.showWarning((String)description);
                }
                logger.error((Object)("Failed to get AuthCode. " + authCodeJson));
            }
        } else if (isShowMsg) {
            String description = o.getString("description_cn");
            if (StringUtil.isEmpty((String)description)) {
                description = o.getString("description");
            }
            MsgBox.showWarning((String)description);
            logger.error((Object)("Failed to get AccessToken. " + o));
        }
        return authCode;
    }

    private boolean needUpdateClient() {
        try {
            return this.doCheckUpdate();
        }
        catch (Throwable e) {
            logger.warn((Object)e);
            return false;
        }
    }

    private boolean doCheckUpdate() throws IOException {
        boolean needUpdate = new ClientUpdateChecker().needUpdate();
        return needUpdate;
    }

    static {
        bottomBgColor = new Color(230, 230, 230);
        separatorColor = new Color(180, 180, 180);
        thisParams = null;
    }
}

