/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.directdeclare.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.DraftStatusEnum;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.basedata.TaxBaseInfo;
import com.kingdee.eas.tm.td.directdeclare.TeAreaInfo;
import com.kingdee.eas.tm.td.directdeclare.TeException;
import com.kingdee.eas.tm.td.directdeclare.TeServiceInfo;
import com.kingdee.eas.tm.td.directdeclare.TeTransTypeEnum;
import com.kingdee.eas.tm.td.directdeclare.app.AbstractTeFacadeControllerBean;
import com.kingdee.eas.tm.td.directdeclare.comm.model.TePwyParam;
import com.kingdee.eas.tm.td.directdeclare.comm.service.ITePwyService;
import com.kingdee.eas.tm.td.directdeclare.comm.util.TeDefinition;
import com.kingdee.eas.tm.td.directdeclare.comm.util.TePwyHelper;
import com.kingdee.eas.tm.td.directdeclare.comm.util.TePwyServiceHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TeFacadeControllerBean
extends AbstractTeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.directdeclare.app.TeFacadeControllerBean");

    @Override
    protected Map _getTeConfig(Context ctx) throws BOSException, EASBizException {
        return TeDefinition.getInstance().getTeMap();
    }

    @Override
    protected Map _buildPwyParam(Context ctx, Map params) throws BOSException, EASBizException {
        Set ids = (Set)params.get("ids");
        TeTransTypeEnum transType = (TeTransTypeEnum)((Object)params.get("transType"));
        TeServiceInfo teServiceInfo = TePwyHelper.getTeServiceInfo(ctx);
        if (teServiceInfo == null) {
            throw new TeException(TeException.TESERVICENOTFOUND);
        }
        ArrayList<TePwyParam> paramList = new ArrayList<TePwyParam>();
        ArrayList<String> exceptionList = new ArrayList<String>();
        TePwyParam pwyParam = null;
        String billID2 = null;
        String errorMsg = null;
        for (String billID2 : ids) {
            TaxDraftRecordInfo reportInfo = TaxDraftRecordFactory.getLocalInstance(ctx).getTaxDraftRecordInfo((IObjectPK)new ObjectUuidPK(billID2));
            if (!DraftStatusEnum.AUDIT.equals((Object)reportInfo.getDraftStatus())) {
                errorMsg = new TeException(TeException.DECLARESTATUSERROR, new Object[]{reportInfo.getNumber(), reportInfo.getName()}).getMessage();
                exceptionList.add(errorMsg);
                continue;
            }
            TaxBaseInfo taxBaseInfo = TePwyHelper.getTaxBaseInfo(ctx, reportInfo.getCompanyOrgUnit());
            if (taxBaseInfo == null) {
                errorMsg = new TeException(TeException.TAXBASENOTFOUND, new Object[]{reportInfo.getNumber(), reportInfo.getName()}).getMessage();
                exceptionList.add(errorMsg);
                continue;
            }
            if (transType == null && (transType = TePwyHelper.getTeTransType(reportInfo.getTaxType(), reportInfo.getRecordType(), taxBaseInfo.getTaxpayerType())) == null) {
                errorMsg = new TeException(TeException.TRANSTYPENOTSUPPORT, new Object[]{reportInfo.getNumber(), reportInfo.getName()}).getMessage();
                exceptionList.add(errorMsg);
                continue;
            }
            TeAreaInfo teAreaInfo = TePwyHelper.getTeAreaInfo(ctx, taxBaseInfo.getRegistProvince(), taxBaseInfo.getRegistCity(), taxBaseInfo.getRegistRegion());
            if (teAreaInfo == null) {
                errorMsg = new TeException(TeException.TEAREANOTFOUND, new Object[]{reportInfo.getNumber(), reportInfo.getName()}).getMessage();
                exceptionList.add(errorMsg);
                continue;
            }
            pwyParam = new TePwyParam();
            pwyParam.setTeServiceInfo(teServiceInfo);
            pwyParam.setReportInfo(reportInfo);
            pwyParam.setTaxBaseInfo(taxBaseInfo);
            pwyParam.setTransType(transType);
            pwyParam.setTeAreaInfo(teAreaInfo);
            if (TePwyServiceHelper.isNeedDeclareData(transType)) {
                pwyParam.setDeclareData(TePwyHelper.getDeclarceData(ctx, billID2));
                pwyParam.setDeclareDetailData(TePwyHelper.getDeclarceDetailData(ctx, billID2));
                pwyParam.setVmModule(TePwyHelper.getVmModule(teAreaInfo, transType));
            }
            paramList.add(pwyParam);
        }
        HashMap<String, ArrayList<Object>> ret = new HashMap<String, ArrayList<Object>>();
        ret.put("paramList", paramList);
        ret.put("exception", exceptionList);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Map _invoke(Context ctx, Map params) throws BOSException, EASBizException {
        Map retMap = this._buildPwyParam(ctx, params);
        List paramList = (List)retMap.get("paramList");
        List exceptionList = (List)retMap.get("exception");
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("exception", exceptionList);
        if (paramList == null || paramList.size() == 0) {
            return map;
        }
        String accessToken = null;
        TeServiceInfo teServiceInfo = null;
        try {
            teServiceInfo = TePwyHelper.getTeServiceInfo(ctx);
            String appToken = null;
            appToken = TePwyHelper.getAppToken(teServiceInfo);
            accessToken = TePwyHelper.login(teServiceInfo, appToken);
            TePwyParam pwyParam2 = null;
            ITePwyService service = null;
            for (TePwyParam pwyParam2 : paramList) {
                pwyParam2.setAccessToken(accessToken);
                try {
                    service = TePwyServiceHelper.getPwyService(ctx, pwyParam2);
                    service.invoke();
                }
                catch (Exception e) {
                    exceptionList.add(e.getMessage());
                }
            }
            if (accessToken == null || teServiceInfo == null) return map;
        }
        catch (Exception e) {
            try {
                exceptionList.add(e.getMessage());
                if (accessToken == null || teServiceInfo == null) return map;
            }
            catch (Throwable throwable) {
                if (accessToken == null || teServiceInfo == null) throw throwable;
                TePwyHelper.loginOut(teServiceInfo, accessToken);
                throw throwable;
            }
            TePwyHelper.loginOut(teServiceInfo, accessToken);
            return map;
        }
        TePwyHelper.loginOut(teServiceInfo, accessToken);
        return map;
    }

    @Override
    protected String _encryptASE128(Context ctx, String content, String password) throws BOSException, EASBizException {
        try {
            return TePwyHelper.encryptASE128(content, password);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

