/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.directdeclare.comm.log;

import com.kingdee.eas.tm.td.directdeclare.comm.log.AsyncExecuteParams;
import com.kingdee.eas.tm.td.directdeclare.comm.log.AysncExecuteProcessor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class AsyncExecuteThread {
    private static BlockingQueue blockingQueue = new LinkedBlockingQueue();
    private static ExecutorService executorService = Executors.newFixedThreadPool(2);
    private static volatile boolean run = true;
    private static final Logger logger = Logger.getLogger(AsyncExecuteThread.class);
    private static AysncExecuteProcessor processor = new AysncExecuteProcessor();

    private static void start() {
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                while (run) {
                    logger.info((Object)("size------------" + blockingQueue.size()));
                    try {
                        AsyncExecuteParams executeParams = AsyncExecuteThread.takeData();
                        if (executeParams == null) continue;
                        processor.execute(executeParams);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                AsyncExecuteThread.stop();
            }
        }));
    }

    private static void stop() {
        run = false;
        executorService.shutdown();
    }

    public static AsyncExecuteParams takeData() {
        try {
            return (AsyncExecuteParams)blockingQueue.take();
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static void putData(AsyncExecuteParams executeParams) {
        try {
            blockingQueue.put(executeParams);
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
    }

    static {
        AsyncExecuteThread.start();
    }
}

