/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.directdeclare.comm.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.basedata.TaxBaseInfo;
import com.kingdee.eas.tm.td.directdeclare.ITePwyLog;
import com.kingdee.eas.tm.td.directdeclare.TeAreaInfo;
import com.kingdee.eas.tm.td.directdeclare.TeException;
import com.kingdee.eas.tm.td.directdeclare.TeLogStatus;
import com.kingdee.eas.tm.td.directdeclare.TePwyLogFactory;
import com.kingdee.eas.tm.td.directdeclare.TePwyLogInfo;
import com.kingdee.eas.tm.td.directdeclare.TeServiceInfo;
import com.kingdee.eas.tm.td.directdeclare.TeTransStatusEnum;
import com.kingdee.eas.tm.td.directdeclare.comm.model.TePwyParam;
import com.kingdee.eas.tm.td.directdeclare.comm.service.ITePwyService;
import com.kingdee.eas.tm.td.directdeclare.comm.util.HttpClientUtil;
import com.kingdee.eas.tm.td.directdeclare.comm.util.TePwyHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractTePwyService
implements ITePwyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.directdeclare.comm.service.AbstractTePwyService");
    protected TePwyParam pwyParam = null;
    protected TePwyLogInfo pwyLog = null;
    protected Context ctx = null;

    public AbstractTePwyService(Context ctx, TePwyParam pwyParam) {
        this.ctx = ctx;
        this.pwyParam = pwyParam;
    }

    @Override
    public void invoke() throws Exception {
        try {
            Map map = this.getPwyData();
            String url = this.getTeServiceInfo().getServiceURL() + "/kapi/app/tsate/interface?access_token=" + this.pwyParam.getAccessToken();
            if (this.pwyLog == null) {
                this.pwyLog = TePwyLogInfo.createNewData(this.ctx, this.pwyParam);
            }
            if (this.pwyParam.getTeAreaInfo() != null) {
                this.pwyLog.setTeInterface(this.pwyParam.getTeAreaInfo().getName());
            }
            this.pwyLog.setUrl(url);
            this.pwyLog.setSendMsg(this.getOriginPwyData());
            this.updatePwyLog(this.pwyLog);
            String response = HttpClientUtil.doPost(url, map);
            this.pwyLog.setRevMsg(response);
            JSONObject resultJson = null;
            String errorCode = null;
            String message = null;
            try {
                resultJson = new JSONObject(response);
                errorCode = resultJson.getString("errorCode");
                if (resultJson.has("message")) {
                    message = resultJson.getString("message");
                }
                this.pwyLog.setTransStatus(TeTransStatusEnum.getEnum(errorCode));
                if (!this.getSuccessCode().equals(errorCode)) {
                    throw new TeException(TeException.DIRECTDECLARERESPERROR, new Object[]{this.getReportInfo().getNumber(), this.getReportInfo().getName(), message});
                }
                this.pwyLog.setStatus(TeLogStatus.SUCCESS);
                this.updatePwyLog(this.pwyLog);
                this.handleSuccess();
            }
            catch (JSONException e) {
                logger.error((Object)("login:" + e.getMessage()));
                throw new TeException(TeException.DIRECTDECLARERESPERROR, new Object[]{this.getReportInfo().getNumber(), this.getReportInfo().getName(), "parseError"});
            }
        }
        catch (Exception e) {
            if (this.pwyLog != null) {
                this.pwyLog.setStatus(TeLogStatus.FAILURE);
                this.pwyLog.setDescription(e.getMessage());
                this.updatePwyLog(this.pwyLog);
            }
            throw e;
        }
    }

    protected String getSuccessCode() {
        return "0000";
    }

    protected void handleSuccess() throws Exception {
        this.doSuccess();
        this.pwyLog.setStatus(TeLogStatus.FINISH);
        this.updatePwyLog(this.pwyLog);
    }

    protected abstract void doSuccess() throws Exception;

    protected abstract String getOriginPwyData() throws Exception;

    protected Map getPwyData() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("transeq", this.getTranSeq());
        map.put("transrc", this.getTranSrc());
        map.put("tranid", this.getTranId());
        map.put("sbdq", this.getSbdq());
        map.put("nsrsbh", this.getNsrsbh());
        map.put("skssqq", this.getSkssqq());
        map.put("skssqz", this.getSkssqz());
        map.put("data", this.getData());
        return map;
    }

    @Override
    public void updatePwyLog(TePwyLogInfo logInfo) throws Exception {
        ITePwyLog iTePwyLog = this.ctx != null ? TePwyLogFactory.getLocalInstance(this.ctx) : TePwyLogFactory.getRemoteInstance();
        iTePwyLog.addLog2Queue((IObjectValue)logInfo);
    }

    protected String getSbdq() {
        return this.getTeAreaInfo().getAreaCode();
    }

    protected String getTranSeq() {
        return this.getReportInfo().getId().toString();
    }

    protected String getTranSrc() {
        return "eas";
    }

    protected String getTranId() {
        return this.pwyParam.getTransType().getValue();
    }

    protected String getNsrsbh() {
        return this.getTaxBaseInfo().getTaxpayerIdetifyNO();
    }

    protected String getSkssqq() {
        Date date = this.getReportInfo().getStartDate();
        return TePwyHelper.getFormatDate(date, "yyyymmdd");
    }

    protected String getSkssqz() {
        Date date = this.getReportInfo().getEndDate();
        return TePwyHelper.getFormatDate(date, "yyyymmdd");
    }

    protected String getData() throws Exception {
        return "";
    }

    protected TeServiceInfo getTeServiceInfo() {
        return this.pwyParam.getTeServiceInfo();
    }

    protected TaxDraftRecordInfo getReportInfo() {
        return this.pwyParam.getReportInfo();
    }

    protected TaxBaseInfo getTaxBaseInfo() {
        return this.pwyParam.getTaxBaseInfo();
    }

    protected TeAreaInfo getTeAreaInfo() {
        return this.pwyParam.getTeAreaInfo();
    }

    public TePwyLogInfo getPwyLog() {
        return this.pwyLog;
    }

    @Override
    public void setPwyLog(TePwyLogInfo pwyLog) {
        this.pwyLog = pwyLog;
    }
}

