/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.directdeclare.comm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.assistant.RegionInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.ITaxDraftRecord;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.basedata.TaxBaseCollection;
import com.kingdee.eas.tm.td.basedata.TaxBaseFactory;
import com.kingdee.eas.tm.td.basedata.TaxBaseInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.basedata.TaxpayerType;
import com.kingdee.eas.tm.td.directdeclare.ITeService;
import com.kingdee.eas.tm.td.directdeclare.TeAreaCollection;
import com.kingdee.eas.tm.td.directdeclare.TeAreaFactory;
import com.kingdee.eas.tm.td.directdeclare.TeAreaInfo;
import com.kingdee.eas.tm.td.directdeclare.TeException;
import com.kingdee.eas.tm.td.directdeclare.TePwyLogInfo;
import com.kingdee.eas.tm.td.directdeclare.TeServiceCollection;
import com.kingdee.eas.tm.td.directdeclare.TeServiceFactory;
import com.kingdee.eas.tm.td.directdeclare.TeServiceInfo;
import com.kingdee.eas.tm.td.directdeclare.TeTransTypeEnum;
import com.kingdee.eas.tm.td.directdeclare.comm.model.TeInterface;
import com.kingdee.eas.tm.td.directdeclare.comm.model.TePwyParam;
import com.kingdee.eas.tm.td.directdeclare.comm.model.VmModule;
import com.kingdee.eas.tm.td.directdeclare.comm.service.ITePwyService;
import com.kingdee.eas.tm.td.directdeclare.comm.util.HttpClientUtil;
import com.kingdee.eas.tm.td.directdeclare.comm.util.TeDefinition;
import com.kingdee.eas.tm.td.directdeclare.comm.util.TePwyServiceHelper;
import com.kingdee.eas.tm.td.structure.DetailItemDataCollection;
import com.kingdee.eas.tm.td.structure.DetailItemDataEntryInfo;
import com.kingdee.eas.tm.td.structure.DetailItemDataFactory;
import com.kingdee.eas.tm.td.structure.DetailItemDataInfo;
import com.kingdee.eas.tm.td.structure.TaxValueTypeEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class TePwyHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.directdeclare.utils.DirectDeclarePwyHelper");
    private static Map<String, Integer> seqMap = new HashMap<String, Integer>();

    public static String getAppToken(TeServiceInfo teServiceInfo) throws EASBizException, BOSException {
        String url = teServiceInfo.getServiceURL() + "/api/getAppToken.do";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", teServiceInfo.getAppId());
        map.put("appSecuret", teServiceInfo.getAppSecuret());
        map.put("tenantid", teServiceInfo.getTenantId());
        map.put("accountId", teServiceInfo.getAccountId());
        map.put("language", teServiceInfo.getLanguage().getValue());
        String response = HttpClientUtil.doPost(url, map);
        JSONObject resultJson = null;
        String errorCode = null;
        String errorDesc = null;
        String appToken = null;
        try {
            resultJson = new JSONObject(response);
            JSONObject dataJson = resultJson.getJSONObject("data");
            errorCode = dataJson.getString("error_code");
            errorDesc = dataJson.getString("error_desc");
            if (!"0".equals(errorCode)) {
                throw new TeException(TeException.GETAPPTOKENERROR, new Object[]{errorDesc});
            }
            appToken = dataJson.getString("app_token");
        }
        catch (JSONException e) {
            logger.error((Object)("getAppToken:" + e.getMessage()));
            throw new TeException(TeException.GETAPPTOKENERROR, new Object[]{"parseError"});
        }
        return appToken;
    }

    public static String login(TeServiceInfo teServiceInfo, String appToken) throws EASBizException, BOSException {
        String url = teServiceInfo.getServiceURL() + "/api/login.do";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("user", teServiceInfo.getUser());
        map.put("tenantid", teServiceInfo.getTenantId());
        map.put("apptoken", appToken);
        map.put("accountId", teServiceInfo.getAccountId());
        map.put("usertype", teServiceInfo.getUserType().getValue());
        map.put("language", teServiceInfo.getLanguage().getValue());
        String response = HttpClientUtil.doPost(url, map);
        JSONObject resultJson = null;
        String errorCode = null;
        String errorDesc = null;
        String accessToken = null;
        try {
            resultJson = new JSONObject(response);
            JSONObject dataJson = resultJson.getJSONObject("data");
            errorCode = dataJson.getString("error_code");
            errorDesc = dataJson.getString("error_desc");
            if (!"0".equals(errorCode)) {
                throw new TeException(TeException.LOGINERROR, new Object[]{errorDesc});
            }
            accessToken = dataJson.getString("access_token");
        }
        catch (JSONException e) {
            logger.error((Object)("login:" + e.getMessage()));
            throw new TeException(TeException.LOGINERROR, new Object[]{"parseError"});
        }
        return accessToken;
    }

    public static void loginOut(TeServiceInfo teServiceInfo, String access_token) {
        String url = teServiceInfo.getServiceURL() + "/api/logout.do";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("access_token", access_token);
        try {
            String string = HttpClientUtil.doPost(url, map);
        }
        catch (Exception e) {
            logger.error((Object)("loginOut:" + e.getMessage()));
        }
    }

    public static String encryptASE128(String content, String password) throws Exception {
        if (password.length() != 16) {
            System.out.print("Key\u957f\u5ea6\u4e0d\u662f16\u4f4d");
            return "";
        }
        byte[] raw = password.getBytes("utf-8");
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES/GCM/PKCS5Padding", "BC");
        cipher.init(1, skeySpec);
        byte[] encrypted = cipher.doFinal(content.getBytes("utf-8"));
        return new Base64().encodeToString(encrypted);
    }

    public static TeServiceInfo getTeServiceInfo(Context ctx) throws BOSException {
        ITeService iTeService = ctx == null ? TeServiceFactory.getRemoteInstance() : TeServiceFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        TeServiceCollection coll = iTeService.getTeServiceCollection(view);
        TeServiceInfo info = null;
        if (coll != null && coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    public static TeAreaInfo getTeAreaInfo(Context ctx, ProvinceInfo province, CityInfo city, RegionInfo region) throws BOSException {
        if (province == null && city == null && region == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (region != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("region.id", (Object)region.getId().toString(), CompareType.EQUALS));
        }
        if (city != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("city.id", (Object)city.getId().toString(), CompareType.EQUALS));
        }
        if (province != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("province.id", (Object)province.getId().toString(), CompareType.EQUALS));
        }
        view.setFilter(filterInfo);
        TeAreaInfo info = null;
        TeAreaCollection coll = TeAreaFactory.getLocalInstance(ctx).getTeAreaCollection(view);
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    public static TeTransTypeEnum getTeTransType(TaxItemTypeInfo taxItemTypeInfo, RecordTypeEnum recordType, TaxpayerType taxpayerType) {
        TeTransTypeEnum transType = null;
        if ("Xip0em3cA6rgU0ETqMAGKduK96Y=".equals(taxItemTypeInfo.getId().toString())) {
            if (TaxpayerType.NOMAL_TAXPAYER.equals((Object)taxpayerType)) {
                transType = TeTransTypeEnum.zzsybnsr;
            } else if (TaxpayerType.SCALE_TAXPRAYER.equals((Object)taxpayerType)) {
                transType = TeTransTypeEnum.zzsxgmnsr;
            }
        } else if ("Xip1b7mfPS7gU0ETqMBAL9uK96Y=".equals(taxItemTypeInfo.getId().toString())) {
            if (RecordTypeEnum.QuarterlyTaxDeclare.equals((Object)recordType)) {
                transType = TeTransTypeEnum.qysdsjb;
            } else if (RecordTypeEnum.AnnualTaxDeclare.equals((Object)recordType)) {
                transType = TeTransTypeEnum.qysdsnb;
            }
        }
        return transType;
    }

    public static TaxBaseInfo getTaxBaseInfo(Context ctx, CompanyOrgUnitInfo company) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        TaxBaseCollection coll = TaxBaseFactory.getLocalInstance(ctx).getTaxBaseCollection(view);
        TaxBaseInfo taxBaseInfo = null;
        if (coll.size() > 0) {
            taxBaseInfo = coll.get(0);
        }
        return taxBaseInfo;
    }

    public static TaxDraftRecordCollection getTaxDraftRecord(Context ctx) throws BOSException {
        TaxDraftRecordCollection coll = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("draftStatus", (Object)5, CompareType.EQUALS));
        view.setFilter(filter);
        ITaxDraftRecord iTaxDraftRecord = ctx != null ? TaxDraftRecordFactory.getLocalInstance(ctx) : TaxDraftRecordFactory.getRemoteInstance();
        coll = iTaxDraftRecord.getTaxDraftRecordCollection(view);
        return coll;
    }

    public static String getFormatDate(Date date, String formatStr) {
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        return format.format(date);
    }

    public static VmModule getVmModule(TeAreaInfo teAreaInfo, TeTransTypeEnum transType) {
        TeInterface teInterface = TeDefinition.getInstance().getTeMap().get(teAreaInfo.getNumber());
        VmModule vmModule2 = null;
        for (VmModule vmModule2 : teInterface.getVms()) {
            if (!vmModule2.getType().equals(transType.getValue())) continue;
            return vmModule2;
        }
        return null;
    }

    public static Map getRPADetailData(Context ctx, String rptID) throws BOSException {
        DetailItemDataCollection coll = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("report.id", (Object)rptID, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("sheet.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.sort("row");
        view.setSelector(sic);
        coll = DetailItemDataFactory.getLocalInstance(ctx).getDetailItemDataCollection(view);
        HashMap data = new HashMap();
        HashMap<String, Object> detailMap = null;
        DetailItemDataInfo info = null;
        DetailItemDataEntryInfo entryInfo = null;
        String key1 = null;
        Object value = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            detailMap = new HashMap<String, Object>();
            detailMap.put("headSize", info.getHeadSize());
            detailMap.put("rowCount", info.getRowCount());
            Iterator it = info.getEntries().iterator();
            while (it.hasNext()) {
                entryInfo = (DetailItemDataEntryInfo)it.next();
                key1 = entryInfo.getRow() + "_" + entryInfo.getCol();
                value = TaxValueTypeEnum.TXT.equals((Object)entryInfo.getValueType()) ? entryInfo.getTextValue() : entryInfo.getValue();
                detailMap.put(key1, value);
            }
            data.put("SheetPart" + i, detailMap);
        }
        return data;
    }

    public static Map getDeclarceDetailData(Context ctx, String rptID) throws BOSException {
        DetailItemDataCollection coll = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("report.id", (Object)rptID, CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("sheet.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        view.setSelector(sic);
        coll = DetailItemDataFactory.getLocalInstance(ctx).getDetailItemDataCollection(view);
        HashMap data = new HashMap();
        HashMap<String, Object> detailMap = null;
        DetailItemDataInfo info = null;
        DetailItemDataEntryInfo entryInfo = null;
        String key = null;
        String key1 = null;
        Object value = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            key = info.getNumber();
            detailMap = new HashMap<String, Object>();
            detailMap.put("headSize", info.getHeadSize());
            detailMap.put("rowCount", info.getRowCount());
            data.put(key, detailMap);
            Iterator it = info.getEntries().iterator();
            while (it.hasNext()) {
                entryInfo = (DetailItemDataEntryInfo)it.next();
                key1 = entryInfo.getRow() + "_" + entryInfo.getCol();
                value = TaxValueTypeEnum.TXT.equals((Object)entryInfo.getValueType()) ? entryInfo.getTextValue() : entryInfo.getValue();
                detailMap.put(key1, value);
            }
        }
        return data;
    }

    public static Map getDeclarceData(Context ctx, String rptID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FPhysicalTblName FROM T_TD_StructDynTblMap tblmap").append("\n");
        sql.append(" INNER JOIN T_TD_TaxReportSheet rptsheet  on tblmap.FReportSheetID = rptsheet.fid").append("\n");
        sql.append(" INNER JOIN T_TD_TaxDraftRecord rpt on rpt.FTaxTypeID = rptsheet.FTaxTypeID and rpt.FRecordType = rptsheet.FRecordType").append("\n");
        sql.append(" WHERE rptsheet.FState = ? and rpt.fid = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"2", rptID});
        ArrayList<String> tblList = new ArrayList<String>();
        String tblName2 = null;
        try {
            while (rs.next()) {
                tblName2 = rs.getString("FPhysicalTblName");
                tblList.add(tblName2);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> itemValue = new HashMap<String, Object>();
        HashMap<String, String> itemName = new HashMap<String, String>();
        String key = null;
        String rowNumber = null;
        String columnNumber = null;
        String rowName = null;
        String columnName = null;
        Object value = null;
        for (String tblName2 : tblList) {
            sql.setLength(0);
            sql.append(" SELECT rowitem.FNumber as rowNumber,columnitem.FNumber as columnNumber,ISNULL(FValue2,TOCHAR(FValue1)) as FValue, ").append("\n");
            sql.append(" rowitem.FName_").append(ctx.getLocale().toString()).append(" as rowName,columnitem.FName_").append(ctx.getLocale().toString()).append(" as columnName").append("\n");
            sql.append(" FROM ").append(tblName2).append(" as tbl").append("\n");
            sql.append(" INNER JOIN T_TD_TaxReportItem rowitem on rowitem.fid = tbl.FRowItemID").append("\n");
            sql.append(" INNER JOIN T_TD_TaxReportItem columnitem on columnitem.fid = tbl.FColumnItemID");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    rowNumber = rs.getString("rowNumber");
                    columnNumber = rs.getString("columnNumber");
                    rowName = rs.getString("rowName");
                    columnName = rs.getString("columnName");
                    value = rs.getObject("FValue");
                    key = rowNumber + "_" + columnNumber;
                    itemValue.put(key, value);
                    itemName.put(rowNumber, rowName);
                    itemName.put(columnNumber, columnName);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        HashMap<String, HashMap<String, Object>> data = new HashMap<String, HashMap<String, Object>>();
        data.put("itemValue", itemValue);
        data.put("itemName", itemName);
        return data;
    }

    public static synchronized String getNewNumberString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String key = df.format(new Date());
        int seq = 0;
        if (seqMap.containsKey(key)) {
            seq = seqMap.get(key) + 1;
        } else {
            seqMap.clear();
            seq = 1;
        }
        seqMap.put(key, seq);
        String number = key + seq;
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void invoke(TePwyParam pwyParam, TePwyLogInfo logInfo) throws Exception {
        String accessToken = null;
        TeServiceInfo teServiceInfo = null;
        try {
            teServiceInfo = pwyParam.getTeServiceInfo();
            String appToken = null;
            appToken = TePwyHelper.getAppToken(teServiceInfo);
            accessToken = TePwyHelper.login(teServiceInfo, appToken);
            pwyParam.setAccessToken(accessToken);
            ITePwyService service = TePwyServiceHelper.getPwyService(null, pwyParam);
            service.setPwyLog(logInfo);
            service.invoke();
            if (accessToken == null || teServiceInfo == null) return;
        }
        catch (Throwable throwable) {
            if (accessToken == null || teServiceInfo == null) throw throwable;
            TePwyHelper.loginOut(teServiceInfo, accessToken);
            throw throwable;
        }
        TePwyHelper.loginOut(teServiceInfo, accessToken);
    }
}

