/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.RealEstateGroupCollection;
import com.kingdee.eas.tm.td.est.RealEstateGroupEntryCollection;
import com.kingdee.eas.tm.td.est.RealEstateGroupEntryInfo;
import com.kingdee.eas.tm.td.est.RealEstateGroupFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.est.app.AbstractRealEstateGroupControllerBean;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RealEstateGroupControllerBean
extends AbstractRealEstateGroupControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.est.app.RealEstateGroupControllerBean");
    private static final String RES = "com.kingdee.eas.tm.td.est.ESTResource";

    private String getResource(String proper, Context ctx) {
        return ResourceBase.getString((String)RES, (String)proper, (Locale)ctx.getLocale());
    }

    private String getResource(String proper, Context ctx, Object[] params) {
        return ResourceBase.getString((String)RES, (String)proper, (Locale)ctx.getLocale(), (Object[])params);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RealEstateGroupInfo info;
        if (model == null) {
            model = this.getValue(ctx, pk);
        }
        if (EstStateEnum.FORBIDDEN.equals((Object)(info = (RealEstateGroupInfo)model).getState())) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{TDUtils.getString(RES, "Error_Cancel", ctx.getLocale())});
        }
        info.setState(EstStateEnum.FORBIDDEN);
        this._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RealEstateGroupInfo info;
        if (model == null) {
            model = this.getValue(ctx, pk);
        }
        if (EstStateEnum.USING.equals((Object)(info = (RealEstateGroupInfo)model).getState())) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{TDUtils.getString(RES, "Error_Cancelcancel", ctx.getLocale())});
        }
        info.setState(EstStateEnum.USING);
        this._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RealEstateGroupInfo info = this.getRealEstateGroupInfo(ctx, pk);
        if (EstStateEnum.USING.equals((Object)info.getState())) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{TDUtils.getString(RES, "Error_USINGDelete", ctx.getLocale())});
        }
        Boolean isReference = RefCheckerFactory.getLocalInstance((Context)ctx).isReferenced(BOSUuid.read((String)pk.toString()));
        if (isReference.booleanValue()) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{TDUtils.getString(RES, "Error_RefDelete", ctx.getLocale())});
        }
        super._delete(ctx, pk);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RealEstateGroupInfo info = (RealEstateGroupInfo)model;
        info.setId(BOSUuid.create((String)"D5C621B2"));
        IObjectPK logPk = LogUtils.beginLog(ctx, "save", BOSObjectType.create((String)"D5C621B2"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_realEstateGroup_new", info.getCU().getId().toString());
        this.checkBefore(ctx, info);
        IObjectPK pk = super._addnew(ctx, model);
        LogUtils.afterLog(ctx, logPk);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getRealEstateGroupInfo(ctx, pk);
        }
        RealEstateGroupInfo info = (RealEstateGroupInfo)model;
        IObjectPK logPk = LogUtils.beginLog(ctx, "edit", BOSObjectType.create((String)"D5C621B2"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_realEstateGroup_edit", info.getCU().getId().toString());
        this.checkBefore(ctx, info);
        super._update(ctx, pk, (IObjectValue)model);
        LogUtils.afterLog(ctx, logPk);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getRealEstateGroupInfo(ctx, pk);
        }
        RealEstateGroupInfo info = (RealEstateGroupInfo)model;
        this.checkBefore(ctx, info);
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RealEstateGroupInfo info = (RealEstateGroupInfo)model;
        this.checkBefore(ctx, info);
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    private void checkBefore(Context ctx, RealEstateGroupInfo info) throws EASBizException, BOSException {
        this.checkNumberDup(ctx, (DataBaseInfo)info);
        StringBuffer errorList = new StringBuffer();
        if (info.getNumber() == null || info.getNumber().isEmpty()) {
            errorList.append(this.getResource("Calc_Number", ctx));
        }
        if (info.getName() == null || info.getName().isEmpty()) {
            errorList.append(this.getResource("Calc_Name", ctx));
        }
        if (errorList.length() > 0) {
            errorList.append(this.getResource("NOTNULL", ctx));
            throw new TDException(TDException.ERROR_MSG, new Object[]{errorList.toString().substring(1)});
        }
        RealEstateGroupEntryCollection coll = info.getEntry();
        RealEstateGroupEntryInfo entryInfo = null;
        if (coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                entryInfo = coll.get(i);
            }
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return new FilterInfo();
    }

    @Override
    protected ArrayList _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        int i;
        StringBuffer idStr = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        RealEstateGroupCollection collection = RealEstateGroupFactory.getLocalInstance(ctx).getRealEstateGroupCollection(view);
        ArrayList<String> error = new ArrayList<String>();
        IObjectPK logPk = null;
        ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
        if (collection.size() > 0) {
            for (i = 0; i < collection.size(); ++i) {
                RealEstateGroupInfo info = collection.get(i);
                logPk = LogUtils.beginLog(ctx, "cancel", BOSObjectType.create((String)"D5C621B2"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_realEstateGroup_cancel", info.getCU().getId().toString());
                if (EstStateEnum.FORBIDDEN.equals((Object)info.getState())) {
                    error.add(info.getNumber() + ":" + TDUtils.getString(RES, "Error_Cancel", ctx.getLocale()));
                    continue;
                }
                idStr.append("'").append(info.getId().toString()).append("',");
                logPkList.add(logPk);
            }
        }
        if (!StringUtils.isEmpty((String)idStr.toString())) {
            String sql = "UPDATE T_TD_RealEstateGroup SET FState = 0 WHERE FID IN (" + idStr.toString().substring(0, idStr.toString().length() - 1) + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        int j = logPkList.size();
        for (i = 0; i < j; ++i) {
            LogUtils.afterLog(ctx, (IObjectPK)logPkList.get(i));
        }
        return error;
    }

    @Override
    protected ArrayList _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        int i;
        String idStr = "";
        ArrayList<String> error = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        RealEstateGroupCollection coll = this.getRealEstateGroupCollection(ctx, view);
        IObjectPK logPk = null;
        ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
        int size = coll.size();
        for (i = 0; i < size; ++i) {
            RealEstateGroupInfo info = coll.get(i);
            logPk = LogUtils.beginLog(ctx, "cancelcancel", BOSObjectType.create((String)"D5C621B2"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_realEstateGroup_cancelcancel", info.getCU().getId().toString());
            if (EstStateEnum.USING.equals((Object)info.getState())) {
                error.add(info.getNumber() + ":" + TDUtils.getString(RES, "Error_Cancelcancel", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
            logPkList.add(logPk);
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("UPDATE T_TD_RealEstateGroup SET FState = 1 WHERE FID IN (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        int j = logPkList.size();
        for (i = 0; i < j; ++i) {
            LogUtils.afterLog(ctx, (IObjectPK)logPkList.get(i));
        }
        return error;
    }

    @Override
    protected ArrayList _deleteBatch(Context ctx, Set ids) throws BOSException, EASBizException {
        ArrayList<String> error = new ArrayList<String>();
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)iterator.next().toString()));
            RealEstateGroupInfo info = this.getRealEstateGroupInfo(ctx, (IObjectPK)pk);
            IObjectPK logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"D5C621B2"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_realEstateGroup_delete", info.getCU().getId().toString());
            if (EstStateEnum.USING.equals((Object)info.getState())) {
                error.add(info.getNumber() + ":" + EASResource.getString((String)RES, (String)"Error_USINGDelete"));
                continue;
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT  FBuildingTaxesGroupID FROM T_TD_TaxDraftRecord AS taxDraftRecord  where FBuildingTaxesGroupID = '" + info.getId().toString() + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    error.add(TDUtils.getString(RES, "Error_RefDelete_Detail", ctx.getLocale(), new Object[]{info.getNumber()}));
                    continue;
                }
                super.delete(ctx, (IObjectPK)pk);
            }
            catch (EASBizException e) {
                throw new TDException(TDException.ERROR_MSG, new Object[]{e.getMessage()});
            }
            catch (SQLException e) {
                throw new TDException(TDException.ERROR_MSG, new Object[]{e.getMessage()});
            }
            LogUtils.afterLog(ctx, logPk);
        }
        return error;
    }
}

