/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.util;

import com.kingdee.eas.tm.td.est.util.EstConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;

public class EstUtils {
    public static Date getNextMonthFirstDay(Date old) {
        Calendar newDate = Calendar.getInstance();
        newDate.setTime(old);
        newDate.set(2, newDate.get(2) + 1);
        newDate.set(5, newDate.getActualMinimum(5));
        return newDate.getTime();
    }

    public static Date getPreMonthLastDay(Date old) {
        Calendar newDate = Calendar.getInstance();
        newDate.setTime(old);
        newDate.set(2, newDate.get(2) - 1);
        newDate.set(5, newDate.getActualMaximum(5));
        return newDate.getTime();
    }

    public static BigDecimal getDiffMonth(Date from, Date to) {
        Calendar start = Calendar.getInstance();
        start.setTime(from);
        int fromYear = start.get(1);
        int fromMonth = start.get(2);
        int fromDay = start.get(5);
        Calendar end = Calendar.getInstance();
        end.setTime(to);
        int toYear = end.get(1);
        int toMonth = end.get(2);
        int toDay = end.get(5);
        BigDecimal totalMonth = BigDecimal.ONE;
        if (fromYear == toYear && fromMonth == toMonth) {
            int days = start.getActualMaximum(5);
            totalMonth = new BigDecimal(toDay - fromDay + 1).divide(new BigDecimal(days), EstConstant.PRECISION_8, RoundingMode.HALF_UP);
        } else {
            totalMonth = new BigDecimal((toYear - fromYear) * 12 + (toMonth - fromMonth - 1));
            BigDecimal firstDay = new BigDecimal(start.getActualMaximum(5) - fromDay + 1);
            BigDecimal firstTotal = new BigDecimal(start.getActualMaximum(5));
            totalMonth = totalMonth.add(firstDay.divide(firstTotal, EstConstant.PRECISION_8, RoundingMode.HALF_UP));
            BigDecimal lastDay = new BigDecimal(toDay);
            BigDecimal lastTotal = new BigDecimal(end.getActualMaximum(5));
            totalMonth = totalMonth.add(lastDay.divide(lastTotal, EstConstant.PRECISION_8, RoundingMode.HALF_UP));
        }
        return totalMonth;
    }

    public static boolean isSameMonth(Date from, Date to) {
        Calendar start = Calendar.getInstance();
        start.setTime(from);
        int fromYear = start.get(1);
        int fromMonth = start.get(2);
        Calendar end = Calendar.getInstance();
        end.setTime(to);
        int toYear = end.get(1);
        int toMonth = end.get(2);
        return fromYear == toYear && fromMonth == toMonth;
    }

    public static int getMonthSpan(Date from, Date to) {
        Calendar start = Calendar.getInstance();
        start.setTime(from);
        int fromYear = start.get(1);
        int fromMonth = start.get(2);
        Calendar end = Calendar.getInstance();
        end.setTime(to);
        int toYear = end.get(1);
        int toMonth = end.get(2);
        int monthSpan = 0;
        monthSpan = (toYear - fromYear) * 12 + (toMonth - fromMonth + 1);
        return monthSpan;
    }

    public static boolean isFirstDay(Date date) {
        Calendar start = Calendar.getInstance();
        start.setTime(date);
        return start.get(5) == start.getActualMinimum(5);
    }

    public static boolean withinDateRange(Date sDate, Date eDate, Date pBeginDate) {
        return !sDate.after(pBeginDate) && !eDate.before(pBeginDate);
    }

    public static boolean hasDupDays(Date sDate, Date eDate, Date pBeginDate, Date pEndDate) {
        return !pBeginDate.after(sDate) && !pEndDate.before(eDate) || !pBeginDate.before(sDate) && !pBeginDate.after(eDate) || !pEndDate.before(sDate) && !pEndDate.after(eDate);
    }

    public static int getDuplicateDays(Date rangeDateFrom, Date rangeDateTo, Date pDateFrom, Date pDateTo) {
        if (rangeDateFrom.after(pDateTo) || rangeDateTo.before(pDateFrom)) {
            return 0;
        }
        if (!rangeDateFrom.after(pDateFrom) && !rangeDateTo.before(pDateTo)) {
            return EstUtils.getDiffDays(pDateFrom, pDateTo);
        }
        if (!rangeDateFrom.before(pDateFrom) && !rangeDateTo.after(pDateTo)) {
            return EstUtils.getDiffDays(rangeDateFrom, rangeDateTo);
        }
        if (!rangeDateFrom.before(pDateFrom)) {
            return EstUtils.getDiffDays(rangeDateFrom, pDateTo);
        }
        if (!rangeDateTo.after(pDateTo)) {
            return EstUtils.getDiffDays(pDateFrom, rangeDateTo);
        }
        return 0;
    }

    public static int getDiffDays(Date from, Date to) {
        long fromTime = from.getTime();
        long toTime = to.getTime();
        return (int)((toTime - fromTime) / (long)EstConstant.ONEDAY) + 1;
    }

    public static BigDecimal getBeforeDays(Date date) {
        Calendar cDate = Calendar.getInstance();
        cDate.setTime(date);
        int day = cDate.get(5);
        int maximum = cDate.getActualMaximum(5);
        return new BigDecimal(day).divide(new BigDecimal(maximum), EstConstant.PRECISION_8, RoundingMode.HALF_UP);
    }

    public static BigDecimal getAfterDays(Date date) {
        Calendar cDate = Calendar.getInstance();
        cDate.setTime(date);
        int day = cDate.get(5);
        int maximum = cDate.getActualMaximum(5);
        return new BigDecimal(maximum - day + 1).divide(new BigDecimal(maximum), EstConstant.PRECISION_8, RoundingMode.HALF_UP);
    }
}

