/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.PeriodTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.est.EstCalculateRecordCollection;
import com.kingdee.eas.tm.td.est.EstCalculateRecordFactory;
import com.kingdee.eas.tm.td.est.EstCalculateRecordInfo;
import com.kingdee.eas.tm.td.est.LandDataInfo;
import com.kingdee.eas.tm.td.est.TaxCycleEnum;
import com.kingdee.eas.tm.td.est.util.EstConstant;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LandDataStrategy {
    private Context ctx;
    private LandDataInfo landDataInfo;
    private PeriodInfo periodInfo;
    private CompanyOrgUnitInfo company;
    private List errorList = new ArrayList();
    private EstCalculateRecordCollection colls = new EstCalculateRecordCollection();

    public LandDataStrategy(Context ctx, LandDataInfo landDataInfo, PeriodInfo period) throws BOSException {
        this.ctx = ctx;
        this.landDataInfo = landDataInfo;
        this.periodInfo = period;
        this.company = landDataInfo.getCompany();
    }

    public Map doCalc() {
        HashMap<String, StringBuffer> calcResult = new HashMap<String, StringBuffer>();
        try {
            TaxCycleEnum taxCycle = this.landDataInfo.getTaxCycle();
            if (TaxCycleEnum.ONCE.equals((Object)taxCycle)) {
                this.calc4Once();
            } else {
                this.calc4Cycle(taxCycle.getValue());
            }
            if (this.colls.size() > 0) {
                EstCalculateRecordFactory.getLocalInstance(this.ctx).batchAddNew(this.colls);
            }
        }
        catch (Exception e) {
            this.errorList.add(e.getMessage());
        }
        if (!this.errorList.isEmpty()) {
            StringBuffer errorMsg = new StringBuffer();
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_DoCalc", this.ctx.getLocale(), new Object[]{this.landDataInfo.getNumber(), this.landDataInfo.getName()})).append('\n');
            for (int i = 0; i < this.errorList.size(); ++i) {
                errorMsg.append(this.errorList.get(i)).append('\n');
            }
            calcResult.put("errorMsg", errorMsg);
        }
        return calcResult;
    }

    private PeriodInfo getFirstPeriod(int periodNumber, int cycle) throws BOSException, EASBizException {
        int firstCalcMonth;
        for (firstCalcMonth = 1; periodNumber < firstCalcMonth || periodNumber >= firstCalcMonth + cycle; firstCalcMonth += cycle) {
        }
        return PeriodUtils.getPeriodInfo((Context)this.ctx, (int)this.periodInfo.getPeriodYear(), (int)firstCalcMonth, (CompanyOrgUnitInfo)this.company);
    }

    private void calc4Once() throws EASBizException, BOSException {
        int month = this.landDataInfo.getFirstPaymentMonth().getValue();
        if (month == this.periodInfo.getPeriodNumber()) {
            BigDecimal basis = BigDecimal.ZERO;
            StringBuffer errorStr = new StringBuffer();
            Map result = this.calcBasis();
            if (result.get("basis") != null) {
                basis = (BigDecimal)result.get("basis");
            } else {
                errorStr.append(result.get("error"));
            }
            EstCalculateRecordInfo record = this.createRecord();
            record.setFirstPeriod(PeriodUtils.getPeriodInfo((Context)this.ctx, (Date)this.landDataInfo.getTaxStartTime(), (CompanyOrgUnitInfo)this.company));
            record.setLastPeriod(PeriodUtils.getPeriodInfo((Context)this.ctx, (Date)this.landDataInfo.getTaxEndTime(), (CompanyOrgUnitInfo)this.company));
            record.setTaxBasis(basis.setScale(EstConstant.PRECISION_2, RoundingMode.HALF_UP));
            Map amtResult = this.calcTaxAmount(basis);
            if (amtResult.get("taxAmount") != null) {
                record.setTaxAmount((BigDecimal)amtResult.get("taxAmount"));
            } else {
                record.setTaxAmount(BigDecimal.ZERO);
                errorStr.append(amtResult.get("error"));
            }
            if (errorStr.length() > 0) {
                record.setCalculateResult(errorStr.toString());
            }
        }
    }

    private void calc4Cycle(int cycle) throws EASBizException, BOSException {
        int firstMonth;
        int periodNumber = this.periodInfo.getPeriodNumber();
        if (periodNumber % cycle == (firstMonth = this.landDataInfo.getFirstPaymentMonth().getValue()) % cycle) {
            PeriodInfo firstPeriod = this.getFirstPeriod(periodNumber, cycle);
            BigDecimal basis = BigDecimal.ZERO;
            StringBuffer errorStr = new StringBuffer();
            Map result = this.calcBasis();
            if (result.get("basis") != null) {
                basis = (BigDecimal)result.get("basis");
            } else {
                errorStr.append(result.get("error"));
            }
            EstCalculateRecordInfo record = this.createRecord();
            record.setFirstPeriod(firstPeriod);
            record.setLastPeriod(PeriodUtils.getPeriodInfo((Context)this.ctx, (int)this.periodInfo.getPeriodYear(), (int)(firstPeriod.getPeriodNumber() + cycle - 1), (CompanyOrgUnitInfo)this.company));
            BigDecimal cycleDecimal = new BigDecimal(cycle);
            BigDecimal totalBasis = basis.multiply(cycleDecimal);
            record.setTaxBasis(totalBasis.setScale(EstConstant.PRECISION_2, RoundingMode.HALF_UP));
            Map amtResult = this.calcTaxAmount(totalBasis);
            if (amtResult.get("taxAmount") != null) {
                record.setTaxAmount((BigDecimal)amtResult.get("taxAmount"));
            } else {
                record.setTaxAmount(BigDecimal.ZERO);
                errorStr.append(amtResult.get("error"));
            }
            if (errorStr.length() > 0) {
                record.setCalculateResult(errorStr.toString());
            }
        }
    }

    private EstCalculateRecordInfo createRecord() {
        EstCalculateRecordInfo record = new EstCalculateRecordInfo();
        record.setCompany(this.company);
        record.setRealEstateGroup(this.landDataInfo.getRealEstateGroup());
        record.setLandData(this.landDataInfo);
        record.setTaxPeriod(this.periodInfo);
        TaxItemTypeInfo taxItem = new TaxItemTypeInfo();
        taxItem.setId(BOSUuid.read((String)"d8umkg7qNn3gU0ETqMCsX9uK96Y="));
        record.setTaxItemType(taxItem);
        record.setPeriodType(this.getPeriodType(this.landDataInfo.getTaxCycle().getValue()));
        record.setDisplayExpr(this.landDataInfo.getCalcFormula().getDisplayExpr());
        record.setTaxBasisExpr(this.landDataInfo.getCalcFormula().getDisplayBasisExpr());
        record.setCalculateResult(TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Msg_success", this.ctx.getLocale()));
        this.colls.add(record);
        return record;
    }

    private Map calcBasis() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Interpreter interpreter = new Interpreter(this.ctx);
            HashMap<String, Serializable> localCtx = new HashMap<String, Serializable>();
            localCtx.put("landData", this.landDataInfo);
            localCtx.put("realEstateGroup", this.landDataInfo.getRealEstateGroup());
            Object eval = interpreter.eval(this.landDataInfo.getCalcFormula().getBasisExpr(), localCtx);
            BigDecimal basis = new BigDecimal(eval.toString()).setScale(EstConstant.PRECISION_20, RoundingMode.HALF_UP);
            result.put("basis", basis);
        }
        catch (Exception e) {
            String errorMsg = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "CalcBasisFailed", this.ctx.getLocale());
            if (this.landDataInfo != null && this.landDataInfo.getCalcFormula() != null) {
                errorMsg = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_CalcBasis", this.ctx.getLocale(), new Object[]{TDUtils.getString("com.kingdee.eas.tm.td.est.landDataResource", "LANDDATAEXPORTEXCELNAME", this.ctx.getLocale()) + this.landDataInfo.getNumber(), this.landDataInfo.getCalcFormula().getNumber()});
            }
            result.put("error", errorMsg);
            this.errorList.add(errorMsg);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map calcTaxAmount(BigDecimal basis) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Interpreter interpreter = new Interpreter(this.ctx);
            HashMap<String, Serializable> localCtx = new HashMap<String, Serializable>();
            this.landDataInfo.setTaxBasis(basis);
            localCtx.put("landData", this.landDataInfo);
            localCtx.put("realEstateGroup", this.landDataInfo.getRealEstateGroup());
            Object eval = interpreter.eval(this.landDataInfo.getCalcFormula().getExpr(), localCtx);
            BigDecimal taxAmount = new BigDecimal(eval.toString()).setScale(EstConstant.PRECISION_2, RoundingMode.HALF_UP);
            result.put("taxAmount", taxAmount);
        }
        catch (Exception e) {
            String errorMsg = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_CalcTaxAmount", this.ctx.getLocale(), new Object[]{e.getMessage()});
            result.put("error", errorMsg);
            this.errorList.add(errorMsg);
        }
        finally {
            this.landDataInfo.setTaxBasis(null);
        }
        return result;
    }

    private PeriodTypeEnum getPeriodType(int value) {
        switch (value) {
            case 0: {
                return PeriodTypeEnum.PERLY;
            }
            case 1: {
                return PeriodTypeEnum.MONTHLY;
            }
            case 3: {
                return PeriodTypeEnum.QUARTERLY;
            }
            case 6: {
                return PeriodTypeEnum.HALFYEAR;
            }
            case 12: {
                return PeriodTypeEnum.YEARLY;
            }
        }
        return PeriodTypeEnum.MONTHLY;
    }
}

