/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.solutionmgr.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.tm.td.solutionmgr.ExportSolutionMgrCollection;
import com.kingdee.eas.tm.td.solutionmgr.ExportSolutionMgrFactory;
import com.kingdee.eas.tm.td.solutionmgr.ExportSolutionMgrInfo;
import com.kingdee.eas.tm.td.solutionmgr.app.AbstractExportSolutionMgrControllerBean;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ExportSolutionMgrControllerBean
extends AbstractExportSolutionMgrControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.solutionmgr.app.ExportSolutionMgrControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ExportSolutionMgrInfo info = (ExportSolutionMgrInfo)model;
        this.beforeSave(ctx, info);
        return super._save(ctx, (IObjectValue)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ExportSolutionMgrInfo info = (ExportSolutionMgrInfo)model;
        this.beforeSave(ctx, info);
        return super._submit(ctx, (IObjectValue)info);
    }

    private void beforeSave(Context ctx, ExportSolutionMgrInfo info) throws EASBizException, BOSException {
        this.checkNumberDup(ctx, info.getNumber(), info.getId());
        int index = info.getNumber().toLowerCase().indexOf("exp_");
        if (index > -1) {
            String subNumber = info.getNumber().substring(index + 4);
            info.setNumber("EXP_" + subNumber);
        } else {
            info.setNumber("EXP_" + info.getNumber());
        }
        if (info.getCU() == null) {
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
    }

    private void checkNumberDup(Context ctx, String number, BOSUuid id) throws EASBizException, BOSException {
        ExportSolutionMgrCollection expConn = this.getExpSolutionConnByNumber(ctx, number);
        if (expConn.size() > 0) {
            ExportSolutionMgrInfo info = expConn.get(0);
            if (id == null || StringUtil.isEmpty((String)id.toString())) {
                String tipInfo = EASCommonResource.getString((String)"com.kingdee.eas.tm.td.solutionmgr.ExpSolutionMgrResource", (String)"number_dup_err", (Locale)ExportSolutionMgrControllerBean.getLocale());
                throw new BOSException(tipInfo);
            }
            if (!info.getId().toString().equals(id.toString())) {
                String tipInfo = EASCommonResource.getString((String)"com.kingdee.eas.tm.td.solutionmgr.ExpSolutionMgrResource", (String)"number_dup_err", (Locale)ExportSolutionMgrControllerBean.getLocale());
                throw new BOSException(tipInfo);
            }
        }
    }

    private ExportSolutionMgrCollection getExpSolutionConnByNumber(Context ctx, String strNumber) throws BOSException, EASBizException {
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)strNumber, CompareType.EQUALS));
        entityView.setFilter(fi);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        entityView.setSelector(sic);
        return ExportSolutionMgrFactory.getLocalInstance(ctx).getExportSolutionMgrCollection(entityView);
    }

    private static Locale getLocale() {
        try {
            return SysContext.getSysContext().getLocale();
        }
        catch (Throwable e) {
            logger.error((Object)("Get Locale fail!" + e.getMessage()));
            return new Locale("L2");
        }
    }
}

