/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.solutionmgr.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.tm.td.solutionmgr.ExportSolutionMgrFactory;
import com.kingdee.eas.tm.td.solutionmgr.ExportSolutionMgrInfo;
import com.kingdee.eas.tm.td.solutionmgr.ExportSolutionSubTabCollection;
import com.kingdee.eas.tm.td.solutionmgr.ExportSolutionSubTabInfo;
import com.kingdee.eas.tm.td.solutionmgr.JoinTypeEnum;
import com.kingdee.eas.tm.td.solutionmgr.app.AbstractSolutionMgrFacadeControllerBean;
import com.kingdee.eas.tm.td.solutionmgr.impexp.cache.ResultSetCache;
import com.kingdee.eas.tm.td.solutionmgr.impexp.util.DbUtils;
import com.kingdee.eas.tm.td.solutionmgr.tools.SolutionMgrConditionInfo;
import com.kingdee.eas.tm.td.utils.EncryptUtil;
import com.kingdee.eas.tm.td.utils.TDParamUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SolutionMgrFacadeControllerBean
extends AbstractSolutionMgrFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.solutionmgr.app.SolutionMgrFacadeControllerBean");
    private static final String CHAR_SEPERATOR = ";";

    @Override
    protected Object[] _getColunmsByTable(Context ctx, String tableName) throws BOSException {
        SolutionMgrConditionInfo[] conditionInfoArray = null;
        if (!StringUtils.isEmpty((String)tableName)) {
            StringBuffer sql = new StringBuffer("select KSQL_COL_NAME, KSQL_COL_TYPE from KSQL_USERCOLUMNS where  KSQL_COL_TABNAME = '");
            sql.append(tableName).append("'").append(" and KSQL_COL_TYPE !='sysname'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            int size = rowSet.size();
            conditionInfoArray = new SolutionMgrConditionInfo[size];
            SolutionMgrConditionInfo conditionInfo = null;
            try {
                String fieldStr = null;
                String fieldType = null;
                int i = 0;
                while (rowSet.next()) {
                    fieldStr = rowSet.getString("KSQL_COL_NAME");
                    fieldType = rowSet.getString("KSQL_COL_TYPE");
                    conditionInfoArray[i] = conditionInfo = new SolutionMgrConditionInfo(fieldStr, fieldType);
                    ++i;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return conditionInfoArray;
    }

    @Override
    public Map getRecordCount(Context ctx, Map params) throws BOSException, EASBizException {
        String sql = (String)params.get("sql");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int count = 0;
        try {
            if (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put("count", count);
        return ret;
    }

    @Override
    public Map _getRecordList(Context ctx, Map params) throws BOSException, EASBizException {
        String sql = (String)params.get("sql");
        int from = Integer.parseInt(params.get("from").toString());
        int len = Integer.parseInt(params.get("len").toString());
        IRowSet rs = null;
        ResultSetCache rsCache = null;
        try {
            rs = DbUtils.executeQuery(ctx, sql, null, from, len);
            rsCache = ResultSetCache.parse(ctx, (ResultSet)rs, params);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, ResultSetCache> ret = new HashMap<String, ResultSetCache>();
        ret.put("rs", rsCache);
        return ret;
    }

    @Override
    protected void _deleteOldData(Context ctx, String solutionMgrNumber, String mainTableId) throws BOSException, EASBizException {
        ExportSolutionMgrInfo info = ExportSolutionMgrFactory.getLocalInstance(ctx).getExportSolutionMgrInfo(" where number='" + solutionMgrNumber + "'");
        String subTableName = null;
        String mainTable = info.getMainTable();
        String joinType = null;
        String relationStr = null;
        String joinRelationStr = null;
        String associalMainTable = null;
        ExportSolutionSubTabInfo subTableInfo = null;
        HashMap<String, String> joinRelationMap = new HashMap<String, String>();
        StringBuffer subTabSelectSql = new StringBuffer();
        ExportSolutionSubTabCollection subTableConn = info.getSolutionSubTab();
        for (int i = 0; i < subTableConn.size(); ++i) {
            subTableInfo = subTableConn.get(i);
            subTableName = subTableInfo.getSubTable();
            associalMainTable = subTableInfo.getAssocialTable();
            joinType = subTableInfo.getJoinType().getName();
            relationStr = subTableInfo.getRelationStr();
            joinRelationStr = this.formatRelationStr(joinType, relationStr, subTableName);
            joinRelationMap.put(subTableName, joinRelationStr);
            subTabSelectSql.append("Delete from ").append(subTableName).append(" Where FID IN (");
            subTabSelectSql.append(" select ").append(subTableName).append(".FID from ");
            subTabSelectSql.append(mainTable).append(" AS ").append(mainTable).append(" \r\n ");
            if (associalMainTable.equals(mainTable)) {
                subTabSelectSql.append(joinRelationStr);
            } else {
                subTabSelectSql.append((String)joinRelationMap.get(associalMainTable)).append(" \r\n ");
                subTabSelectSql.append(joinRelationStr);
                joinRelationMap.put(subTableName, (String)joinRelationMap.get(associalMainTable) + joinRelationStr);
            }
            subTabSelectSql.append(" Where ").append(mainTable).append(".FID IN ").append(mainTableId);
            subTabSelectSql.append(");");
        }
        StringBuffer deleteSQL = new StringBuffer();
        if (subTabSelectSql.length() > 0) {
            String[] sqlArray = subTabSelectSql.toString().split(CHAR_SEPERATOR);
            for (int i = sqlArray.length - 1; i >= 0; --i) {
                deleteSQL.append(sqlArray[i]).append(CHAR_SEPERATOR);
            }
        }
        deleteSQL.append(" Delete from ").append(info.getMainTable());
        deleteSQL.append(" Where FID IN (").append(mainTableId).append(")").append(CHAR_SEPERATOR);
        KsqlUtil.execute((Context)ctx, (String[])deleteSQL.toString().split(CHAR_SEPERATOR));
    }

    private String formatRelationStr(String joinType, String relationStr, String subTable) {
        StringBuffer joinRelationBuff = new StringBuffer();
        String joinTypeStr = null;
        joinTypeStr = joinType.equals(JoinTypeEnum.RIGHT_JOIN.getName()) ? " RIGHT OUTER JOIN " : (joinType.equals(JoinTypeEnum.LEFT_JOIN.getName()) ? " LEFT OUTER JOIN " : " INNER JOIN ");
        joinRelationBuff.append(joinTypeStr).append(subTable);
        joinRelationBuff.append(" AS ").append(subTable).append(" \r\n ");
        joinRelationBuff.append(" ON ").append(relationStr).append(" \r\n ");
        return joinRelationBuff.toString();
    }

    @Override
    protected void _updateBlob(Context ctx, String tblName, Map data) throws BOSException, EASBizException {
        Map blobData = (Map)data.get("blobData");
        Map blobId = (Map)data.get("blobId");
        String columnName2 = null;
        List blobList = null;
        List idList = null;
        String sql = null;
        ArrayList<Object[]> paramsList = null;
        Object[] params = null;
        String id = null;
        for (String columnName2 : blobId.keySet()) {
            blobList = (List)blobData.get(columnName2);
            idList = (List)blobId.get(columnName2);
            paramsList = new ArrayList<Object[]>();
            int size = blobList.size();
            for (int i = 0; i < size; ++i) {
                id = (String)idList.get(i);
                params = new Object[]{blobList.get(i), id.substring(1, id.length() - 1)};
                paramsList.add(params);
            }
            sql = "update " + tblName + " set " + columnName2 + "= ? where fid = ?";
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
        }
    }

    @Override
    protected byte[] _encodeFileOS(Context ctx, byte[] file) throws BOSException, EASBizException {
        return EncryptUtil.encrypt(file, TDParamUtil.getValue("td.solutionmgr.secret"));
    }

    @Override
    protected byte[] _decodeFileOS(Context ctx, byte[] file) throws BOSException, EASBizException {
        return EncryptUtil.decrypt(file, TDParamUtil.getValue("td.solutionmgr.secret"));
    }
}

