/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.solutionmgr.impexp.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.tm.td.solutionmgr.ExportSolutionMgrInfo;
import com.kingdee.eas.tm.td.solutionmgr.ExportSolutionSubTabCollection;
import com.kingdee.eas.tm.td.solutionmgr.ExportSolutionSubTabInfo;
import com.kingdee.eas.tm.td.solutionmgr.impexp.model.TableModel;
import com.kingdee.eas.tm.td.solutionmgr.impexp.util.FileUtil;
import com.kingdee.eas.tm.td.solutionmgr.impexp.util.ImpExpUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExpProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.solutionmgr.impexp.model.TableModel");
    protected ExportSolutionMgrInfo mgrInfo = null;
    protected String filter = null;
    protected List<TableModel> tableList = new ArrayList<TableModel>();
    protected Map params = null;
    private String filePath = null;
    protected String basePath = null;

    public ExpProcessor(ExportSolutionMgrInfo mgrInfo, String filter, Map params) {
        this.mgrInfo = mgrInfo;
        this.filter = filter;
        this.params = params;
        this.filePath = (String)params.get("filePath");
    }

    public void execute() throws BOSException {
        this.beforeExecute();
        this.doExecute();
        this.afterExecute();
    }

    private void beforeExecute() throws BOSException {
        this.basePath = FileUtil.createExpFileFolder(this.filePath, this.mgrInfo);
        this.initTableModel();
    }

    protected void initTableModel() {
        String mainTable = this.mgrInfo.getMainTable();
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(mainTable).append(".* from ");
        sql.append(mainTable).append(" AS ").append(mainTable);
        StringBuffer totalSql = new StringBuffer();
        totalSql.append("select count(1) from ").append(mainTable).append(" AS ").append(mainTable);
        TableModel tableModel = new TableModel(this.mgrInfo, null, true);
        tableModel.setSql(sql.toString());
        tableModel.setTotalSql(totalSql.toString());
        tableModel.setFilter(this.filter);
        tableModel.setBasePath(this.basePath);
        this.tableList.add(tableModel);
        ExportSolutionSubTabCollection subTableConn = this.mgrInfo.getSolutionSubTab();
        StringBuffer subTabSelectSql = new StringBuffer();
        String subTableName = null;
        String joinType = null;
        String relationStr = null;
        String joinRelationStr = null;
        String associalMainTable = null;
        HashMap<String, String> joinRelationMap = new HashMap<String, String>();
        ExportSolutionSubTabInfo subTabInfo = null;
        for (int i = 0; i < subTableConn.size(); ++i) {
            subTabSelectSql.setLength(0);
            totalSql.setLength(0);
            subTabInfo = subTableConn.get(i);
            subTableName = subTabInfo.getSubTable();
            associalMainTable = subTabInfo.getAssocialTable();
            joinType = subTabInfo.getJoinType().getName();
            relationStr = subTabInfo.getRelationStr();
            joinRelationStr = ImpExpUtil.formatRelationStr(joinType, relationStr, subTableName);
            joinRelationMap.put(subTableName, joinRelationStr);
            subTabSelectSql.append(" select ").append(subTableName).append(".* from ");
            subTabSelectSql.append(mainTable).append(" AS ").append(mainTable).append(" \r\n ");
            totalSql.append(" select count(1) from ");
            totalSql.append(mainTable).append(" AS ").append(mainTable).append(" \r\n ");
            if (associalMainTable.equals(mainTable)) {
                subTabSelectSql.append(joinRelationStr);
                totalSql.append(joinRelationStr);
            } else {
                subTabSelectSql.append((String)joinRelationMap.get(associalMainTable)).append(" \r\n ");
                subTabSelectSql.append(joinRelationStr);
                totalSql.append((String)joinRelationMap.get(associalMainTable)).append(" \r\n ");
                totalSql.append(joinRelationStr);
                joinRelationMap.put(subTableName, (String)joinRelationMap.get(associalMainTable) + joinRelationStr);
            }
            tableModel = new TableModel(this.mgrInfo, subTabInfo, false);
            tableModel.setSql(subTabSelectSql.toString());
            tableModel.setTotalSql(totalSql.toString());
            tableModel.setFilter(this.filter);
            tableModel.setBasePath(this.basePath);
            this.tableList.add(tableModel);
        }
    }

    private void doExecute() {
        TableModel tableModel2 = null;
        for (TableModel tableModel2 : this.tableList) {
            try {
                tableModel2.out();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void afterExecute() {
    }
}

