/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.solutionmgr.impexp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.streamwork.cuba.util.ByteArrayOutputStream;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.solutionmgr.ExportSolutionMgrInfo;
import com.kingdee.eas.tm.td.solutionmgr.SolutionMgrFacadeFactory;
import com.kingdee.eas.tm.td.solutionmgr.impexp.model.TablePageModel;
import com.kingdee.eas.tm.td.solutionmgr.tools.SolutionMgrUtil;
import com.kingdee.eas.tm.td.utils.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FileUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.solutionmgr.impexp.util.FileUtil");
    public static final String FILE_TYPE = ".dat";
    public static final String FILE_SPLIT = "-";
    public static final String FILE_PREFIX = "EXP#";

    public static String createExpFileFolder(String filePath, ExportSolutionMgrInfo mgrInfo) throws BOSException {
        String basePath = filePath + File.separator + FILE_PREFIX + mgrInfo.getNumber();
        File file = new File(basePath);
        if (file.exists()) {
            FileUtil.delAllFile(basePath);
        }
        file.mkdir();
        return basePath;
    }

    public static String[] getFileList(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        String[] tempList = file.list();
        return tempList;
    }

    public static List getChildFolderList(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        String[] tempList = file.list();
        ArrayList<String> folderList = new ArrayList<String>();
        for (int i = 0; i < tempList.length; ++i) {
            if (tempList[i].indexOf(FILE_PREFIX) < 0 || !(file = new File(path + File.separator + tempList[i])).exists() || !file.isDirectory()) continue;
            folderList.add(tempList[i]);
        }
        return folderList;
    }

    private static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            FileUtil.delAllFile(path + File.separator + tempList[i]);
            FileUtil.delFolder(path + File.separator + tempList[i]);
            flag = true;
        }
        return flag;
    }

    private static void delFolder(String folderPath) {
        try {
            FileUtil.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File createTableFile(TablePageModel pageModel) {
        String fileName = pageModel.getModel().getBasePath() + File.separator + pageModel.getModel().getTblName() + FILE_SPLIT + pageModel.getPageNo() + FILE_TYPE;
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        return file;
    }

    public static File createTableIdFile(TablePageModel pageModel) {
        File file;
        String fileName = pageModel.getModel().getBasePath() + File.separator + pageModel.getModel().getTblName() + FILE_SPLIT + pageModel.getPageNo() + FILE_SPLIT + "ID";
        if (pageModel.getModel().isMainTable()) {
            fileName = fileName + FILE_SPLIT + "MAIN";
        }
        if ((file = new File(fileName = fileName + FILE_TYPE)).exists()) {
            file.delete();
        }
        return file;
    }

    public static File createBlobFile(TablePageModel pageModel, String columnName, int rowIndex) {
        String fileName = pageModel.getModel().getBasePath() + File.separator + pageModel.getModel().getTblName() + FILE_SPLIT + pageModel.getPageNo() + FILE_SPLIT + columnName + FILE_SPLIT + rowIndex + FILE_TYPE;
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        return file;
    }

    public static String createFile(String basePath, String fileName) {
        String fileAllName = basePath + File.separator + fileName;
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        return fileAllName;
    }

    public static boolean isTableFile(String fileName) {
        return fileName.split(FILE_SPLIT).length == 2;
    }

    public static boolean isTableIdFile(String fileName) {
        String[] keys = fileName.split(FILE_SPLIT);
        return keys.length >= 3 && keys[2].equals("ID");
    }

    public static boolean isBlobFile(String fileName) {
        String[] keys = fileName.split(FILE_SPLIT);
        return keys.length == 4 && !keys[2].equals("ID");
    }

    public static String readFile2String(String fileName) throws BOSException, EASBizException {
        BufferedReader in = null;
        StringBuffer tableStr = new StringBuffer();
        String str = null;
        File tempFile = FileUtil.decodeFile(fileName);
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(tempFile), "UTF-8");
            in = new BufferedReader(isr);
            while ((str = in.readLine()) != null) {
                if (str.length() == 0 || str.startsWith("--")) continue;
                tableStr.append(str);
            }
        }
        catch (IOException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                tempFile.delete();
                throw throwable;
            }
        }
        IOUtils.close(in);
        tempFile.delete();
        return tableStr.toString();
    }

    public static String getFileSuffix(String fileName) {
        return fileName.substring(fileName.lastIndexOf("."), fileName.length());
    }

    public static String getFileNoSuffix(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static byte[] readFile2Byte(String fileName) throws BOSException {
        FileInputStream fin = null;
        ByteArrayOutputStream bou = null;
        try {
            fin = new FileInputStream(fileName);
            bou = new ByteArrayOutputStream();
            int x = 0;
            while ((x = fin.read()) != -1) {
                bou.write(x);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(fin);
                IOUtils.close(bou);
                throw throwable;
            }
        }
        IOUtils.close(fin);
        IOUtils.close((OutputStream)bou);
        return bou.toByteArray();
    }

    public static byte[] readFile2Byte(File file) throws BOSException {
        FileInputStream fin = null;
        ByteArrayOutputStream bou = null;
        try {
            fin = new FileInputStream(file);
            bou = new ByteArrayOutputStream();
            int x = 0;
            while ((x = fin.read()) != -1) {
                bou.write(x);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(fin);
                IOUtils.close(bou);
                throw throwable;
            }
        }
        IOUtils.close(fin);
        IOUtils.close((OutputStream)bou);
        return bou.toByteArray();
    }

    public static void writeEncodeFile(File file) throws BOSException, EASBizException {
        byte[] fileData = SolutionMgrFacadeFactory.getRemoteInstance().encodeFileOS(FileUtil.readFile2Byte(file));
        SolutionMgrUtil.writeExpFile(fileData, file.getPath());
    }

    public static File decodeFile(String fileName) throws BOSException, EASBizException {
        byte[] decodeFile = SolutionMgrFacadeFactory.getRemoteInstance().decodeFileOS(FileUtil.readFile2Byte(fileName));
        SolutionMgrUtil.writeExpFile(decodeFile, fileName + "_bak");
        return new File(fileName + "_bak");
    }
}

