/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.StatusEnum;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.TDCloudException;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateFactory;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateInfo;
import com.kingdee.eas.tm.td.structure.TaxStructureExeception;
import com.kingdee.eas.tm.td.structure.app.AbstractTaxReportTemplateControllerBean;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxReportTemplateControllerBean
extends AbstractTaxReportTemplateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.structure.app.TaxReportTemplateControllerBean");
    private static final String NEXTLINE = ";\r\n";

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._addnew(ctx, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxReportTemplateInfo info = (TaxReportTemplateInfo)model;
        info.setId(BOSUuid.create((String)"9B933163"));
        IObjectPK logPk = LogUtils.beginLog(ctx, "addNew", BOSObjectType.create((String)"9B933163"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "td_" + this.getTemplateType(info.getRecordType()) + "_addnew", info.getCU().getId().toString());
        IObjectPK pk = super._addnew(ctx, model);
        LogUtils.afterLog(ctx, logPk);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxReportTemplateInfo info = (TaxReportTemplateInfo)model;
        IObjectPK logPk = LogUtils.beginLog(ctx, "edit", BOSObjectType.create((String)"9B933163"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "td_" + this.getTemplateType(info.getRecordType()) + "_update", info.getCU().getId().toString());
        super._update(ctx, pk, model);
        LogUtils.afterLog(ctx, logPk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkBeforeSave(ctx, model);
        this._checkNumberDup(ctx, model);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkBeforeSave(ctx, model);
        this._checkNumberDup(ctx, model);
        return super._submit(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxReportTemplateInfo dataBaseInfo = (TaxReportTemplateInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "NUMBER", ctx.getLocale()) + " : " + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TaxReportTemplateInfo info = TaxReportTemplateFactory.getLocalInstance(ctx).getTaxReportTemplateInfo(pk);
        IObjectPK logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"9B933163"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "td_" + this.getTemplateType(info.getRecordType()) + "_delete", info.getCU().getId().toString());
        this.checkBeforeDelete(ctx, (IObjectValue)info);
        super._delete(ctx, pk);
        LogUtils.afterLog(ctx, logPk);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxReportTemplateInfo info = TaxReportTemplateFactory.getLocalInstance(ctx).getTaxReportTemplateInfo(pk);
        IObjectPK logPk = LogUtils.beginLog(ctx, "edit", BOSObjectType.create((String)"9B933163"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "td_" + this.getTemplateType(info.getRecordType()) + "_cancel", info.getCU().getId().toString());
        this.checkBeforeCancel(ctx, (IObjectValue)info);
        info.setState(StatusEnum.DisEnable);
        super._update(ctx, pk, (IObjectValue)info);
        LogUtils.afterLog(ctx, logPk);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxReportTemplateInfo info = TaxReportTemplateFactory.getLocalInstance(ctx).getTaxReportTemplateInfo(pk);
        IObjectPK logPk = LogUtils.beginLog(ctx, "edit", BOSObjectType.create((String)"9B933163"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "td_" + this.getTemplateType(info.getRecordType()) + "_cancelCancel", info.getCU().getId().toString());
        this.checkBeforeCancelCancel(ctx, (IObjectValue)info);
        info.setState(StatusEnum.Enable);
        super._update(ctx, pk, (IObjectValue)info);
        LogUtils.afterLog(ctx, logPk);
    }

    private void checkBeforeSave(Context ctx, IObjectValue value) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        String NotNull = TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "NotNull", ctx.getLocale());
        if (StringUtils.isEmpty((String)((String)value.get("number")))) {
            String number = TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "NUMBER", ctx.getLocale());
            errorMsg.append(number).append(NotNull).append(NEXTLINE);
        }
        if (StringUtils.isEmpty((String)((String)value.get("name")))) {
            String name = TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "NAME", ctx.getLocale());
            if (!StringUtils.isEmpty((String)((String)value.get("number")))) {
                errorMsg.append((String)value.get("number")).append(":");
            }
            errorMsg.append(name).append(NotNull).append(NEXTLINE);
        }
        if (errorMsg.length() > 0) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{errorMsg});
        }
    }

    private void checkBeforeDelete(Context ctx, IObjectValue value) throws BOSException, EASBizException {
        if ("2".equals(value.get("state"))) {
            throw new TDCloudException(TDCloudException.DELETE_STATUS_ERROR1);
        }
        if (value.getBoolean("isScheduled")) {
            throw new TDCloudException(TDCloudException.DELETE_STATUS_ERROR2);
        }
        if (this.existReferences(ctx, value)) {
            throw new TaxStructureExeception(TaxStructureExeception.TAXTEMPLATE_EXISTREFERENCES);
        }
    }

    private boolean existReferences(Context ctx, IObjectValue value) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from T_TD_TaxDraftRecord where FTempletReport = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{value.get("id").toString()});
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private void checkBeforeCancel(Context ctx, IObjectValue value) throws BOSException, EASBizException {
        if (!"2".equals(value.get("state"))) {
            throw new TDCloudException(TDCloudException.CANCEL_STATUS_ERROR);
        }
    }

    private void checkBeforeCancelCancel(Context ctx, IObjectValue value) throws BOSException, EASBizException {
        if ("2".equals(value.get("state"))) {
            throw new TDCloudException(TDCloudException.CANCELCANCEL_STATUS_ERROR);
        }
    }

    @Override
    protected boolean _isHasItemData(Context ctx, String id) throws BOSException, EASBizException {
        TaxReportTemplateInfo info = TaxReportTemplateFactory.getLocalInstance(ctx).getTaxReportTemplateInfo((IObjectPK)new ObjectUuidPK(id));
        Book book = null;
        try {
            book = info.getBook();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        Map itemData = null;
        return book != null && (itemData = StructureUtils.getItemformulaByBook(book)).size() > 0;
    }

    protected String getTemplateType(RecordTypeEnum recordType) {
        if (RecordTypeEnum.Account == recordType) {
            return "accounttemplate";
        }
        if (RecordTypeEnum.DraftItem == recordType) {
            return "draftitemtemplate";
        }
        if (RecordTypeEnum.TaxDeclare == recordType) {
            return "taxdeclaretemplate";
        }
        return "accounttemplate";
    }
}

