/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.td.DraftStatusEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.YearMonthVo;
import com.kingdee.eas.tm.td.cloud.datamodel.utils.DataModelUtil;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.structure.TaxItemFormulaFacadeFactory;
import com.kingdee.eas.tm.td.structure.TaxReportItemFactory;
import com.kingdee.eas.tm.td.structure.TaxReportItemInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetFactory;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateFactory;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateInfo;
import com.kingdee.eas.tm.td.structure.TaxStructureExeception;
import com.kingdee.eas.tm.td.structure.app.AbstractTaxStructureFacadeControllerBean;
import com.kingdee.eas.tm.td.structure.utils.StructureDynamicTableManager;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.tm.td.structure.utils.TaxItemFormula;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxStructureFacadeControllerBean
extends AbstractTaxStructureFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.structure.app.TaxStructureFacadeControllerBean");

    @Override
    protected Map _getNextItemNumberBySheet(Context ctx, String sheetID, int itemDimension) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("taxType.*");
        ObjectUuidPK pk = new ObjectUuidPK(sheetID);
        TaxReportSheetInfo sheetInfo = TaxReportSheetFactory.getLocalInstance(ctx).getTaxReportSheetInfo((IObjectPK)pk, sic);
        StringBuffer number = new StringBuffer();
        number.append(sheetInfo.getNumber());
        if (0 == itemDimension) {
            number.append("L").append("-");
        } else if (1 == itemDimension) {
            number.append("C").append("-");
        }
        number.append("AUTO").append("-");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT MAX(FNumber) as maxNumber FROM T_TD_TaxReportItem where FNumber LIKE '").append(number.toString()).append("%'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int seq = 1;
        try {
            String maxNumber;
            if (rs.next() && !StringUtils.isEmpty((String)(maxNumber = rs.getString("maxNumber")))) {
                seq = Integer.parseInt(maxNumber.substring(number.length(), maxNumber.length()).split("\\.")[0]) + 1;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("number", number.toString());
        ret.put("seq", seq);
        return ret;
    }

    @Override
    protected Map _saveReportItems(Context ctx, List items) throws BOSException, EASBizException {
        Iterator it = items.iterator();
        while (it.hasNext()) {
            TaxReportItemFactory.getLocalInstance(ctx).submit((CoreBaseInfo)it.next());
        }
        return null;
    }

    @Override
    protected Map _synchFormulaData(Context ctx, Map params) throws EASBizException, BOSException {
        String reportId = (String)params.get("reportId");
        TaxReportTemplateInfo templateInfo = TaxReportTemplateFactory.getLocalInstance(ctx).getTaxReportTemplateInfo((IObjectPK)new ObjectUuidPK(reportId));
        IObjectPK logPk = LogUtils.beginLog(ctx, "edit", BOSObjectType.create((String)"9B933163"), (IObjectPK)new ObjectUuidPK(templateInfo.getId().toString()), templateInfo.getNumber(), "td_" + this.getTemplateType(templateInfo.getRecordType()) + "_sync", templateInfo.getCU().getId().toString());
        Map initMap = this.initTemplateFormulaData(ctx, templateInfo);
        Map itemFormulaMap = (Map)initMap.get("itemFormulaMap");
        Map sheetMap = (Map)initMap.get("sheetMap");
        Map copyToReportMap = this.getCopyToReportMap(ctx, params, templateInfo);
        int yearFrom = (Integer)params.get("yearFrom");
        int monthFrom = (Integer)params.get("monthFrom");
        int yearTo = (Integer)params.get("yearTo");
        int monthTo = (Integer)params.get("monthTo");
        List companyIds = StructureUtils.getF7Value(params.get("company"));
        List<YearMonthVo> rangePeriod = DataModelUtil.getRangePeriod(yearFrom, monthFrom, yearTo, monthTo);
        CompanyOrgUnitCollection cous = this.getCompanyOrgUnitCollection(ctx, companyIds);
        ArrayList<String> errorMsg = new ArrayList<String>();
        ArrayList successMsg = new ArrayList();
        YearMonthVo yearMonthVo2 = null;
        TaxDraftRecordInfo reportInfo = null;
        CompanyOrgUnitInfo cou = null;
        int totalSize = cous.size() * rangePeriod.size();
        int size = cous.size();
        for (int i = 0; i < size; ++i) {
            cou = cous.get(i);
            for (YearMonthVo yearMonthVo2 : rangePeriod) {
                reportInfo = (TaxDraftRecordInfo)copyToReportMap.get(cou.getId().toString() + "_" + yearMonthVo2.toString());
                if (reportInfo == null) {
                    errorMsg.add(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "Report_Not_Found", ctx.getLocale(), new Object[]{cou.getName(), yearMonthVo2.toString()}));
                    continue;
                }
                if (!this.isSupportSynch(reportInfo, params)) {
                    errorMsg.add(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "Report_Status_Error", ctx.getLocale(), new Object[]{reportInfo.getNumber(), reportInfo.getName()}));
                    continue;
                }
                this.updateReportItemFormulaData(ctx, itemFormulaMap, sheetMap, reportInfo, templateInfo, errorMsg, successMsg);
            }
        }
        LogUtils.afterLog(ctx, logPk);
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("totalSize", Integer.valueOf(totalSize));
        ret.put("errorMsg", errorMsg);
        ret.put("successMsg", successMsg);
        return ret;
    }

    private boolean isSupportSynch(TaxDraftRecordInfo reportInfo, Map params) {
        boolean isSynchAuditOrDeclare = (Boolean)params.get("isSynch");
        return isSynchAuditOrDeclare || !DraftStatusEnum.AUDIT.equals((Object)reportInfo.getDraftStatus()) && !DraftStatusEnum.DECLARING.equals((Object)reportInfo.getDraftStatus()) && !DraftStatusEnum.DECLARED.equals((Object)reportInfo.getDraftStatus());
    }

    private Map initTemplateFormulaData(Context ctx, TaxReportTemplateInfo info) throws EASBizException, BOSException {
        Book book = null;
        try {
            book = info.getBook();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaxStructureExeception(TaxStructureExeception.TAXTEMPLATE_GETBOOK_ERROR);
        }
        if (book == null) {
            throw new TaxStructureExeception(TaxStructureExeception.TAXTEMPLATE_NOTSAVE);
        }
        Map itemFormulaData = StructureUtils.getItemformulaByBook(book);
        HashMap itemFormulaMap = new HashMap();
        HashMap<String, Sheet> sheetMap = new HashMap<String, Sheet>();
        String sheetName = null;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sheetName = book.getSheetName(i);
            itemFormulaMap.put(sheetName, new ArrayList());
            sheetMap.put(sheetName, book.getSheet(i));
        }
        List formulaList = null;
        for (Object key : itemFormulaData.keySet()) {
            TaxItemFormula f = (TaxItemFormula)itemFormulaData.get(key);
            Sheet sheet = f.getSheet();
            formulaList = (List)itemFormulaMap.get(sheet.getSheetName());
            formulaList.add(f);
        }
        HashMap ret = new HashMap();
        ret.put("itemFormulaMap", itemFormulaMap);
        ret.put("sheetMap", sheetMap);
        return ret;
    }

    private Map getCopyToReportMap(Context ctx, Map params, TaxReportTemplateInfo info) throws BOSException {
        String taxTypeId = info.getTaxType().getId().toString();
        int recordType = info.getRecordType().getValue();
        List companyIds = StructureUtils.getF7Value(params.get("company"));
        String yearFrom = String.valueOf(params.get("yearFrom"));
        String monthFrom = String.valueOf(params.get("monthFrom"));
        String yearTo = String.valueOf(params.get("yearTo"));
        String monthTo = String.valueOf(params.get("monthTo"));
        String periodFrom = StructureUtils.getPeriodNumber(yearFrom, monthFrom);
        String periodTo = StructureUtils.getPeriodNumber(yearTo, monthTo);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)taxTypeId));
        filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)recordType));
        if (recordType == 0) {
            String accountConfigId = info.getAccountConfig().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("relateAccount", (Object)accountConfigId));
        }
        filter.getFilterItems().add(new FilterItemInfo("rptPeriod.number", (Object)periodFrom, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("rptPeriod.number", (Object)periodTo, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", new HashSet(companyIds), CompareType.INCLUDE));
        view.setFilter(filter);
        TaxDraftRecordCollection coll = TaxDraftRecordFactory.getLocalInstance(ctx).getTaxDraftRecordCollection(view);
        HashMap<String, TaxDraftRecordInfo> ret = new HashMap<String, TaxDraftRecordInfo>();
        TaxDraftRecordInfo reportInfo = null;
        String key = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            reportInfo = coll.get(i);
            key = reportInfo.getCompanyOrgUnit().getId().toString() + "_" + reportInfo.getRptPeriod().getNumber();
            ret.put(key, reportInfo);
        }
        return ret;
    }

    private CompanyOrgUnitCollection getCompanyOrgUnitCollection(Context ctx, List ids) throws BOSException {
        CompanyOrgUnitCollection coll = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        return coll;
    }

    private void updateReportItemFormulaData(Context ctx, Map itemFormulaMap, Map sheetMap, TaxDraftRecordInfo reportInfo, TaxReportTemplateInfo templateInfo, List errorMsg, List successMsg) throws EASBizException, BOSException {
        Book book = null;
        Sheet sheet = null;
        try {
            book = TDUtils.getReportBook(ctx, (IObjectValue)reportInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            errorMsg.add(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "Report_getData_Error", ctx.getLocale(), new Object[]{reportInfo.getNumber(), reportInfo.getName()}));
            return;
        }
        String sheetName2 = null;
        List itemFormulaList = null;
        TaxItemFormula itemFormula2 = null;
        boolean hasSynchSuccess = false;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sheet = book.getSheet(i);
            sheetName2 = sheet.getSheetName();
            itemFormulaList = (List)itemFormulaMap.get(sheetName2);
            if (itemFormulaList == null) continue;
            int row = sheet.getRows().getMaxIntMark() + 1;
            int col = sheet.getCols().getMaxIntMark() + 1;
            sheet.getRange(0, 0, row, col).clear(false, false, false, false, new String[]{"TAXITEM"});
            Cell cell = null;
            if (itemFormulaList != null && itemFormulaList.size() > 0) {
                for (TaxItemFormula itemFormula2 : itemFormulaList) {
                    cell = itemFormula2.getCell();
                    sheet.getRange(cell.getRow(), cell.getCol()).setUserObject("TAXITEM", (Object)itemFormula2);
                }
            }
            hasSynchSuccess = true;
        }
        boolean isOverrideSheet = false;
        String moduleSynchOverrideSheet = TDUtils.getTDParamsValue(ctx, "moduleSynchOverrideSheet");
        String[] overideSheetNames = moduleSynchOverrideSheet.split(";");
        int sheetIndex = 0;
        Sheet templateSheet = null;
        Sheet reportSheet = null;
        for (String sheetName2 : overideSheetNames) {
            templateSheet = (Sheet)sheetMap.get(sheetName2);
            sheetIndex = book.getSheetIndexByName(sheetName2);
            if (templateSheet != null) {
                book.removeSheet(sheetName2);
                reportSheet = new Sheet(book, sheetName2);
                reportSheet.copySheetFrom(templateSheet);
                if (sheetIndex >= 0) {
                    book.insertSheet(sheetIndex, reportSheet);
                } else {
                    book.addSheet(reportSheet);
                }
                isOverrideSheet = true;
                continue;
            }
            if (templateSheet != null || sheetIndex < 0) continue;
            book.removeSheet(sheetName2);
            isOverrideSheet = true;
        }
        if (isOverrideSheet) {
            try {
                TDUtils.calculateBook(ctx, reportInfo, book);
            }
            catch (Exception e1) {
                throw new BOSException((Throwable)e1);
            }
        }
        if (!hasSynchSuccess && !isOverrideSheet) {
            errorMsg.add(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "Report_Not_Match", ctx.getLocale(), new Object[]{reportInfo.getNumber(), reportInfo.getName()}));
            return;
        }
        try {
            reportInfo.setBook(book);
        }
        catch (IOException e) {
            logger.error((Object)e);
            errorMsg.add(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "Report_setData_Error", ctx.getLocale(), new Object[]{reportInfo.getNumber(), reportInfo.getName()}));
            return;
        }
        reportInfo.setTempletReport(templateInfo);
        TaxDraftRecordFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(reportInfo.getId().toString()), reportInfo);
        TaxItemFormulaFacadeFactory.getLocalInstance(ctx).saveItemData((IObjectValue)reportInfo);
        successMsg.add(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ReportSynchSuccess", ctx.getLocale(), new Object[]{reportInfo.getNumber(), reportInfo.getName()}));
    }

    @Override
    protected Map _getItemDataByDim(Context ctx, List billIds, String key) throws BOSException, EASBizException {
        if (billIds == null || billIds.size() == 0 || StringUtils.isEmpty((String)key)) {
            return null;
        }
        String[] keys = key.split("_");
        if (keys.length < 3) {
            return null;
        }
        String sheetNumber = keys[0];
        String rowItemNumber = keys[1];
        String columnItemNumber = keys[2];
        String buildingTaxesGroupNumber = null;
        if (keys.length == 4) {
            buildingTaxesGroupNumber = keys[3];
        }
        TaxReportSheetInfo sheetInfo = StructureUtils.getTaxReportSheetByNumber(ctx, sheetNumber);
        TaxReportItemInfo rowItem = StructureUtils.getTaxReportItemByNumber(ctx, rowItemNumber);
        TaxReportItemInfo columnItem = StructureUtils.getTaxReportItemByNumber(ctx, columnItemNumber);
        RealEstateGroupInfo buildingTaxesGroup = null;
        if (!StringUtils.isEmpty((String)buildingTaxesGroupNumber)) {
            buildingTaxesGroup = StructureUtils.getBuildingTaxesGroupNumberByNumber(ctx, buildingTaxesGroupNumber);
        }
        if (sheetInfo == null || rowItem == null || columnItem == null) {
            return null;
        }
        String tblName = StructureDynamicTableManager.getPhysicalTblName(ctx, sheetInfo.getId().toString());
        if (StringUtils.isEmpty((String)tblName)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FReportID,isNull(fvalue2,TOCHAR(fvalue1)) as FValue  from ").append(tblName).append("\n");
        sql.append("where FReportID in (").append(CollectionUtil.convertList2String(billIds)).append(")").append("\n");
        sql.append("and FSheetID='").append(sheetInfo.getId().toString()).append("'").append("\n");
        sql.append("and FRowItemID='").append(rowItem.getId().toString()).append("'").append("\n");
        sql.append("and FColumnItemID='").append(columnItem.getId().toString()).append("'").append("\n");
        if (buildingTaxesGroup != null) {
            sql.append("and FBuildingTaxesGroupID='").append(buildingTaxesGroup.getId().toString()).append("'").append("\n");
        }
        HashMap<String, Object> reportItemValueMap = new HashMap<String, Object>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                reportItemValueMap.put(rs.getString("FReportID"), rs.getObject("FValue"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return reportItemValueMap;
    }

    protected String getTemplateType(RecordTypeEnum recordType) {
        if (RecordTypeEnum.Account == recordType) {
            return "accounttemplate";
        }
        if (RecordTypeEnum.DraftItem == recordType) {
            return "draftitemtemplate";
        }
        if (RecordTypeEnum.TaxDeclare == recordType) {
            return "taxdeclaretemplate";
        }
        return "accounttemplate";
    }
}

