/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.structure.StructDynTblMapCollection;
import com.kingdee.eas.tm.td.structure.StructDynTblMapEntryCollection;
import com.kingdee.eas.tm.td.structure.StructDynTblMapEntryInfo;
import com.kingdee.eas.tm.td.structure.StructDynTblMapFactory;
import com.kingdee.eas.tm.td.structure.StructDynTblMapInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetFactory;
import com.kingdee.eas.tm.td.structure.utils.StructureDbUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class StructureDynamicTableManager {
    private static Logger logger = Logger.getLogger((String)StructureDynamicTableManager.class.getName());
    private static CustomCacheService m_DynamicTblMapCache = new CustomCacheService("TaxModule.StructDynTblMap");
    private static final char CLF = '\n';
    private static ThreadLocal threadLocal = new ThreadLocal();

    public static String getPhysicalTblNameWithCreate(Context ctx, String sheetID) throws BOSException, EASBizException {
        String physTableName = StructureDynamicTableManager.getPhysicalTblName(ctx, sheetID);
        if (physTableName != null) {
            return physTableName;
        }
        String[] tblNameInfo = StructureDynamicTableManager.getRandomTblName(ctx);
        if (tblNameInfo.length == 2 && StructureDynamicTableManager.createDynamicTable(ctx, sheetID, tblNameInfo)) {
            physTableName = tblNameInfo[0];
            StructureDynamicTableManager.recordTblMapping(ctx, sheetID, physTableName, tblNameInfo[1]);
        }
        StructureDynamicTableManager.setPhysicalTblNameFromContext(ctx, sheetID, physTableName);
        m_DynamicTblMapCache.put(sheetID, (Object)physTableName);
        return physTableName;
    }

    public static String getPhysicalTblName(Context ctx, String sheetID) throws BOSException, EASBizException {
        String sKey = sheetID;
        String phyTblName = StructureDynamicTableManager.getPhysicalTblNameFromContext(ctx, sheetID);
        if (phyTblName != null) {
            return phyTblName;
        }
        phyTblName = (String)m_DynamicTblMapCache.get(sKey);
        if (phyTblName != null) {
            return phyTblName;
        }
        String sql = "Select physicalTblName,needUpdateIndex,needUpdateColumn, entries.* where reportSheet='" + sheetID + "'";
        StructDynTblMapCollection data = StructDynTblMapFactory.getLocalInstance(ctx).getStructDynTblMapCollection(sql);
        StructDynTblMapInfo structDynTblMapInfo = null;
        if (data != null && data.size() > 0) {
            structDynTblMapInfo = data.get(0);
            String physicalTblName = structDynTblMapInfo.getPhysicalTblName();
            if (data.get(0).isNeedUpdateIndex()) {
                StructureDynamicTableManager.updateIndexs(ctx, sheetID, physicalTblName, structDynTblMapInfo);
            }
            if (data.get(0).isNeedUpdateColumn()) {
                StructureDynamicTableManager.updateColumn(ctx, sheetID, physicalTblName, structDynTblMapInfo);
            }
            StructureDynamicTableManager.setPhysicalTblNameFromContext(ctx, sheetID, physicalTblName);
            m_DynamicTblMapCache.put(sKey, (Object)physicalTblName);
            return physicalTblName;
        }
        return null;
    }

    private static void updateColumn(Context ctx, String sheetID, String physicalTblName, StructDynTblMapInfo tblMap) throws EASBizException, BOSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isColumnExists(Context ctx, String tblName, String columnName) throws SQLException {
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '" + tblName + "' AND KSQL_COL_NAME = '" + columnName + "'  )";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            boolean bl = rs.next();
            return bl;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return false;
    }

    private static void updateIndexs(Context ctx, String sheetID, String physicalTblName, StructDynTblMapInfo tblMap) throws EASBizException, BOSException {
        StructDynTblMapEntryCollection idxs = tblMap.getEntries();
        StringBuffer sb = new StringBuffer();
        String sql = null;
        String indexName = null;
        String indexColumns = null;
        indexColumns = "FCompanyID,FPeriodID";
        if (!StructureDynamicTableManager.containIndex(idxs, indexColumns)) {
            sql = "CREATE INDEX {0} ON {1} (FCompanyID ASC,FPeriodID ASC);";
            indexName = StructureDynamicTableManager.getValidIndexName(ctx);
            sb.append(MessageFormat.format(sql, indexName, physicalTblName)).append('\n');
            StructureDynamicTableManager.recordTblMapping_Entry(ctx, tblMap, indexName, indexColumns);
        }
        try {
            if (sb.length() > 0) {
                StructureDbUtil.batchSqlExecute(ctx, sb.toString(), ";");
            }
        }
        catch (BOSException e) {
            logger.debug((Object)("Create indexs for dynamic business table " + physicalTblName + " error."), (Throwable)e);
        }
        ObjectUuidPK pk = new ObjectUuidPK(tblMap.getId());
        tblMap.setNeedUpdateIndex(false);
        StructDynTblMapFactory.getLocalInstance(ctx).update((IObjectPK)pk, tblMap);
    }

    public static boolean deleteTable(Context ctx, String physicalTblName, String whereClause) throws SQLException {
        Assert.that((physicalTblName != null ? 1 : 0) != 0);
        String sqlTrunc = "truncate table " + physicalTblName;
        String sqlDelete = "delete from  " + physicalTblName;
        if (whereClause != null) {
            sqlDelete = sqlDelete + " " + whereClause;
        }
        try {
            if (StructureDynamicTableManager.isTableExists(ctx, physicalTblName)) {
                if (whereClause == null) {
                    DbUtil.execute((Context)ctx, (String)sqlTrunc);
                } else {
                    DbUtil.execute((Context)ctx, (String)sqlDelete);
                }
            }
        }
        catch (BOSException e) {
            throw new SQLException(e.getMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPhysicalTblNameOnContext(Context ctx) {
        if (ctx != null) {
            Context context = ctx;
            synchronized (context) {
                Map map = (Map)threadLocal.get();
                if (map == null) {
                    threadLocal.set(new HashMap());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releasePhysicalTblNameOnContext(Context ctx) {
        if (ctx != null) {
            Context context = ctx;
            synchronized (context) {
                threadLocal.set(null);
            }
        }
    }

    private static void recordTblMapping_Entry(Context ctx, StructDynTblMapInfo parent, String indexName, String indexColumns) throws BOSException, EASBizException {
        StructDynTblMapEntryInfo data = new StructDynTblMapEntryInfo();
        data.setParent(parent);
        data.setIndexName(indexName);
        data.setIndexColumns(indexColumns);
        parent.getEntries().add(data);
    }

    public static String getValidIndexName(Context ctx) throws BOSException {
        String indexName;
        do {
            if ((indexName = new UUTN("ZC").toString()).length() <= 10) continue;
            indexName = indexName.substring(0, 10);
        } while (StructureDynamicTableManager.isIndexExists(ctx, indexName = indexName.replaceFirst("ZC", "IX_TAX")));
        return indexName;
    }

    private static boolean isIndexExists(Context ctx, String indexName) throws BOSException {
        Assert.that((indexName != null ? 1 : 0) != 0);
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = ? )";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{indexName});
        try {
            return rs.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static boolean containIndex(StructDynTblMapEntryCollection idxs, String columns) {
        StructDynTblMapEntryInfo item = null;
        for (int i = 0; i < idxs.size(); ++i) {
            item = idxs.get(i);
            if (!item.getIndexColumns().equals(columns)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPhysicalTblNameFromContext(Context ctx, String sheetID) {
        if (ctx != null && sheetID != null) {
            Context context = ctx;
            synchronized (context) {
                Map map = (Map)threadLocal.get();
                if (map != null) {
                    String phyTblName = (String)map.get(sheetID);
                    return phyTblName;
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setPhysicalTblNameFromContext(Context ctx, String sheetID, String phyTblName) {
        if (ctx != null && sheetID != null && phyTblName != null) {
            Context context = ctx;
            synchronized (context) {
                Map map = (Map)threadLocal.get();
                if (map != null) {
                    map.put(sheetID, phyTblName);
                }
            }
        }
    }

    private static void recordTblMapping(Context ctx, String sheetID, String physicalTblName, String consName) throws BOSException, EASBizException {
        StructDynTblMapInfo data = new StructDynTblMapInfo();
        data.setReportSheet(TaxReportSheetFactory.getLocalInstance(ctx).getTaxReportSheetInfo((IObjectPK)new ObjectUuidPK(sheetID)));
        data.setPhysicalTblName(physicalTblName);
        data.setPrimaryKeyName(consName);
        data.setNeedUpdateIndex(true);
        StructDynTblMapFactory.getLocalInstance(ctx).addnew(data);
    }

    private static boolean createDynamicTable(Context ctx, String sheetID, String[] physicalTblNameInfo) throws EASBizException, BOSException {
        String sql = "Create Table {0} ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FPeriodID VARCHAR(44),FTaxTypeID VARCHAR(44),FRecordType int,FAccountConfigID VARCHAR(44),FBuildingTaxesGroupID VARCHAR(44),FReportID VARCHAR(44),FSheetID VARCHAR(44),FRowItemID VARCHAR(44),FColumnItemID VARCHAR(44),FValueType VARCHAR(20),FValue1 NUMERIC(28,16),FValue2 NVARCHAR(255),FDraftRecordType int,CONSTRAINT {1} PRIMARY KEY (FID))";
        String tblName = physicalTblNameInfo[0];
        String tblPkName = physicalTblNameInfo[1];
        Object[] param = null;
        if (sql != null) {
            if (param == null) {
                param = tblPkName == null ? new Object[]{tblName} : new Object[]{tblName, tblPkName};
            }
            sql = MessageFormat.format(sql, param);
            String dbTypeName = (String)ctx.get((Object)"dbType");
            int currentDataBaseType = DbType.getValue((String)dbTypeName);
            if ((currentDataBaseType == 2 || currentDataBaseType == 7 || currentDataBaseType == 8) && sql.indexOf("Create Table") >= 0 && sql.substring(sql.length() - 1).equals(")")) {
                String SelDefine = null;
                try {
                    SelDefine = TransUtil.Translate((String)sql, (int)currentDataBaseType);
                }
                catch (SqlTranslateException e) {
                    throw new BOSException(e.getMessage());
                }
                sql = "/*dialect*/" + SelDefine + " nologging ";
            }
            DbUtil.execute((Context)ctx, (String)sql);
            return true;
        }
        return false;
    }

    private static String[] getRandomTblName(Context ctx) throws BOSException {
        String tablePkConstrait;
        String tableName;
        do {
            if ((tableName = new UUTN(true).toString()).length() > 28) {
                tableName = tableName.substring(0, 28);
            }
            tableName = tableName.replaceFirst("VT", "TAX");
            tablePkConstrait = new UUTN("ZC").toString();
            if (tablePkConstrait.length() > 10) {
                tablePkConstrait = tablePkConstrait.substring(0, 10);
            }
            tablePkConstrait = tablePkConstrait.replaceFirst("ZC", "PK_TAX");
        } while (StructureDynamicTableManager.isTableExists(ctx, tableName) || StructureDynamicTableManager.isConstrainsExists(ctx, tablePkConstrait));
        return new String[]{tableName, tablePkConstrait};
    }

    private static boolean isTableExists(Context ctx, String tableName) throws BOSException {
        Assert.that((tableName != null ? 1 : 0) != 0);
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = ?)";
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{tableName});
        try {
            return rs.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static boolean isConstrainsExists(Context ctx, String consName) throws BOSException {
        Assert.that((consName != null ? 1 : 0) != 0);
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_CONSTRAINTS WHERE  KSQL_CONS_NAME = '" + consName + "' )";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            return rs.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

