/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.FillType;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.Validate;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.ITDFacade;
import com.kingdee.eas.tm.td.ITaxDraftRecord;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.account.engine.model.AccountCalculatorParams;
import com.kingdee.eas.tm.td.account.engine.model.AccountCalculatorResult;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryCollection;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.basedata.IAccountConfig;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.tm.td.utils.Location;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountTakeDataUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.utils.AccountTakeDataUtil");
    private static Map<String, List> enumDataMap = new HashMap<String, List>();
    private static Map<String, List<String>> enumAliasListMap = new HashMap<String, List<String>>();
    private static Map<String, Map<String, String>> enumAliasMap = new HashMap<String, Map<String, String>>();

    public static void accountTakeData(Context ctx, TaxDraftRecordInfo recordInfo, Book book) throws EASBizException, BOSException {
        AccountCalculatorResult result = AccountTakeDataUtil.getAccountData(ctx, recordInfo);
        if (result != null) {
            for (int i = 0; i < book.getSheetCount(); ++i) {
                book.getSheet(i).setSelected(false);
            }
            if (recordInfo.getRelateAccount().isIsTotal()) {
                AccountTakeDataUtil.addAccountDataTotalSheet(ctx, recordInfo, book, result);
            }
            AccountTakeDataUtil.addAccountDataSheet(ctx, recordInfo, book, result);
            if (result.getSumRs() != null) {
                AccountTakeDataUtil.addAccountDataSumSheet(ctx, recordInfo, book, result);
            }
        }
    }

    public static AccountCalculatorResult getAccountData(Context ctx, TaxDraftRecordInfo recordInfo) throws EASBizException, BOSException {
        AccountConfigInfo accountConfigInfo = recordInfo.getRelateAccount();
        if (accountConfigInfo == null) {
            return null;
        }
        String accountId = accountConfigInfo.getId().toString();
        IAccountConfig iaccountconfig = ctx == null ? AccountConfigFactory.getRemoteInstance() : AccountConfigFactory.getLocalInstance(ctx);
        accountConfigInfo = iaccountconfig.getAccountConfigInfo((IObjectPK)new ObjectUuidPK(accountId));
        AccountCalculatorResult calculatorResult = null;
        AccountCalculatorParams params = new AccountCalculatorParams();
        params.setAccountID(accountConfigInfo.getId().toString());
        params.setCompanyID(recordInfo.getCompanyOrgUnit().getId().toString());
        params.setStartDate(recordInfo.getStartDate());
        params.setEndDate(recordInfo.getEndDate());
        if (recordInfo.getRptPeriod() != null) {
            params.setPeriodID(recordInfo.getRptPeriod().getId().toString());
        }
        params.setYear(recordInfo.getYear());
        params.setPeriod(recordInfo.getPeriod());
        if (recordInfo.getRptPeriodFrom() != null) {
            params.put("periodFromID", recordInfo.getRptPeriodFrom().getId().toString());
        }
        if (recordInfo.getRptPeriodTo() != null) {
            params.put("periodToID", recordInfo.getRptPeriodTo().getId().toString());
        }
        if (recordInfo.getOrgTree() != null) {
            params.put("orgTreeID", recordInfo.getOrgTree().getId().toString());
        }
        if (recordInfo.getBuildingTaxesGroup() != null) {
            params.setGroupID(recordInfo.getBuildingTaxesGroup().getId().toString());
        }
        AccountConfigEntryCollection accountConfigEntry = accountConfigInfo.getEntry();
        ArrayList<String> groupFields = new ArrayList<String>();
        ArrayList<String> sumFields = new ArrayList<String>();
        for (int i = 0; i < accountConfigEntry.size(); ++i) {
            AccountConfigEntryInfo entryInfo = accountConfigEntry.get(i);
            if (entryInfo.isIsGroup()) {
                groupFields.add(entryInfo.getName());
            }
            if (!entryInfo.isIsSum()) continue;
            sumFields.add(entryInfo.getName());
        }
        params.put("groupFields", groupFields);
        params.put("sumFields", sumFields);
        ITDFacade iTDFacade = null;
        iTDFacade = ctx == null ? TDFacadeFactory.getRemoteInstance() : TDFacadeFactory.getLocalInstance(ctx);
        calculatorResult = iTDFacade.getAccountData(params);
        return calculatorResult;
    }

    public static void addAccountDataTotalSheet(Context ctx, TaxDraftRecordInfo recordInfo, Book book, AccountCalculatorResult result) throws BOSException {
        int valueRangeTop;
        int i;
        int size;
        Locale loc = null;
        loc = ctx != null ? ctx.getLocale() : TDUtils.getLocale();
        String rsClass = "com.kingdee.eas.tm.td.TDResource";
        Sheet rptSheet = book.getSheet(TDUtils.getString(rsClass, "AccountPeriodTotal", loc));
        Book copyBook = null;
        Sheet copySheet = null;
        boolean isRefreshData = false;
        ITaxDraftRecord iReport = null;
        try {
            iReport = ctx == null ? TaxDraftRecordFactory.getRemoteInstance() : TaxDraftRecordFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            return;
        }
        SimpleDateFormat slp = new SimpleDateFormat("yyyy-MM-dd");
        int rowCount = 0;
        try {
            if (recordInfo.getRelateRecordAccount() != null) {
                TaxDraftRecordInfo copyReportInfo = iReport.getTaxDraftRecordInfo((IObjectPK)new ObjectStringPK(recordInfo.getRelateRecordAccount().getId().toString()), TDSelectorFactory.getAllReportSelectors());
                copyBook = copyReportInfo.getBook();
                copySheet = copyBook.getSheet(TDUtils.getString(rsClass, "AccountPeriodTotal", loc));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        if (rptSheet != null) {
            isRefreshData = true;
        } else {
            rptSheet = new Sheet(book, TDUtils.getString(rsClass, "AccountPeriodTotal", loc));
            book.addSheet(rptSheet);
        }
        rptSheet.setSelected(false);
        if (copySheet != null) {
            rowCount = copySheet.getRows().getMaxIntMark() + 1;
        }
        int top = 0;
        int left = 0;
        AccountConfigInfo accountConfigInfo = result.getAccountConfigInfo();
        AccountConfigEntryCollection coll = accountConfigInfo.getEntry();
        AccountConfigEntryInfo entryInfo = null;
        top = accountConfigInfo.getFillRow() > 0 ? accountConfigInfo.getFillRow() - 1 : accountConfigInfo.getFillRow();
        int n = left = accountConfigInfo.getFillColumn() > 0 ? accountConfigInfo.getFillColumn() - 1 : accountConfigInfo.getFillColumn();
        if (copySheet == null) {
            size = coll.size();
            for (i = 0; i < size; ++i) {
                entryInfo = coll.get(i);
                valueRangeTop = top;
                rptSheet.getRange(valueRangeTop, left + i).setValue(new Variant((Object)entryInfo.getAlias()));
                rptSheet.getRange(valueRangeTop, left + i).setUserObject("fieldKey", (Object)entryInfo.getName());
                rptSheet.getRange(top + 1, left + i, AccountTakeDataUtil.getMaxRowIndex(rptSheet, top + 1), left + i).clear(true, true, false, true, new String[0]);
            }
            ++top;
        } else {
            size = coll.size();
            for (i = 0; i < size; ++i) {
                entryInfo = coll.get(i);
                SortedCellBlockArray blocks = new SortedCellBlockArray();
                blocks.insert((Object)CellBlock.getNewCellBlock((int)0, (int)(left + i), (int)(copySheet.getRows().getMaxIntMark() > top ? copySheet.getRows().getMaxIntMark() : top), (int)(left + i)));
                copySheet.copyPartSheet(blocks, rptSheet, 0, left + i, false);
            }
            top = rowCount > top ? rowCount : top;
            size = coll.size();
            for (i = 0; i < size; ++i) {
                entryInfo = coll.get(i);
                rptSheet.getRange(top, left + i, AccountTakeDataUtil.getMaxRowIndex(rptSheet, top), left + i).clear(true, true, false, true, new String[0]);
            }
        }
        try {
            int fillRow = accountConfigInfo.getFillRow() > 0 ? accountConfigInfo.getFillRow() - 1 : accountConfigInfo.getFillRow();
            Sheet localSheet = book.getSheet(TDUtils.getString(rsClass, "AccountPeriod", loc));
            if (localSheet != null) {
                SortedCellBlockArray blocks = new SortedCellBlockArray();
                blocks.insert((Object)CellBlock.getNewCellBlock((int)(fillRow + 1), (int)left, (int)(localSheet.getRows().getMaxIntMark() > fillRow + 1 ? localSheet.getRows().getMaxIntMark() : fillRow + 1), (int)(left + coll.size())));
                localSheet.copyPartSheet(blocks, rptSheet, top, left, true);
            } else {
                valueRangeTop = top;
                IRowSet rs = result.getRs();
                rs.beforeFirst();
                while (rs.next()) {
                    Object value = null;
                    int size2 = coll.size();
                    for (int i2 = 0; i2 < size2; ++i2) {
                        entryInfo = coll.get(i2);
                        if (!entryInfo.isIsRefreshData() && isRefreshData) continue;
                        value = rs.getObject(entryInfo.getName());
                        if (DataTypeEnum.Enum.equals((Object)entryInfo.getDataType())) {
                            String enumClass = entryInfo.getBaseDataBOSType();
                            value = AccountTakeDataUtil.getEnumAlias(enumClass, value);
                        } else if (DataTypeEnum.Boolean.equals((Object)entryInfo.getDataType())) {
                            if (value != null) {
                                value = Integer.parseInt(value.toString()) == 0 ? TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Data_false", loc) : TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Data_True", loc);
                            }
                        } else if (DataTypeEnum.Date.equals((Object)entryInfo.getDataType())) {
                            StyleAttributes sa = Styles.getEmptySA();
                            sa.setNumberFormat("yyyy-MM-dd");
                            rptSheet.getRange(valueRangeTop, left + i2).setStyle(sa, sa);
                        }
                        if (!StringUtils.isEmpty((String)entryInfo.getFormulaValue())) {
                            value = AccountTakeDataUtil.getReplaceFormulaParameter(entryInfo.getFormulaValue(), accountConfigInfo, valueRangeTop, left);
                            rptSheet.getRange(valueRangeTop, left + i2).setFormula("=" + (String)value);
                        } else if (value != null) {
                            rptSheet.getRange(valueRangeTop, left + i2).setValue(new Variant(value));
                        }
                        rptSheet.getRange(valueRangeTop, left + i2).setUserObject("fieldKey", value);
                    }
                    ++valueRangeTop;
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    public static List getEnumData(String enumClass) {
        if (enumDataMap.containsKey(enumClass)) {
            return enumDataMap.get(enumClass);
        }
        List enumList = EnumUtils.getEnumList((String)enumClass);
        enumDataMap.put(enumClass, enumList);
        return enumList;
    }

    public static Object getEnumAlias(String enumClass, Object value) {
        if (value == null) {
            return "";
        }
        return AccountTakeDataUtil.getEnumAliasCache(enumClass, value.toString());
    }

    public static Object getEnumAliasCache(String enumClass, String key) {
        Map<Object, Object> enumMap = null;
        if (enumAliasMap.containsKey(enumClass)) {
            enumMap = enumAliasMap.get(enumClass);
        } else {
            enumMap = new HashMap();
            List enumList = AccountTakeDataUtil.getEnumData(enumClass);
            Object enumValue = null;
            for (int i = 0; i < enumList.size(); ++i) {
                Enum enumData = (Enum)enumList.get(i);
                if (enumData instanceof StringEnum) {
                    enumValue = ((StringEnum)enumData).getValue();
                } else if (enumData instanceof IntEnum) {
                    enumValue = ((IntEnum)enumData).getValue();
                } else if (enumData instanceof LongEnum) {
                    enumValue = ((LongEnum)enumData).getValue();
                } else if (enumData instanceof FloatEnum) {
                    enumValue = Float.valueOf(((FloatEnum)enumData).getValue());
                } else if (enumData instanceof DoubleEnum) {
                    enumValue = ((DoubleEnum)enumData).getValue();
                } else if (enumData instanceof DynamicEnum) {
                    enumValue = ((DynamicEnum)enumData).getValue();
                }
                if (enumValue == null) continue;
                enumMap.put(enumValue.toString(), enumData.getAlias());
            }
            enumAliasMap.put(enumClass, enumMap);
        }
        if (enumMap == null) {
            return "";
        }
        return enumMap.get(key);
    }

    public static List<String> getEnumAliasList(String enumClass) {
        if (enumAliasListMap.containsKey(enumClass)) {
            return enumAliasListMap.get(enumClass);
        }
        ArrayList<String> retList = new ArrayList<String>();
        List enumList = AccountTakeDataUtil.getEnumData(enumClass);
        int len = enumList.size();
        for (int i = 0; i < len; ++i) {
            Enum enumData = (Enum)enumList.get(i);
            retList.add(enumData.getAlias());
        }
        enumAliasListMap.put(enumClass, retList);
        return retList;
    }

    public static int getMaxRowIndex(Sheet rptSheet, int rowIndex) {
        if (rptSheet.getMaxRowIndex() < rowIndex) {
            return rowIndex;
        }
        return rptSheet.getMaxRowIndex();
    }

    public static void addAccountDataSheet(Context ctx, TaxDraftRecordInfo recordInfo, Book book, AccountCalculatorResult result) throws BOSException {
        String rsClass = "com.kingdee.eas.tm.td.TDResource";
        Locale loc = null;
        loc = ctx != null ? ctx.getLocale() : TDUtils.getLocale();
        Sheet rptSheet = book.getSheet(TDUtils.getString(rsClass, "AccountPeriod", loc));
        boolean isRefreshData = false;
        if (rptSheet != null) {
            isRefreshData = true;
        } else {
            rptSheet = new Sheet(book, TDUtils.getString(rsClass, "AccountPeriod", loc));
            book.addSheet(rptSheet);
            rptSheet.setSelected(false);
        }
        int top = 0;
        int left = 0;
        AccountConfigInfo accountConfigInfo = result.getAccountConfigInfo();
        AccountConfigEntryCollection coll = accountConfigInfo.getEntry();
        AccountConfigEntryInfo entryInfo = null;
        top = accountConfigInfo.getFillRow() > 0 ? accountConfigInfo.getFillRow() - 1 : accountConfigInfo.getFillRow();
        left = accountConfigInfo.getFillColumn() > 0 ? accountConfigInfo.getFillColumn() - 1 : accountConfigInfo.getFillColumn();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = coll.get(i);
            int valueRangeTop = top;
            rptSheet.getRange(valueRangeTop, left + i).setValue(new Variant((Object)entryInfo.getAlias()));
            rptSheet.getRange(valueRangeTop, left + i).setUserObject("fieldKey", (Object)entryInfo.getName());
            if (isRefreshData && !entryInfo.isIsRefreshData()) continue;
            rptSheet.getRange(top + 1, left + i, AccountTakeDataUtil.getMaxRowIndex(rptSheet, top + 1), left + i).clear(true, true, false, true, new String[0]);
        }
        try {
            int i;
            int valueRangeTop = top + 1;
            IRowSet rs = result.getRs();
            rs.beforeFirst();
            while (rs.next()) {
                Object value = null;
                int size2 = coll.size();
                for (int i2 = 0; i2 < size2; ++i2) {
                    entryInfo = coll.get(i2);
                    if (!entryInfo.isIsRefreshData() && isRefreshData) continue;
                    value = rs.getObject(entryInfo.getName());
                    if (DataTypeEnum.Enum.equals((Object)entryInfo.getDataType())) {
                        String enumClass = entryInfo.getBaseDataBOSType();
                        value = AccountTakeDataUtil.getEnumAlias(enumClass, value);
                    } else if (DataTypeEnum.Boolean.equals((Object)entryInfo.getDataType())) {
                        if (value != null) {
                            value = Integer.parseInt(value.toString()) == 0 ? TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Data_false", loc) : TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Data_True", loc);
                        }
                    } else if (DataTypeEnum.Date.equals((Object)entryInfo.getDataType())) {
                        StyleAttributes sa = Styles.getEmptySA();
                        sa.setNumberFormat("yyyy-MM-dd");
                        rptSheet.getRange(valueRangeTop, left + i2).setStyle(sa, sa);
                    }
                    if (!StringUtils.isEmpty((String)entryInfo.getFormulaValue())) {
                        value = AccountTakeDataUtil.getReplaceFormulaParameter(entryInfo.getFormulaValue(), accountConfigInfo, valueRangeTop, left);
                        rptSheet.getRange(valueRangeTop, left + i2).setFormula("=" + (String)value);
                    } else if (value != null) {
                        rptSheet.getRange(valueRangeTop, left + i2).setValue(new Variant(value));
                    }
                    rptSheet.getRange(valueRangeTop, left + i2).setUserObject("fieldKey", value);
                }
                ++valueRangeTop;
            }
            int size3 = coll.size();
            for (i = 0; i < size3; ++i) {
                entryInfo = coll.get(i);
                if (!StringUtils.isEmpty((String)entryInfo.getTxtVolidScope())) {
                    AccountTakeDataUtil.insertValidationByColumn(rptSheet, top + 1, left + i, valueRangeTop - top - 1, null, entryInfo.getTxtVolidScope());
                    continue;
                }
                if (!DataTypeEnum.Enum.equals((Object)entryInfo.getDataType())) continue;
                String enumClass = entryInfo.getBaseDataBOSType();
                AccountTakeDataUtil.insertValidationByColumn(rptSheet, top + 1, left + i, valueRangeTop - top - 1, enumClass, null);
            }
            if (valueRangeTop == top + 1) {
                int len = coll.size();
                for (i = 0; i < len; ++i) {
                    entryInfo = coll.get(i);
                    if (!DataTypeEnum.String.equals((Object)entryInfo.getDataType()) || StringUtils.isEmpty((String)entryInfo.getTxtVolidScope())) continue;
                    String value = entryInfo.getDefaultValue();
                    AccountTakeDataUtil.insertValidation(rptSheet, valueRangeTop, left + i, null, entryInfo.getTxtVolidScope());
                    rptSheet.getRange(valueRangeTop, left + i).setValue(new Variant((Object)value));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    private static void insertValidationByColumn(Sheet rptSheet, int row, int column, int rowCount, String enumClass, String validationText) {
        CellBlock cellBlock = CellBlock.getNewCellBlock((int)row, (int)column, (int)(row + rowCount - 1), (int)column);
        SortedCellBlockArray sa = new SortedCellBlockArray();
        sa.insert((Object)cellBlock);
        sa.mergeSelf();
        ValidationList vl = rptSheet.getValidations();
        MessagedValidate retMV = new MessagedValidate();
        retMV.setType(Validate.Type_List);
        if (!StringUtils.isEmpty((String)enumClass)) {
            retMV.setMin(CollectionUtil.convertList2String(AccountTakeDataUtil.getEnumAliasList(enumClass), ",", false));
        } else {
            retMV.setMin(validationText);
        }
        retMV.setCellRangeList(true);
        vl.insertValidation(retMV, sa);
    }

    private static void insertValidation(Sheet rptSheet, int row, int column, String enumClass, String validationText) {
        CellBlock cellBlock = CellBlock.getNewCellBlock((int)row, (int)column, (int)row, (int)column);
        rptSheet.getRange(row, column, row, column).fill(cellBlock, FillType.DEFAULT_EXCEPT_FORMAT, new FillType(0));
        SortedCellBlockArray sa = new SortedCellBlockArray();
        sa.insert((Object)cellBlock);
        sa.mergeSelf();
        ValidationList vl = rptSheet.getValidations();
        MessagedValidate retMV = new MessagedValidate();
        retMV.setType(Validate.Type_List);
        if (!StringUtils.isEmpty((String)enumClass)) {
            retMV.setMin(CollectionUtil.convertList2String(AccountTakeDataUtil.getEnumAliasList(enumClass), ",", false));
        } else {
            retMV.setMin(validationText);
        }
        retMV.setCellRangeList(true);
        vl.insertValidation(retMV, sa);
    }

    private static String getReplaceFormulaParameter(String formula, AccountConfigInfo accountConfigInfo, int rowIndex, int colIndex) {
        AccountConfigEntryCollection coll = accountConfigInfo.getEntry();
        AccountConfigEntryInfo entryInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            entryInfo = coll.get(i);
            formula = formula.replace("'" + (i + 1) + "#'", Location.getCellName(rowIndex, colIndex + i));
        }
        return formula;
    }

    public static void addAccountDataSumSheet(Context ctx, TaxDraftRecordInfo recordInfo, Book book, AccountCalculatorResult result) {
        Locale loc = null;
        loc = ctx != null ? ctx.getLocale() : TDUtils.getLocale();
        Sheet rptSheet = book.getSheet(TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "TotalSheet", loc));
        boolean isRefreshData = false;
        if (rptSheet != null) {
            isRefreshData = true;
        } else {
            rptSheet = new Sheet(book, TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "TotalSheet", loc));
            book.addSheet(rptSheet);
            rptSheet.setSelected(false);
        }
        int top = 0;
        int left = 0;
        AccountConfigInfo accountConfigInfo = result.getAccountConfigInfo();
        AccountConfigEntryCollection coll = accountConfigInfo.getEntry();
        AccountConfigEntryInfo entryInfo = null;
        top = accountConfigInfo.getFillRow() > 0 ? accountConfigInfo.getFillRow() - 1 : accountConfigInfo.getFillRow();
        left = accountConfigInfo.getFillColumn() > 0 ? accountConfigInfo.getFillColumn() - 1 : accountConfigInfo.getFillColumn();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = coll.get(i);
            int valueRangeTop = top;
            rptSheet.getRange(valueRangeTop, left + i).setValue(new Variant((Object)entryInfo.getAlias()));
            rptSheet.getRange(valueRangeTop, left + i).setUserObject("fieldKey", (Object)entryInfo.getName());
            if (isRefreshData && !entryInfo.isIsRefreshData()) continue;
            rptSheet.getRange(top + 1, left + i, AccountTakeDataUtil.getMaxRowIndex(rptSheet, top + 1), left + i).clear(true, true, false, true, new String[0]);
        }
        try {
            int valueRangeTop = top + 1;
            IRowSet rs = result.getSumRs();
            rs.beforeFirst();
            while (rs.next()) {
                Object value = null;
                int size2 = coll.size();
                for (int i = 0; i < size2; ++i) {
                    value = null;
                    entryInfo = coll.get(i);
                    if (entryInfo.isIsGroup() || entryInfo.isIsSum()) {
                        value = rs.getObject(entryInfo.getName());
                        if (DataTypeEnum.Enum.equals((Object)entryInfo.getDataType())) {
                            String enumClass = entryInfo.getBaseDataBOSType();
                            value = AccountTakeDataUtil.getEnumAlias(enumClass, value);
                        } else if (DataTypeEnum.Boolean.equals((Object)entryInfo.getDataType())) {
                            if (value != null) {
                                value = Integer.parseInt(value.toString()) == 0 ? TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Data_false", loc) : TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Data_True", loc);
                            }
                        } else if (DataTypeEnum.Date.equals((Object)entryInfo.getDataType())) {
                            StyleAttributes sa = Styles.getEmptySA();
                            sa.setNumberFormat("yyyy-MM-dd");
                            rptSheet.getRange(valueRangeTop, left + i).setStyle(sa, sa);
                        }
                    }
                    if (value != null) {
                        rptSheet.getRange(valueRangeTop, left + i).setValue(new Variant(value));
                    }
                    rptSheet.getRange(valueRangeTop, left + i).setUserObject("fieldKey", value);
                }
                ++valueRangeTop;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
    }
}

