/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.utils;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class EncryptUtil {
    private static Logger logger = Logger.getLogger(EncryptUtil.class);
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static final String PRNG_ALGORITHM = "SHA1PRNG";
    private static final int IV_LENGTH = 16;

    public static String encrypt(String content, String encryptPass) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(1, EncryptUtil.getSecretKey(encryptPass));
            byte[] iv = cipher.getIV();
            assert (iv.length == 12);
            byte[] encryptData = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
            assert (encryptData.length == content.getBytes(StandardCharsets.UTF_8).length + 16);
            byte[] message = new byte[12 + content.getBytes(StandardCharsets.UTF_8).length + 16];
            System.arraycopy(iv, 0, message, 0, 12);
            System.arraycopy(encryptData, 0, message, 12, encryptData.length);
            return Base64.encodeBase64String((byte[])message);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] encrypt(byte[] content, String encryptPass) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(1, EncryptUtil.getSecretKey(encryptPass));
            byte[] iv = cipher.getIV();
            assert (iv.length == 12);
            byte[] encryptData = cipher.doFinal(content);
            assert (encryptData.length == content.length + 16);
            byte[] message = new byte[12 + content.length + 16];
            System.arraycopy(iv, 0, message, 0, 12);
            System.arraycopy(encryptData, 0, message, 12, encryptData.length);
            return Base64.encodeBase64((byte[])message);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] decrypt(byte[] base64Content, String encryptPass) {
        byte[] content = Base64.decodeBase64((byte[])base64Content);
        if (content.length < 28) {
            throw new IllegalArgumentException();
        }
        GCMParameterSpec params = new GCMParameterSpec(128, content, 0, 12);
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, (Key)EncryptUtil.getSecretKey(encryptPass), params);
            byte[] decryptData = cipher.doFinal(content, 12, content.length - 12);
            return decryptData;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static SecretKeySpec getSecretKey(String encryptPass) {
        return new SecretKeySpec(encryptPass.getBytes(), KEY_ALGORITHM);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

