/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.mrm.module.query.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.web.SelectItem;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.mrm.ApplyStateEnum;
import com.kingdee.eas.cp.mrm.EnableStateEnum;
import com.kingdee.eas.cp.mrm.IMRApply;
import com.kingdee.eas.cp.mrm.IMeetingRoom;
import com.kingdee.eas.cp.mrm.IMeetingSetting;
import com.kingdee.eas.cp.mrm.IMeetingType;
import com.kingdee.eas.cp.mrm.ImpDegreeEnum;
import com.kingdee.eas.cp.mrm.MRApplyCollection;
import com.kingdee.eas.cp.mrm.MRApplyFactory;
import com.kingdee.eas.cp.mrm.MRApplyInfo;
import com.kingdee.eas.cp.mrm.MRApplyMRAgendaCollection;
import com.kingdee.eas.cp.mrm.MRApplyMRAgendaInfo;
import com.kingdee.eas.cp.mrm.MRApplyMRAttendantCollection;
import com.kingdee.eas.cp.mrm.MRApplyMRAttendantInfo;
import com.kingdee.eas.cp.mrm.MeetingRoomFactory;
import com.kingdee.eas.cp.mrm.MeetingRoomInfo;
import com.kingdee.eas.cp.mrm.MeetingRoomStateEnum;
import com.kingdee.eas.cp.mrm.MeetingSettingCollection;
import com.kingdee.eas.cp.mrm.MeetingSettingFactory;
import com.kingdee.eas.cp.mrm.MeetingSettingInfo;
import com.kingdee.eas.cp.mrm.MeetingTypeCollection;
import com.kingdee.eas.cp.mrm.MeetingTypeFactory;
import com.kingdee.eas.cp.mrm.MeetingTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.plt.mrm.module.query.dto.MeetingAgendaDTO;
import com.kingdee.portal.plt.mrm.module.query.dto.MeetingDTO;
import com.kingdee.portal.plt.mrm.module.query.util.BOTPHelper;
import com.kingdee.portal.plt.mrm.module.query.util.MeetingUtil;
import com.kingdee.portal.plt.mrm.module.setting.dto.MeetingRoomDTO;
import com.kingdee.portal.plt.mrm.module.setting.dto.MeetingSettingDTO;
import com.kingdee.portal.plt.mrm.module.setting.dto.MeetingTypeDTO;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.sql.SQLException;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.faces.FacesException;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.apache.commons.lang3.StringUtils;

public class MeetingAction
extends BaseAction {
    private static final long serialVersionUID = -8367791240669847443L;

    /*
     * Unable to fully structure code
     */
    public void loadMeetingList() {
        request = this.getRequest();
        ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        entityViewInfo = new EntityViewInfo();
        meetingName = request.getParameter("meetingName");
        keyword = request.getParameter("keyword");
        mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app.MRApplyQuery");
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("mrType.name"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("applier.name"));
        sic.add(new SelectorItemInfo("applier.id"));
        sic.add(new SelectorItemInfo("applyUnit.name"));
        sic.add(new SelectorItemInfo("address.name"));
        sic.add(new SelectorItemInfo("startTime"));
        sic.add(new SelectorItemInfo("endTime"));
        sic.add(new SelectorItemInfo("applyProcess"));
        try {
            list = new ArrayList<MeetingDTO>();
            total = 0;
            totalPage = 0;
            pageNo = 0;
            pageSize = 10;
            personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            if (personInfo != null) {
                nameSql = "";
                keywordSql = "";
                if (meetingName != null && !meetingName.equals("")) {
                    nameSql = "name like '%" + meetingName + "%' and ";
                }
                if (keyword != null && !keyword.equals("")) {
                    keywordSql = " id = '" + keyword + "' and ";
                }
                filterStr = nameSql + keywordSql + " applier.id='" + personInfo.getId().toString() + "'";
                entityViewInfo.setFilter(filterStr);
                entityViewInfo.setSelector(sic);
                exec = null;
                rowSet = null;
                countRowSet = null;
                pageNo = this.pagingParam.getPageNo();
                pageSize = this.pagingParam.getPageSize();
                exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
                this.logger.debug("executor search content count sql is:" + exec.getSQL());
                countRowSet = exec.executeQuery();
                while (countRowSet.next()) {
                    ++total;
                }
                totalPage = (total - 1) / pageSize + 1;
                if (pageNo > totalPage) {
                    pageNo = totalPage;
                }
                if (pageNo <= 0) {
                    pageNo = 1;
                }
                if (total > 0) {
                    isMRAdmin = true;
                    rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
                    ** if (rowSet == null) goto lbl105
                    while (rowSet.next()) {
                        meetingDTO = new MeetingDTO();
                        meetingDTO.setId(rowSet.getString("id"));
                        meetingDTO.setName(rowSet.getString("name"));
                        meetingDTO.setAddress(rowSet.getString("address.name"));
                        meetingDTO.setMeetingType(rowSet.getString("mrType.name"));
                        meetingDTO.setApplier(rowSet.getString("applier.name"));
                        meetingDTO.setApplierUnit(rowSet.getString("applyUnit.name"));
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                        meetingDTO.setStartTime(sdf.format(rowSet.getDate("startTime")));
                        meetingDTO.setEndTime(sdf.format(rowSet.getDate("endTime")));
                        applyStateValue = "";
                        try {
                            applystate = (BizEnumValueDTO)rowSet.getObject("state");
                            applyStateEnum = ApplyStateEnum.getEnum((int)Integer.valueOf(applystate.getValue().toString()));
                            applyStateValue = applyStateEnum.getAlias();
                            meetingDTO.setState(applyStateValue);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            meetingDTO.setState(rowSet.getString("state"));
                        }
                        meetingDTO.setApplyProcess(rowSet.getString("applyProcess"));
                        meetingDTO.setCreateTime(sdf.format(rowSet.getDate("createTime")));
                        meetingDTO.setIsAdmin(isMRAdmin);
                        if (personInfo.getId().toString().equals(rowSet.getString("applier.id"))) {
                            meetingDTO.setIsSelf(true);
                        } else {
                            meetingDTO.setIsSelf(false);
                        }
                        rs = DbUtil.executeQuery((Context)ctx, (String)("select * from T_MRM_MRSummary t where t.FSourceBillID='" + rowSet.getString("id") + "'"));
                        if (rs != null && rs.next()) {
                            meetingDTO.setHasSummary(true);
                        } else {
                            meetingDTO.setHasSummary(false);
                        }
                        list.add(meetingDTO);
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                }
            }
lbl105:
            // 6 sources

            pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            this.writePagingResult(pagingResult);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void queryMeetingRoomInfo() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app.MeetingRoomQuery");
        LocalErr localErr = null;
        boolean success = false;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String filterStr = "(cu.id='" + cuId + "' or (id in(select FParentId from T_MRM_MeetingRoomShareCU where FShareCUId='" + cuId + "'))) and enableState=" + 0;
        try {
            entityViewInfo.setFilter(filterStr);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("seatCount"));
            sic.add(new SelectorItemInfo("address"));
            sic.add(new SelectorItemInfo("description"));
            sic.add(new SelectorItemInfo("contact.name"));
            sic.add(new SelectorItemInfo("contact.officePhone"));
            sic.add(new SelectorItemInfo("contact.cell"));
            sic.add(new SelectorItemInfo("contactTwo.name"));
            sic.add(new SelectorItemInfo("equipment"));
            sic.add(new SelectorItemInfo("applyProcess"));
            sic.add(new SelectorItemInfo("enableState"));
            sic.add(new SelectorItemInfo("controlUnit.id"));
            sic.add(new SelectorItemInfo("contact.email"));
            IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            IRowSet rowSet = exec.executeQuery();
            ArrayList<MeetingRoomDTO> list = new ArrayList<MeetingRoomDTO>();
            if (rowSet != null) {
                while (rowSet.next()) {
                    MeetingRoomDTO meetingRoomDTO = new MeetingRoomDTO();
                    meetingRoomDTO.setId(rowSet.getString("id"));
                    meetingRoomDTO.setAddress(rowSet.getString("address"));
                    meetingRoomDTO.setName(rowSet.getString("name"));
                    meetingRoomDTO.setSeatCount(rowSet.getString("seatCount"));
                    meetingRoomDTO.setContact1Name(rowSet.getString("contact.name"));
                    meetingRoomDTO.setContact2Name(rowSet.getString("contactTwo.name"));
                    meetingRoomDTO.setEnableState(rowSet.getString("enableState"));
                    meetingRoomDTO.setControlUnitId(rowSet.getString("controlUnit.id"));
                    meetingRoomDTO.setEquipment(rowSet.getString("equipment"));
                    meetingRoomDTO.setApplyProcess(rowSet.getString("applyProcess"));
                    meetingRoomDTO.setContactPhone(rowSet.getString("contact.cell"));
                    meetingRoomDTO.setEmail(rowSet.getString("contact.email"));
                    list.add(meetingRoomDTO);
                }
            }
            result.put("rooms", list);
            IMeetingSetting meetingSetting = MeetingSettingFactory.getLocalInstance((Context)ctx);
            MeetingSettingCollection collection = meetingSetting.getMeetingSettingCollection("select key, value, type where CU.id = '" + cuId + "'");
            ArrayList<MeetingSettingDTO> listSetting = new ArrayList<MeetingSettingDTO>(collection.size());
            for (int i = 0; i < collection.size(); ++i) {
                MeetingSettingInfo info = collection.get(i);
                MeetingSettingDTO dto = new MeetingSettingDTO();
                dto.setKey(info.getKey());
                dto.setValue(info.getValue());
                listSetting.add(dto);
            }
            result.put("settings", listSetting);
            result.put("stateEnum", MeetingRoomStateEnum.getEnumMap());
            success = true;
        }
        catch (ParserException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (Exception e) {
            localErr = this.handleErr(e);
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void queryExistMeetings() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        LocalErr localErr = null;
        boolean success = false;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String id = request.getParameter("id");
        String curDate = request.getParameter("curDate");
        String meetingRoomIds = request.getParameter("meetingRoomIds");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        try {
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app.MRApplyQuery");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("mrType.name"));
            sic.add(new SelectorItemInfo("applier.name"));
            sic.add(new SelectorItemInfo("applyUnit.name"));
            sic.add(new SelectorItemInfo("startTime"));
            sic.add(new SelectorItemInfo("endTime"));
            sic.add(new SelectorItemInfo("address.id"));
            sic.add(new SelectorItemInfo("state"));
            sic.add(new SelectorItemInfo("contactPhone"));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("address.id", (Object)meetingRoomIds, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("startTime", (Object)sdf.parse(curDate + " 00:00"), CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("endTime", (Object)sdf.parse(curDate + " 24:00"), CompareType.LESS));
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)"4,1", CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            entityViewInfo.setSelector(sic);
            IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            IRowSet rowSet = exec.executeQuery();
            ArrayList<MeetingDTO> lstMeetingDTO = new ArrayList<MeetingDTO>();
            if (rowSet != null) {
                while (rowSet.next()) {
                    MeetingDTO meetingDTO = new MeetingDTO();
                    meetingDTO.setId(rowSet.getString("id"));
                    meetingDTO.setName(rowSet.getString("name"));
                    meetingDTO.setMeetingType(rowSet.getString("mrType.name"));
                    meetingDTO.setApplier(rowSet.getString("applier.name"));
                    meetingDTO.setApplierUnit(rowSet.getString("applyUnit.name"));
                    meetingDTO.setStartTime(sdf.format(rowSet.getDate("startTime")));
                    meetingDTO.setEndTime(sdf.format(rowSet.getDate("endTime")));
                    meetingDTO.setAddressId(rowSet.getString("address.id"));
                    int applyStateValue = 0;
                    try {
                        BizEnumValueDTO applystate = (BizEnumValueDTO)rowSet.getObject("state");
                        ApplyStateEnum applyStateEnum = ApplyStateEnum.getEnum((int)Integer.valueOf(applystate.getValue().toString()));
                        applyStateValue = applyStateEnum.getValue();
                        meetingDTO.setState(applyStateValue + "");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    meetingDTO.setContactPhone(rowSet.getString("contactPhone"));
                    lstMeetingDTO.add(meetingDTO);
                }
            }
            result.put("meetings", lstMeetingDTO);
            result.put("applyStateEnum", ApplyStateEnum.getEnumMap());
            success = true;
        }
        catch (ParseException e) {
            localErr = this.handleErr(e);
            success = false;
            e.printStackTrace();
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (Exception e) {
            localErr = this.handleErr(e);
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void initMeetingInfo() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        LocalErr localErr = null;
        boolean success = false;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String id = request.getParameter("id");
        result.put("impDegreeEnum", ImpDegreeEnum.getEnumList());
        boolean isSendMsg = false;
        boolean isSendEmail = false;
        ConfigurationItem loginCtxFilesItem = Configuration.getInstance().getConfigItem("PortalInfo");
        if (loginCtxFilesItem != null) {
            String sendMsg = loginCtxFilesItem.getProperty("isAllowMobile");
            String sendEmail = loginCtxFilesItem.getProperty("isAllowEMailAudit");
            if ("true".equals(sendMsg)) {
                isSendMsg = true;
            }
            if ("true".equals(sendEmail)) {
                isSendEmail = true;
            }
        }
        result.put("isSendMsg", isSendMsg);
        result.put("isSendEmail", isSendEmail);
        try {
            IMeetingType meetingType = MeetingTypeFactory.getLocalInstance((Context)ctx);
            String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            MeetingTypeCollection meetingTypeCollection = meetingType.getMeetingTypeCollection("select name where cu.id='" + cuId + "' and enableState = " + 0);
            ArrayList<MeetingTypeDTO> lstMeetingTypeDTO = new ArrayList<MeetingTypeDTO>(meetingTypeCollection.size());
            for (int i = 0; i < meetingTypeCollection.size(); ++i) {
                MeetingTypeDTO meetingTypeDTO = new MeetingTypeDTO();
                meetingTypeDTO.setId(meetingTypeCollection.get(i).getId().toString());
                meetingTypeDTO.setName(meetingTypeCollection.get(i).getName());
                meetingTypeDTO.setSummaryProcessId(meetingTypeCollection.get(i).getSummaryProcess());
                lstMeetingTypeDTO.add(meetingTypeDTO);
            }
            result.put("meetingTypes", lstMeetingTypeDTO);
            ArrayList<MeetingAgendaDTO> agendas = new ArrayList<MeetingAgendaDTO>();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app.MRApplyQuery");
                String filterStr = "id='" + id + "'";
                entityViewInfo.setFilter(filterStr);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("mrType.name"));
                sic.add(new SelectorItemInfo("mrType.id"));
                sic.add(new SelectorItemInfo("applier.name"));
                sic.add(new SelectorItemInfo("applier.Id"));
                sic.add(new SelectorItemInfo("compere.name"));
                sic.add(new SelectorItemInfo("compere.id"));
                sic.add(new SelectorItemInfo("applyUnit.name"));
                sic.add(new SelectorItemInfo("applyUnit.Id"));
                sic.add(new SelectorItemInfo("address.name"));
                sic.add(new SelectorItemInfo("address.Id"));
                sic.add(new SelectorItemInfo("startTime"));
                sic.add(new SelectorItemInfo("endTime"));
                sic.add(new SelectorItemInfo("impDegree"));
                sic.add(new SelectorItemInfo("applyProcess"));
                sic.add(new SelectorItemInfo("contactPhone"));
                sic.add(new SelectorItemInfo("remark"));
                sic.add(new SelectorItemInfo("submitEmail"));
                sic.add(new SelectorItemInfo("submitSMS"));
                sic.add(new SelectorItemInfo("submitMessage"));
                sic.add(new SelectorItemInfo("laterEmail"));
                sic.add(new SelectorItemInfo("laterSMS"));
                sic.add(new SelectorItemInfo("laterMessage"));
                entityViewInfo.setSelector(sic);
                IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
                exec.option().isAutoTranslateEnum = false;
                IRowSet rowSet = exec.executeQuery();
                if (rowSet != null && rowSet.next()) {
                    result.put("unitId", rowSet.getString("applyUnit.Id"));
                    result.put("unitName", rowSet.getString("applyUnit.name"));
                    result.put("personId", rowSet.getString("applier.Id"));
                    result.put("personName", rowSet.getString("applier.name"));
                    result.put("contactPhone", rowSet.getString("contactPhone"));
                    result.put("remark", rowSet.getString("remark"));
                    result.put("impDegree", rowSet.getString("impDegree"));
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    result.put("startTime", sdf.format(rowSet.getDate("startTime")));
                    result.put("endTime", sdf.format(rowSet.getDate("endTime")));
                    result.put("name", rowSet.getString("name"));
                    result.put("meetingType", rowSet.getString("mrType.name"));
                    result.put("meetingTypeId", rowSet.getString("mrType.id"));
                    result.put("addressId", rowSet.getString("address.id"));
                    result.put("address", rowSet.getString("address.name"));
                    result.put("applyProcess", rowSet.getString("applyProcess"));
                    result.put("compere", rowSet.getString("compere.name"));
                    result.put("compereId", rowSet.getString("compere.id"));
                    result.put("submitEmail", rowSet.getBoolean("submitEmail"));
                    result.put("submitSMS", rowSet.getBoolean("submitSMS"));
                    result.put("submitMessage", rowSet.getBoolean("submitMessage"));
                    result.put("laterEmail", rowSet.getBoolean("laterEmail"));
                    result.put("laterSMS", rowSet.getBoolean("laterSMS"));
                    result.put("laterMessage", rowSet.getBoolean("laterMessage"));
                    IMRApply mrApply = MRApplyFactory.getLocalInstance((Context)ctx);
                    MRApplyInfo info = mrApply.getMRApplyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                    StringBuffer sbIdSql = new StringBuffer(200);
                    MRApplyMRAttendantCollection attendantCollection = info.getMRAttendant();
                    int j = attendantCollection.size();
                    for (int i = 0; i < j; ++i) {
                        MRApplyMRAttendantInfo attendantInfo = attendantCollection.get(i);
                        sbIdSql.append("'" + attendantInfo.getAttendant().getId().toString() + "'").append(",");
                    }
                    IPerson person = PersonFactory.getLocalInstance((Context)ctx);
                    PersonCollection personCollection = person.getPersonCollection("select id,name where id in (" + sbIdSql.substring(0, sbIdSql.length() - 1).toString() + ")");
                    StringBuffer sbAttendantId = new StringBuffer(200);
                    StringBuffer sbAttendantName = new StringBuffer(200);
                    int j2 = personCollection.size();
                    for (int i = 0; i < j2; ++i) {
                        sbAttendantId.append(personCollection.get(i).getId().toString()).append(";");
                        sbAttendantName.append(personCollection.get(i).getName()).append(";");
                    }
                    result.put("meetingAttendantId", sbAttendantId.substring(0, sbAttendantId.length() - 1).toString());
                    result.put("meetingAttendantName", sbAttendantName.substring(0, sbAttendantName.length() - 1).toString());
                    MRApplyMRAgendaCollection agendaCollection = info.getMRAgenda();
                    int j3 = agendaCollection.size();
                    for (int i = 0; i < j3; ++i) {
                        MeetingAgendaDTO meetingAgendaDTO = new MeetingAgendaDTO();
                        meetingAgendaDTO.setCompere(agendaCollection.get(i).getCompere());
                        meetingAgendaDTO.setName(agendaCollection.get(i).getName());
                        meetingAgendaDTO.setTime(agendaCollection.get(i).getTime());
                        agendas.add(meetingAgendaDTO);
                    }
                }
            } else {
                String newId = BOSUuid.create((BOSObjectType)new MRApplyInfo().getBOSType()).toString();
                PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
                String adminOrgId = null;
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                entityViewInfo.setFilter("person.id='" + person.getString("id") + "'");
                entityViewInfo.getSelector().add(new SelectorItemInfo("Person.name"));
                entityViewInfo.getSelector().add(new SelectorItemInfo("Person.id"));
                entityViewInfo.getSelector().add(new SelectorItemInfo("AdminOrg.id"));
                entityViewInfo.getSelector().add(new SelectorItemInfo("user.id"));
                entityViewInfo.getSelector().add(new SelectorItemInfo("user.name"));
                entityViewInfo.getSelector().add(new SelectorItemInfo("PM.isPrimary"));
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.AdminOrgPersons");
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("PM.isPrimary"));
                sic.add(new SelectorItemInfo("AdminOrg.id"));
                sic.add(new SelectorItemInfo("Person.name"));
                sic.add(new SelectorItemInfo("Person.id"));
                sic.add(new SelectorItemInfo("user.id"));
                sic.add(new SelectorItemInfo("user.name"));
                entityViewInfo.setSelector(sic);
                IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
                this.logger.debug("executor search content list sql is:" + exec.getSQL());
                IRowSet rowSet = exec.executeQuery();
                int count = 0;
                String firstOrgId = "";
                if (rowSet != null) {
                    while (rowSet.next()) {
                        boolean isPrimary = rowSet.getBoolean("PM.isPrimary");
                        if (isPrimary) {
                            adminOrgId = rowSet.getString("AdminOrg.id");
                            break;
                        }
                        if (count == 0) {
                            firstOrgId = rowSet.getString("AdminOrg.id");
                        }
                        ++count;
                    }
                }
                if (null == adminOrgId) {
                    adminOrgId = firstOrgId;
                }
                AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgId));
                result.put("unitId", adminOrgId);
                result.put("unitName", adminOrgUnitInfo.getName());
                result.put("personId", person.getId().toString());
                result.put("personName", person.getName());
                PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("select id,name,cell,email,officePhone where id='" + person.getString("id") + "'");
                if (personCollection.size() > 0) {
                    person = personCollection.get(0);
                }
                result.put("contactPhone", person.getCell());
                result.put("id", newId);
            }
            result.put("agendas", agendas);
            success = true;
        }
        catch (ParserException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (Exception e) {
            localErr = this.handleErr(e);
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void saveMeeting() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        LocalErr localErr = null;
        boolean success = false;
        String result = "";
        String id = request.getParameter("id");
        String name = request.getParameter("name");
        String impDegree = request.getParameter("impDegree");
        String applierId = request.getParameter("applierId");
        String compereId = request.getParameter("compereId");
        String applierName = request.getParameter("applier");
        String compereName = request.getParameter("compere");
        String address = request.getParameter("address");
        String applyUnitId = request.getParameter("applierUnitId");
        String addressId = request.getParameter("addressId");
        String contactPhone = request.getParameter("contactPhone");
        String startTime = request.getParameter("startTime");
        String endTime = request.getParameter("endTime");
        String remark = request.getParameter("remark");
        String applyProcess = request.getParameter("applyProcess");
        String meetingTypeId = request.getParameter("meetingTypeId");
        String meetingAttendantId = request.getParameter("meetingAttendantId");
        String meetingAttendant = request.getParameter("meetingAttendant");
        String operateType = request.getParameter("operateType");
        String agendaStr = request.getParameter("agenda");
        String submitEmail = request.getParameter("submitEmail");
        String submitSMS = request.getParameter("submitSMS");
        String submitMessage = request.getParameter("submitMessage");
        String laterEmail = request.getParameter("laterEmail");
        String laterSMS = request.getParameter("laterSMS");
        String laterMessage = request.getParameter("laterMessage");
        MRApplyInfo info = new MRApplyInfo();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        try {
            IMRApply mrApply = MRApplyFactory.getLocalInstance((Context)ctx);
            info.setName(name);
            info.setImpDegree(ImpDegreeEnum.getEnum((String)impDegree));
            info.setRemark(remark);
            info.setState(ApplyStateEnum.SAVE);
            info.setApplyProcess(applyProcess);
            info.setContactPhone(contactPhone);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            Date dateStartTime = sdf.parse(startTime);
            info.setStartTime(new Time(dateStartTime.getTime()));
            Date dateEndTime = sdf.parse(endTime);
            info.setEndTime(new Time(dateEndTime.getTime()));
            info.setSubmitEmail(new Boolean(submitEmail).booleanValue());
            info.setSubmitMessage(new Boolean(submitMessage).booleanValue());
            info.setSubmitSMS(new Boolean(submitSMS).booleanValue());
            info.setLaterEmail(new Boolean(laterEmail).booleanValue());
            info.setLaterMessage(new Boolean(laterMessage).booleanValue());
            info.setLaterSMS(new Boolean(laterSMS).booleanValue());
            MeetingRoomInfo meetingRoomInfo = new MeetingRoomInfo();
            meetingRoomInfo.setId(BOSUuid.read((String)addressId));
            info.setAddress(meetingRoomInfo);
            if (StringUtils.isNotBlank((CharSequence)meetingTypeId)) {
                MeetingTypeInfo meetingTypeInfo = new MeetingTypeInfo();
                meetingTypeInfo.setId(BOSUuid.read((String)meetingTypeId));
                info.setMrType(meetingTypeInfo);
            }
            CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
            ctrlUnitInfo.setId(BOSUuid.read((String)cuId));
            info.setCU(ctrlUnitInfo);
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)applierId));
            info.setApplier(personInfo);
            personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)compereId));
            info.setCompere(personInfo);
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)applyUnitId));
            info.setApplyUnit(adminOrgUnitInfo);
            String[] meetingAttendantArr = meetingAttendant.split(";");
            String[] meetingAttendantIdArr = meetingAttendantId.split(";");
            MRApplyMRAttendantCollection attendantCollection = info.getMRAttendant();
            for (int i = 0; i < meetingAttendantIdArr.length; ++i) {
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)meetingAttendantIdArr[i]));
                person.setName(meetingAttendantArr[i]);
                MRApplyMRAttendantInfo attendantInfo = new MRApplyMRAttendantInfo();
                attendantInfo.setAttendant(person);
                attendantInfo.setParent(info);
                attendantCollection.add(attendantInfo);
            }
            MRApplyMRAgendaCollection agendaCollection = info.getMRAgenda();
            JSONObject agendaObject = JSONObject.fromObject((Object)agendaStr, (JsonConfig)new JsonConfig());
            JSONArray agendasArr = agendaObject.getJSONArray("agendas");
            for (int i = 0; i < agendasArr.size(); ++i) {
                JSONObject agenda = (JSONObject)agendasArr.get(i);
                String strName = (String)agenda.get("name");
                String strCompere = (String)agenda.get("compere");
                String strTime = (String)agenda.get("time");
                if (StringUtils.isBlank((CharSequence)strName) && StringUtils.isBlank((CharSequence)strCompere) && StringUtils.isBlank((CharSequence)strTime)) continue;
                MRApplyMRAgendaInfo agendaInfo = new MRApplyMRAgendaInfo();
                agendaInfo.setParent(info);
                agendaInfo.setName(strName);
                agendaInfo.setCompere(strCompere);
                agendaInfo.setTime(strTime);
                agendaCollection.add(agendaInfo);
            }
            if ("update".equals(operateType)) {
                info.setId(BOSUuid.read((String)id));
                mrApply.save((CoreBaseInfo)info);
                success = true;
                result = id;
            } else {
                info.setNumber(id);
                mrApply.addnew((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), (CoreBaseInfo)info);
                success = true;
                result = id;
            }
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (ParseException e) {
            localErr = this.handleErr(e);
            success = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void submitMeeting() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        LocalErr localErr = null;
        boolean success = false;
        HashMap<String, String> result = new HashMap<String, String>();
        String id = request.getParameter("id");
        String name = request.getParameter("name");
        String impDegree = request.getParameter("impDegree");
        String applierId = request.getParameter("applierId");
        String compereId = request.getParameter("compereId");
        String applierName = request.getParameter("applier");
        String compereName = request.getParameter("compere");
        String applyUnitId = request.getParameter("applierUnitId");
        String address = request.getParameter("address");
        String addressId = request.getParameter("addressId");
        String contactPhone = request.getParameter("contactPhone");
        String startTime = request.getParameter("startTime");
        String endTime = request.getParameter("endTime");
        String remark = request.getParameter("remark");
        String applyProcess = request.getParameter("applyProcess");
        String meetingTypeId = request.getParameter("meetingTypeId");
        String meetingAttendantId = request.getParameter("meetingAttendantId");
        String meetingAttendant = request.getParameter("meetingAttendant");
        String settingStartTime = request.getParameter("settingStartTime");
        String settingEndTime = request.getParameter("settingEndTime");
        String operateType = request.getParameter("operateType");
        String agendaStr = request.getParameter("agenda");
        String submitEmail = request.getParameter("submitEmail");
        String submitSMS = request.getParameter("submitSMS");
        String submitMessage = request.getParameter("submitMessage");
        String laterEmail = request.getParameter("laterEmail");
        String laterSMS = request.getParameter("laterSMS");
        String laterMessage = request.getParameter("laterMessage");
        MRApplyInfo info = new MRApplyInfo();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        try {
            IMRApply mrApply = MRApplyFactory.getLocalInstance((Context)ctx);
            info.setName(name);
            info.setImpDegree(ImpDegreeEnum.getEnum((String)impDegree));
            info.setRemark(remark);
            info.setState(ApplyStateEnum.SAVE);
            info.setApplyProcess(applyProcess);
            info.setContactPhone(contactPhone);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            Date dateStartTime = sdf.parse(startTime);
            info.setStartTime(new Time(dateStartTime.getTime()));
            Date dateEndTime = sdf.parse(endTime);
            info.setEndTime(new Time(dateEndTime.getTime()));
            info.setSubmitEmail(new Boolean(submitEmail).booleanValue());
            info.setSubmitMessage(new Boolean(submitMessage).booleanValue());
            info.setSubmitSMS(new Boolean(submitSMS).booleanValue());
            info.setLaterEmail(new Boolean(laterEmail).booleanValue());
            info.setLaterMessage(new Boolean(laterMessage).booleanValue());
            info.setLaterSMS(new Boolean(laterSMS).booleanValue());
            IMeetingRoom meetingRoom = MeetingRoomFactory.getLocalInstance((Context)ctx);
            MeetingRoomInfo meetingRoomInfo = meetingRoom.getMeetingRoomInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)addressId)));
            info.setAddress(meetingRoomInfo);
            if (StringUtils.isNotBlank((CharSequence)meetingTypeId)) {
                MeetingTypeInfo meetingTypeInfo = new MeetingTypeInfo();
                meetingTypeInfo.setId(BOSUuid.read((String)meetingTypeId));
                info.setMrType(meetingTypeInfo);
            }
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)applierId));
            personInfo.setName(applierName);
            info.setApplier(personInfo);
            personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)compereId));
            personInfo.setName(compereName);
            info.setCompere(personInfo);
            CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
            ctrlUnitInfo.setId(BOSUuid.read((String)cuId));
            info.setCU(ctrlUnitInfo);
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)applyUnitId));
            info.setApplyUnit(adminOrgUnitInfo);
            String[] meetingAttendantArr = meetingAttendant.split(";");
            String[] meetingAttendantIdArr = meetingAttendantId.split(";");
            MRApplyMRAttendantCollection attendantCollection = info.getMRAttendant();
            for (int i = 0; i < meetingAttendantIdArr.length; ++i) {
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)meetingAttendantIdArr[i]));
                person.setName(meetingAttendantArr[i]);
                MRApplyMRAttendantInfo attendantInfo = new MRApplyMRAttendantInfo();
                attendantInfo.setAttendant(person);
                attendantInfo.setParent(info);
                attendantCollection.add(attendantInfo);
            }
            MRApplyMRAgendaCollection agendaCollection = info.getMRAgenda();
            JSONObject agendaObject = JSONObject.fromObject((Object)agendaStr, (JsonConfig)new JsonConfig());
            JSONArray agendasArr = agendaObject.getJSONArray("agendas");
            for (int i = 0; i < agendasArr.size(); ++i) {
                JSONObject agenda = (JSONObject)agendasArr.get(i);
                String strName = (String)agenda.get("name");
                String strCompere = (String)agenda.get("compere");
                String strTime = (String)agenda.get("time");
                if (StringUtils.isBlank((CharSequence)strName) && StringUtils.isBlank((CharSequence)strCompere) && StringUtils.isBlank((CharSequence)strTime)) continue;
                MRApplyMRAgendaInfo agendaInfo = new MRApplyMRAgendaInfo();
                agendaInfo.setParent(info);
                agendaInfo.setName(strName);
                agendaInfo.setCompere(strCompere);
                agendaInfo.setTime(strTime);
                agendaCollection.add(agendaInfo);
            }
            if ("update".equals(operateType)) {
                info.setId(BOSUuid.read((String)id));
                mrApply.save((CoreBaseInfo)info);
                success = true;
                result.put("id", id);
            } else {
                info.setNumber(id);
                mrApply.addnew((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), (CoreBaseInfo)info);
                success = true;
                result.put("id", id);
            }
            StringBuffer errMsg = new StringBuffer();
            if (this.checkTime(startTime, endTime, settingStartTime, settingEndTime, errMsg) && this.checkMeetingType(meetingTypeId, ctx, errMsg) && this.checkMeetingRoom(info, ctx, errMsg)) {
                mrApply.submit((CoreBaseInfo)info);
                success = true;
            } else {
                result.put("errMsg", errMsg.toString());
                localErr = new LocalErr();
                localErr.setDesc("\u4f1a\u8bae\u5355\u636e\u4e0d\u5408\u6cd5");
                success = false;
            }
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (ParseException e) {
            localErr = this.handleErr(e);
            success = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void deleteMeeting() {
        HttpServletRequest request = this.getRequest();
        String ids = request.getParameter("ids");
        LocalErr localErr = null;
        boolean success = false;
        String result = "0";
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            String[] idArr = ids.split(",");
            ObjectUuidPK[] pkArr = new ObjectUuidPK[idArr.length];
            StringBuffer sbIds = new StringBuffer(200);
            int j = idArr.length;
            for (int i = 0; i < j; ++i) {
                sbIds.append("'").append(idArr[i]).append("'").append(",");
                pkArr[i] = new ObjectUuidPK(BOSUuid.read((String)idArr[i]));
            }
            PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            try {
                IMRApply mrApply = MRApplyFactory.getLocalInstance((Context)ctx);
                MRApplyCollection mrApplyCollection = mrApply.getMRApplyCollection("select id,applier.id,state where id in (" + sbIds.substring(0, sbIds.length() - 1).toString() + ")");
                for (int i = 0; i < mrApplyCollection.size(); ++i) {
                    MRApplyInfo mrapplyInfo = mrApplyCollection.get(i);
                    if (!ApplyStateEnum.DISUSE.equals((Object)mrapplyInfo.getState()) || personInfo.getId().toString().equals(mrapplyInfo.getApplier().getId().toString()) && MeetingUtil.isMRAdminCurCU(ctx, personInfo, mrapplyInfo.getId().toString())) continue;
                    localErr = new LocalErr();
                    localErr.setDesc("\u53ea\u6709\u4f1a\u8bae\u7ba1\u7406\u5458\u548c\u4f1a\u8bae\u7533\u8bf7\u4eba\u624d\u80fd\u5220\u9664\u5e9f\u5f03\u7684\u8bb0\u5f55\uff01");
                    this.writeAjaxData(success, localErr, result);
                    return;
                }
                mrApply.delete((IObjectPK[])pkArr);
                success = true;
            }
            catch (BOSException e) {
                localErr = this.handleErr((Exception)((Object)e));
                success = false;
                e.printStackTrace();
            }
            catch (EASBizException e) {
                localErr = this.handleErr((Exception)((Object)e));
                success = false;
                e.printStackTrace();
            }
            catch (SQLException e) {
                localErr = this.handleErr(e);
                success = false;
                e.printStackTrace();
            }
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void disuseWorkFlow() {
        HttpServletRequest request = this.getRequest();
        String id = request.getParameter("id");
        LocalErr localErr = null;
        boolean success = false;
        String result = "0";
        if (StringUtils.isNotBlank((CharSequence)id)) {
            try {
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
                IMRApply mrApply = MRApplyFactory.getLocalInstance((Context)ctx);
                MRApplyInfo info = mrApply.getMRApplyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
                if (info != null && personInfo != null && info.getApplier() != null) {
                    if (info.getApplier().getId().toString().equals(personInfo.getId().toString()) || MeetingUtil.isMRAdminCurCU(ctx, personInfo, info.getId().toString())) {
                        if (ApplyStateEnum.AUD.equals((Object)info.getState())) {
                            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
                            service.abortProcessByHoldedObjectId(info.getId().toString());
                            info.setState(ApplyStateEnum.DISUSE);
                            mrApply.update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
                            success = true;
                            result = "1";
                        } else if (ApplyStateEnum.END.equals((Object)info.getState())) {
                            if (info.getStartTime().getTime() > new Date().getTime()) {
                                mrApply.cancel((IObjectValue)info);
                                success = true;
                                result = "1";
                            } else {
                                result = "\u5df2\u5f00\u59cb\u7684\u4f1a\u8bae\u4e0d\u80fd\u53d6\u6d88";
                            }
                        } else {
                            result = "\u6d41\u7a0b\u4e2d\u7684\u4f1a\u8bae\u624d\u80fd\u6267\u884c\u5e9f\u5f03\u64cd\u4f5c";
                        }
                    } else {
                        result = "\u4f1a\u8bae\u7533\u8bf7\u4eba\u6216\u4f1a\u8bae\u7ba1\u7406\u5458\u624d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c";
                    }
                }
            }
            catch (BOSException e) {
                localErr = this.handleErr((Exception)((Object)e));
                success = false;
                result = "\u64cd\u4f5c\u5931\u8d25";
                e.printStackTrace();
            }
            catch (EASBizException e) {
                localErr = this.handleErr((Exception)((Object)e));
                success = false;
                e.printStackTrace();
                result = "\u64cd\u4f5c\u5931\u8d25";
            }
            catch (SQLException e) {
                localErr = this.handleErr(e);
                success = false;
                e.printStackTrace();
                result = "\u64cd\u4f5c\u5931\u8d25";
            }
        }
        this.writeAjaxData(success, localErr, result);
    }

    private boolean checkMeetingRoom(MRApplyInfo info, Context ctx, StringBuffer errMsg) throws BOSException, EASBizException {
        boolean flag = false;
        if (info.getAddress() != null) {
            IMRApply mrApply = MRApplyFactory.getLocalInstance((Context)ctx);
            try {
                mrApply.checkTime(info.getStartTime(), info.getEndTime(), info.getId() == null ? null : info.getId().toString(), info.getAddress().getId().toString());
            }
            catch (Exception e) {
                errMsg.append("\u4f1a\u8bae\u5ba4\u51b2\u7a81\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4f1a\u8bae\u5ba4\u6216\u4fee\u6539\u4f1a\u8bae\u65f6\u95f4");
                return flag;
            }
            flag = true;
        }
        return flag;
    }

    private boolean checkTime(String startTime, String endTime, String settingStartTime, String settingEndTime, StringBuffer errMsg) throws ParseException {
        boolean flag = false;
        Date curDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Date startDate = sdf.parse(startTime);
        Date endDate = sdf.parse(endTime);
        if (MeetingUtil.compareDateMinute(startDate, curDate) <= 0) {
            flag = false;
            errMsg.append("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
        } else if (MeetingUtil.compareDateMinute(endDate, startDate) <= 0) {
            flag = false;
            errMsg.append("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        } else if (Integer.valueOf(MeetingUtil.formatDate(startDate, "HH")) - Integer.valueOf(settingStartTime) < 0) {
            flag = false;
            errMsg.append("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u4f1a\u8bae\u53c2\u6570\u65f6\u95f4");
        } else if (Integer.valueOf(MeetingUtil.formatDate(endDate, "HH")) - Integer.valueOf(settingEndTime) > 0) {
            flag = false;
            errMsg.append("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u4f1a\u8bae\u53c2\u6570\u65f6\u95f4");
        } else {
            flag = true;
        }
        return flag;
    }

    private boolean checkMeetingType(String id, Context ctx, StringBuffer errMsg) throws BOSException, EASBizException {
        IMeetingType meetingType;
        MeetingTypeInfo info;
        boolean flag = true;
        if (StringUtils.isNotBlank((CharSequence)id) && EnableStateEnum.DISABLE_STATE.equals((Object)(info = (meetingType = MeetingTypeFactory.getLocalInstance((Context)ctx)).getMeetingTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)))).getEnableState())) {
            flag = false;
            errMsg.append("\u4e0d\u80fd\u9009\u62e9\u88ab\u7981\u7528\u7684\u4f1a\u8bae\u7c7b\u578b");
        }
        return flag;
    }

    public void getPersonPhone() {
        HttpServletRequest request = this.getRequest();
        LocalErr localErr = null;
        boolean success = false;
        HashMap<String, String> result = new HashMap<String, String>();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String id = request.getParameter("id");
        try {
            IPerson person = PersonFactory.getLocalInstance((Context)ctx);
            PersonInfo personInfo = person.getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            result.put("contactPhone", personInfo.getCell());
            result.put("email", personInfo.getEmail());
            success = true;
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void doBOTP() {
        HttpServletRequest request = this.getRequest();
        LocalErr localErr = null;
        boolean success = false;
        HashMap<String, String> result = new HashMap<String, String>();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String cbRule = request.getParameter("cbRule");
        String cbDistType = request.getParameter("cbDistType");
        String id = request.getParameter("id");
        if (StringUtils.isNotBlank((CharSequence)cbRule) && StringUtils.isNotBlank((CharSequence)cbDistType)) {
            try {
                IMRApply mrApply = MRApplyFactory.getLocalInstance((Context)ctx);
                MRApplyInfo info = mrApply.getMRApplyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                String srcBosType = info.getBOSType().toString();
                BOTPHelper botpHelper = new BOTPHelper(ctx, srcBosType, null, null);
                BOTMappingInfo mappingInfo = botpHelper.getMappingInfoByPK(cbRule);
                if (mappingInfo.getIsTempSave() != 2) {
                    StringBuffer sb = new StringBuffer();
                    String times = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                    try {
                        botpHelper = new BOTPHelper(ctx, srcBosType, cbDistType, cbRule);
                        botpHelper.setWebForm(true);
                        botpHelper.transformTo(new String[]{id});
                        success = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        String errMsg = BatchActionUtil.getExceptionMsg((Context)ctx, (Throwable)e);
                        if (errMsg == null) {
                            StringBuffer sbErrMsg = new StringBuffer(2000);
                            sbErrMsg.append(e);
                            StackTraceElement[] trace = e.getStackTrace();
                            for (int i = 0; i < trace.length; ++i) {
                                sbErrMsg.append("\tat " + trace[i] + "\n");
                            }
                            errMsg = sbErrMsg.toString();
                            result.put("errMsg", errMsg);
                        }
                        success = false;
                    }
                }
            }
            catch (BOSException e) {
                localErr = this.handleErr((Exception)((Object)e));
                success = false;
                e.printStackTrace();
            }
            catch (EASBizException e) {
                localErr = this.handleErr((Exception)((Object)e));
                success = false;
                e.printStackTrace();
            }
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void initSummaryBOTP() {
        HttpServletRequest request = this.getRequest();
        LocalErr localErr = null;
        boolean success = false;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String id = request.getParameter("id");
        try {
            IMRApply mrApply = MRApplyFactory.getLocalInstance((Context)ctx);
            MRApplyInfo info = mrApply.getMRApplyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            BOTPHelper botpHelper = new BOTPHelper(ctx, info.getBOSType().toString(), null, null);
            MRApplyCollection collection = new MRApplyCollection();
            collection.addObject((IObjectValue)info);
            LinkedList<SelectItem> destTypeItems = new LinkedList<SelectItem>();
            SelectItem[] rules = new SelectItem[]{};
            String cbDistType = "";
            String[][] destBosTypes = botpHelper.getDestinationBosTypes();
            if (destBosTypes == null || destBosTypes.length == 0) {
                cbDistType = "";
                return;
            }
            for (int i = 0; i < destBosTypes[0].length; ++i) {
                if (!this.hasCompanyBotpRule(destBosTypes[0][i], botpHelper)) continue;
                destTypeItems.add(new SelectItem((Object)destBosTypes[0][i], destBosTypes[1][i]));
            }
            int typeItemCount = destTypeItems.size();
            SelectItem[] distTypes = new SelectItem[typeItemCount];
            for (int i = 0; i < typeItemCount; ++i) {
                distTypes[i] = (SelectItem)destTypeItems.get(i);
            }
            if (distTypes.length > 0) {
                cbDistType = distTypes[0].getValue().toString();
            }
            BOTMappingCollection botMappingCols = new BOTMappingCollection();
            BOTMappingCollection botMappingCollection = botpHelper.getMappingCollectionForSelect(cbDistType);
            Iterator iter = botMappingCollection.iterator();
            ArrayList<BOTMappingInfo> companyMappings = new ArrayList<BOTMappingInfo>();
            while (iter.hasNext()) {
                BOTMappingInfo mappingInfo = (BOTMappingInfo)iter.next();
                String currentOrgId = "";
                if (mappingInfo.getExtRule() != null && mappingInfo.getExtRule().getOrg() != null && !mappingInfo.getExtRule().getOrg().getId().toString().equals(currentOrgId)) continue;
                companyMappings.add(mappingInfo);
            }
            if (companyMappings.size() == 0) {
                throw new BOTPException(BOTPException.NOCOMPANYMAPPING);
            }
            for (BOTMappingInfo mappingInfo : companyMappings) {
                BOTPHelper.acceptMapping(new String[]{id}, mappingInfo, info.getBOSType().toString());
                botMappingCols.add(mappingInfo);
            }
            botMappingCollection = botMappingCols;
            if (botMappingCols != null) {
                int count = botMappingCols.size();
                rules = new SelectItem[count];
                for (int i = 0; i < count; ++i) {
                    rules[i] = new SelectItem((Object)botMappingCols.get(i).getId().toString(), botMappingCols.get(i).getAlias());
                }
            }
            success = true;
            result.put("cbDistType", cbDistType);
            result.put("distTypes", distTypes);
            result.put("rules", rules);
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    private boolean hasCompanyBotpRule(String destBillBosType, BOTPHelper botpHelper) {
        boolean flag = false;
        try {
            BOTMappingCollection botMappingCollection = botpHelper.getMappingCollectionForSelect(destBillBosType);
            Iterator iter = botMappingCollection.iterator();
            ArrayList<BOTMappingInfo> companyMappings = new ArrayList<BOTMappingInfo>();
            while (iter.hasNext()) {
                BOTMappingInfo mappingInfo = (BOTMappingInfo)iter.next();
                String currentOrgId = "";
                if (mappingInfo.getExtRule() != null && mappingInfo.getExtRule().getOrg() != null && !mappingInfo.getExtRule().getOrg().getId().toString().equals(currentOrgId)) continue;
                companyMappings.add(mappingInfo);
            }
            if (companyMappings.size() > 0) {
                flag = true;
            }
        }
        catch (BOTPException botE) {
            throw new FacesException((Throwable)botE);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public void queryMyMeetings() {
        HttpServletRequest request = this.getRequest();
        LocalErr localErr = null;
        boolean success = false;
        HashMap result = new HashMap();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app.MRApplyQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("applier.name"));
        sic.add(new SelectorItemInfo("address.name"));
        sic.add(new SelectorItemInfo("startTime"));
        sic.add(new SelectorItemInfo("endTime"));
        sic.add(new SelectorItemInfo("contactPhone"));
        try {
            ArrayList<MeetingDTO> list = new ArrayList<MeetingDTO>();
            PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            if (personInfo != null) {
                FilterInfo filterInfo = new FilterInfo();
                FilterItemCollection itemCollection = filterInfo.getFilterItems();
                itemCollection.add(new FilterItemInfo("compere.id", (Object)personInfo.getId(), CompareType.EQUALS));
                itemCollection.add(new FilterItemInfo("MRAttendant.attendant.id", (Object)personInfo.getId(), CompareType.EQUALS));
                itemCollection.add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
                filterInfo.setMaskString("(#0 or #1) and #2 ");
                entityViewInfo.setFilter(filterInfo);
                entityViewInfo.setSelector(sic);
                IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
                this.logger.debug("executor search content sql is:" + exec.getSQL());
                IRowSet rowSet = exec.executeQuery();
                if (rowSet != null) {
                    while (rowSet.next()) {
                        MeetingDTO meetingDTO = new MeetingDTO();
                        meetingDTO.setId(rowSet.getString("id"));
                        meetingDTO.setName(rowSet.getString("name"));
                        meetingDTO.setAddress(rowSet.getString("address.name"));
                        meetingDTO.setApplier(rowSet.getString("applier.name"));
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                        meetingDTO.setStartTime(sdf.format(rowSet.getDate("startTime")));
                        meetingDTO.setEndTime(sdf.format(rowSet.getDate("endTime")));
                        meetingDTO.setState(rowSet.getString("state"));
                        meetingDTO.setContactPhone(rowSet.getString("contactPhone"));
                        list.add(meetingDTO);
                    }
                }
            }
            String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            IMeetingSetting meetingSetting = MeetingSettingFactory.getLocalInstance((Context)ctx);
            MeetingSettingCollection collection = meetingSetting.getMeetingSettingCollection("select key, value, type where CU.id = '" + cuId + "'" + "and key in ('startTime','endTime')");
            ArrayList<MeetingSettingDTO> listSetting = new ArrayList<MeetingSettingDTO>(collection.size());
            for (int i = 0; i < collection.size(); ++i) {
                MeetingSettingInfo info = collection.get(i);
                MeetingSettingDTO dto = new MeetingSettingDTO();
                dto.setKey(info.getKey());
                dto.setValue(info.getValue());
                listSetting.add(dto);
            }
            result.put("settings", listSetting);
            result.put("meetings", list);
            success = true;
        }
        catch (ParserException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (Exception e) {
            localErr = this.handleErr(e);
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void meetingBillView() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        LocalErr localErr = null;
        boolean success = false;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String id = request.getParameter("id");
        try {
            ArrayList<MeetingAgendaDTO> agendas = new ArrayList<MeetingAgendaDTO>();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app.MRApplyQuery");
                String filterStr = "id='" + id + "'";
                entityViewInfo.setFilter(filterStr);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("mrType.name"));
                sic.add(new SelectorItemInfo("mrType.id"));
                sic.add(new SelectorItemInfo("applier.name"));
                sic.add(new SelectorItemInfo("applier.Id"));
                sic.add(new SelectorItemInfo("compere.name"));
                sic.add(new SelectorItemInfo("compere.id"));
                sic.add(new SelectorItemInfo("applyUnit.name"));
                sic.add(new SelectorItemInfo("applyUnit.Id"));
                sic.add(new SelectorItemInfo("address.name"));
                sic.add(new SelectorItemInfo("address.Id"));
                sic.add(new SelectorItemInfo("startTime"));
                sic.add(new SelectorItemInfo("endTime"));
                sic.add(new SelectorItemInfo("impDegree"));
                sic.add(new SelectorItemInfo("applyProcess"));
                sic.add(new SelectorItemInfo("contactPhone"));
                sic.add(new SelectorItemInfo("remark"));
                sic.add(new SelectorItemInfo("submitEmail"));
                sic.add(new SelectorItemInfo("submitSMS"));
                sic.add(new SelectorItemInfo("submitMessage"));
                sic.add(new SelectorItemInfo("laterEmail"));
                sic.add(new SelectorItemInfo("laterSMS"));
                sic.add(new SelectorItemInfo("laterMessage"));
                entityViewInfo.setSelector(sic);
                IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
                IRowSet rowSet = exec.executeQuery();
                if (rowSet != null && rowSet.next()) {
                    result.put("unitId", rowSet.getString("applyUnit.Id"));
                    result.put("unitName", rowSet.getString("applyUnit.name"));
                    result.put("personId", rowSet.getString("applier.Id"));
                    result.put("personName", rowSet.getString("applier.name"));
                    result.put("contactPhone", rowSet.getString("contactPhone"));
                    result.put("remark", rowSet.getString("remark"));
                    result.put("impDegree", rowSet.getString("impDegree"));
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    result.put("startTime", sdf.format(rowSet.getDate("startTime")));
                    result.put("endTime", sdf.format(rowSet.getDate("endTime")));
                    result.put("name", rowSet.getString("name"));
                    result.put("meetingType", rowSet.getString("mrType.name"));
                    result.put("meetingTypeId", rowSet.getString("mrType.id"));
                    result.put("addressId", rowSet.getString("address.id"));
                    result.put("address", rowSet.getString("address.name"));
                    result.put("applyProcess", rowSet.getString("applyProcess"));
                    result.put("compere", rowSet.getString("compere.name"));
                    result.put("compereId", rowSet.getString("compere.id"));
                    result.put("submitEmail", rowSet.getBoolean("submitEmail"));
                    result.put("submitSMS", rowSet.getBoolean("submitSMS"));
                    result.put("submitMessage", rowSet.getBoolean("submitMessage"));
                    result.put("laterEmail", rowSet.getBoolean("laterEmail"));
                    result.put("laterSMS", rowSet.getBoolean("laterSMS"));
                    result.put("laterMessage", rowSet.getBoolean("laterMessage"));
                    IMRApply mrApply = MRApplyFactory.getLocalInstance((Context)ctx);
                    MRApplyInfo info = mrApply.getMRApplyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                    StringBuffer sbIdSql = new StringBuffer(200);
                    MRApplyMRAttendantCollection attendantCollection = info.getMRAttendant();
                    int j = attendantCollection.size();
                    for (int i = 0; i < j; ++i) {
                        MRApplyMRAttendantInfo attendantInfo = attendantCollection.get(i);
                        sbIdSql.append("'" + attendantInfo.getAttendant().getId().toString() + "'").append(",");
                    }
                    IPerson person = PersonFactory.getLocalInstance((Context)ctx);
                    PersonCollection personCollection = person.getPersonCollection("select id,name where id in (" + sbIdSql.substring(0, sbIdSql.length() - 1).toString() + ")");
                    StringBuffer sbAttendantId = new StringBuffer(200);
                    StringBuffer sbAttendantName = new StringBuffer(200);
                    int j2 = personCollection.size();
                    for (int i = 0; i < j2; ++i) {
                        sbAttendantId.append(personCollection.get(i).getId().toString()).append(";");
                        sbAttendantName.append(personCollection.get(i).getName()).append(";");
                    }
                    result.put("meetingAttendantId", sbAttendantId.substring(0, sbAttendantId.length() - 1).toString());
                    result.put("meetingAttendantName", sbAttendantName.substring(0, sbAttendantName.length() - 1).toString());
                    MRApplyMRAgendaCollection agendaCollection = info.getMRAgenda();
                    int j3 = agendaCollection.size();
                    for (int i = 0; i < j3; ++i) {
                        MeetingAgendaDTO meetingAgendaDTO = new MeetingAgendaDTO();
                        meetingAgendaDTO.setCompere(agendaCollection.get(i).getCompere());
                        meetingAgendaDTO.setName(agendaCollection.get(i).getName());
                        meetingAgendaDTO.setTime(agendaCollection.get(i).getTime());
                        agendas.add(meetingAgendaDTO);
                    }
                }
            }
            result.put("agendas", agendas);
            success = true;
        }
        catch (ParserException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (Exception e) {
            localErr = this.handleErr(e);
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }
}

