/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.mrm.module.query.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.DocumentControlSettingFactory;
import com.kingdee.eas.cp.base.DocumentControlSettingInfo;
import com.kingdee.eas.cp.base.IDocumentControlSetting;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.mrm.EnableStateEnum;
import com.kingdee.eas.cp.mrm.IMRApply;
import com.kingdee.eas.cp.mrm.IMRSummary;
import com.kingdee.eas.cp.mrm.IMeetingRoom;
import com.kingdee.eas.cp.mrm.IMeetingType;
import com.kingdee.eas.cp.mrm.ImpDegreeEnum;
import com.kingdee.eas.cp.mrm.MRApplyFactory;
import com.kingdee.eas.cp.mrm.MRApplyInfo;
import com.kingdee.eas.cp.mrm.MRSummaryFactory;
import com.kingdee.eas.cp.mrm.MRSummaryInfo;
import com.kingdee.eas.cp.mrm.MRSummaryMRApplyCCCollection;
import com.kingdee.eas.cp.mrm.MRSummaryMRApplyCCInfo;
import com.kingdee.eas.cp.mrm.MRSummaryMRAttendantCollection;
import com.kingdee.eas.cp.mrm.MRSummaryMRAttendantInfo;
import com.kingdee.eas.cp.mrm.MeetingRoomCollection;
import com.kingdee.eas.cp.mrm.MeetingRoomFactory;
import com.kingdee.eas.cp.mrm.MeetingRoomInfo;
import com.kingdee.eas.cp.mrm.MeetingTypeCollection;
import com.kingdee.eas.cp.mrm.MeetingTypeFactory;
import com.kingdee.eas.cp.mrm.MeetingTypeInfo;
import com.kingdee.eas.cp.mrm.SummaryStateEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.plt.mrm.module.query.dto.MeetingSummaryDTO;
import com.kingdee.portal.plt.mrm.module.query.util.MeetingUtil;
import com.kingdee.portal.plt.mrm.module.setting.dto.MeetingRoomDTO;
import com.kingdee.portal.plt.mrm.module.setting.dto.MeetingTypeDTO;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class MeetingSummaryAction
extends BaseAction {
    private static final long serialVersionUID = 7137876321275560043L;

    public void loadMeetingSummaryList() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app.MRSummaryQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("mrType.name"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("recorder.name"));
        sic.add(new SelectorItemInfo("pigState"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        String summaryName = request.getParameter("summaryName");
        String keyword = request.getParameter("keyword");
        try {
            FilterInfo filterInfo;
            entityViewInfo = this.assembleCondition(request);
            if (StringUtils.isNotBlank((CharSequence)summaryName)) {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + summaryName + "%"), CompareType.LIKE));
                entityViewInfo.getFilter().mergeFilter(filterInfo, "AND");
            }
            if (StringUtils.isNotBlank((CharSequence)keyword)) {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)keyword, CompareType.EQUALS));
                entityViewInfo.getFilter().mergeFilter(filterInfo, "AND");
            }
            entityViewInfo.setSelector(sic);
            IQueryExecutor exec = null;
            IRowSet rowSet = null;
            IRowSet countRowSet = null;
            int total = 0;
            int totalPage = 0;
            int pageNo = 0;
            int pageSize = 10;
            pageNo = this.pagingParam.getPageNo();
            pageSize = this.pagingParam.getPageSize();
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content count sql is:" + exec.getSQL());
            countRowSet = exec.executeQuery();
            while (countRowSet.next()) {
                this.logger.debug("record total is" + ++total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.logger.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            ArrayList<MeetingSummaryDTO> list = new ArrayList<MeetingSummaryDTO>();
            if (total > 0) {
                this.logger.debug("executor search content sql is:" + exec.getSQL());
                rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
                if (rowSet != null) {
                    while (rowSet.next()) {
                        MeetingSummaryDTO meetingSummaryDTO = new MeetingSummaryDTO();
                        meetingSummaryDTO.setId(rowSet.getString("id"));
                        meetingSummaryDTO.setName(rowSet.getString("name"));
                        meetingSummaryDTO.setMeetingType(rowSet.getString("mrType.name"));
                        meetingSummaryDTO.setRecorder(rowSet.getString("recorder.name"));
                        meetingSummaryDTO.setState(rowSet.getString("state"));
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                        meetingSummaryDTO.setCreateTime(sdf.format(rowSet.getDate("createTime")));
                        meetingSummaryDTO.setPigState(rowSet.getString("pigState"));
                        meetingSummaryDTO.setMeetingId(rowSet.getString("sourceBillId"));
                        list.add(meetingSummaryDTO);
                    }
                }
            }
            PagingResult pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            this.writePagingResult(pagingResult);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initSummaryInfo() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        LocalErr localErr = null;
        boolean success = false;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String id = request.getParameter("id");
        result.put("impDegreeEnum", ImpDegreeEnum.getEnumList());
        try {
            String isForced = "0";
            String fileType = "1";
            try {
                IDocumentControlSetting idcs = DocumentControlSettingFactory.getLocalInstance((Context)ctx);
                DocumentControlSettingInfo dci = null;
                dci = idcs.getDocumentControlSettingInfo("select fileType,isForced where id ='" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId() + "'");
                if (dci != null) {
                    fileType = dci.getFileType().getValue();
                    isForced = dci.isIsForced() ? "1" : "0";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            result.put("isForced", isForced);
            result.put("fileType", fileType);
            IMeetingType meetingType = MeetingTypeFactory.getLocalInstance((Context)ctx);
            String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            MeetingTypeCollection meetingTypeCollection = meetingType.getMeetingTypeCollection("select id,name,summryProcess where cu.id='" + cuId + "' and enableState = " + 0);
            ArrayList<MeetingTypeDTO> lstMeetingTypeDTO = new ArrayList<MeetingTypeDTO>(meetingTypeCollection.size());
            for (int i = 0; i < meetingTypeCollection.size(); ++i) {
                MeetingTypeDTO meetingTypeDTO = new MeetingTypeDTO();
                meetingTypeDTO.setId(meetingTypeCollection.get(i).getId().toString());
                meetingTypeDTO.setName(meetingTypeCollection.get(i).getName());
                meetingTypeDTO.setSummaryProcessId(meetingTypeCollection.get(i).getSummaryProcess());
                lstMeetingTypeDTO.add(meetingTypeDTO);
            }
            result.put("meetingTypes", lstMeetingTypeDTO);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            String roomFilterStr = "(cu.id='" + cuId + "' or (id in(select FParentId from T_MRM_MeetingRoomShareCU where FShareCUId='" + cuId + "'))) and enableState=" + 0;
            entityViewInfo.setFilter(roomFilterStr);
            IMeetingRoom meetingRoom = MeetingRoomFactory.getLocalInstance((Context)ctx);
            MeetingRoomCollection meetingRooms = meetingRoom.getMeetingRoomCollection(entityViewInfo);
            ArrayList<MeetingRoomDTO> lstMeetingRoomDTO = new ArrayList<MeetingRoomDTO>(meetingRooms.size());
            for (int i = 0; i < meetingRooms.size(); ++i) {
                MeetingRoomDTO meetingRoomDTO = new MeetingRoomDTO();
                meetingRoomDTO.setName(meetingRooms.get(i).getName());
                meetingRoomDTO.setId(meetingRooms.get(i).getId().toString());
                lstMeetingRoomDTO.add(meetingRoomDTO);
            }
            result.put("meetingRooms", lstMeetingRoomDTO);
            if (StringUtils.isNotBlank((CharSequence)id)) {
                EntityViewInfo eview = new EntityViewInfo();
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app.MRSummaryQuery");
                String filterStr = "id='" + id + "'";
                eview.setFilter(filterStr);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("mrType.name"));
                sic.add(new SelectorItemInfo("mrType.id"));
                sic.add(new SelectorItemInfo("compere.name"));
                sic.add(new SelectorItemInfo("compere.id"));
                sic.add(new SelectorItemInfo("recorder.name"));
                sic.add(new SelectorItemInfo("recorder.id"));
                sic.add(new SelectorItemInfo("address.name"));
                sic.add(new SelectorItemInfo("address.Id"));
                sic.add(new SelectorItemInfo("startTime"));
                sic.add(new SelectorItemInfo("endTime"));
                sic.add(new SelectorItemInfo("summaryProcess"));
                sic.add(new SelectorItemInfo("sourceBillId"));
                sic.add(new SelectorItemInfo("state"));
                eview.setSelector(sic);
                IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, eview, ctx);
                IRowSet rowSet = exec.executeQuery();
                if (rowSet != null && rowSet.next()) {
                    MRApplyInfo info;
                    result.put("personId", rowSet.getString("recorder.id"));
                    result.put("personName", rowSet.getString("recorder.name"));
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    result.put("startTime", sdf.format(rowSet.getDate("startTime")));
                    result.put("endTime", sdf.format(rowSet.getDate("endTime")));
                    result.put("name", rowSet.getString("name"));
                    result.put("meetingType", rowSet.getString("mrType.name"));
                    result.put("meetingTypeId", rowSet.getString("mrType.id"));
                    result.put("addressId", rowSet.getString("address.id"));
                    result.put("address", rowSet.getString("address.name"));
                    result.put("summaryProcess", rowSet.getString("summaryProcess"));
                    result.put("compere", rowSet.getString("compere.name"));
                    result.put("compereId", rowSet.getString("compere.id"));
                    result.put("state", rowSet.getString("state"));
                    String sourceBillId = rowSet.getString("sourceBillId");
                    if (StringUtils.isNotBlank((CharSequence)sourceBillId)) {
                        IMRApply mrApply = MRApplyFactory.getLocalInstance((Context)ctx);
                        info = mrApply.getMRApplyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)sourceBillId)));
                        result.put("meetingName", info.getName());
                        result.put("meetingId", sourceBillId);
                    }
                    IMRSummary mrSummry = MRSummaryFactory.getLocalInstance((Context)ctx);
                    info = mrSummry.getMRSummaryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                    StringBuffer sbAttendantIdSql = new StringBuffer(200);
                    MRSummaryMRAttendantCollection attendantCollection = info.getMRAttendant();
                    int j = attendantCollection.size();
                    for (int i = 0; i < j; ++i) {
                        MRSummaryMRAttendantInfo attendantInfo = attendantCollection.get(i);
                        sbAttendantIdSql.append("'" + attendantInfo.getAttendant().getId().toString() + "'").append(",");
                    }
                    IPerson person = PersonFactory.getLocalInstance((Context)ctx);
                    PersonCollection attendantPersonCollection = person.getPersonCollection("select id,name where id in (" + sbAttendantIdSql.substring(0, sbAttendantIdSql.length() - 1).toString() + ")");
                    StringBuffer sbAttendantId = new StringBuffer(200);
                    StringBuffer sbAttendantName = new StringBuffer(200);
                    int j2 = attendantCollection.size();
                    for (int i = 0; i < j2; ++i) {
                        sbAttendantId.append(attendantPersonCollection.get(i).getId().toString()).append(";");
                        sbAttendantName.append(attendantPersonCollection.get(i).getName()).append(";");
                    }
                    result.put("meetingAttendantId", sbAttendantId.substring(0, sbAttendantId.length() - 1).toString());
                    result.put("meetingAttendantName", sbAttendantName.substring(0, sbAttendantName.length() - 1).toString());
                    StringBuffer sbCCIdSql = new StringBuffer(200);
                    MRSummaryMRApplyCCCollection ccCollection = info.getMRApplyCC();
                    int j3 = ccCollection.size();
                    for (int i = 0; i < j3; ++i) {
                        MRSummaryMRApplyCCInfo ccInfo = ccCollection.get(i);
                        sbCCIdSql.append("'" + ccInfo.getCc().getId().toString() + "'").append(",");
                    }
                    PersonCollection ccPersonCollection = person.getPersonCollection("select id,name where id in (" + sbCCIdSql.substring(0, sbCCIdSql.length() - 1).toString() + ")");
                    StringBuffer sbCCId = new StringBuffer(200);
                    StringBuffer sbCCName = new StringBuffer(200);
                    int j4 = ccPersonCollection.size();
                    for (int i = 0; i < j4; ++i) {
                        sbCCId.append(ccPersonCollection.get(i).getId().toString()).append(";");
                        sbCCName.append(ccPersonCollection.get(i).getName()).append(";");
                    }
                    result.put("meetingCCId", sbCCId.substring(0, sbCCId.length() - 1).toString());
                    result.put("meetingCCName", sbCCName.substring(0, sbCCName.length() - 1).toString());
                }
            } else {
                String newId = BOSUuid.create((BOSObjectType)new MRApplyInfo().getBOSType()).toString();
                PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
                result.put("personId", person.getId().toString());
                result.put("personName", person.getName());
                result.put("id", newId);
            }
            success = true;
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (ParserException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (Exception e) {
            localErr = this.handleErr(e);
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void saveSummary() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        LocalErr localErr = null;
        boolean success = false;
        String result = "";
        String id = request.getParameter("id");
        String name = request.getParameter("name");
        String compereId = request.getParameter("compereId");
        String addressId = request.getParameter("addressId");
        String address = request.getParameter("address");
        String startTime = request.getParameter("startTime");
        String endTime = request.getParameter("endTime");
        String meetingTypeId = request.getParameter("meetingTypeId");
        String meetingId = request.getParameter("meetingId");
        String meetingAttendantId = request.getParameter("meetingAttendantId");
        String meetingAttendant = request.getParameter("meetingAttendant");
        String meetingCCId = request.getParameter("meetingCCId");
        String meetingCC = request.getParameter("meetingCC");
        String operateType = request.getParameter("operateType");
        String actionType = request.getParameter("actionType");
        String fileName = request.getParameter("fileName");
        fileName = fileName.replaceAll("%2B", "+");
        fileName = fileName.replaceAll("/", "l");
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        try {
            PersonInfo person;
            int i;
            IMRSummary mrSummary = MRSummaryFactory.getLocalInstance((Context)ctx);
            MRSummaryInfo info = new MRSummaryInfo();
            info.setName(name);
            info.setState(SummaryStateEnum.SAVE);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            info.setStartTime(new Time(sdf.parse(startTime).getTime()));
            info.setEndTime(new Time(sdf.parse(endTime).getTime()));
            info.setFileName(fileName);
            info.setSourceBillId(meetingId);
            if (StringUtils.isNotBlank((CharSequence)addressId)) {
                MeetingRoomInfo meetingRoomInfo = new MeetingRoomInfo();
                meetingRoomInfo.setId(BOSUuid.read((String)addressId));
                meetingRoomInfo.setName(address);
                info.setAddress(meetingRoomInfo);
            }
            if (StringUtils.isNotBlank((CharSequence)meetingTypeId)) {
                IMeetingType meetingType = MeetingTypeFactory.getLocalInstance((Context)ctx);
                MeetingTypeInfo meetingTypeInfo = meetingType.getMeetingTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)meetingTypeId)));
                info.setMrType(meetingTypeInfo);
                info.setSummaryProcess(meetingTypeInfo.getSummaryProcess());
            }
            CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
            ctrlUnitInfo.setId(BOSUuid.read((String)cuId));
            info.setCU(ctrlUnitInfo);
            PersonInfo personInfo = null;
            if (StringUtils.isNotBlank((CharSequence)compereId)) {
                personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)compereId));
                info.setCompere(personInfo);
            }
            personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            info.setRecorder(personInfo);
            if (StringUtils.isNotBlank((CharSequence)meetingAttendantId)) {
                String[] meetingAttendantArr = meetingAttendant.split(";");
                String[] meetingAttendantIdArr = meetingAttendantId.split(";");
                MRSummaryMRAttendantCollection attendantCollection = info.getMRAttendant();
                for (i = 0; i < meetingAttendantIdArr.length; ++i) {
                    person = new PersonInfo();
                    person.setId(BOSUuid.read((String)meetingAttendantIdArr[i]));
                    person.setName(meetingAttendantArr[i]);
                    MRSummaryMRAttendantInfo attendantInfo = new MRSummaryMRAttendantInfo();
                    attendantInfo.setAttendant(person);
                    attendantInfo.setParent(info);
                    attendantCollection.add(attendantInfo);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)meetingCCId)) {
                String[] meetingCCArr = meetingCC.split(";");
                String[] meetingCCIdArr = meetingCCId.split(";");
                MRSummaryMRApplyCCCollection ccCollection = info.getMRApplyCC();
                for (i = 0; i < meetingCCIdArr.length; ++i) {
                    person = new PersonInfo();
                    person.setId(BOSUuid.read((String)meetingCCIdArr[i]));
                    person.setName(meetingCCArr[i]);
                    MRSummaryMRApplyCCInfo ccInfo = new MRSummaryMRApplyCCInfo();
                    ccInfo.setCc(person);
                    ccInfo.setParent(info);
                    ccCollection.add(ccInfo);
                }
            }
            if ("add".equals(operateType)) {
                info.setNumber(id);
                info.setId(BOSUuid.read((String)id));
                mrSummary.addNewForDoc(info);
                success = true;
                result = id;
            } else if ("update".equals(operateType)) {
                info.setId(BOSUuid.read((String)id));
                mrSummary.save((CoreBaseInfo)info);
                success = true;
                result = id;
            }
            if ("submit".equals(actionType)) {
                StringBuffer errMsg = new StringBuffer();
                if (this.checkTime(startTime, endTime, errMsg) && this.checkMeetingType(meetingTypeId, ctx, errMsg)) {
                    mrSummary.submit((CoreBaseInfo)info);
                    success = true;
                } else {
                    result = errMsg.toString();
                    localErr = new LocalErr();
                    localErr.setDesc("\u4f1a\u8bae\u5355\u636e\u4e0d\u5408\u6cd5");
                    success = false;
                }
            }
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (ParseException e) {
            localErr = this.handleErr(e);
            success = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void deleteSummary() {
        HttpServletRequest request = this.getRequest();
        String ids = request.getParameter("ids");
        LocalErr localErr = null;
        boolean success = false;
        String result = "0";
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            String[] idArr = ids.split(",");
            ObjectUuidPK[] pkArr = new ObjectUuidPK[idArr.length];
            StringBuffer sbIds = new StringBuffer(200);
            int j = idArr.length;
            for (int i = 0; i < j; ++i) {
                sbIds.append("'").append(idArr[i]).append("'").append(",");
                pkArr[i] = new ObjectUuidPK(BOSUuid.read((String)idArr[i]));
            }
            try {
                IMRSummary mrSummary = MRSummaryFactory.getLocalInstance((Context)ctx);
                mrSummary.delete((IObjectPK[])pkArr);
                success = true;
            }
            catch (BOSException e) {
                localErr = this.handleErr((Exception)((Object)e));
                success = false;
                e.printStackTrace();
            }
            catch (EASBizException e) {
                localErr = this.handleErr((Exception)((Object)e));
                success = false;
                e.printStackTrace();
            }
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void checkSummaryDoc() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        LocalErr localErr = null;
        boolean success = false;
        String result = "1";
        String id = request.getParameter("id");
        try {
            IMRSummary mrSummary = MRSummaryFactory.getLocalInstance((Context)ctx);
            MRSummaryInfo info = mrSummary.getMRSummaryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            if (info.getDocEntity() == null) {
                result = "0";
            } else {
                result = "1";
                success = true;
            }
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void loadMeetingRoomList() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app.MeetingRoomQuery");
        try {
            String meetingroomName = this.getRequest().getParameter("meetingRoomName");
            String nameSql = "(";
            if (meetingroomName != null && !meetingroomName.trim().equals("")) {
                nameSql = "name like '%" + meetingroomName.trim() + "%' and (";
            }
            String filterStr = nameSql + "cu.id='" + cuId + "' or (id in(select FParentId from T_MRM_MeetingRoomShareCU where FShareCUId='" + cuId + "')" + "))and enableState=" + 0 + "  order by id asc";
            entityViewInfo.setFilter(filterStr);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("seatCount"));
            sic.add(new SelectorItemInfo("address"));
            sic.add(new SelectorItemInfo("contact.name"));
            entityViewInfo.setSelector(sic);
            IQueryExecutor exec = null;
            IRowSet rowSet = null;
            IRowSet countRowSet = null;
            int total = 0;
            int totalPage = 0;
            int pageNo = 0;
            int pageSize = 10;
            pageNo = this.pagingParam.getPageNo();
            pageSize = this.pagingParam.getPageSize();
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content count sql is:" + exec.getSQL());
            countRowSet = exec.executeQuery();
            while (countRowSet.next()) {
                this.logger.debug("record total is" + ++total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.logger.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            ArrayList<MeetingRoomDTO> list = new ArrayList<MeetingRoomDTO>();
            if (total > 0) {
                this.logger.debug("executor search content sql is:" + exec.getSQL());
                rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
                if (rowSet != null) {
                    while (rowSet.next()) {
                        MeetingRoomDTO meetingRoomDTO = new MeetingRoomDTO();
                        String meetingroomId = rowSet.getString("id");
                        meetingRoomDTO.setId(meetingroomId);
                        meetingRoomDTO.setAddress(rowSet.getString("address"));
                        meetingRoomDTO.setName(rowSet.getString("name"));
                        meetingRoomDTO.setSeatCount(rowSet.getString("seatCount"));
                        meetingRoomDTO.setContact1Name(rowSet.getString("contact.name"));
                        list.add(meetingRoomDTO);
                    }
                }
            }
            PagingResult pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            this.writePagingResult(pagingResult);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void summaryBillView() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        LocalErr localErr = null;
        boolean success = false;
        HashMap<String, String> result = new HashMap<String, String>();
        String id = request.getParameter("id");
        try {
            String isForced = "0";
            String fileType = "1";
            try {
                IDocumentControlSetting idcs = DocumentControlSettingFactory.getLocalInstance((Context)ctx);
                DocumentControlSettingInfo dci = null;
                dci = idcs.getDocumentControlSettingInfo("select fileType,isForced where id ='" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId() + "'");
                if (dci != null) {
                    fileType = dci.getFileType().getValue();
                    isForced = dci.isIsForced() ? "1" : "0";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            result.put("isForced", isForced);
            result.put("fileType", fileType);
            if (StringUtils.isNotBlank((CharSequence)id)) {
                EntityViewInfo eview = new EntityViewInfo();
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app.MRSummaryQuery");
                String filterStr = "id='" + id + "'";
                eview.setFilter(filterStr);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("mrType.name"));
                sic.add(new SelectorItemInfo("compere.name"));
                sic.add(new SelectorItemInfo("compere.id"));
                sic.add(new SelectorItemInfo("recorder.name"));
                sic.add(new SelectorItemInfo("recorder.id"));
                sic.add(new SelectorItemInfo("address.name"));
                sic.add(new SelectorItemInfo("address.Id"));
                sic.add(new SelectorItemInfo("startTime"));
                sic.add(new SelectorItemInfo("endTime"));
                sic.add(new SelectorItemInfo("summaryProcess"));
                sic.add(new SelectorItemInfo("sourceBillId"));
                sic.add(new SelectorItemInfo("state"));
                eview.setSelector(sic);
                IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, eview, ctx);
                IRowSet rowSet = exec.executeQuery();
                if (rowSet != null && rowSet.next()) {
                    MRApplyInfo info;
                    result.put("recorderName", rowSet.getString("recorder.name"));
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    result.put("startTime", sdf.format(rowSet.getDate("startTime")));
                    result.put("endTime", sdf.format(rowSet.getDate("endTime")));
                    result.put("name", rowSet.getString("name"));
                    result.put("meetingType", rowSet.getString("mrType.name"));
                    result.put("addressId", rowSet.getString("address.id"));
                    result.put("address", rowSet.getString("address.name"));
                    result.put("summaryProcess", rowSet.getString("summaryProcess"));
                    result.put("compere", rowSet.getString("compere.name"));
                    result.put("compereId", rowSet.getString("compere.id"));
                    result.put("state", rowSet.getString("state"));
                    String sourceBillId = rowSet.getString("sourceBillId");
                    if (StringUtils.isNotBlank((CharSequence)sourceBillId)) {
                        IMRApply mrApply = MRApplyFactory.getLocalInstance((Context)ctx);
                        info = mrApply.getMRApplyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)sourceBillId)));
                        result.put("meetingName", info.getName());
                        result.put("meetingId", sourceBillId);
                    }
                    IMRSummary mrSummry = MRSummaryFactory.getLocalInstance((Context)ctx);
                    info = mrSummry.getMRSummaryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                    StringBuffer sbAttendantIdSql = new StringBuffer(200);
                    MRSummaryMRAttendantCollection attendantCollection = info.getMRAttendant();
                    int j = attendantCollection.size();
                    for (int i = 0; i < j; ++i) {
                        MRSummaryMRAttendantInfo attendantInfo = attendantCollection.get(i);
                        sbAttendantIdSql.append("'" + attendantInfo.getAttendant().getId().toString() + "'").append(",");
                    }
                    IPerson person = PersonFactory.getLocalInstance((Context)ctx);
                    PersonCollection attendantPersonCollection = person.getPersonCollection("select id,name where id in (" + sbAttendantIdSql.substring(0, sbAttendantIdSql.length() - 1).toString() + ")");
                    StringBuffer sbAttendantId = new StringBuffer(200);
                    StringBuffer sbAttendantName = new StringBuffer(200);
                    int j2 = attendantCollection.size();
                    for (int i = 0; i < j2; ++i) {
                        sbAttendantId.append(attendantPersonCollection.get(i).getId().toString()).append(";");
                        sbAttendantName.append(attendantPersonCollection.get(i).getName()).append(";");
                    }
                    result.put("meetingAttendantId", sbAttendantId.substring(0, sbAttendantId.length() - 1).toString());
                    result.put("meetingAttendantName", sbAttendantName.substring(0, sbAttendantName.length() - 1).toString());
                    StringBuffer sbCCIdSql = new StringBuffer(200);
                    MRSummaryMRApplyCCCollection ccCollection = info.getMRApplyCC();
                    int j3 = ccCollection.size();
                    for (int i = 0; i < j3; ++i) {
                        MRSummaryMRApplyCCInfo ccInfo = ccCollection.get(i);
                        sbCCIdSql.append("'" + ccInfo.getCc().getId().toString() + "'").append(",");
                    }
                    PersonCollection ccPersonCollection = person.getPersonCollection("select id,name where id in (" + sbCCIdSql.substring(0, sbCCIdSql.length() - 1).toString() + ")");
                    StringBuffer sbCCId = new StringBuffer(200);
                    StringBuffer sbCCName = new StringBuffer(200);
                    int j4 = ccPersonCollection.size();
                    for (int i = 0; i < j4; ++i) {
                        sbCCId.append(ccPersonCollection.get(i).getId().toString()).append(";");
                        sbCCName.append(ccPersonCollection.get(i).getName()).append(";");
                    }
                    result.put("meetingCCId", sbCCId.substring(0, sbCCId.length() - 1).toString());
                    result.put("meetingCCName", sbCCName.substring(0, sbCCName.length() - 1).toString());
                }
                success = true;
            }
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (ParserException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (Exception e) {
            localErr = this.handleErr(e);
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void uploadWord() {
        HttpServletRequest request = this.getRequest();
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload fu = new ServletFileUpload((FileItemFactory)factory);
        boolean isMultipartContent = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipartContent) {
            this.uploadFile(request, fu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFile(HttpServletRequest request, ServletFileUpload fu) {
        InputStream is = null;
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            List fileItems = fu.parseRequest(request);
            for (FileItem fi : fileItems) {
                if (!"EDITFILE".equals(fi.getFieldName())) continue;
                String fileName = FilenameUtils.getName((String)fi.getName());
                fileName = this.getUploadFileName(fileName);
                this.deleteDocExchange(ctx, fileName);
                is = fi.getInputStream();
                String sql = "Insert into T_CP_DocExchange(FID,FEntity) values(?,?)";
                PreparedStatement ps = EJBFactory.getConnection((Context)ctx).prepareStatement(sql);
                ps.setString(1, fileName);
                ps.setBinaryStream(2, is, is.available());
                ps.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getUploadFileName(String fileName) {
        if (fileName.indexOf(":") > 0 && fileName.indexOf("\\") > 0) {
            fileName = fileName.substring(fileName.lastIndexOf("\\") + 1);
        }
        if (fileName.lastIndexOf(".") > 0) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDocExchange(Context ctx, String FID) {
        String sql = "delete T_CP_DocExchange where fid = ? ";
        PreparedStatement ps = null;
        try {
            ps = EJBFactory.getConnection((Context)ctx).prepareStatement(sql);
            ps.setString(1, FID);
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean checkTime(String startTime, String endTime, StringBuffer errMsg) throws ParseException {
        boolean flag = true;
        if (StringUtils.isBlank((CharSequence)startTime) || StringUtils.isBlank((CharSequence)endTime)) {
            errMsg.append("\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            flag = false;
        } else {
            Date endDate;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            Date startDate = sdf.parse(startTime);
            if (startDate.compareTo(endDate = sdf.parse(endTime)) > 0) {
                flag = false;
                errMsg.append("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
            } else {
                flag = true;
            }
        }
        return flag;
    }

    private boolean checkMeetingType(String id, Context ctx, StringBuffer errMsg) throws BOSException, EASBizException {
        IMeetingType meetingType;
        MeetingTypeInfo info;
        boolean flag = true;
        if (StringUtils.isNotBlank((CharSequence)id) && EnableStateEnum.DISABLE_STATE.equals((Object)(info = (meetingType = MeetingTypeFactory.getLocalInstance((Context)ctx)).getMeetingTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)))).getEnableState())) {
            flag = false;
            errMsg.append("\u4e0d\u80fd\u9009\u62e9\u88ab\u7981\u7528\u7684\u4f1a\u8bae\u7c7b\u578b");
        }
        return flag;
    }

    private EntityViewInfo assembleCondition(HttpServletRequest request) throws BOSException, SQLException {
        PersonInfo personInfo;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        boolean isMRAdmin = MeetingUtil.isMRAdmin(ctx, personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        if (isMRAdmin) {
            itemCollection.add(new FilterItemInfo("recorder.id", (Object)personInfo.getId(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("caller.id", (Object)personInfo.getId(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("compere.id", (Object)personInfo.getId(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("MRApplyCC.cc.id", (Object)personInfo.getId(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("MRAttendant.attendant.id", (Object)personInfo.getId(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("state", (Object)0, CompareType.NOTEQUALS));
            itemCollection.add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
            filterInfo.setMaskString("(#0 or ((#1 or #2 or #3 or #4) and #5)) or #6");
        } else {
            itemCollection.add(new FilterItemInfo("recorder.id", (Object)personInfo.getId(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("caller.id", (Object)personInfo.getId(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("compere.id", (Object)personInfo.getId(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("MRApplyCC.cc.id", (Object)personInfo.getId(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("MRAttendant.attendant.id", (Object)personInfo.getId(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("state", (Object)0, CompareType.NOTEQUALS));
            itemCollection.add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("recorder.id", (Object)personInfo.getId(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("caller.id", (Object)personInfo.getId(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("compere.id", (Object)personInfo.getId(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("MRApplyCC.cc.id", (Object)personInfo.getId(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("MRAttendant.attendant.id", (Object)personInfo.getId(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("state", (Object)0, CompareType.NOTEQUALS));
            filterInfo.setMaskString("((#0 or ((#1 or #2 or #3 or #4) and #5)) and #6) or (#7 or ((#8 or #9 or #10 or #11) and #12)) ");
        }
        entityViewInfo.setFilter(filterInfo);
        return entityViewInfo;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }
}

