/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.mrm.module.setting.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.mrm.EnableStateEnum;
import com.kingdee.eas.cp.mrm.IMeetingRoom;
import com.kingdee.eas.cp.mrm.MeetingRoomCollection;
import com.kingdee.eas.cp.mrm.MeetingRoomFactory;
import com.kingdee.eas.cp.mrm.MeetingRoomInfo;
import com.kingdee.eas.cp.mrm.MeetingRoomShareCUInfo;
import com.kingdee.eas.cp.mrm.app.MRProcessService;
import com.kingdee.eas.cp.mrm.app.ProcessInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.plt.mrm.module.setting.dto.MeetingRoomDTO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class MeetingRoomAction
extends BaseAction {
    private static final long serialVersionUID = 3452234125968141524L;
    private final int DEFAULT_SEAT_COUNT = 1;

    public void loadMeetingRoomList() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app.MeetingRoomQuery");
        try {
            String meetingroomName = this.getRequest().getParameter("meetingroomName");
            String nameSql = "(";
            if (meetingroomName != null && !meetingroomName.equals("")) {
                nameSql = "name like '%" + meetingroomName + "%' and (";
            }
            String filterStr = nameSql + "cu.id='" + cuId + "' or (id in(select FParentId from T_MRM_MeetingRoomShareCU where FShareCUId='" + cuId + "') and enableState=" + 0 + ")) order by id asc";
            entityViewInfo.setFilter(filterStr);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("seatCount"));
            sic.add(new SelectorItemInfo("address"));
            sic.add(new SelectorItemInfo("description"));
            sic.add(new SelectorItemInfo("contact.number"));
            sic.add(new SelectorItemInfo("contact.name"));
            sic.add(new SelectorItemInfo("contact.id"));
            sic.add(new SelectorItemInfo("contactTwo.number"));
            sic.add(new SelectorItemInfo("contactTwo.name"));
            sic.add(new SelectorItemInfo("contactTwo.id"));
            sic.add(new SelectorItemInfo("enableState"));
            sic.add(new SelectorItemInfo("controlUnit.id"));
            sic.add(new SelectorItemInfo("shareCUNameList"));
            entityViewInfo.setSelector(sic);
            IQueryExecutor exec = null;
            IRowSet rowSet = null;
            IRowSet countRowSet = null;
            int total = 0;
            int totalPage = 0;
            int pageNo = 0;
            int pageSize = 10;
            pageNo = this.pagingParam.getPageNo();
            pageSize = this.pagingParam.getPageSize();
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content count sql is:" + exec.getSQL());
            countRowSet = exec.executeQuery();
            while (countRowSet.next()) {
                this.logger.debug("record total is" + ++total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.logger.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            ArrayList<MeetingRoomDTO> list = new ArrayList<MeetingRoomDTO>();
            if (total > 0) {
                this.logger.debug("executor search content sql is:" + exec.getSQL());
                rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
                if (rowSet != null) {
                    while (rowSet.next()) {
                        MeetingRoomDTO meetingRoomDTO = new MeetingRoomDTO();
                        String meetingroomId = rowSet.getString("id");
                        meetingRoomDTO.setId(meetingroomId);
                        meetingRoomDTO.setAddress(rowSet.getString("address"));
                        meetingRoomDTO.setName(rowSet.getString("name"));
                        meetingRoomDTO.setSeatCount(rowSet.getString("seatCount"));
                        meetingRoomDTO.setContact1Id(rowSet.getString("contact.id"));
                        meetingRoomDTO.setContact1Name(rowSet.getString("contact.name"));
                        meetingRoomDTO.setContact1Number(rowSet.getString("contact.number"));
                        meetingRoomDTO.setContact2Id(rowSet.getString("contactTwo.id"));
                        meetingRoomDTO.setContact2Name(rowSet.getString("contactTwo.name"));
                        meetingRoomDTO.setContact2Number(rowSet.getString("contactTwo.number"));
                        meetingRoomDTO.setEnableState(rowSet.getString("enableState"));
                        meetingRoomDTO.setControlUnitId(rowSet.getString("controlUnit.id"));
                        String roomCUId = rowSet.getString("controlUnit.id");
                        if (cuId.equals(roomCUId)) {
                            meetingRoomDTO.setType("\u81ea\u5efa");
                        } else {
                            meetingRoomDTO.setType("\u5171\u4eab");
                        }
                        String shareCuName = "";
                        String shareIds = "";
                        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select * from T_MRM_MeetingRoomShareCU where fparentId='" + meetingroomId + "'"));
                        if (rs != null) {
                            while (rs.next()) {
                                String shareCuId = rs.getString("FShareCUID");
                                ICtrlUnit ctrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
                                CtrlUnitInfo ctrlCUInfo = ctrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(shareCuId));
                                String cuName = ctrlCUInfo.getName();
                                shareCuName = shareCuName + cuName + ";";
                                shareIds = shareIds + shareCuId + ";";
                            }
                            if (shareIds.length() > 0) {
                                shareIds = shareIds.substring(0, shareIds.length() - 1);
                                shareCuName = shareCuName.substring(0, shareCuName.length() - 1);
                            }
                        }
                        meetingRoomDTO.setShareControlUnitName(shareCuName);
                        meetingRoomDTO.setShareControlUnitId(shareIds);
                        list.add(meetingRoomDTO);
                    }
                }
            }
            PagingResult pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            this.writePagingResult(pagingResult);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveMeetingRoom() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        LocalErr localErr = null;
        boolean success = false;
        String result = "";
        String id = request.getParameter("id");
        String name = request.getParameter("name");
        String seatCount = request.getParameter("seatCount");
        String address = request.getParameter("address");
        String description = request.getParameter("description");
        String contact1Id = request.getParameter("contact1Id");
        String equipment = request.getParameter("equipment");
        String applyProcess = request.getParameter("applyProcess");
        try {
            IMeetingRoom meetingRoom = MeetingRoomFactory.getLocalInstance((Context)ctx);
            MeetingRoomInfo info = StringUtils.isEmpty((String)id) ? new MeetingRoomInfo() : meetingRoom.getMeetingRoomInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            info.setName(name);
            if (!StringUtils.isEmpty((String)seatCount)) {
                info.setSeatCount(Integer.valueOf(seatCount).intValue());
            } else {
                info.setSeatCount(1);
            }
            info.setAddress(address);
            info.setDescription(description);
            info.setEnableState(EnableStateEnum.ENABLE_STATE);
            info.setEquipment(equipment);
            info.setApplyProcess(applyProcess);
            if (!StringUtils.isEmpty((String)contact1Id)) {
                PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)contact1Id)));
                info.setContact(personInfo);
            }
            if (StringUtils.isEmpty((String)id)) {
                String newId = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                info.setNumber(newId);
                meetingRoom.addnew((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)newId)), (CoreBaseInfo)info);
                success = true;
                result = newId;
            } else {
                info.setId(BOSUuid.read((String)id));
                meetingRoom.save((CoreBaseInfo)info);
                success = true;
                result = id;
            }
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void checkMeetingRoomName() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        boolean success = false;
        LocalErr localErr = null;
        int result = 0;
        String id = request.getParameter("id");
        String name = request.getParameter("name");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)name));
        if (StringUtils.isNotBlank((String)id)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        }
        entityViewInfo.setFilter(filterInfo);
        try {
            IMeetingRoom meetingRoom = MeetingRoomFactory.getLocalInstance((Context)ctx);
            MeetingRoomCollection collection = meetingRoom.getMeetingRoomCollection(entityViewInfo);
            if (collection.size() > 0 && !collection.get(0).getId().equals((Object)id)) {
                localErr = new LocalErr();
                localErr.setDesc("\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u4f1a\u8bae\u5ba4");
                result = 1;
            }
            success = true;
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void initMeetingRoomData() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        LocalErr localErr = null;
        boolean success = false;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String id = request.getParameter("id");
        try {
            IMeetingRoom meetingRoom;
            MeetingRoomInfo info;
            if (StringUtils.isNotBlank((String)id) && (info = (meetingRoom = MeetingRoomFactory.getLocalInstance((Context)ctx)).getMeetingRoomInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)))) != null) {
                result.put("id", id);
                result.put("name", info.getName());
                result.put("seatCount", info.getSeatCount());
                result.put("address", info.getAddress());
                result.put("description", info.getDescription());
                result.put("equipment", info.getEquipment());
                result.put("applyProcessId", info.getApplyProcess());
                String contactId = info.getContact().getId().toString();
                result.put("contact1Id", contactId);
                PersonInfo contact = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)contactId)));
                result.put("contact1Name", contact.getName());
                result.put("shareCUNameList", info.getShareCUNameList());
            }
            ProcessInfo[] processes = this.getApplyProcess(ctx);
            result.put("processes", processes);
            success = true;
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void deleteMeetingRoom() throws SQLException {
        HttpServletRequest request = this.getRequest();
        String ids = request.getParameter("ids");
        if (!StringUtils.isEmpty((String)ids)) {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            LocalErr localErr = null;
            boolean succ = false;
            String result = "";
            String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            String[] idArr = ids.split(",");
            ObjectUuidPK[] pkArr = new ObjectUuidPK[idArr.length];
            StringBuffer sbIds = new StringBuffer(200);
            try {
                int j = idArr.length;
                for (int i = 0; i < j; ++i) {
                    sbIds.append("'").append(idArr[i]).append("'");
                    if (i < j - 1) {
                        sbIds.append(",");
                    }
                    pkArr[i] = new ObjectUuidPK(BOSUuid.read((String)idArr[i]));
                }
                if (this.includeShareRoom(ctx, sbIds.toString(), cuId)) {
                    localErr = new LocalErr();
                    localErr.setDesc("\u53ea\u80fd\u5220\u9664\u81ea\u5efa\u7684\u4f1a\u8bae\u5ba4\uff01");
                    succ = false;
                    result = "\u53ea\u80fd\u5220\u9664\u81ea\u5efa\u7684\u4f1a\u8bae\u5ba4\uff01";
                } else {
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select * from T_MRM_MRApply where FAddressID in (" + sbIds.toString() + ")"));
                    if (rs != null && rs.next()) {
                        localErr = new LocalErr();
                        localErr.setDesc("\u5df2\u53d1\u751f\u4f1a\u8bae\u7684\u4f1a\u8bae\u5ba4\u4e0d\u5f97\u5220\u9664\uff01");
                        succ = false;
                        result = "\u5df2\u53d1\u751f\u4f1a\u8bae\u7684\u4f1a\u8bae\u5ba4\u4e0d\u5f97\u5220\u9664\uff01";
                    } else {
                        IMeetingRoom meetingRoom = MeetingRoomFactory.getLocalInstance((Context)ctx);
                        meetingRoom.delete((IObjectPK[])pkArr);
                        succ = true;
                    }
                }
            }
            catch (BOSException e) {
                localErr = this.handleErr((Exception)((Object)e));
                succ = false;
                result = "-1";
                e.printStackTrace();
            }
            catch (EASBizException e) {
                localErr = this.handleErr((Exception)((Object)e));
                succ = false;
                result = "-1";
                e.printStackTrace();
            }
            this.writeAjaxData(succ, localErr, result);
        }
    }

    public void shareMeetingRoom() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String id = request.getParameter("id");
        String CUIds = request.getParameter("CUIds");
        LocalErr localErr = null;
        boolean succ = false;
        HashMap<String, String> result = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)id)) {
            try {
                IMeetingRoom iMeetingRoom = MeetingRoomFactory.getLocalInstance((Context)ctx);
                MeetingRoomInfo meetingRoom = iMeetingRoom.getMeetingRoomInfo((IObjectPK)new ObjectUuidPK(id));
                meetingRoom.getShareCU().clear();
                StringBuffer sb = new StringBuffer(200);
                if (!StringUtils.isEmpty((String)CUIds)) {
                    String[] CUIdArr = CUIds.split(",");
                    StringBuffer sbIds = new StringBuffer(200);
                    int j = CUIdArr.length;
                    for (int i = 0; i < j; ++i) {
                        sbIds.append("'").append(CUIdArr[i]).append("'");
                        if (i >= j - 1) continue;
                        sbIds.append(",");
                    }
                    ICtrlUnit ctrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
                    CtrlUnitCollection ctrlUnitCollection = ctrlUnit.getCtrlUnitCollection("select id,name where id in (" + sbIds.toString() + ")");
                    for (int i = 0; i < ctrlUnitCollection.size(); ++i) {
                        MeetingRoomShareCUInfo shareCUInfo = new MeetingRoomShareCUInfo();
                        shareCUInfo.setParent(meetingRoom);
                        shareCUInfo.setShareCU(ctrlUnitCollection.get(i));
                        meetingRoom.getShareCU().add(shareCUInfo);
                        sb.append(ctrlUnitCollection.get(i).getName()).append(",");
                    }
                }
                if (sb.toString().endsWith(",")) {
                    sb.setLength(sb.length() - 1);
                }
                if (sb.toString().length() > 15) {
                    sb.setLength(15);
                    sb.append("...");
                }
                meetingRoom.setShareCUNameList(sb.toString());
                iMeetingRoom.save((CoreBaseInfo)meetingRoom);
                succ = true;
                result.put("shareCUName", sb.toString());
            }
            catch (BOSException e) {
                localErr = this.handleErr((Exception)((Object)e));
                succ = false;
                e.printStackTrace();
            }
            catch (EASBizException e) {
                localErr = this.handleErr((Exception)((Object)e));
                succ = false;
                e.printStackTrace();
            }
        }
        this.writeAjaxData(succ, localErr, result);
    }

    public void setMeetingRoomState() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        LocalErr localErr = null;
        boolean succ = false;
        String result = "";
        String ids = request.getParameter("ids");
        String status = request.getParameter("status");
        if (StringUtils.isNotBlank((String)ids) && (status.equals(String.valueOf(0)) || status.equals(String.valueOf(1)))) {
            try {
                String[] idArr = ids.split(",");
                String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
                StringBuffer sbIds = new StringBuffer(100);
                for (String id : idArr) {
                    sbIds.append("'").append(id).append("'").append(",");
                }
                if (this.includeShareRoom(ctx, sbIds.substring(0, sbIds.length() - 1).toString(), cuId)) {
                    localErr = new LocalErr();
                    localErr.setDesc("\u53ea\u80fd\u64cd\u4f5c\u81ea\u5efa\u7684\u4f1a\u8bae\u5ba4\uff01");
                    succ = false;
                    result = "0";
                } else {
                    DbUtil.execute((Context)ctx, (String)("UPDATE T_MRM_MeetingRoom SET FEnableState = '" + status + "'" + " WHERE FID IN (" + sbIds.substring(0, sbIds.length() - 1).toString() + ")"));
                    succ = true;
                    result = "1";
                }
            }
            catch (BOSException e) {
                localErr = this.handleErr((Exception)((Object)e));
                succ = false;
                e.printStackTrace();
            }
        }
        this.writeAjaxData(succ, localErr, result);
    }

    private boolean includeShareRoom(Context ctx, String ids, String CUid) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select * from T_MRM_MeetingRoomShareCU where fparentId in (" + ids.toString() + ") and FShareCUId <> '" + CUid + "'"));
        return rs == null;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private ProcessInfo[] getApplyProcess(Context ctx) throws WfException, BOSException {
        ProcessInfo[] processes = MRProcessService.getApplyProcessInfo((Context)ctx);
        return processes;
    }
}

